/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;

public class RssReportShuffleResultRequest {
    private String appId;
    private int shuffleId;
    private long taskAttemptId;
    private int bitmapNum;
    private Map<Integer, List<Long>> partitionToBlockIds;

    public RssReportShuffleResultRequest(String appId, int shuffleId, long taskAttemptId, Map<Integer, List<Long>> partitionToBlockIds, int bitmapNum) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.taskAttemptId = taskAttemptId;
        this.bitmapNum = bitmapNum;
        this.partitionToBlockIds = partitionToBlockIds;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public int getBitmapNum() {
        return this.bitmapNum;
    }

    public Map<Integer, List<Long>> getPartitionToBlockIds() {
        return this.partitionToBlockIds;
    }

    public RssProtos.ReportShuffleResultRequest toProto() {
        RssReportShuffleResultRequest request = this;
        ArrayList<RssProtos.PartitionToBlockIds> partitionToBlockIds = Lists.newArrayList();
        for (Map.Entry<Integer, List<Long>> entry : request.getPartitionToBlockIds().entrySet()) {
            List<Long> blockIds = entry.getValue();
            if (blockIds == null || blockIds.isEmpty()) continue;
            partitionToBlockIds.add(RssProtos.PartitionToBlockIds.newBuilder().setPartitionId(entry.getKey()).addAllBlockIds((Iterable<? extends Long>)entry.getValue()).build());
        }
        RssProtos.ReportShuffleResultRequest rpcRequest = RssProtos.ReportShuffleResultRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setTaskAttemptId(request.getTaskAttemptId()).setBitmapNum(request.getBitmapNum()).addAllPartitionToBlockIds(partitionToBlockIds).build();
        return rpcRequest;
    }
}

