/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.web;

import java.io.FileNotFoundException;
import java.net.BindException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hbase.thirdparty.org.glassfish.jersey.servlet.ServletContainer;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.util.ExitUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);
    private Server server;
    private ServletContextHandler servletContextHandler;
    private int httpPort;
    private ServletHolder servletHolder;
    private Set<String> resourcePackages = new HashSet<String>();

    public JettyServer(RssBaseConf conf) throws FileNotFoundException {
        this.createServer(conf);
    }

    public void createServer(RssBaseConf conf) throws FileNotFoundException {
        this.httpPort = conf.getInteger(RssBaseConf.JETTY_HTTP_PORT);
        ExecutorThreadPool threadPool = this.createThreadPool(conf);
        this.server = new Server((ThreadPool)threadPool);
        this.server.setStopAtShutdown(true);
        this.server.setStopTimeout(conf.getLong(RssBaseConf.JETTY_STOP_TIMEOUT));
        this.server.addBean((Object)new ScheduledExecutorScheduler("jetty-thread-pool", true));
        HttpConfiguration httpConfig = new HttpConfiguration();
        this.addHttpConnector(conf.getInteger(RssBaseConf.JETTY_HTTP_PORT), httpConfig, conf.getLong(RssBaseConf.JETTY_HTTP_IDLE_TIMEOUT));
        this.setRootServletHandler();
        if (conf.getBoolean(RssBaseConf.JETTY_SSL_ENABLE)) {
            this.addHttpsConnector(httpConfig, conf);
        }
        if (this.servletContextHandler != null) {
            this.servletContextHandler.setAttribute("_servlet_context_attr_conf_", (Object)conf);
        }
    }

    private ExecutorThreadPool createThreadPool(RssBaseConf conf) {
        int corePoolSize = conf.getInteger(RssBaseConf.JETTY_CORE_POOL_SIZE);
        int maxPoolSize = conf.getInteger(RssBaseConf.JETTY_MAX_POOL_SIZE);
        ExecutorThreadPool pool = new ExecutorThreadPool((ExecutorService)new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.getThreadFactory("Jetty")));
        return pool;
    }

    private void addHttpConnector(int port, HttpConfiguration httpConfig, long idleTimeout) {
        ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        httpConnector.setPort(port);
        httpConnector.setIdleTimeout(idleTimeout);
        this.server.addConnector((Connector)httpConnector);
    }

    private void addHttpsConnector(HttpConfiguration httpConfig, RssBaseConf conf) throws FileNotFoundException {
        LOG.info("Create https connector");
        Path keystorePath = Paths.get(conf.get(RssBaseConf.JETTY_SSL_KEYSTORE_PATH), new String[0]).toAbsolutePath();
        if (!Files.exists(keystorePath, new LinkOption[0])) {
            throw new FileNotFoundException(keystorePath.toString());
        }
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystorePath.toString());
        sslContextFactory.setKeyStorePassword(conf.get(RssBaseConf.JETTY_SSL_KEYSTORE_PASSWORD));
        sslContextFactory.setKeyManagerPassword(conf.get(RssBaseConf.JETTY_SSL_KEYMANAGER_PASSWORD));
        sslContextFactory.setTrustStorePath(keystorePath.toString());
        sslContextFactory.setTrustStorePassword(conf.get(RssBaseConf.JETTY_SSL_TRUSTSTORE_PASSWORD));
        int securePort = conf.getInteger(RssBaseConf.JETTY_HTTPS_PORT);
        httpConfig.setSecurePort(securePort);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(securePort);
        this.server.addConnector((Connector)sslConnector);
    }

    private void setRootServletHandler() {
        this.servletContextHandler = new ServletContextHandler();
        this.servletContextHandler.setContextPath("/");
        this.server.setHandler((Handler)this.servletContextHandler);
        this.servletHolder = this.servletContextHandler.addServlet(ServletContainer.class, "/*");
    }

    public void addResourcePackages(String ... packages) {
        this.resourcePackages.addAll(Arrays.asList(packages));
        this.servletHolder.setInitParameter("org.apache.hbase.thirdparty.jersey.config.server.provider.packages", String.join((CharSequence)",", this.resourcePackages));
        this.servletHolder.setInitParameter("org.apache.hbase.thirdparty.jersey.config.server.wadl.disableWadl", "true");
    }

    public void registerInstance(Class<?> clazz, Object instance) {
        this.registerInstance(clazz.getCanonicalName(), instance);
    }

    public void registerInstance(String name, Object instance) {
        this.servletContextHandler.setAttribute(name, instance);
    }

    public Server getServer() {
        return this.server;
    }

    public int start() throws Exception {
        try {
            this.server.start();
            this.httpPort = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        catch (BindException e) {
            ExitUtils.terminate(1, "Fail to start jetty http server, port is " + this.httpPort, e, LOG);
        }
        LOG.info("Jetty http server started, listening on port {}", (Object)this.httpPort);
        return this.httpPort;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

