/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.InputContextUtils;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.UmbilicalUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.library.common.CompositeInputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.shuffle.FetchResult;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.Fetcher;
import org.apache.tez.runtime.library.common.shuffle.FetcherCallback;
import org.apache.tez.runtime.library.common.shuffle.HostPort;
import org.apache.tez.runtime.library.common.shuffle.InputHost;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.impl.RssTezFetcherTask;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.base.Objects;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;
import org.apache.uniffle.shaded.com.google.common.collect.Iterables;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.Futures;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssShuffleManager
extends ShuffleManager {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleManager.class);
    private static final Logger LOG_FETCH = LoggerFactory.getLogger((String)(LOG.getName() + ".fetch"));
    private static final ShuffleUtils.FetchStatsLogger fetchStatsLogger = new ShuffleUtils.FetchStatsLogger(LOG_FETCH, LOG);
    private final InputContext inputContext;
    private final int numInputs;
    private final int shuffleId;
    private final ApplicationAttemptId applicationAttemptId;
    private final DecimalFormat mbpsFormat = new DecimalFormat("0.00");
    private final FetchedInputAllocator inputManager;
    @VisibleForTesting
    final ListeningExecutorService fetcherExecutor;
    private ExecutorService reporterExecutor;
    private final ReentrantLock reportLock = new ReentrantLock();
    private final Condition reportCondition = this.reportLock.newCondition();
    private final HashMap<InputReadErrorEvent, Integer> failedEvents = new HashMap();
    private final ListeningExecutorService schedulerExecutor;
    private final RssRunShuffleCallable rssSchedulerCallable;
    private final BlockingQueue<FetchedInput> completedInputs;
    private final AtomicBoolean inputReadyNotificationSent = new AtomicBoolean(false);
    @VisibleForTesting
    final BitSet completedInputSet;
    private final ConcurrentMap<HostPort, InputHost> knownSrcHosts;
    private final BlockingQueue<InputHost> pendingHosts;
    private final Set<InputAttemptIdentifier> obsoletedInputs;
    private Set<RssTezFetcherTask> rssRunningFetchers;
    private final AtomicInteger numCompletedInputs = new AtomicInteger(0);
    private final AtomicInteger numFetchedSpills = new AtomicInteger(0);
    private final long startTime;
    private long lastProgressTime;
    private long totalBytesShuffledTillNow;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition wakeLoop = this.lock.newCondition();
    private final int numFetchers;
    private final boolean asyncHttp;
    private final CompressionCodec codec;
    private final Configuration conf;
    private final boolean localDiskFetchEnabled;
    private final boolean sharedFetchEnabled;
    private final boolean verifyDiskChecksum;
    private final boolean compositeFetch;
    private final int ifileBufferSize;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final int maxTimeToWaitForReportMillis;
    private final String srcNameTrimmed;
    private final int maxTaskOutputAtOnce;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final TezCounter shuffledInputsCounter;
    private final TezCounter failedShufflesCounter;
    private final TezCounter bytesShuffledCounter;
    private final TezCounter decompressedDataSizeCounter;
    private final TezCounter bytesShuffledToDiskCounter;
    private final TezCounter bytesShuffledToMemCounter;
    private final TezCounter bytesShuffledDirectDiskCounter;
    private volatile Throwable shuffleError;
    private final HttpConnectionParams httpConnectionParams;
    private final LocalDirAllocator localDirAllocator;
    private final RawLocalFileSystem localFs;
    private final Path[] localDisks;
    private final String localhostName;
    private final int shufflePort;
    private final TezCounter shufflePhaseTime;
    private final TezCounter firstEventReceived;
    private final TezCounter lastEventReceived;
    @VisibleForTesting
    final Map<Integer, ShuffleEventInfo> shuffleInfoEventsMap;
    private Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private final Set<Integer> successRssPartitionSet = new HashSet<Integer>();
    private final Set<Integer> runningRssPartitionMap = new HashSet<Integer>();
    private final Set<Integer> allRssPartition = Sets.newConcurrentHashSet();
    private final BlockingQueue<Integer> pendingPartition = new LinkedBlockingQueue<Integer>();
    Map<Integer, List<InputAttemptIdentifier>> partitionToInput = new HashMap<Integer, List<InputAttemptIdentifier>>();
    private final Map<Integer, Roaring64NavigableMap> rssAllBlockIdBitmapMap = JavaUtils.newConcurrentMap();
    private final Map<Integer, Roaring64NavigableMap> rssSuccessBlockIdBitmapMap = JavaUtils.newConcurrentMap();
    private final AtomicInteger numNoDataInput = new AtomicInteger(0);
    private final AtomicInteger numWithDataInput = new AtomicInteger(0);
    private final AtomicInteger nextProgressLineEventCount = new AtomicInteger(0);

    public RssShuffleManager(InputContext inputContext, Configuration conf, int numInputs, int bufferSize, boolean ifileReadAheadEnabled, int ifileReadAheadLength, CompressionCodec codec, FetchedInputAllocator inputAllocator, int shuffleId, ApplicationAttemptId applicationAttemptId) throws IOException {
        super(inputContext, conf, numInputs, bufferSize, ifileReadAheadEnabled, ifileReadAheadLength, codec, inputAllocator);
        this.inputContext = inputContext;
        this.conf = conf;
        this.numInputs = numInputs;
        this.shuffleId = shuffleId;
        this.applicationAttemptId = applicationAttemptId;
        this.shuffledInputsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_SHUFFLED_INPUTS);
        this.failedShufflesCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_FAILED_SHUFFLE_INPUTS);
        this.bytesShuffledCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES);
        this.decompressedDataSizeCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED);
        this.bytesShuffledToDiskCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_TO_DISK);
        this.bytesShuffledToMemCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_TO_MEM);
        this.bytesShuffledDirectDiskCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DISK_DIRECT);
        this.ifileBufferSize = bufferSize;
        this.ifileReadAhead = ifileReadAheadEnabled;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.codec = codec;
        this.inputManager = inputAllocator;
        this.localDiskFetchEnabled = conf.getBoolean("tez.runtime.optimize.local.fetch", true);
        this.sharedFetchEnabled = conf.getBoolean("tez.runtime.optimize.shared.fetch", false);
        this.verifyDiskChecksum = conf.getBoolean("tez.runtime.shuffle.fetch.verify-disk-checksum", true);
        this.maxTimeToWaitForReportMillis = 1;
        this.shufflePhaseTime = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_PHASE_TIME);
        this.firstEventReceived = inputContext.getCounters().findCounter((Enum)TaskCounter.FIRST_EVENT_RECEIVED);
        this.lastEventReceived = inputContext.getCounters().findCounter((Enum)TaskCounter.LAST_EVENT_RECEIVED);
        this.compositeFetch = ShuffleUtils.isTezShuffleHandler((Configuration)conf);
        this.srcNameTrimmed = TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName());
        this.completedInputSet = new BitSet(numInputs);
        this.completedInputs = new LinkedBlockingDeque<FetchedInput>();
        this.knownSrcHosts = JavaUtils.newConcurrentMap();
        this.pendingHosts = new LinkedBlockingQueue<InputHost>();
        this.obsoletedInputs = Collections.newSetFromMap(JavaUtils.newConcurrentMap());
        this.rssRunningFetchers = Collections.newSetFromMap(JavaUtils.newConcurrentMap());
        int maxConfiguredFetchers = conf.getInt("tez.runtime.shuffle.parallel.copies", 20);
        this.numFetchers = Math.min(maxConfiguredFetchers, numInputs);
        ExecutorService fetcherRawExecutor = conf.getBoolean("tez.runtime.shuffle.fetcher.use-shared-pool", false) ? inputContext.createTezFrameworkExecutorService(this.numFetchers, "Fetcher_B {" + this.srcNameTrimmed + "} #%d") : Executors.newFixedThreadPool(this.numFetchers, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Fetcher_B {" + this.srcNameTrimmed + "} #%d").build());
        this.fetcherExecutor = MoreExecutors.listeningDecorator(fetcherRawExecutor);
        ExecutorService schedulerRawExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleRunner {" + this.srcNameTrimmed + "}").build());
        this.schedulerExecutor = MoreExecutors.listeningDecorator(schedulerRawExecutor);
        this.rssSchedulerCallable = new RssRunShuffleCallable(conf);
        this.lastProgressTime = this.startTime = System.currentTimeMillis();
        this.asyncHttp = conf.getBoolean("tez.runtime.shuffle.use.async.http", false);
        this.httpConnectionParams = ShuffleUtils.getHttpConnectionParams((Configuration)conf);
        this.localFs = (RawLocalFileSystem)FileSystem.getLocal((Configuration)conf).getRaw();
        this.localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        this.localDisks = Iterables.toArray(this.localDirAllocator.getAllLocalPathsToRead(".", conf), Path.class);
        this.localhostName = inputContext.getExecutionContext().getHostName();
        String auxiliaryService = conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        ByteBuffer shuffleMetaData = inputContext.getServiceProviderMetaData(auxiliaryService);
        this.shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData((ByteBuffer)shuffleMetaData);
        this.maxTaskOutputAtOnce = Math.max(1, Math.min(75, conf.getInt("tez.runtime.shuffle.fetch.max.task.output.at.once", 20)));
        if (null != this.localDisks) {
            Arrays.sort(this.localDisks);
        }
        this.shuffleInfoEventsMap = JavaUtils.newConcurrentMap();
        LOG.info(this.srcNameTrimmed + ": numInputs=" + numInputs + ", compressionCodec=" + (codec == null ? "NoCompressionCodec" : codec.getClass().getName()) + ", numFetchers=" + this.numFetchers + ", ifileBufferSize=" + this.ifileBufferSize + ", ifileReadAheadEnabled=" + this.ifileReadAhead + ", ifileReadAheadLength=" + ifileReadAheadLength + ", localDiskFetchEnabled=" + this.localDiskFetchEnabled + ", sharedFetchEnabled=" + this.sharedFetchEnabled + ", " + this.httpConnectionParams.toString() + ", maxTaskOutputAtOnce=" + this.maxTaskOutputAtOnce);
    }

    public void run() throws IOException {
        TezTaskAttemptID tezTaskAttemptId = InputContextUtils.getTezTaskAttemptID(this.inputContext);
        this.partitionToServers = UmbilicalUtils.requestShuffleServer(this.inputContext.getApplicationId(), this.conf, tezTaskAttemptId, this.shuffleId);
        Preconditions.checkState(this.inputManager != null, "InputManager must be configured");
        if (this.maxTimeToWaitForReportMillis > 0) {
            this.reporterExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleRunner {" + this.srcNameTrimmed + "}").build());
            Future future = this.reporterExecutor.submit(new ReporterCallable());
        }
        Future runShuffleFuture = this.schedulerExecutor.submit((Callable)((Object)this.rssSchedulerCallable));
        Futures.addCallback(runShuffleFuture, new SchedulerFutureCallback(), MoreExecutors.directExecutor());
        this.schedulerExecutor.shutdown();
    }

    private boolean isAllInputFetched() {
        LOG.info("Check isAllInputFetched, numNoDataInput:{}, numWithDataInput:{},numInputs:{},  successRssPartitionSet:{},  allRssPartition:{}.", new Object[]{this.numNoDataInput, this.numWithDataInput, this.numInputs, this.successRssPartitionSet, this.allRssPartition});
        return this.numNoDataInput.get() + this.numWithDataInput.get() >= this.numInputs && this.successRssPartitionSet.size() >= this.allRssPartition.size();
    }

    private boolean isAllInputAdded() {
        LOG.info("Check isAllInputAdded, numNoDataInput:{}, numWithDataInput:{},numInputs:{},  successRssPartitionSet:{}, allRssPartition:{}.", new Object[]{this.numNoDataInput, this.numWithDataInput, this.numInputs, this.successRssPartitionSet, this.allRssPartition});
        return this.numNoDataInput.get() + this.numWithDataInput.get() >= this.numInputs;
    }

    private boolean validateInputAttemptForPipelinedShuffle(InputAttemptIdentifier input) {
        ShuffleEventInfo eventInfo;
        if (input.canRetrieveInputInChunks() && (eventInfo = this.shuffleInfoEventsMap.get(input.getInputIdentifier())) != null && input.getAttemptNumber() != eventInfo.attemptNum && (eventInfo.scheduledForDownload || !eventInfo.eventsProcessed.isEmpty())) {
            IOException exception = new IOException("Previous event already got scheduled for " + input + ". Previous attempt's data could have been already merged to memory/disk outputs.  Killing (self) this task early. currentAttemptNum=" + eventInfo.attemptNum + ", eventsProcessed=" + eventInfo.eventsProcessed + ", scheduledForDownload=" + eventInfo.scheduledForDownload + ", newAttemptNum=" + input.getAttemptNumber());
            String message = "Killing self as previous attempt data could have been consumed";
            this.killSelf(exception, message);
            return false;
        }
        return true;
    }

    void killSelf(Exception exception, String message) {
        LOG.error(message, (Throwable)exception);
        this.inputContext.killSelf((Throwable)exception, message);
    }

    @VisibleForTesting
    Fetcher constructFetcherForHost(InputHost inputHost, Configuration conf) {
        Path lockDisk = null;
        if (this.sharedFetchEnabled) {
            int h = Math.abs(Objects.hashCode(this.srcNameTrimmed, inputHost.getHost()));
            lockDisk = new Path(this.localDisks[h % this.localDisks.length], "locks");
        }
        Fetcher.FetcherBuilder fetcherBuilder = new Fetcher.FetcherBuilder((FetcherCallback)this, this.httpConnectionParams, this.inputManager, this.inputContext.getApplicationId(), this.inputContext.getDagIdentifier(), null, this.srcNameTrimmed, conf, this.localFs, this.localDirAllocator, lockDisk, this.localDiskFetchEnabled, this.sharedFetchEnabled, this.localhostName, this.shufflePort, this.asyncHttp, this.verifyDiskChecksum, this.compositeFetch);
        if (this.codec != null) {
            fetcherBuilder.setCompressionParameters(this.codec);
        }
        fetcherBuilder.setIFileParams(this.ifileReadAhead, this.ifileReadAheadLength);
        InputHost.PartitionToInputs pendingInputsOfOnePartitionRange = inputHost.clearAndGetOnePartitionRange();
        int includedMaps = 0;
        Iterator inputIter = pendingInputsOfOnePartitionRange.getInputs().iterator();
        while (inputIter.hasNext()) {
            int maxClearBit;
            CompositeInputAttemptIdentifier compositeInput;
            int nextClearBit;
            InputAttemptIdentifier input = (InputAttemptIdentifier)inputIter.next();
            if (!this.validateInputAttemptForPipelinedShuffle(input)) continue;
            boolean alreadyCompleted = input instanceof CompositeInputAttemptIdentifier ? (nextClearBit = this.completedInputSet.nextClearBit((compositeInput = (CompositeInputAttemptIdentifier)input).getInputIdentifier())) > (maxClearBit = compositeInput.getInputIdentifier() + compositeInput.getInputIdentifierCount()) : this.completedInputSet.get(input.getInputIdentifier());
            if (alreadyCompleted || this.obsoletedInputs.contains(input)) {
                inputIter.remove();
                continue;
            }
            if (includedMaps >= this.maxTaskOutputAtOnce) {
                inputIter.remove();
                inputHost.addKnownInput(pendingInputsOfOnePartitionRange.getPartition(), pendingInputsOfOnePartitionRange.getPartitionCount(), input);
                continue;
            }
            ++includedMaps;
        }
        if (inputHost.getNumPendingPartitions() > 0) {
            this.pendingHosts.add(inputHost);
        }
        for (InputAttemptIdentifier input : pendingInputsOfOnePartitionRange.getInputs()) {
            ShuffleEventInfo eventInfo = this.shuffleInfoEventsMap.get(input.getInputIdentifier());
            if (eventInfo == null) continue;
            eventInfo.scheduledForDownload = true;
        }
        fetcherBuilder.assignWork(inputHost.getHost(), inputHost.getPort(), pendingInputsOfOnePartitionRange.getPartition(), pendingInputsOfOnePartitionRange.getPartitionCount(), pendingInputsOfOnePartitionRange.getInputs());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created Fetcher for host: " + inputHost.getHost() + ", info: " + inputHost.getAdditionalInfo() + ", with inputs: " + pendingInputsOfOnePartitionRange);
        }
        return fetcherBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnownInput(String hostName, int port, CompositeInputAttemptIdentifier srcAttemptIdentifier, int srcPhysicalIndex) {
        int i;
        InputHost old;
        HostPort identifier = new HostPort(hostName, port);
        InputHost host = (InputHost)this.knownSrcHosts.get(identifier);
        if (host == null && (old = this.knownSrcHosts.putIfAbsent(identifier, host = new InputHost(identifier))) != null) {
            host = old;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Adding input: {}, to host: {}", new Object[]{this.srcNameTrimmed, srcAttemptIdentifier, host});
        }
        if (!this.validateInputAttemptForPipelinedShuffle((InputAttemptIdentifier)srcAttemptIdentifier)) {
            return;
        }
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        for (i = 0; i < srcAttemptIdentifier.getInputIdentifierCount(); ++i) {
            if (this.shuffleInfoEventsMap.get(inputIdentifier + i) != null) continue;
            this.shuffleInfoEventsMap.put(inputIdentifier + i, new ShuffleEventInfo(srcAttemptIdentifier.expand(i)));
            LOG.info("AddKnownInput, srcAttemptIdentifier:{}, i:{}, expand:{}, map:{}", new Object[]{srcAttemptIdentifier, i, srcAttemptIdentifier.expand(i), this.shuffleInfoEventsMap});
        }
        host.addKnownInput(srcPhysicalIndex, srcAttemptIdentifier.getInputIdentifierCount(), (InputAttemptIdentifier)srcAttemptIdentifier);
        this.lock.lock();
        try {
            boolean added = this.pendingHosts.offer(host);
            if (!added) {
                String errorMessage = "Unable to add host: " + host.getIdentifier() + " to pending queue";
                LOG.error(errorMessage);
                throw new TezUncheckedException(errorMessage);
            }
            this.wakeLoop.signal();
        }
        finally {
            this.lock.unlock();
        }
        LOG.info("AddKnowInput, hostname:{}, port:{}, srcAttemptIdentifier:{}, srcPhysicalIndex:{}", new Object[]{hostName, port, srcAttemptIdentifier, srcPhysicalIndex});
        this.lock.lock();
        try {
            for (i = 0; i < srcAttemptIdentifier.getInputIdentifierCount(); ++i) {
                int p = srcPhysicalIndex + i;
                LOG.info("PartitionToInput, original:{}, add:{},  now:{}", new Object[]{srcAttemptIdentifier, srcAttemptIdentifier.expand(i), this.partitionToInput.get(p)});
                if (!this.allRssPartition.contains(srcPhysicalIndex + i)) {
                    this.pendingPartition.add(p);
                }
                this.allRssPartition.add(p);
                this.partitionToInput.computeIfAbsent(p, key -> new ArrayList());
                this.partitionToInput.get(p).add((InputAttemptIdentifier)srcAttemptIdentifier);
                LOG.info("Add partition:{}, after add, now partition:{}", (Object)p, this.allRssPartition);
            }
            this.numWithDataInput.incrementAndGet();
            LOG.info("numWithDataInput:{}.", (Object)this.numWithDataInput.get());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedInputWithNoData(InputAttemptIdentifier srcAttemptIdentifier) {
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        if (LOG.isDebugEnabled()) {
            LOG.debug("No input data exists for SrcTask: " + inputIdentifier + ". Marking as complete.");
        }
        this.lock.lock();
        try {
            if (!this.completedInputSet.get(inputIdentifier)) {
                NullFetchedInput fetchedInput = new NullFetchedInput(srcAttemptIdentifier);
                if (!srcAttemptIdentifier.canRetrieveInputInChunks()) {
                    this.registerCompletedInput(fetchedInput);
                } else {
                    this.registerCompletedInputForPipelinedShuffle(srcAttemptIdentifier, fetchedInput);
                }
            }
            this.wakeLoop.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.numNoDataInput.incrementAndGet();
        LOG.info("AddCompletedInputWithNoData, numNoDataInput:{}, numWithDataInput:{},numInputs:{},  successRssPartitionSet:{}, allRssPartition:{}.", new Object[]{this.numNoDataInput, this.numWithDataInput, this.numInputs, this.successRssPartitionSet, this.allRssPartition});
    }

    protected synchronized void updateEventReceivedTime() {
        long relativeTime = System.currentTimeMillis() - this.startTime;
        if (this.firstEventReceived.getValue() == 0L) {
            this.firstEventReceived.setValue(relativeTime);
            this.lastEventReceived.setValue(relativeTime);
            return;
        }
        this.lastEventReceived.setValue(relativeTime);
    }

    void obsoleteKnownInput(InputAttemptIdentifier srcAttemptIdentifier) {
        this.obsoletedInputs.add(srcAttemptIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSucceeded(String host, InputAttemptIdentifier srcAttemptIdentifier, FetchedInput fetchedInput, long fetchedBytes, long decompressedLength, long copyDuration) throws IOException {
        this.lock.lock();
        try {
            this.lastProgressTime = System.currentTimeMillis();
            this.inputContext.notifyProgress();
            fetchedInput.commit();
            fetchStatsLogger.logIndividualFetchComplete(copyDuration, fetchedBytes, decompressedLength, fetchedInput.getType().toString(), srcAttemptIdentifier);
            this.shuffledInputsCounter.increment(1L);
            this.bytesShuffledCounter.increment(fetchedBytes);
            if (fetchedInput.getType() == FetchedInput.Type.MEMORY) {
                this.bytesShuffledToMemCounter.increment(fetchedBytes);
            } else if (fetchedInput.getType() == FetchedInput.Type.DISK) {
                LOG.warn("Rss bytesShuffledToDiskCounter");
                this.bytesShuffledToDiskCounter.increment(fetchedBytes);
            } else if (fetchedInput.getType() == FetchedInput.Type.DISK_DIRECT) {
                LOG.warn("Rss bytesShuffledDirectDiskCounter");
                this.bytesShuffledDirectDiskCounter.increment(fetchedBytes);
            }
            this.decompressedDataSizeCounter.increment(decompressedLength);
            if (!srcAttemptIdentifier.canRetrieveInputInChunks()) {
                this.registerCompletedInput(fetchedInput);
            } else {
                LOG.warn("Rss registerCompletedInputForPipelinedShuffle");
                this.registerCompletedInputForPipelinedShuffle(srcAttemptIdentifier, fetchedInput);
            }
            this.totalBytesShuffledTillNow += fetchedBytes;
            this.logProgress();
            this.wakeLoop.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerCompletedInput(FetchedInput fetchedInput) {
        this.lock.lock();
        try {
            this.maybeInformInputReady(fetchedInput);
            this.adjustCompletedInputs(fetchedInput);
            this.numFetchedSpills.getAndIncrement();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void maybeInformInputReady(FetchedInput fetchedInput) {
        this.lock.lock();
        try {
            if (!(fetchedInput instanceof NullFetchedInput)) {
                LOG.info("maybeInformInputReady");
                this.completedInputs.add(fetchedInput);
            }
            if (!this.inputReadyNotificationSent.getAndSet(true)) {
                LOG.info("maybeInformInputReady InputContext inputIsReady");
                this.inputContext.inputIsReady();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void adjustCompletedInputs(FetchedInput fetchedInput) {
        this.lock.lock();
        try {
            this.completedInputSet.set(fetchedInput.getInputAttemptIdentifier().getInputIdentifier());
            int numComplete = this.numCompletedInputs.incrementAndGet();
            LOG.info("AdjustCompletedInputs, numCompletedInputs:{}", (Object)numComplete);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCompletedInputForPipelinedShuffle(InputAttemptIdentifier srcAttemptIdentifier, FetchedInput fetchedInput) {
        if (!this.validateInputAttemptForPipelinedShuffle(srcAttemptIdentifier)) {
            return;
        }
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        ShuffleEventInfo eventInfo = this.shuffleInfoEventsMap.get(inputIdentifier);
        if (eventInfo == null && fetchedInput instanceof NullFetchedInput) {
            eventInfo = new ShuffleEventInfo(srcAttemptIdentifier);
            this.shuffleInfoEventsMap.put(inputIdentifier, eventInfo);
        }
        if (eventInfo == null) {
            throw new RssException("eventInfo should not be null");
        }
        eventInfo.spillProcessed(srcAttemptIdentifier.getSpillEventId());
        this.numFetchedSpills.getAndIncrement();
        if (srcAttemptIdentifier.getFetchTypeInfo() == InputAttemptIdentifier.SPILL_INFO.FINAL_UPDATE) {
            eventInfo.setFinalEventId(srcAttemptIdentifier.getSpillEventId());
        }
        this.lock.lock();
        try {
            this.maybeInformInputReady(fetchedInput);
            if (eventInfo.isDone()) {
                this.adjustCompletedInputs(fetchedInput);
                this.shuffleInfoEventsMap.remove(srcAttemptIdentifier.getInputIdentifier());
            }
        }
        finally {
            this.lock.unlock();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("eventInfo " + eventInfo.toString());
        }
    }

    private void reportFatalError(Throwable exception, String message) {
        LOG.error(message);
        this.inputContext.reportFailure(TaskFailureType.NON_FATAL, exception, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchFailed(String host, InputAttemptIdentifier srcAttemptIdentifier, boolean connectFailed) {
        LOG.info(this.srcNameTrimmed + ": Fetch failed for src: " + srcAttemptIdentifier + "InputIdentifier: " + srcAttemptIdentifier + ", connectFailed: " + connectFailed);
        this.failedShufflesCounter.increment(1L);
        this.inputContext.notifyProgress();
        if (srcAttemptIdentifier == null) {
            this.reportFatalError(null, "Received fetchFailure for an unknown src (null)");
        } else {
            InputReadErrorEvent readError = InputReadErrorEvent.create((String)("Fetch failure while fetching from " + TezRuntimeUtils.getTaskAttemptIdentifier((String)this.inputContext.getSourceVertexName(), (int)srcAttemptIdentifier.getInputIdentifier(), (int)srcAttemptIdentifier.getAttemptNumber())), (int)srcAttemptIdentifier.getInputIdentifier(), (int)srcAttemptIdentifier.getAttemptNumber());
            if (this.maxTimeToWaitForReportMillis > 0) {
                this.reportLock.lock();
                try {
                    this.failedEvents.merge(readError, 1, (a, b) -> a + b);
                    this.reportCondition.signal();
                }
                finally {
                    this.reportLock.unlock();
                }
            } else {
                ArrayList<InputReadErrorEvent> events = Lists.newArrayListWithCapacity(1);
                events.add(readError);
                this.inputContext.sendEvents(events);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            LOG.info("{}: Thread interrupted. Need to cleanup the local dirs", (Object)this.srcNameTrimmed);
        }
        if (!this.isShutdown.getAndSet(true)) {
            LOG.info("Shutting down pending fetchers on source" + this.srcNameTrimmed + ": " + this.rssRunningFetchers.size());
            this.lock.lock();
            try {
                this.wakeLoop.signal();
                for (RssTezFetcherTask fetcher : this.rssRunningFetchers) {
                    try {
                        fetcher.shutdown();
                    }
                    catch (Exception e) {
                        LOG.warn("Error while stopping fetcher during shutdown. Ignoring and continuing. Message={}", (Object)e.getMessage());
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.schedulerExecutor != null && !this.schedulerExecutor.isShutdown()) {
                this.schedulerExecutor.shutdownNow();
            }
            if (this.reporterExecutor != null && !this.reporterExecutor.isShutdown()) {
                this.reporterExecutor.shutdownNow();
            }
            if (this.fetcherExecutor != null && !this.fetcherExecutor.isShutdown()) {
                this.fetcherExecutor.shutdownNow();
            }
        }
    }

    public boolean isAllPartitionFetched() {
        this.lock.lock();
        try {
            if (!this.allRssPartition.containsAll(this.successRssPartitionSet)) {
                LOG.error("Failed to check partition, all partition:{}, success partiton:{}", this.allRssPartition, this.successRssPartitionSet);
            }
            boolean bl = this.isAllInputFetched();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FetchedInput getNextInput() throws InterruptedException {
        FetchedInput fetchedInput = null;
        if (this.completedInputs.peek() == null) {
            while ((fetchedInput = this.completedInputs.poll(2000L, TimeUnit.MICROSECONDS)) == null) {
                if (this.isAllPartitionFetched()) {
                    fetchedInput = this.completedInputs.poll(100L, TimeUnit.MICROSECONDS);
                    LOG.info("GetNextInput, enter isAllPartitionFetched");
                    break;
                }
                LOG.info("GetNextInput, out loop");
            }
        } else {
            fetchedInput = this.completedInputs.take();
        }
        if (fetchedInput instanceof NullFetchedInput) {
            LOG.info("getNextInput, NullFetchedInput is null:{}", (Object)fetchedInput);
            fetchedInput = null;
        }
        LOG.info("getNextInput, fetchedInput:{}", (Object)fetchedInput);
        return fetchedInput;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public float getNumCompletedInputsFloat() {
        return this.numCompletedInputs.floatValue();
    }

    private void logProgress() {
        int inputsDone = this.numCompletedInputs.get();
        if (inputsDone > this.nextProgressLineEventCount.get() || inputsDone == this.numInputs) {
            this.nextProgressLineEventCount.addAndGet(50);
            double mbs = (double)this.totalBytesShuffledTillNow / 1048576.0;
            long secsSinceStart = (System.currentTimeMillis() - this.startTime) / 1000L + 1L;
            double transferRate = mbs / (double)secsSinceStart;
            LOG.info("copy(" + inputsDone + " (spillsFetched=" + this.numFetchedSpills.get() + ") of " + this.numInputs + ". Transfer rate (CumulativeDataFetched/TimeSinceInputStarted)) " + this.mbpsFormat.format(transferRate) + " MB/s)");
        }
    }

    private class FetchFutureCallback
    implements FutureCallback<FetchResult> {
        private final RssTezFetcherTask fetcher;

        FetchFutureCallback(RssTezFetcherTask fetcher) {
            this.fetcher = fetcher;
        }

        private void doBookKeepingForFetcherComplete() {
            RssShuffleManager.this.lock.lock();
            try {
                RssShuffleManager.this.rssRunningFetchers.remove((Object)this.fetcher);
                RssShuffleManager.this.wakeLoop.signal();
            }
            finally {
                RssShuffleManager.this.lock.unlock();
            }
        }

        @Override
        public void onSuccess(FetchResult result) {
            LOG.info("FetchFutureCallback success, result:{}, partition:{}", (Object)result, (Object)this.fetcher.getPartitionId());
            this.fetcher.shutdown();
            if (RssShuffleManager.this.isShutdown.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Already shutdown. Ignoring event from fetcher", (Object)RssShuffleManager.this.srcNameTrimmed);
                }
            } else {
                RssShuffleManager.this.lock.lock();
                try {
                    RssShuffleManager.this.successRssPartitionSet.add(this.fetcher.getPartitionId());
                    RssShuffleManager.this.runningRssPartitionMap.remove(this.fetcher.getPartitionId());
                    LOG.info("FetchFutureCallback allRssPartition:{}, successRssPartitionSet:{}, runningRssPartitionMap:{}.", new Object[]{RssShuffleManager.this.allRssPartition, RssShuffleManager.this.successRssPartitionSet, RssShuffleManager.this.runningRssPartitionMap});
                    this.doBookKeepingForFetcherComplete();
                }
                finally {
                    RssShuffleManager.this.lock.unlock();
                }
            }
        }

        @Override
        public void onFailure(Throwable t) {
            this.fetcher.shutdown();
            if (RssShuffleManager.this.isShutdown.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Already shutdown. Ignoring error from fetcher: ", (Object)RssShuffleManager.this.srcNameTrimmed, (Object)t);
                }
            } else {
                LOG.error("{}: Fetcher failed with error: ", (Object)RssShuffleManager.this.srcNameTrimmed, (Object)t);
                RssShuffleManager.this.shuffleError = t;
                RssShuffleManager.this.inputContext.reportFailure(TaskFailureType.NON_FATAL, t, "Fetch failed");
                this.doBookKeepingForFetcherComplete();
            }
        }
    }

    private class SchedulerFutureCallback
    implements FutureCallback<Void> {
        private SchedulerFutureCallback() {
        }

        @Override
        public void onSuccess(Void result) {
            LOG.info("{}: Scheduler thread completed", (Object)RssShuffleManager.this.srcNameTrimmed);
        }

        @Override
        public void onFailure(Throwable t) {
            if (RssShuffleManager.this.isShutdown.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Already shutdown. Ignoring error: ", (Object)RssShuffleManager.this.srcNameTrimmed, (Object)t);
                }
            } else {
                LOG.error("{}: Scheduler failed with error: ", (Object)RssShuffleManager.this.srcNameTrimmed, (Object)t);
                RssShuffleManager.this.inputContext.reportFailure(TaskFailureType.NON_FATAL, t, "Shuffle Scheduler Failed");
            }
        }
    }

    @VisibleForTesting
    static class NullFetchedInput
    extends FetchedInput {
        NullFetchedInput(InputAttemptIdentifier inputAttemptIdentifier) {
            super(inputAttemptIdentifier, null);
        }

        public FetchedInput.Type getType() {
            return FetchedInput.Type.MEMORY;
        }

        public long getSize() {
            return -1L;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        public void commit() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        public void abort() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        public void free() {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }
    }

    static class ShuffleEventInfo {
        BitSet eventsProcessed;
        int finalEventId = -1;
        int attemptNum;
        String id;
        boolean scheduledForDownload;

        ShuffleEventInfo(InputAttemptIdentifier input) {
            this.id = input.getInputIdentifier() + "_" + input.getAttemptNumber();
            this.eventsProcessed = new BitSet();
            this.attemptNum = input.getAttemptNumber();
        }

        void spillProcessed(int spillId) {
            if (this.finalEventId != -1) {
                Preconditions.checkState(this.eventsProcessed.cardinality() <= this.finalEventId + 1, "Wrong state. eventsProcessed cardinality=" + this.eventsProcessed.cardinality() + " finalEventId=" + this.finalEventId + ", spillId=" + spillId + ", " + this.toString());
            }
            this.eventsProcessed.set(spillId);
        }

        void setFinalEventId(int spillId) {
            this.finalEventId = spillId;
        }

        boolean isDone() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("finalEventId=" + this.finalEventId + ", eventsProcessed cardinality=" + this.eventsProcessed.cardinality());
            }
            return this.finalEventId != -1 && this.finalEventId + 1 == this.eventsProcessed.cardinality();
        }

        public String toString() {
            return "[eventsProcessed=" + this.eventsProcessed + ", finalEventId=" + this.finalEventId + ", id=" + this.id + ", attemptNum=" + this.attemptNum + ", scheduledForDownload=" + this.scheduledForDownload + "]";
        }
    }

    private class RssRunShuffleCallable
    extends CallableWithNdc<Void> {
        private final Configuration conf;

        RssRunShuffleCallable(Configuration conf) {
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void callInternal() throws Exception {
            block8: while (!RssShuffleManager.this.isShutdown.get() && !RssShuffleManager.this.isAllInputFetched()) {
                RssShuffleManager.this.lock.lock();
                try {
                    LOG.info("numFetchers:{}, shuffleInfoEventsMap.size:{}, numInputs:{}.", new Object[]{RssShuffleManager.this.numFetchers, RssShuffleManager.this.shuffleInfoEventsMap.size(), RssShuffleManager.this.numInputs});
                    while ((RssShuffleManager.this.rssRunningFetchers.size() >= RssShuffleManager.this.numFetchers || RssShuffleManager.this.pendingPartition.isEmpty()) && !RssShuffleManager.this.isAllInputFetched() || !RssShuffleManager.this.isAllInputAdded()) {
                        LOG.info("isAllInputAdded:{}, rssRunningFetchers:{}, numFetchers:{}, pendingPartition:{}, successRssPartitionSet:{}, allRssPartition:{} ", new Object[]{RssShuffleManager.this.isAllInputAdded(), RssShuffleManager.this.rssRunningFetchers, RssShuffleManager.this.numFetchers, RssShuffleManager.this.pendingPartition, RssShuffleManager.this.successRssPartitionSet, RssShuffleManager.this.allRssPartition});
                        RssShuffleManager.this.inputContext.notifyProgress();
                        boolean isSignal = RssShuffleManager.this.wakeLoop.await(1000L, TimeUnit.MILLISECONDS);
                        if (isSignal) {
                            LOG.info("wakeLoop is signal");
                        }
                        if (!RssShuffleManager.this.isShutdown.get()) continue;
                        LOG.info("is shut down and break");
                        break;
                    }
                    LOG.info("run out of while, is all inputadded:{}, fetched:{}", (Object)RssShuffleManager.this.isAllInputAdded(), (Object)RssShuffleManager.this.isAllInputFetched());
                }
                finally {
                    RssShuffleManager.this.lock.unlock();
                }
                if (RssShuffleManager.this.shuffleError != null) {
                    LOG.warn("Shuffle error.", RssShuffleManager.this.shuffleError);
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: NumCompletedInputs: {}", (Object)RssShuffleManager.this.srcNameTrimmed, (Object)RssShuffleManager.this.numCompletedInputs);
                }
                if (RssShuffleManager.this.isAllInputFetched() || RssShuffleManager.this.isShutdown.get()) continue;
                RssShuffleManager.this.lock.lock();
                try {
                    LOG.info("numFetchers:{}\uff0crunningFetchers.size():{}.", (Object)RssShuffleManager.this.numFetchers, (Object)RssShuffleManager.this.rssRunningFetchers.size());
                    int maxFetchersToRun = RssShuffleManager.this.numFetchers - RssShuffleManager.this.rssRunningFetchers.size();
                    int count = 0;
                    LOG.info("pendingPartition:{}", RssShuffleManager.this.pendingPartition.peek());
                    while (RssShuffleManager.this.pendingPartition.peek() != null && !RssShuffleManager.this.isShutdown.get()) {
                        Integer partition = null;
                        try {
                            partition = (Integer)RssShuffleManager.this.pendingPartition.take();
                        }
                        catch (InterruptedException e) {
                            if (RssShuffleManager.this.isShutdown.get()) {
                                LOG.info(RssShuffleManager.this.srcNameTrimmed + ": Interrupted and hasBeenShutdown, Breaking out of ShuffleScheduler");
                                Thread.currentThread().interrupt();
                                continue block8;
                            }
                            throw e;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{}: Processing pending partition: {}", (Object)RssShuffleManager.this.srcNameTrimmed, (Object)partition);
                        }
                        if (!(RssShuffleManager.this.isShutdown.get() || RssShuffleManager.this.successRssPartitionSet.contains(partition) || RssShuffleManager.this.runningRssPartitionMap.contains(partition))) {
                            RssShuffleManager.this.runningRssPartitionMap.add(partition);
                            LOG.info("generate RssTezFetcherTask, partition:{}, rssWoker:{}, all woker:{}", new Object[]{partition, RssShuffleManager.this.partitionToServers.get(partition), RssShuffleManager.this.partitionToServers});
                            int maxAttemptNo = RssTezUtils.getMaxAttemptNo(this.conf);
                            RssTezFetcherTask fetcher = new RssTezFetcherTask((FetcherCallback)RssShuffleManager.this, RssShuffleManager.this.inputContext, this.conf, RssShuffleManager.this.inputManager, partition, RssShuffleManager.this.shuffleId, RssShuffleManager.this.applicationAttemptId, RssShuffleManager.this.partitionToInput.get(partition), new HashSet<ShuffleServerInfo>((Collection)RssShuffleManager.this.partitionToServers.get(partition)), RssShuffleManager.this.rssAllBlockIdBitmapMap, RssShuffleManager.this.rssSuccessBlockIdBitmapMap, RssShuffleManager.this.numInputs, RssShuffleManager.this.partitionToServers.size(), maxAttemptNo);
                            RssShuffleManager.this.rssRunningFetchers.add(fetcher);
                            if (RssShuffleManager.this.isShutdown.get()) {
                                LOG.info(RssShuffleManager.this.srcNameTrimmed + ": hasBeenShutdown,Breaking out of ShuffleScheduler Loop");
                                continue block8;
                            }
                            Future future = RssShuffleManager.this.fetcherExecutor.submit((Callable)((Object)fetcher));
                            Futures.addCallback(future, new FetchFutureCallback(fetcher), MoreExecutors.directExecutor());
                            if (++count < maxFetchersToRun) continue;
                            continue block8;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(RssShuffleManager.this.srcNameTrimmed + ": Skipping partition: " + partition + " since is shutdown");
                    }
                }
                finally {
                    RssShuffleManager.this.lock.unlock();
                }
            }
            LOG.info("RssShuffleManager numInputs:{}", (Object)RssShuffleManager.this.numInputs);
            RssShuffleManager.this.shufflePhaseTime.setValue(System.currentTimeMillis() - RssShuffleManager.this.startTime);
            LOG.info(RssShuffleManager.this.srcNameTrimmed + ": Shutting down FetchScheduler, Was Interrupted: " + Thread.currentThread().isInterrupted());
            if (!RssShuffleManager.this.fetcherExecutor.isShutdown()) {
                RssShuffleManager.this.fetcherExecutor.shutdownNow();
            }
            return null;
        }
    }

    private class ReporterCallable
    extends CallableWithNdc<Void> {
        ReporterCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void callInternal() throws Exception {
            long nextReport = 0L;
            while (!RssShuffleManager.this.isShutdown.get()) {
                RssShuffleManager.this.reportLock.lock();
                try {
                    while (RssShuffleManager.this.failedEvents.isEmpty()) {
                        boolean bl = RssShuffleManager.this.reportCondition.await(RssShuffleManager.this.maxTimeToWaitForReportMillis, TimeUnit.MILLISECONDS);
                    }
                    long currentTime = Time.monotonicNow();
                    if (currentTime <= nextReport || RssShuffleManager.this.failedEvents.size() <= 0) continue;
                    ArrayList<InputReadErrorEvent> failedEventsToSend = Lists.newArrayListWithCapacity(RssShuffleManager.this.failedEvents.size());
                    for (InputReadErrorEvent key : RssShuffleManager.this.failedEvents.keySet()) {
                        failedEventsToSend.add(InputReadErrorEvent.create((String)key.getDiagnostics(), (int)key.getIndex(), (int)key.getVersion()));
                    }
                    RssShuffleManager.this.inputContext.sendEvents(failedEventsToSend);
                    RssShuffleManager.this.failedEvents.clear();
                    nextReport = currentTime + (long)RssShuffleManager.this.maxTimeToWaitForReportMillis;
                }
                finally {
                    RssShuffleManager.this.reportLock.unlock();
                }
            }
            return null;
        }
    }
}

