/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.stylemap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.internal.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class StyleMapXmlParser
extends DefaultHandler {
    private static final String FEATURE_VALUE_PREFIX = "[@";
    public Vector annotType = new Vector();
    public Vector styleLabel = new Vector();
    public Vector styleColor = new Vector();
    public Vector featureValue = new Vector();
    private StringBuffer data = new StringBuffer();

    public StyleMapXmlParser(String xmlFile) {
        try {
            SAXParserFactory saxParserFactory = XMLUtils.createSAXParserFactory();
            SAXParser parser = saxParserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(this);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(xmlFile.getBytes()));
            reader.parse(inputSource);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("pattern".equals(localName) || "pattern".equals(qName)) {
            String patternString = this.data.toString().trim();
            int featureValueIndex = patternString.indexOf(FEATURE_VALUE_PREFIX);
            if (featureValueIndex == -1) {
                this.annotType.add(patternString);
                this.featureValue.add("");
            } else {
                String annotationType = patternString.substring(0, featureValueIndex);
                int equalsSignIndex = patternString.indexOf(61);
                String featureName = patternString.substring(featureValueIndex + 2, equalsSignIndex);
                this.annotType.add(annotationType + ":" + featureName);
                int firstQuoteIndex = patternString.indexOf("'");
                int lastQuoteIndex = patternString.lastIndexOf("'");
                String fValue = patternString.substring(firstQuoteIndex + 1, lastQuoteIndex);
                this.featureValue.add(fValue);
            }
        } else if ("label".equals(localName) || "label".equals(qName)) {
            this.styleLabel.add(this.data.toString().trim());
        } else if ("style".equals(localName) || "style".equals(qName)) {
            this.styleColor.add(this.data.toString().trim());
        }
        this.data.delete(0, this.data.length());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.data.append(ch, start, length);
    }
}

