/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ejbd.EjbServer;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpServer;
import org.apache.openejb.server.httpd.ServerServiceAdapter;

public abstract class HttpEjbServer
implements ServerService {
    protected HttpServer httpServer;
    private String name;

    public void init(Properties props) throws Exception {
        this.name = props.getProperty("name");
        EjbServer ejbServer = new EjbServer();
        ServerServiceAdapter adapter = new ServerServiceAdapter((ServerService)ejbServer);
        SystemInstance systemInstance = SystemInstance.get();
        HttpListenerRegistry registry = (HttpListenerRegistry)systemInstance.getComponent(HttpListenerRegistry.class);
        if (registry == null) {
            registry = new HttpListenerRegistry();
            systemInstance.setComponent(HttpListenerRegistry.class, (Object)registry);
        }
        registry.addHttpListener(adapter, "/ejb/?.*");
        systemInstance.setComponent(HttpServer.class, (Object)this.httpServer);
        this.httpServer.init(props);
        ejbServer.init(props);
    }

    public void service(Socket socket) throws ServiceException, IOException {
        this.httpServer.service(socket);
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        this.httpServer.service(in, out);
    }

    public void start() throws ServiceException {
        this.httpServer.start();
    }

    public void stop() throws ServiceException {
        this.httpServer.stop();
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.httpServer.getPort();
    }

    public String getIP() {
        return this.httpServer.getIP();
    }
}

