/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class JarFileURLMetaDataIterator
implements MetaDataIterator,
MetaDataFilter.Resource {
    private final MetaDataFilter _filter;
    private final JarFile _jarFile;
    private final JarEntry _jarTargetEntry;
    private int index = 0;
    private JarEntry _last = null;
    private final ArrayList<JarEntry> _entryList = new ArrayList();

    public JarFileURLMetaDataIterator(URL url, MetaDataFilter filter) throws IOException {
        if (url == null) {
            this._jarFile = null;
            this._jarTargetEntry = null;
        } else {
            JarURLConnection jarURLConn = (JarURLConnection)url.openConnection();
            jarURLConn.setDefaultUseCaches(false);
            try {
                this._jarFile = AccessController.doPrivileged(J2DoPrivHelper.getJarFileAction(jarURLConn));
                this._jarTargetEntry = AccessController.doPrivileged(J2DoPrivHelper.getJarEntryAction(jarURLConn));
                if (this._jarTargetEntry.isDirectory()) {
                    Enumeration<JarEntry> jarEntryEnum = this._jarFile.entries();
                    while (jarEntryEnum.hasMoreElements()) {
                        JarEntry jarEntry = jarEntryEnum.nextElement();
                        if (!jarEntry.getName().startsWith(this._jarTargetEntry.getName())) continue;
                        this._entryList.add(jarEntry);
                    }
                } else {
                    this._entryList.add(this._jarTargetEntry);
                }
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        this._filter = filter;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this._entryList.size() <= this.index) {
            return false;
        }
        while (this.index < this._entryList.size() && this._filter != null && !this._filter.matches(this)) {
            ++this.index;
        }
        return this.index < this._entryList.size();
    }

    @Override
    public Object next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String ret = this._entryList.get(this.index).getName();
        this._last = this._entryList.get(this.index);
        ++this.index;
        return ret;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._last == null) {
            throw new IllegalStateException();
        }
        return this._jarFile.getInputStream(this._last);
    }

    @Override
    public File getFile() throws IOException {
        if (this._last == null) {
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this._jarFile != null) {
                this._jarFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        if (this.index < this._entryList.size()) {
            return this._entryList.get(this.index).getName();
        }
        return null;
    }

    @Override
    public byte[] getContent() throws IOException {
        byte[] content;
        if (this._entryList.size() <= this.index) {
            return new byte[0];
        }
        long size = this._entryList.get(this.index).getSize();
        if (size == 0L) {
            return new byte[0];
        }
        InputStream in = this._jarFile.getInputStream(this._entryList.get(this.index));
        if (size < 0L) {
            int r;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) != -1) {
                bout.write(buf, 0, r);
            }
            content = bout.toByteArray();
        } else {
            int read;
            content = new byte[(int)size];
            int offset = 0;
            while ((long)offset < size && (read = in.read(content, offset, (int)size - offset)) != -1) {
                offset += read;
            }
        }
        in.close();
        return content;
    }
}

