/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Appender;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezContainerLogAppender;
import org.apache.tez.dag.api.TezUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezThreadDumpHelper {
    private final long duration;
    private final Path basePath;
    private final FileSystem fs;
    private static final ThreadMXBean THREAD_BEAN = ManagementFactory.getThreadMXBean();
    private static final Logger LOG = LoggerFactory.getLogger(TezThreadDumpHelper.class);
    private ScheduledExecutorService periodicThreadDumpServiceExecutor;

    private TezThreadDumpHelper(long duration, Configuration conf) throws IOException {
        this.duration = duration;
        Appender appender = org.apache.log4j.Logger.getRootLogger().getAppender("CLA");
        if (appender instanceof TezContainerLogAppender) {
            this.basePath = new Path(((TezContainerLogAppender)appender).getContainerLogDir());
            this.fs = FileSystem.getLocal((Configuration)conf);
        } else {
            this.basePath = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
            this.fs = this.basePath.getFileSystem(conf);
        }
        LOG.info("Periodic Thread Dump Capture Service Configured to capture Thread Dumps at {} ms frequency and at path: {}", (Object)duration, (Object)this.basePath);
    }

    public static TezThreadDumpHelper getInstance(Configuration conf) {
        long periodicThreadDumpFrequency = conf.getTimeDuration("tez.thread.dump.interval", "100ms", TimeUnit.MILLISECONDS);
        Preconditions.checkArgument((periodicThreadDumpFrequency > 0L ? 1 : 0) != 0, (String)"%s must be positive duration", (Object[])new Object[]{"tez.thread.dump.interval"});
        try {
            return new TezThreadDumpHelper(periodicThreadDumpFrequency, conf);
        }
        catch (IOException e) {
            throw new TezUncheckedException("Can not initialize periodic thread dump service", (Throwable)e);
        }
    }

    public TezThreadDumpHelper start(String name) {
        this.periodicThreadDumpServiceExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("PeriodicThreadDumpService{" + name + "} #%d").build());
        ThreadDumpCollector threadDumpCollector = new ThreadDumpCollector(this.basePath, name, this.fs);
        this.periodicThreadDumpServiceExecutor.schedule(threadDumpCollector, this.duration, TimeUnit.MILLISECONDS);
        return this;
    }

    public void stop() {
        if (this.periodicThreadDumpServiceExecutor != null) {
            this.periodicThreadDumpServiceExecutor.shutdown();
            try {
                if (!this.periodicThreadDumpServiceExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    this.periodicThreadDumpServiceExecutor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.periodicThreadDumpServiceExecutor.shutdownNow();
            this.periodicThreadDumpServiceExecutor = null;
        }
    }

    private static class ThreadDumpCollector
    implements Runnable {
        private final Path path;
        private final String name;
        private final FileSystem fs;

        ThreadDumpCollector(Path path, String name, FileSystem fs) {
            this.path = path;
            this.fs = fs;
            this.name = name;
        }

        @Override
        public void run() {
            if (!Thread.interrupted()) {
                try (FSDataOutputStream fsStream = this.fs.create(new Path(this.path, this.name + "_" + System.currentTimeMillis() + ".jstack"));
                     PrintStream printStream = new PrintStream((OutputStream)fsStream, false, "UTF8");){
                    this.printThreadInfo(printStream, this.name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public synchronized void printThreadInfo(PrintStream stream, String title) {
            boolean contention = THREAD_BEAN.isThreadContentionMonitoringEnabled();
            long[] threadIds = THREAD_BEAN.getAllThreadIds();
            stream.println("Process Thread Dump: " + title);
            stream.println(threadIds.length + " active threads");
            for (long tid : threadIds) {
                ThreadInfo info = THREAD_BEAN.getThreadInfo(tid, Integer.MAX_VALUE);
                if (info == null) {
                    stream.println("  Inactive");
                    continue;
                }
                stream.println("Thread " + this.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
                Thread.State state = info.getThreadState();
                stream.println("  State: " + (Object)((Object)state));
                stream.println("  Blocked count: " + info.getBlockedCount());
                stream.println("  Waited count: " + info.getWaitedCount());
                if (contention) {
                    stream.println("  Blocked time: " + info.getBlockedTime());
                    stream.println("  Waited time: " + info.getWaitedTime());
                }
                if (state == Thread.State.WAITING) {
                    stream.println("  Waiting on " + info.getLockName());
                } else if (state == Thread.State.BLOCKED) {
                    stream.println("  Blocked on " + info.getLockName());
                    stream.println("  Blocked by " + this.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
                }
                stream.println("  Stack:");
                for (StackTraceElement frame : info.getStackTrace()) {
                    stream.println("    " + frame.toString());
                }
            }
            stream.flush();
        }

        private String getTaskName(long id, String taskName) {
            if (taskName == null) {
                return Long.toString(id);
            }
            return id + " (" + taskName + ")";
        }
    }
}

