/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.io.CompressWrap;
import org.apache.sysds.runtime.compress.io.CompressedWriteBlock;
import org.apache.sysds.runtime.compress.io.DictWritable;
import org.apache.sysds.runtime.compress.lib.CLALibSeparator;
import org.apache.sysds.runtime.compress.lib.CLALibSlice;
import org.apache.sysds.runtime.instructions.spark.CompressionSPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public final class WriterCompressed
extends MatrixWriter {
    protected static final Log LOG = LogFactory.getLog((String)WriterCompressed.class.getName());
    protected static int jobUse = 0;
    protected static JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
    private String fname;
    private FileSystem fs;
    private Future<SequenceFile.Writer>[] writers;
    private Lock[] writerLocks;

    public static WriterCompressed create(FileFormatProperties props) {
        return new WriterCompressed();
    }

    public static void writeCompressedMatrixToHDFS(MatrixBlock src, String fname) throws IOException {
        WriterCompressed.writeCompressedMatrixToHDFS(src, fname, src.getNumRows(), src.getNumColumns(), 1000, src.getNonZeros(), false);
    }

    public static void writeCompressedMatrixToHDFS(MatrixBlock src, String fname, int blen) throws IOException {
        WriterCompressed.writeCompressedMatrixToHDFS(src, fname, src.getNumRows(), src.getNumColumns(), blen, src.getNonZeros(), false);
    }

    public static void writeCompressedMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException {
        WriterCompressed.create(null).writeMatrixToHDFS(src, fname, rlen, clen, blen, nnz, diag);
    }

    public static void writeRDDToHDFS(JavaPairRDD<MatrixIndexes, MatrixBlock> src, String path, int blen, DataCharacteristics mc) {
        DataCharacteristics outC = new MatrixCharacteristics(mc).setBlocksize(blen);
        WriterCompressed.writeRDDToHDFS(RDDConverterUtils.binaryBlockToBinaryBlock(src, mc, outC), path);
    }

    public static void writeRDDToHDFS(JavaPairRDD<MatrixIndexes, MatrixBlock> src, String path) {
        src.mapValues(new CompressionSPInstruction.CompressionFunction()).mapValues(new CompressWrap()).saveAsHadoopFile(path, MatrixIndexes.class, CompressedWriteBlock.class, SequenceFileOutputFormat.class);
    }

    @Override
    public void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException {
        if (blen <= 0) {
            throw new DMLRuntimeException("Invalid block size for writing to disk");
        }
        if (diag) {
            throw new DMLRuntimeException("Not supported diag for compressed writing.");
        }
        if (fname == null) {
            throw new DMLRuntimeException("Invalid missing path.");
        }
        if (src == null) {
            throw new DMLRuntimeException("Null matrix block invalid");
        }
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new DMLRuntimeException("Invalid number of rows or columns specified not matching");
        }
        this.write(src, fname, blen);
    }

    @Override
    public void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException {
        if (rlen <= 0L) {
            throw new RuntimeException("Invalid empty write with rlen : " + rlen);
        }
        if (clen <= 0L) {
            throw new RuntimeException("Invalid empty write with clen : " + clen);
        }
        if (blen <= 0) {
            throw new RuntimeException("Invalid empty write with blen " + blen);
        }
        if (rlen > Integer.MAX_VALUE || clen > Integer.MAX_VALUE) {
            throw new RuntimeException("Unable to create compressed matrix block larger than IntMax");
        }
        if (fname == null) {
            throw new RuntimeException("Invalid null file name to write to");
        }
        CompressedMatrixBlock m = CompressedMatrixBlockFactory.createConstant((int)rlen, (int)clen, 0.0);
        this.write(m, fname, blen);
    }

    private void write(MatrixBlock src, String fname, int blen) throws IOException {
        if (++jobUse > 30) {
            job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            jobUse = 0;
        }
        if (this.fname != fname) {
            this.fname = fname;
            this.writers = null;
        }
        this.fs = IOUtilFunctions.getFileSystem(new Path(fname), (Configuration)job);
        int k = OptimizerUtils.getParallelBinaryWriteParallelism();
        k = Math.min(k, (int)(src.getInMemorySize() / InfrastructureAnalyzer.getBlockSize(this.fs)));
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        if (!(src instanceof CompressedMatrixBlock)) {
            src = (MatrixBlock)CompressedMatrixBlockFactory.compress(src, k).getLeft();
        }
        if (rlen <= blen && clen <= blen) {
            this.writeSingleBlock(src, k);
        } else if (!(src instanceof CompressedMatrixBlock)) {
            this.writeMultiBlockUncompressed(src, rlen, clen, blen, k);
        } else {
            this.writeMultiBlockCompressed(src, rlen, clen, blen, k);
        }
    }

    private void writeSingleBlock(MatrixBlock b, int k) throws IOException {
        Path path = new Path(this.fname);
        SequenceFile.Writer w = WriterCompressed.generateWriter(job, path, this.fs);
        MatrixIndexes idx = new MatrixIndexes(1L, 1L);
        if (!(b instanceof CompressedMatrixBlock)) {
            b = (MatrixBlock)CompressedMatrixBlockFactory.compress(b, k).getLeft();
        }
        w.append((Writable)idx, (Writable)new CompressedWriteBlock(b));
        IOUtilFunctions.closeSilently((Closeable)w);
        this.cleanup(path);
    }

    private void writeMultiBlockUncompressed(MatrixBlock b, int rlen, int clen, int blen, int k) throws IOException {
        Path path = new Path(this.fname);
        SequenceFile.Writer w = WriterCompressed.generateWriter(job, path, this.fs);
        MatrixIndexes indexes = new MatrixIndexes();
        LOG.warn((Object)"Writing compressed format with non identical compression scheme");
        int bc = 0;
        while (bc * blen < clen) {
            int sC = bc * blen;
            int mC = Math.min(sC + blen, clen) - 1;
            int br = 0;
            while (br * blen < rlen) {
                int sR = br * blen;
                int mR = Math.min(sR + blen, rlen) - 1;
                MatrixBlock mb = b.slice(sR, mR, sC, mC);
                MatrixBlock mc = (MatrixBlock)CompressedMatrixBlockFactory.compress(mb, k).getLeft();
                indexes.setIndexes(br + 1, bc + 1);
                w.append((Writable)indexes, (Writable)new CompressedWriteBlock(mc));
                ++br;
            }
            ++bc;
        }
        IOUtilFunctions.closeSilently((Closeable)w);
        this.cleanup(path);
    }

    private void writeMultiBlockCompressed(MatrixBlock b, int rlen, int clen, int blen, int k) throws IOException {
        if (k > 1) {
            this.writeMultiBlockCompressedParallel(b, rlen, clen, blen, k);
        } else {
            this.writeMultiBlockCompressedSingleThread(b, rlen, clen, blen);
        }
    }

    private void writeMultiBlockCompressedSingleThread(MatrixBlock mb, int rlen, int clen, int blen) throws IOException {
        try {
            CompressedMatrixBlock cmb = (CompressedMatrixBlock)mb;
            Path path = new Path(this.fname);
            SequenceFile.Writer w = WriterCompressed.generateWriter(job, path, this.fs);
            int bc = 0;
            while (bc * blen < clen) {
                int sC = bc * blen;
                int mC = Math.min(sC + blen, clen) - 1;
                CompressedMatrixBlock mc = CLALibSlice.sliceColumns(cmb, sC, mC);
                CLALibSeparator.SeparatedGroups s = CLALibSeparator.split(mc.getColGroups());
                CompressedMatrixBlock rmc = new CompressedMatrixBlock(mc.getNumRows(), mc.getNumColumns(), mc.getNonZeros(), false, s.indexStructures);
                int nBlocks = rlen / blen + (rlen % blen > 0 ? 1 : 0);
                WriterCompressed.write(w, rmc, bc + 1, 1, nBlocks + 1, blen);
                new DictWriteTask(this.fname, s.dicts, bc).call();
                ++bc;
            }
            IOUtilFunctions.closeSilently((Closeable)w);
            this.cleanup(path);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void writeMultiBlockCompressedParallel(MatrixBlock b, int rlen, int clen, int blen, int k) throws IOException {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
            if (this.writers == null) {
                this.writers = new Future[k];
                this.writerLocks = new Lock[k];
            }
            for (int i = 0; i < k; ++i) {
                int j = i;
                if (this.writers[i] == null) {
                    this.writers[i] = pool.submit(() -> WriterCompressed.generateWriter(job, this.getPath(j), this.fs));
                }
                this.writerLocks[i] = new ReentrantLock();
            }
            int colBlocks = (int)Math.ceil((double)clen / (double)blen);
            int nBlocks = (int)Math.ceil((double)rlen / (double)blen);
            int blocksPerThread = Math.max(1, nBlocks * colBlocks / k);
            HDFSTool.deleteFileIfExistOnHDFS(new Path(this.fname + ".dict"), job);
            int i = 0;
            int bc = 0;
            while (bc * blen < clen) {
                int sC = bc * blen;
                int mC = Math.min(sC + blen, clen) - 1;
                CompressedMatrixBlock mc = CLALibSlice.sliceColumns((CompressedMatrixBlock)b, sC, mC);
                CLALibSeparator.SeparatedGroups s = CLALibSeparator.split(mc.getColGroups());
                CompressedMatrixBlock rmc = new CompressedMatrixBlock(mc.getNumRows(), mc.getNumColumns(), mc.getNonZeros(), false, s.indexStructures);
                for (int block = 0; block < nBlocks; block += blocksPerThread) {
                    WriteTask we = new WriteTask(i++ % k, rmc, bc, block, Math.min(nBlocks, block + blocksPerThread), blen);
                    tasks.add(we);
                }
                tasks.add(new DictWriteTask(this.fname, s.dicts, bc));
                ++bc;
            }
            for (Future o : pool.invokeAll(tasks)) {
                o.get();
            }
            int z = 0;
            while (z < this.writers.length) {
                int l = z++;
                pool.submit(() -> {
                    try {
                        IOUtilFunctions.closeSilently((Closeable)this.writers[l].get());
                        WriterCompressed.cleanup(job, this.getPath(l), this.fs);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new IOException("Failed writing compressed multi block", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private Path getPath(int id) {
        return new Path(this.fname, IOUtilFunctions.getPartFileName(id));
    }

    private static SequenceFile.Writer generateWriter(JobConf job, Path path, FileSystem fs) throws IOException {
        return SequenceFile.createWriter((Configuration)job, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.bufferSize((int)4096), SequenceFile.Writer.keyClass(MatrixIndexes.class), SequenceFile.Writer.valueClass(CompressedWriteBlock.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)IOUtilFunctions.getCompressionEncodingType(), (CompressionCodec)IOUtilFunctions.getCompressionCodec()), SequenceFile.Writer.replication((short)1)});
    }

    private void cleanup(Path p) throws IOException {
        WriterCompressed.cleanup(job, p, this.fs);
    }

    private static void cleanup(JobConf job, Path path, FileSystem fs) throws IOException {
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    private static void write(SequenceFile.Writer w, CompressedMatrixBlock rmc, int bc, int bl, int bu, int blen) throws IOException {
        int nrow = rmc.getNumRows();
        int nGroups = rmc.getColGroups().size();
        for (int b = bl; b < bu; ++b) {
            MatrixIndexes index = new MatrixIndexes(b, bc);
            MatrixBlock cb = CLALibSlice.sliceRowsCompressed(rmc, (b - 1) * blen, Math.min(b * blen, nrow) - 1);
            if (cb instanceof CompressedMatrixBlock && ((CompressedMatrixBlock)cb).getColGroups().size() != nGroups) {
                throw new RuntimeException("invalid writing of different number of column groups");
            }
            CompressedWriteBlock blk = new CompressedWriteBlock(cb);
            w.append((Writable)index, (Writable)blk);
        }
    }

    private class DictWriteTask
    implements Callable<Object> {
        final String fname;
        final List<IDictionary> dicts;
        final Integer id;

        protected DictWriteTask(String fname, List<IDictionary> dicts, int id) {
            this.fname = fname;
            this.dicts = dicts;
            this.id = id;
        }

        @Override
        public Object call() throws Exception {
            Path p = new Path(this.fname + ".dict", IOUtilFunctions.getPartFileName(this.id));
            HDFSTool.deleteFileIfExistOnHDFS(p, job);
            try (SequenceFile.Writer w = SequenceFile.createWriter((Configuration)job, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)p), SequenceFile.Writer.bufferSize((int)4096), SequenceFile.Writer.keyClass(DictWritable.K.class), SequenceFile.Writer.valueClass(DictWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)IOUtilFunctions.getCompressionEncodingType(), (CompressionCodec)IOUtilFunctions.getCompressionCodec()), SequenceFile.Writer.replication((short)1)});){
                w.append((Writable)new DictWritable.K(this.id), (Writable)new DictWritable(this.dicts));
            }
            WriterCompressed.cleanup(job, p, WriterCompressed.this.fs);
            return null;
        }
    }

    private class WriteTask
    implements Callable<Object> {
        final int id;
        final CompressedMatrixBlock rmc;
        final int bc;
        final int bl;
        final int bu;
        final int blen;

        private WriteTask(int id, CompressedMatrixBlock rmc, int bc, int bl, int bu, int blen) {
            this.id = id;
            this.rmc = rmc;
            this.bl = bl + 1;
            this.bu = bu + 1;
            this.bc = bc + 1;
            this.blen = blen;
        }

        @Override
        public Object call() throws Exception {
            WriterCompressed.this.writerLocks[this.id].lock();
            try {
                SequenceFile.Writer w = WriterCompressed.this.writers[this.id].get();
                WriterCompressed.write(w, this.rmc, this.bc, this.bl, this.bu, this.blen);
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                WriterCompressed.this.writerLocks[this.id].unlock();
            }
        }
    }
}

