/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.runner;

import java.time.LocalDateTime;
import org.apache.streampark.common.util.SystemPropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order
@Component
public class StartedUpRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(StartedUpRunner.class);
    @Autowired
    private ConfigurableApplicationContext context;

    public void run(ApplicationArguments args) {
        if (this.context.isActive()) {
            String port = SystemPropertyUtils.get((String)"server.port", (String)"10000");
            System.out.println("\n");
            System.out.println("        _____ __                                             __       ");
            System.out.println("       / ___// /_________  ____ _____ ___  ____  ____ ______/ /__     ");
            System.out.println("       \\__ \\/ __/ ___/ _ \\/ __ `/ __ `__ \\/ __ \\  __ `/ ___/ //_/");
            System.out.println("      ___/ / /_/ /  /  __/ /_/ / / / / / / /_/ / /_/ / /  / ,<        ");
            System.out.println("     /____/\\__/_/   \\___/\\__,_/_/ /_/ /_/ ____/\\__,_/_/  /_/|_|   ");
            System.out.println("                                       /_/                        \n\n");
            System.out.println("    Version:  2.1.6                                                   ");
            System.out.println("    WebSite:  https://streampark.apache.org                           ");
            System.out.println("    GitHub :  https://github.com/apache/streampark          ");
            System.out.println("    Info   :  streampark-console start successful                     ");
            System.out.println("    JDK    :  " + System.getProperty("java.version"));
            System.out.println("    Local  :  http://localhost:" + port);
            System.out.println("    Time   :  " + LocalDateTime.now() + "\n\n");
            System.setProperty("streampark.start.timestamp", System.currentTimeMillis() + "");
        }
    }
}

