/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore;

import java.util.HashSet;
import java.util.Set;
import org.apache.storm.metricstore.AggLevel;
import org.apache.storm.metricstore.MetricException;

public class FilterOptions {
    private Set<AggLevel> aggLevels = null;
    private long startTime = 0L;
    private long endTime = -1L;
    private String topologyId = null;
    private String componentId = null;
    private String metricName = null;
    private String executorId = null;
    private String hostId = null;
    private Integer port = null;
    private String streamId = null;

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topoId) {
        this.topologyId = topoId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String component) {
        this.componentId = component;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long time) {
        this.startTime = time;
    }

    public long getEndTime() {
        if (this.endTime < 0L) {
            this.endTime = System.currentTimeMillis();
        }
        return this.endTime;
    }

    public void setEndTime(Long time) {
        this.endTime = time;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String name) {
        this.metricName = name;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(String id) {
        this.executorId = id;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String id) {
        this.hostId = id;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer p) {
        this.port = p;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String id) {
        this.streamId = id;
    }

    public void addAggLevel(AggLevel level) {
        if (this.aggLevels == null) {
            this.aggLevels = new HashSet<AggLevel>(1);
        }
        this.aggLevels.add(level);
    }

    public Set<AggLevel> getAggLevels() {
        if (this.aggLevels == null) {
            this.aggLevels = new HashSet<AggLevel>(4);
            this.aggLevels.add(AggLevel.AGG_LEVEL_NONE);
            this.aggLevels.add(AggLevel.AGG_LEVEL_1_MIN);
            this.aggLevels.add(AggLevel.AGG_LEVEL_10_MIN);
            this.aggLevels.add(AggLevel.AGG_LEVEL_60_MIN);
        }
        return this.aggLevels;
    }

    public void setAggLevels(Set<AggLevel> levels) throws MetricException {
        this.aggLevels = levels;
        if (this.aggLevels == null || this.aggLevels.isEmpty()) {
            throw new MetricException("Cannot search for empty AggLevel");
        }
    }
}

