/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.List;
import java.util.Map;
import org.apache.storm.utils.DisallowedStrategyException;

public class ReflectionUtils {
    private static ReflectionUtils _instance = new ReflectionUtils();

    public static ReflectionUtils setInstance(ReflectionUtils u) {
        ReflectionUtils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    public static <T> T newInstance(String klass) {
        try {
            return (T)ReflectionUtils.newInstance(Class.forName(klass));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> klass) {
        return _instance.newInstanceImpl(klass);
    }

    public static <T> T newInstance(String klass, Map<String, Object> conf) {
        try {
            return (T)ReflectionUtils.newInstance(Class.forName(klass), conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> klass, Map<String, Object> conf) {
        try {
            return klass.getConstructor(Map.class).newInstance(conf);
        }
        catch (Exception e) {
            try {
                return klass.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static <T> T newSchedulerStrategyInstance(String klass, Map<String, Object> conf) {
        List allowedSchedulerStrategies = (List)conf.get("nimbus.scheduler.strategy.class.whitelist");
        if (allowedSchedulerStrategies == null || allowedSchedulerStrategies.contains(klass)) {
            return ReflectionUtils.newInstance(klass);
        }
        throw new DisallowedStrategyException(klass, allowedSchedulerStrategies);
    }

    public <T> T newInstanceImpl(Class<T> klass) {
        try {
            return klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

