/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.LazyFileInputStream;

public class FileDataRecord
extends AbstractDataRecord {
    private final File file;

    public FileDataRecord(AbstractDataStore store, DataIdentifier identifier, File file) {
        super(store, identifier);
        assert (file.isFile());
        this.file = file;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public InputStream getStream() throws DataStoreException {
        try {
            return new LazyFileInputStream(this.file);
        }
        catch (IOException e) {
            throw new DataStoreException("Error opening input stream of " + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }
}

