/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.Dependency;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageExistsException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanBuilderImpl;

public class CompositePackageRegistry
implements PackageRegistry {
    private final List<PackageRegistry> registries;
    private final PackageRegistry primaryRegistry;

    CompositePackageRegistry(PackageRegistry ... registries) throws IOException {
        this(Arrays.asList(registries));
    }

    public CompositePackageRegistry(List<PackageRegistry> registries) throws IOException {
        this.registries = registries;
        this.primaryRegistry = registries.get(0);
        this.enforcePackageIdsUniqueness(this.registries);
    }

    private void enforcePackageIdsUniqueness(List<PackageRegistry> registries) throws IOException {
        for (int n = 0; n < registries.size(); ++n) {
            for (int i = n + 1; i < registries.size(); ++i) {
                registries.get(n).packages().retainAll(registries.get(i).packages());
                Set<PackageId> packageIntersection = registries.get(n).packages();
                packageIntersection.retainAll(registries.get(i).packages());
                if (packageIntersection.isEmpty()) continue;
                String duplicatePackageIds = packageIntersection.stream().map(packageId -> packageId.toString()).collect(Collectors.joining(", "));
                throw new IllegalStateException("The following package ids exist in registry " + registries.get(i) + " and registry " + registries.get(n) + ": " + duplicatePackageIds);
            }
        }
    }

    private void enforcePackageIdsUniqueness(PackageId packageId, PackageRegistry sourcePackageRegistry) throws PackageExistsException, IOException {
        for (PackageRegistry registry : this.registries) {
            if (registry == sourcePackageRegistry || !registry.contains(packageId)) continue;
            try {
                sourcePackageRegistry.remove(packageId);
            }
            catch (NoSuchPackageException e) {
                throw new IOException("Could not remove duplicate package id " + packageId, e);
            }
            throw new PackageExistsException("The package id " + packageId + " already exists in another registry " + registry);
        }
    }

    @Override
    public boolean contains(@NotNull PackageId id) throws IOException {
        for (PackageRegistry registry : this.registries) {
            if (!registry.contains(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<PackageId> packages() throws IOException {
        HashSet<PackageId> allPackages = new HashSet<PackageId>();
        for (PackageRegistry registry : this.registries) {
            allPackages.addAll(registry.packages());
        }
        return allPackages;
    }

    @Override
    @Nullable
    public RegisteredPackage open(@NotNull PackageId id) throws IOException {
        for (PackageRegistry registry : this.registries) {
            if (!registry.contains(id)) continue;
            return registry.open(id);
        }
        return null;
    }

    @Override
    @NotNull
    public PackageId register(@NotNull InputStream in, boolean replace) throws IOException, PackageExistsException {
        PackageId packageId = this.primaryRegistry.register(in, replace);
        this.enforcePackageIdsUniqueness(packageId, this.primaryRegistry);
        return packageId;
    }

    @Override
    @NotNull
    public PackageId register(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        PackageId packageId = this.primaryRegistry.register(file, replace);
        this.enforcePackageIdsUniqueness(packageId, this.primaryRegistry);
        return packageId;
    }

    @Override
    @NotNull
    public PackageId registerExternal(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        PackageId packageId = this.primaryRegistry.registerExternal(file, replace);
        this.enforcePackageIdsUniqueness(packageId, this.primaryRegistry);
        return packageId;
    }

    @Override
    public void remove(@NotNull PackageId id) throws IOException, NoSuchPackageException {
        for (PackageRegistry registry : this.registries) {
            if (!registry.contains(id)) continue;
            registry.remove(id);
            return;
        }
        throw new NoSuchPackageException("No registry contains the given package id " + id);
    }

    @Override
    @NotNull
    public DependencyReport analyzeDependencies(@NotNull PackageId id, boolean onlyInstalled) throws IOException, NoSuchPackageException {
        for (PackageRegistry registry : this.registries) {
            if (!registry.contains(id)) continue;
            return registry.analyzeDependencies(id, onlyInstalled);
        }
        throw new NoSuchPackageException("No registry contains the given package id " + id);
    }

    @Override
    @Nullable
    public PackageId resolve(@NotNull Dependency dependency, boolean onlyInstalled) throws IOException {
        PackageId packageId = null;
        for (PackageRegistry registry : this.registries) {
            packageId = registry.resolve(dependency, onlyInstalled);
            if (packageId == null) continue;
            return packageId;
        }
        return packageId;
    }

    @Override
    @NotNull
    public PackageId[] usage(@NotNull PackageId id) throws IOException {
        ArrayList<PackageId> dependentPackageIds = new ArrayList<PackageId>();
        for (PackageRegistry registry : this.registries) {
            PackageId[] packageIds = registry.usage(id);
            if (packageIds.length <= 0) continue;
            dependentPackageIds.addAll(Arrays.asList(packageIds));
        }
        return dependentPackageIds.toArray(new PackageId[0]);
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder createExecutionPlan() {
        return new ExecutionPlanBuilderImpl(this);
    }
}

