/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.interpolator;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.feature.cpconverter.interpolator.VariablesInterpolator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleVariablesInterpolator
implements VariablesInterpolator {
    private final Pattern replacementPattern = Pattern.compile("\\$\\{\\{(.+?)\\}\\}");

    @Override
    @NotNull
    public String interpolate(@NotNull String format, @Nullable Map<String, String> properties) {
        Objects.requireNonNull(format, "Input string format must be not null");
        if (properties == null || properties.isEmpty()) {
            return format;
        }
        Matcher matcher = this.replacementPattern.matcher(format);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String variable = matcher.group(1);
            String resolved = properties.get(variable);
            if (resolved == null) {
                resolved = String.format("\\$\\{\\{%s\\}\\}", variable);
            }
            matcher.appendReplacement(result, resolved);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

