/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserErrorLog;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.BrowserErrorLogDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.ErrorLogParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogAnalysisListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorLogAnalyzer.class);
    private final ModuleManager moduleManager;
    private final ErrorLogParserListenerManager listenerManager;
    private final BrowserServiceModuleConfig moduleConfig;
    private final List<ErrorLogAnalysisListener> analysisListeners = new LinkedList<ErrorLogAnalysisListener>();

    public void doAnalysis(BrowserErrorLog errorLog) {
        this.createAnalysisListeners();
        try {
            BrowserErrorLogDecorator decorator = new BrowserErrorLogDecorator(errorLog);
            long nowMillis = System.currentTimeMillis();
            decorator.setTime(nowMillis);
            this.notifyListener(decorator);
            this.notifyListenerToBuild();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    private void notifyListener(BrowserErrorLogDecorator decorator) {
        this.analysisListeners.forEach(listener -> listener.parse(decorator));
    }

    private void notifyListenerToBuild() {
        this.analysisListeners.forEach(ErrorLogAnalysisListener::build);
    }

    private void createAnalysisListeners() {
        this.listenerManager.getErrorLogAnalysisListeners().forEach(factory -> this.analysisListeners.add(factory.create(this.moduleManager, this.moduleConfig)));
    }

    @Generated
    public ErrorLogAnalyzer(ModuleManager moduleManager, ErrorLogParserListenerManager listenerManager, BrowserServiceModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.listenerManager = listenerManager;
        this.moduleConfig = moduleConfig;
    }
}

