/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.cors;

import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.armeria.server.annotation.decorator.CorsDecorator;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.cors.CorsServiceBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class CorsDecoratorFactoryFunction
implements DecoratorFactoryFunction<CorsDecorator> {
    @Override
    public Function<? super HttpService, ? extends HttpService> newDecorator(CorsDecorator parameter) {
        CorsServiceBuilder cb;
        Objects.requireNonNull(parameter, "parameter");
        if (parameter.origins().length == 0 && parameter.originRegexes().length == 0) {
            throw new IllegalArgumentException("Either origins or originRegex must be configured");
        }
        List<String> origins = Arrays.asList(parameter.origins());
        if (!origins.isEmpty() && origins.contains("*")) {
            cb = CorsService.builderForAnyOrigin();
        } else {
            Predicate<String> originPredicate = !origins.isEmpty() ? origins::contains : origin -> false;
            for (String originRegex : parameter.originRegexes()) {
                Pattern regex = Pattern.compile(originRegex);
                originPredicate = originPredicate.or(regex.asPredicate());
            }
            cb = CorsService.builder(originPredicate);
        }
        cb.firstPolicyBuilder.setConfig(parameter);
        Function<? super HttpService, CorsService> decorator = cb.newDecorator();
        return service -> {
            if (service.as(CorsService.class) != null) {
                return service;
            }
            return (HttpService)decorator.apply((HttpService)service);
        };
    }
}

