/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import io.grpc.Status;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.config.DownSamplingConfigService;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MeasureModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.PropertyModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.StreamModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBIndexInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBIndexInstaller.class);
    private final Set<String> groupAligned = new HashSet<String>();
    private final Map<String, Map<String, BanyandbDatabase.IndexRule>> groupIndexRules = new HashMap<String, Map<String, BanyandbDatabase.IndexRule>>();
    private final BanyanDBStorageConfig config;

    public BanyanDBIndexInstaller(Client client, ModuleManager moduleManager, BanyanDBStorageConfig config) {
        super(client, moduleManager);
        this.config = config;
    }

    public ModelInstaller.InstallInfo isExists(Model model) throws StorageException {
        InstallInfoBanyanDB installInfo = new InstallInfoBanyanDB(model);
        installInfo.setDownSampling(model.getDownsampling());
        DownSamplingConfigService downSamplingConfigService = (DownSamplingConfigService)this.moduleManager.find("core").provider().getService(DownSamplingConfigService.class);
        MetadataRegistry.SchemaMetadata metadata = MetadataRegistry.INSTANCE.parseMetadata(model, this.config, downSamplingConfigService);
        installInfo.setTableName(metadata.name());
        installInfo.setKind(metadata.getKind());
        installInfo.setGroup(metadata.getGroup());
        try {
            BanyanDBClient c = ((BanyanDBStorageClient)this.client).client;
            ResourceExist resourceExist = this.checkResourceExistence(metadata, c);
            installInfo.setGroupExist(resourceExist.hasGroup());
            installInfo.setTableExist(resourceExist.hasResource());
            if (!resourceExist.hasResource()) {
                installInfo.setAllExist(false);
                return installInfo;
            }
            if (model.isTimeSeries()) {
                if (model.isRecord()) {
                    StreamModel streamModel = MetadataRegistry.INSTANCE.registerStreamModel(model, this.config, downSamplingConfigService);
                    if (!RunningMode.isNoInitMode()) {
                        this.checkStream(streamModel.getStream(), c);
                        this.checkIndexRules(model.getName(), streamModel.getIndexRules(), c);
                        this.checkIndexRuleBinding(streamModel.getIndexRules(), metadata.getGroup(), metadata.name(), BanyandbCommon.Catalog.CATALOG_STREAM, c);
                    }
                } else {
                    MeasureModel measureModel = MetadataRegistry.INSTANCE.registerMeasureModel(model, this.config, downSamplingConfigService);
                    if (!RunningMode.isNoInitMode()) {
                        this.checkMeasure(measureModel.getMeasure(), c);
                        this.checkIndexRules(model.getName(), measureModel.getIndexRules(), c);
                        this.checkIndexRuleBinding(measureModel.getIndexRules(), metadata.getGroup(), metadata.name(), BanyandbCommon.Catalog.CATALOG_MEASURE, c);
                        this.checkTopNAggregation(model, c);
                    }
                }
                MetadataCache.EntityMetadata remoteMeta = this.updateSchemaFromServer(metadata, c);
                if (remoteMeta == null) {
                    throw new IllegalStateException("inconsistent state: metadata:" + metadata + ", remoteMeta: null");
                }
            } else {
                PropertyModel propertyModel = MetadataRegistry.INSTANCE.registerPropertyModel(model, this.config);
                if (!RunningMode.isNoInitMode()) {
                    this.checkProperty(propertyModel.getProperty(), c);
                }
            }
            installInfo.setAllExist(true);
            return installInfo;
        }
        catch (BanyanDBException ex) {
            throw new StorageException("fail to check existence", (Throwable)ex);
        }
    }

    public void createTable(Model model) throws StorageException {
        block20: {
            try {
                DownSamplingConfigService configService = (DownSamplingConfigService)this.moduleManager.find("core").provider().getService(DownSamplingConfigService.class);
                if (model.isTimeSeries()) {
                    if (model.isRecord()) {
                        StreamModel streamModel = MetadataRegistry.INSTANCE.registerStreamModel(model, this.config, configService);
                        BanyandbDatabase.Stream stream = streamModel.getStream();
                        if (stream == null) break block20;
                        log.info("install stream schema {}", (Object)model.getName());
                        BanyanDBClient client = ((BanyanDBStorageClient)this.client).client;
                        try {
                            client.define(stream);
                            if (CollectionUtils.isNotEmpty(streamModel.getIndexRules())) {
                                for (BanyandbDatabase.IndexRule indexRule : streamModel.getIndexRules()) {
                                    this.defineIndexRule(model.getName(), indexRule, client);
                                }
                                this.defineIndexRuleBinding(streamModel.getIndexRules(), stream.getMetadata().getGroup(), stream.getMetadata().getName(), BanyandbCommon.Catalog.CATALOG_STREAM, client);
                            }
                            break block20;
                        }
                        catch (BanyanDBException ex) {
                            if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                                log.info("Stream schema {}_{} already created by another OAP node", (Object)model.getName(), (Object)model.getDownsampling());
                                break block20;
                            }
                            throw ex;
                        }
                    }
                    MeasureModel measureModel = MetadataRegistry.INSTANCE.registerMeasureModel(model, this.config, configService);
                    BanyandbDatabase.Measure measure = measureModel.getMeasure();
                    if (measure == null) break block20;
                    log.info("install measure schema {}", (Object)model.getName());
                    BanyanDBClient client = ((BanyanDBStorageClient)this.client).client;
                    try {
                        client.define(measure);
                        if (CollectionUtils.isNotEmpty(measureModel.getIndexRules())) {
                            for (BanyandbDatabase.IndexRule indexRule : measureModel.getIndexRules()) {
                                this.defineIndexRule(model.getName(), indexRule, client);
                            }
                            this.defineIndexRuleBinding(measureModel.getIndexRules(), measure.getMetadata().getGroup(), measure.getMetadata().getName(), BanyandbCommon.Catalog.CATALOG_MEASURE, client);
                        }
                    }
                    catch (BanyanDBException ex) {
                        if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                            log.info("Measure schema {}_{} already created by another OAP node", (Object)model.getName(), (Object)model.getDownsampling());
                        }
                        throw ex;
                    }
                    MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
                    try {
                        this.defineTopNAggregation(schema, client);
                        break block20;
                    }
                    catch (BanyanDBException ex) {
                        if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                            log.info("Measure schema {}_{} TopN({}) already created by another OAP node", new Object[]{model.getName(), model.getDownsampling(), schema.getTopNSpec()});
                            break block20;
                        }
                        throw ex;
                    }
                }
                PropertyModel propertyModel = MetadataRegistry.INSTANCE.registerPropertyModel(model, this.config);
                BanyandbDatabase.Property property = propertyModel.getProperty();
                log.info("install property schema {}", (Object)model.getName());
                BanyanDBClient client = ((BanyanDBStorageClient)this.client).client;
                try {
                    client.define(property);
                }
                catch (BanyanDBException ex) {
                    if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                        log.info("Property schema {} already created by another OAP node", (Object)model.getName());
                        break block20;
                    }
                    throw ex;
                }
            }
            catch (BanyanDBException ex) {
                throw new StorageException("fail to create schema " + model.getName(), (Throwable)ex);
            }
        }
    }

    private boolean checkGroup(MetadataRegistry.SchemaMetadata metadata, BanyanDBClient client) throws BanyanDBException {
        BanyandbCommon.Group g = client.findGroup(metadata.getGroup());
        return g.getResourceOpts().getShardNum() != metadata.getShard() || g.getResourceOpts().getSegmentInterval().getNum() != metadata.getSegmentIntervalDays() || g.getResourceOpts().getTtl().getNum() != metadata.getTtlDays();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceExist checkResourceExistence(MetadataRegistry.SchemaMetadata metadata, BanyanDBClient client) throws BanyanDBException {
        ResourceExist resourceExist;
        BanyandbCommon.Group.Builder gBuilder = BanyandbCommon.Group.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setName(metadata.getGroup()));
        BanyandbCommon.ResourceOpts.Builder optsBuilder = BanyandbCommon.ResourceOpts.newBuilder().setShardNum(metadata.getShard());
        switch (metadata.getKind()) {
            case STREAM: {
                optsBuilder.setSegmentInterval(BanyandbCommon.IntervalRule.newBuilder().setUnit(BanyandbCommon.IntervalRule.Unit.UNIT_DAY).setNum(metadata.getSegmentIntervalDays())).setTtl(BanyandbCommon.IntervalRule.newBuilder().setUnit(BanyandbCommon.IntervalRule.Unit.UNIT_DAY).setNum(metadata.getTtlDays()));
                resourceExist = client.existStream(metadata.getGroup(), metadata.name());
                gBuilder.setCatalog(BanyandbCommon.Catalog.CATALOG_STREAM).build();
                break;
            }
            case MEASURE: {
                optsBuilder.setSegmentInterval(BanyandbCommon.IntervalRule.newBuilder().setUnit(BanyandbCommon.IntervalRule.Unit.UNIT_DAY).setNum(metadata.getSegmentIntervalDays())).setTtl(BanyandbCommon.IntervalRule.newBuilder().setUnit(BanyandbCommon.IntervalRule.Unit.UNIT_DAY).setNum(metadata.getTtlDays()));
                resourceExist = client.existMeasure(metadata.getGroup(), metadata.name());
                gBuilder.setCatalog(BanyandbCommon.Catalog.CATALOG_MEASURE).build();
                break;
            }
            case PROPERTY: {
                resourceExist = client.existProperty(metadata.getGroup(), metadata.name());
                gBuilder.setCatalog(BanyandbCommon.Catalog.CATALOG_PROPERTY).build();
                break;
            }
            default: {
                throw new IllegalStateException("unknown metadata kind: " + metadata.getKind());
            }
        }
        gBuilder.setResourceOpts(optsBuilder.build());
        if (!RunningMode.isNoInitMode() && !this.groupAligned.contains(metadata.getGroup())) {
            if (!resourceExist.hasGroup()) {
                try {
                    BanyandbCommon.Group g = client.define(gBuilder.build());
                    if (g != null) {
                        log.info("group {} created", (Object)g.getMetadata().getName());
                    }
                }
                catch (BanyanDBException ex) {
                    if (!ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                        throw ex;
                    }
                    log.info("group {} already created by another OAP node", (Object)metadata.getGroup());
                }
            } else if (this.checkGroup(metadata, client)) {
                client.update(gBuilder.build());
                log.info("group {} updated", (Object)metadata.getGroup());
            }
            this.groupAligned.add(metadata.getGroup());
        }
        return resourceExist;
    }

    private MetadataCache.EntityMetadata updateSchemaFromServer(MetadataRegistry.SchemaMetadata metadata, BanyanDBClient client) throws BanyanDBException {
        switch (metadata.getKind()) {
            case STREAM: {
                return client.updateStreamMetadataCacheFromSever(metadata.getGroup(), metadata.name());
            }
            case MEASURE: {
                return client.updateMeasureMetadataCacheFromSever(metadata.getGroup(), metadata.name());
            }
        }
        throw new IllegalStateException("unknown metadata kind: " + metadata.getKind());
    }

    private void defineTopNAggregation(MetadataRegistry.Schema schema, BanyanDBClient client) throws BanyanDBException {
        if (schema.getTopNSpec() == null) {
            if (schema.getMetadata().getKind() == MetadataRegistry.Kind.MEASURE) {
                log.debug("skip null TopN Schema for [{}]", (Object)schema.getMetadata().name());
            }
            return;
        }
        try {
            client.define(schema.getTopNSpec());
            log.info("installed TopN schema for measure {}", (Object)schema.getMetadata().name());
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                log.info("TopNAggregation {} already created by another OAP node", (Object)schema.getTopNSpec());
            }
            throw ex;
        }
    }

    private void checkIndexRuleConflicts(String modelName, BanyandbDatabase.IndexRule indexRule, BanyandbDatabase.IndexRule existRule) {
        if (!existRule.equals((Object)indexRule)) {
            throw new IllegalStateException("conflict index rule in model: " + modelName + ": " + indexRule + " vs exist rule: " + existRule);
        }
    }

    private boolean checkIndexRuleProcessed(String modelName, BanyandbDatabase.IndexRule indexRule) {
        Map rules = this.groupIndexRules.computeIfAbsent(indexRule.getMetadata().getGroup(), k -> new HashMap());
        BanyandbDatabase.IndexRule existRule = (BanyandbDatabase.IndexRule)rules.get(indexRule.getMetadata().getName());
        if (existRule != null) {
            this.checkIndexRuleConflicts(modelName, indexRule, existRule);
            return true;
        }
        rules.put(indexRule.getMetadata().getName(), indexRule);
        return false;
    }

    private void defineIndexRule(String modelName, BanyandbDatabase.IndexRule indexRule, BanyanDBClient client) throws BanyanDBException {
        if (this.checkIndexRuleProcessed(modelName, indexRule)) {
            return;
        }
        try {
            client.define(indexRule);
            log.info("new IndexRule created: {}", (Object)indexRule.getMetadata().getName());
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                log.info("IndexRule {} already created by another OAP node", (Object)indexRule.getMetadata().getName());
            }
            throw ex;
        }
    }

    private void defineIndexRuleBinding(List<BanyandbDatabase.IndexRule> indexRules, String group, String name, BanyandbCommon.Catalog catalog, BanyanDBClient client) throws BanyanDBException {
        List indexRuleNames = indexRules.stream().map(indexRule -> indexRule.getMetadata().getName()).collect(Collectors.toList());
        try {
            client.define(BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name)).setSubject(BanyandbDatabase.Subject.newBuilder().setName(name).setCatalog(catalog)).addAllRules(indexRuleNames).build());
            log.info("new IndexRuleBinding created: {}", (Object)name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                log.info("IndexRuleBinding {} already created by another OAP node", (Object)name);
            }
            throw ex;
        }
    }

    private void checkMeasure(BanyandbDatabase.Measure measure, BanyanDBClient client) throws BanyanDBException {
        BanyandbDatabase.Measure hisMeasure = client.findMeasure(measure.getMetadata().getGroup(), measure.getMetadata().getName());
        if (hisMeasure == null) {
            throw new IllegalStateException("Measure: " + measure.getMetadata().getName() + " exist but can't find it from BanyanDB server");
        }
        boolean equals = hisMeasure.toBuilder().clearUpdatedAt().clearMetadata().build().equals((Object)measure.toBuilder().clearMetadata().build());
        if (!equals) {
            client.update(measure);
            log.info("update Measure: {} from: {} to: {}", new Object[]{hisMeasure.getMetadata().getName(), hisMeasure, measure});
        }
    }

    private void checkStream(BanyandbDatabase.Stream stream, BanyanDBClient client) throws BanyanDBException {
        BanyandbDatabase.Stream hisStream = client.findStream(stream.getMetadata().getGroup(), stream.getMetadata().getName());
        if (hisStream == null) {
            throw new IllegalStateException("Stream: " + stream.getMetadata().getName() + " exist but can't find it from BanyanDB server");
        }
        boolean equals = hisStream.toBuilder().clearUpdatedAt().clearMetadata().build().equals((Object)stream.toBuilder().clearUpdatedAt().clearMetadata().build());
        if (!equals) {
            client.update(stream);
            log.info("update Stream: {} from: {} to: {}", new Object[]{hisStream.getMetadata().getName(), hisStream, stream});
        }
    }

    private void checkProperty(BanyandbDatabase.Property property, BanyanDBClient client) throws BanyanDBException {
        BanyandbDatabase.Property hisProperty = client.findPropertyDefinition(property.getMetadata().getGroup(), property.getMetadata().getName());
        if (hisProperty == null) {
            throw new IllegalStateException("Property: " + property.getMetadata().getName() + " exist but can't find it from BanyanDB server");
        }
        boolean equals = hisProperty.toBuilder().clearUpdatedAt().clearMetadata().build().equals((Object)property.toBuilder().clearUpdatedAt().clearMetadata().build());
        if (!equals) {
            client.update(property);
            log.info("update Property: {} from: {} to: {}", new Object[]{hisProperty.getMetadata().getName(), hisProperty, property});
        }
    }

    private void checkIndexRules(String modelName, List<BanyandbDatabase.IndexRule> indexRules, BanyanDBClient client) throws BanyanDBException {
        for (BanyandbDatabase.IndexRule indexRule : indexRules) {
            if (this.checkIndexRuleProcessed(modelName, indexRule)) {
                return;
            }
            BanyandbDatabase.IndexRule hisIndexRule = client.findIndexRule(indexRule.getMetadata().getGroup(), indexRule.getMetadata().getName());
            if (hisIndexRule == null) {
                try {
                    client.define(indexRule);
                    log.info("new IndexRule created: {}", (Object)indexRule);
                    continue;
                }
                catch (BanyanDBException ex) {
                    if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                        log.info("IndexRule {} already created by another OAP node", (Object)indexRule);
                        continue;
                    }
                    throw ex;
                }
            }
            boolean equals = hisIndexRule.toBuilder().clearUpdatedAt().clearMetadata().build().equals((Object)indexRule.toBuilder().clearUpdatedAt().clearMetadata().build());
            if (equals) continue;
            client.update(indexRule);
            log.info("update IndexRule: {} from: {} to: {}", new Object[]{hisIndexRule.getMetadata().getName(), hisIndexRule, indexRule});
        }
    }

    private void checkIndexRuleBinding(List<BanyandbDatabase.IndexRule> indexRules, String group, String name, BanyandbCommon.Catalog catalog, BanyanDBClient client) throws BanyanDBException {
        if (indexRules.isEmpty()) {
            return;
        }
        List indexRuleNames = indexRules.stream().map(indexRule -> indexRule.getMetadata().getName()).collect(Collectors.toList());
        BanyandbDatabase.IndexRuleBinding indexRuleBinding = BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name)).setSubject(BanyandbDatabase.Subject.newBuilder().setName(name).setCatalog(catalog)).addAllRules(indexRuleNames).build();
        BanyandbDatabase.IndexRuleBinding hisIndexRuleBinding = client.findIndexRuleBinding(group, name);
        if (hisIndexRuleBinding == null) {
            try {
                client.define(indexRuleBinding);
                log.info("new IndexRuleBinding created: {}", (Object)indexRuleBinding);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                    log.info("IndexRuleBinding {} already created by another OAP node", (Object)indexRuleBinding);
                }
                throw ex;
            }
        } else {
            boolean equals = hisIndexRuleBinding.toBuilder().clearUpdatedAt().clearMetadata().clearBeginAt().clearExpireAt().build().equals((Object)indexRuleBinding.toBuilder().clearMetadata().build());
            if (!equals) {
                client.update(indexRuleBinding.toBuilder().setBeginAt(hisIndexRuleBinding.getBeginAt()).setExpireAt(hisIndexRuleBinding.getExpireAt()).build());
                log.info("update IndexRuleBinding: {} from: {} to: {}", new Object[]{hisIndexRuleBinding.getMetadata().getName(), hisIndexRuleBinding, indexRuleBinding});
            }
        }
    }

    private void checkTopNAggregation(Model model, BanyanDBClient client) throws BanyanDBException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
        String topNName = MetadataRegistry.Schema.formatTopNName(schema.getMetadata().name());
        BanyandbDatabase.TopNAggregation hisTopNAggregation = client.findTopNAggregation(schema.getMetadata().getGroup(), topNName);
        if (schema.getTopNSpec() != null) {
            BanyandbDatabase.TopNAggregation topNAggregation = schema.getTopNSpec();
            if (hisTopNAggregation == null) {
                try {
                    client.define(topNAggregation);
                    log.info("new TopNAggregation created: {}", (Object)topNAggregation);
                }
                catch (BanyanDBException ex) {
                    if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) {
                        log.info("TopNAggregation {} already created by another OAP node", (Object)topNAggregation);
                    }
                    throw ex;
                }
            } else {
                boolean equals = hisTopNAggregation.toBuilder().clearUpdatedAt().clearMetadata().build().equals((Object)topNAggregation.toBuilder().clearMetadata().build());
                if (!equals) {
                    client.update(topNAggregation);
                    log.info("update TopNAggregation: {} from: {} to: {}", new Object[]{hisTopNAggregation.getMetadata().getName(), hisTopNAggregation, topNAggregation});
                }
            }
        } else if (hisTopNAggregation != null) {
            client.deleteTopNAggregation(schema.getMetadata().getGroup(), topNName);
            log.info("delete deprecated TopNAggregation: {} from group: {}", (Object)hisTopNAggregation.getMetadata().getName(), (Object)schema.getMetadata().getGroup());
        }
    }

    private static class InstallInfoBanyanDB
    extends ModelInstaller.InstallInfo {
        private DownSampling downSampling;
        private String tableName;
        private MetadataRegistry.Kind kind;
        private String group;
        private boolean tableExist;
        private boolean groupExist;

        protected InstallInfoBanyanDB(Model model) {
            super(model);
        }

        public String buildInstallInfoMsg() {
            return "InstallInfoBanyanDB{modelName=" + this.getModelName() + ", modelType=" + this.getModelType() + ", timeSeries=" + this.isTimeSeries() + ", superDataset=" + this.isSuperDataset() + ", downSampling=" + this.downSampling.name() + ", tableName=" + this.tableName + ", kind=" + this.kind.name() + ", group=" + this.group + ", allResourcesExist=" + this.isAllExist() + " [groupExist=" + this.groupExist + ", tableExist=" + this.tableExist + "]}";
        }

        @Generated
        public DownSampling getDownSampling() {
            return this.downSampling;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public MetadataRegistry.Kind getKind() {
            return this.kind;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public boolean isTableExist() {
            return this.tableExist;
        }

        @Generated
        public boolean isGroupExist() {
            return this.groupExist;
        }

        @Generated
        public void setDownSampling(DownSampling downSampling) {
            this.downSampling = downSampling;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public void setKind(MetadataRegistry.Kind kind) {
            this.kind = kind;
        }

        @Generated
        public void setGroup(String group) {
            this.group = group;
        }

        @Generated
        public void setTableExist(boolean tableExist) {
            this.tableExist = tableExist;
        }

        @Generated
        public void setGroupExist(boolean groupExist) {
            this.groupExist = groupExist;
        }
    }
}

