/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.aws.firehose;

import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.firehose.v0_7.AnyValue;
import io.opentelemetry.proto.common.firehose.v0_7.ArrayValue;
import io.opentelemetry.proto.common.firehose.v0_7.KeyValue;
import io.opentelemetry.proto.common.firehose.v0_7.KeyValueList;
import io.opentelemetry.proto.common.firehose.v0_7.StringKeyValue;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.ArrayValue;
import io.opentelemetry.proto.common.v1.KeyValueList;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleDataPoint;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleGauge;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleHistogram;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleHistogramDataPoint;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleSum;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleSummary;
import io.opentelemetry.proto.metrics.firehose.v0_7.DoubleSummaryDataPoint;
import io.opentelemetry.proto.metrics.firehose.v0_7.InstrumentationLibraryMetrics;
import io.opentelemetry.proto.metrics.firehose.v0_7.IntDataPoint;
import io.opentelemetry.proto.metrics.firehose.v0_7.IntGauge;
import io.opentelemetry.proto.metrics.firehose.v0_7.IntHistogram;
import io.opentelemetry.proto.metrics.firehose.v0_7.IntHistogramDataPoint;
import io.opentelemetry.proto.metrics.firehose.v0_7.IntSum;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Gauge;
import io.opentelemetry.proto.metrics.v1.Histogram;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.Summary;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Optional;

public class OtelMetricsConvertor {
    public static ExportMetricsServiceRequest convertExportMetricsRequest(io.opentelemetry.proto.collector.metrics.firehose.v0_7.ExportMetricsServiceRequest sourceRequest) {
        ExportMetricsServiceRequest.Builder targetRequestBuilder = ExportMetricsServiceRequest.newBuilder();
        for (io.opentelemetry.proto.metrics.firehose.v0_7.ResourceMetrics resourceMetrics : sourceRequest.getResourceMetricsList()) {
            targetRequestBuilder.addResourceMetrics(OtelMetricsConvertor.convertResourceMetrics(resourceMetrics));
        }
        return targetRequestBuilder.build();
    }

    private static ResourceMetrics convertResourceMetrics(io.opentelemetry.proto.metrics.firehose.v0_7.ResourceMetrics resourceMetrics) {
        ResourceMetrics.Builder targetResourceMetricsBuilder = ResourceMetrics.newBuilder();
        targetResourceMetricsBuilder.setResource(OtelMetricsConvertor.convertResource(resourceMetrics.getResource()));
        for (InstrumentationLibraryMetrics instrumentationLibraryMetrics : resourceMetrics.getInstrumentationLibraryMetricsList()) {
            targetResourceMetricsBuilder.addScopeMetrics(OtelMetricsConvertor.convertScopeMetrics(instrumentationLibraryMetrics));
        }
        return targetResourceMetricsBuilder.build();
    }

    private static ScopeMetrics convertScopeMetrics(InstrumentationLibraryMetrics instrumentationLibraryMetrics) {
        ScopeMetrics.Builder builder = ScopeMetrics.newBuilder();
        for (io.opentelemetry.proto.metrics.firehose.v0_7.Metric metric : instrumentationLibraryMetrics.getMetricsList()) {
            builder.addMetrics(OtelMetricsConvertor.convertMetrics(metric));
        }
        return builder.build();
    }

    private static Metric convertMetrics(io.opentelemetry.proto.metrics.firehose.v0_7.Metric metric) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setDescription(metric.getDescription());
        builder.setDescriptionBytes(metric.getDescriptionBytes());
        builder.setName(metric.getName());
        builder.setNameBytes(metric.getNameBytes());
        builder.setUnit(metric.getUnit());
        builder.setUnitBytes(metric.getUnitBytes());
        Optional.of(metric.getDoubleGauge()).map(OtelMetricsConvertor::convertDoubleGauge).ifPresent(arg_0 -> ((Metric.Builder)builder).setGauge(arg_0));
        Optional.of(metric.getIntGauge()).map(OtelMetricsConvertor::convertIntGauge).ifPresent(arg_0 -> ((Metric.Builder)builder).setGauge(arg_0));
        Optional.of(metric.getDoubleHistogram()).map(OtelMetricsConvertor::convertDoubleHistogram).ifPresent(arg_0 -> ((Metric.Builder)builder).setHistogram(arg_0));
        Optional.of(metric.getIntHistogram()).map(OtelMetricsConvertor::convertIntHistogram).ifPresent(arg_0 -> ((Metric.Builder)builder).setHistogram(arg_0));
        Optional.of(metric.getDoubleSum()).map(OtelMetricsConvertor::convertDoubleSum).ifPresent(arg_0 -> ((Metric.Builder)builder).setSum(arg_0));
        Optional.of(metric.getIntSum()).map(OtelMetricsConvertor::convertIntSum).ifPresent(arg_0 -> ((Metric.Builder)builder).setSum(arg_0));
        Optional.of(metric.getDoubleSummary()).map(OtelMetricsConvertor::convertDoubleSummary).ifPresent(arg_0 -> ((Metric.Builder)builder).setSummary(arg_0));
        return builder.build();
    }

    private static Summary convertDoubleSummary(DoubleSummary doubleSummary) {
        Summary.Builder builder = Summary.newBuilder();
        doubleSummary.getDataPointsList().stream().map(OtelMetricsConvertor::convertDoubleSummaryDatapoint).forEach(arg_0 -> ((Summary.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static SummaryDataPoint convertDoubleSummaryDatapoint(DoubleSummaryDataPoint doubleSummaryDataPoint) {
        SummaryDataPoint.Builder builder = SummaryDataPoint.newBuilder();
        doubleSummaryDataPoint.getLabelsList().stream().map(OtelMetricsConvertor::convertStringKV).forEach(arg_0 -> ((SummaryDataPoint.Builder)builder).addAttributes(arg_0));
        builder.setCount(doubleSummaryDataPoint.getCount());
        builder.setSum(doubleSummaryDataPoint.getSum());
        builder.setFlags(0);
        doubleSummaryDataPoint.getQuantileValuesList().stream().map(OtelMetricsConvertor::convertValueAtQuantile).forEach(arg_0 -> ((SummaryDataPoint.Builder)builder).addQuantileValues(arg_0));
        builder.setStartTimeUnixNano(doubleSummaryDataPoint.getStartTimeUnixNano());
        builder.setTimeUnixNano(doubleSummaryDataPoint.getTimeUnixNano());
        return builder.build();
    }

    private static SummaryDataPoint.ValueAtQuantile convertValueAtQuantile(DoubleSummaryDataPoint.ValueAtQuantile valueAtQuantile) {
        SummaryDataPoint.ValueAtQuantile.Builder builder = SummaryDataPoint.ValueAtQuantile.newBuilder();
        builder.setValue(valueAtQuantile.getValue());
        builder.setQuantile(valueAtQuantile.getQuantile());
        return builder.build();
    }

    private static Sum convertIntSum(IntSum intSum) {
        Sum.Builder builder = Sum.newBuilder();
        intSum.getDataPointsList().stream().map(OtelMetricsConvertor::convertIntDataPoint).forEach(arg_0 -> ((Sum.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static Sum convertDoubleSum(DoubleSum doubleSum) {
        Sum.Builder builder = Sum.newBuilder();
        doubleSum.getDataPointsList().stream().map(OtelMetricsConvertor::convertDoubleDataPoint).forEach(arg_0 -> ((Sum.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static NumberDataPoint convertDoubleDataPoint(DoubleDataPoint doubleDataPoint) {
        NumberDataPoint.Builder builder = NumberDataPoint.newBuilder();
        doubleDataPoint.getLabelsList().stream().map(OtelMetricsConvertor::convertStringKV).forEach(arg_0 -> ((NumberDataPoint.Builder)builder).addAttributes(arg_0));
        builder.setTimeUnixNano(doubleDataPoint.getTimeUnixNano());
        builder.setStartTimeUnixNano(doubleDataPoint.getStartTimeUnixNano());
        builder.setAsDouble(doubleDataPoint.getValue());
        return builder.build();
    }

    private static NumberDataPoint convertIntDataPoint(IntDataPoint intDataPoint) {
        NumberDataPoint.Builder builder = NumberDataPoint.newBuilder();
        intDataPoint.getLabelsList().stream().map(OtelMetricsConvertor::convertStringKV).forEach(arg_0 -> ((NumberDataPoint.Builder)builder).addAttributes(arg_0));
        builder.setTimeUnixNano(intDataPoint.getTimeUnixNano());
        builder.setStartTimeUnixNano(intDataPoint.getStartTimeUnixNano());
        builder.setAsInt(intDataPoint.getValue());
        return builder.build();
    }

    private static io.opentelemetry.proto.common.v1.KeyValue convertStringKV(StringKeyValue stringKeyValue) {
        return io.opentelemetry.proto.common.v1.KeyValue.newBuilder().setKey(stringKeyValue.getKey()).setValue(io.opentelemetry.proto.common.v1.AnyValue.newBuilder().setStringValue(stringKeyValue.getValue())).build();
    }

    private static Histogram convertIntHistogram(IntHistogram intHistogram) {
        Histogram.Builder builder = Histogram.newBuilder();
        builder.setAggregationTemporality(OtelMetricsConvertor.convertAggregationTemporality(intHistogram.getAggregationTemporality()));
        builder.setAggregationTemporalityValue(intHistogram.getAggregationTemporalityValue());
        intHistogram.getDataPointsList().stream().map(OtelMetricsConvertor::convertIntHistogramDataPoint).forEach(arg_0 -> ((Histogram.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static HistogramDataPoint convertIntHistogramDataPoint(IntHistogramDataPoint intHistogramDataPoint) {
        HistogramDataPoint.Builder builder = HistogramDataPoint.newBuilder();
        intHistogramDataPoint.getLabelsList().stream().map(OtelMetricsConvertor::convertStringKV).forEach(arg_0 -> ((HistogramDataPoint.Builder)builder).addAttributes(arg_0));
        builder.setCount(intHistogramDataPoint.getCount());
        builder.setSum((double)intHistogramDataPoint.getSum());
        builder.setStartTimeUnixNano(intHistogramDataPoint.getStartTimeUnixNano());
        builder.setTimeUnixNano(intHistogramDataPoint.getTimeUnixNano());
        builder.addBucketCounts((long)intHistogramDataPoint.getBucketCountsCount());
        builder.setFlags(0);
        builder.addAllExplicitBounds(intHistogramDataPoint.getExplicitBoundsList());
        return builder.build();
    }

    private static HistogramDataPoint convertDoubleHistogramDataPoint(DoubleHistogramDataPoint intHistogramDataPoint) {
        HistogramDataPoint.Builder builder = HistogramDataPoint.newBuilder();
        intHistogramDataPoint.getLabelsList().stream().map(OtelMetricsConvertor::convertStringKV).forEach(arg_0 -> ((HistogramDataPoint.Builder)builder).addAttributes(arg_0));
        builder.setCount(intHistogramDataPoint.getCount());
        builder.setSum(intHistogramDataPoint.getSum());
        builder.setStartTimeUnixNano(intHistogramDataPoint.getStartTimeUnixNano());
        builder.setTimeUnixNano(intHistogramDataPoint.getTimeUnixNano());
        builder.addBucketCounts((long)intHistogramDataPoint.getBucketCountsCount());
        builder.setFlags(0);
        builder.addAllExplicitBounds(intHistogramDataPoint.getExplicitBoundsList());
        return builder.build();
    }

    private static AggregationTemporality convertAggregationTemporality(io.opentelemetry.proto.metrics.firehose.v0_7.AggregationTemporality aggregationTemporality) {
        if (aggregationTemporality == io.opentelemetry.proto.metrics.firehose.v0_7.AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED) {
            return AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
        }
        if (aggregationTemporality == io.opentelemetry.proto.metrics.firehose.v0_7.AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE) {
            return AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
        }
        if (aggregationTemporality == io.opentelemetry.proto.metrics.firehose.v0_7.AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA) {
            return AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
        }
        throw new UnsupportedOperationException("Can't convert " + aggregationTemporality);
    }

    private static Histogram convertDoubleHistogram(DoubleHistogram doubleHistogram) {
        Histogram.Builder builder = Histogram.newBuilder();
        builder.setAggregationTemporality(OtelMetricsConvertor.convertAggregationTemporality(doubleHistogram.getAggregationTemporality()));
        builder.setAggregationTemporalityValue(doubleHistogram.getAggregationTemporalityValue());
        doubleHistogram.getDataPointsList().stream().map(OtelMetricsConvertor::convertDoubleHistogramDataPoint).forEach(arg_0 -> ((Histogram.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static Gauge convertIntGauge(IntGauge intGauge) {
        Gauge.Builder builder = Gauge.newBuilder();
        intGauge.getDataPointsList().stream().map(OtelMetricsConvertor::convertIntDataPoint).forEach(arg_0 -> ((Gauge.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static Gauge convertDoubleGauge(DoubleGauge doubleGauge) {
        Gauge.Builder builder = Gauge.newBuilder();
        doubleGauge.getDataPointsList().stream().map(OtelMetricsConvertor::convertDoubleDataPoint).forEach(arg_0 -> ((Gauge.Builder)builder).addDataPoints(arg_0));
        return builder.build();
    }

    private static Resource convertResource(io.opentelemetry.proto.resource.firehose.v0_7.Resource resource) {
        Resource.Builder builder = Resource.newBuilder();
        for (KeyValue keyValue : resource.getAttributesList()) {
            builder.addAttributes(OtelMetricsConvertor.convertKeyValue(keyValue));
        }
        return builder.build();
    }

    private static io.opentelemetry.proto.common.v1.AnyValue convertAnyValue(AnyValue value) {
        AnyValue.Builder builder = io.opentelemetry.proto.common.v1.AnyValue.newBuilder();
        if (value.hasBoolValue()) {
            builder.setBoolValue(value.getBoolValue());
        }
        if (value.hasDoubleValue()) {
            builder.setDoubleValue(value.getDoubleValue());
        }
        if (value.hasIntValue()) {
            builder.setIntValue(value.getIntValue());
        }
        if (value.hasStringValue()) {
            builder.setStringValue(value.getStringValue());
        }
        if (value.hasArrayValue()) {
            builder.setArrayValue(OtelMetricsConvertor.convertValuList(value.getArrayValue()));
        }
        if (value.hasKvlistValue()) {
            builder.setKvlistValue(OtelMetricsConvertor.convertKvlistValue(value.getKvlistValue()));
        }
        return builder.build();
    }

    private static io.opentelemetry.proto.common.v1.KeyValueList convertKvlistValue(KeyValueList keyValueList) {
        KeyValueList.Builder builder = io.opentelemetry.proto.common.v1.KeyValueList.newBuilder();
        keyValueList.getValuesList().stream().map(OtelMetricsConvertor::convertKeyValue).forEach(arg_0 -> ((KeyValueList.Builder)builder).addValues(arg_0));
        return builder.build();
    }

    private static io.opentelemetry.proto.common.v1.KeyValue convertKeyValue(KeyValue keyValue) {
        return io.opentelemetry.proto.common.v1.KeyValue.newBuilder().setKey(keyValue.getKey()).setValue(OtelMetricsConvertor.convertAnyValue(keyValue.getValue())).build();
    }

    private static io.opentelemetry.proto.common.v1.ArrayValue convertValuList(ArrayValue arrayValue) {
        ArrayValue.Builder builder = io.opentelemetry.proto.common.v1.ArrayValue.newBuilder();
        arrayValue.getValuesList().stream().map(OtelMetricsConvertor::convertAnyValue).forEach(arg_0 -> ((ArrayValue.Builder)builder).addValues(arg_0));
        return builder.build();
    }
}

