/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.internal.shared;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.internal.Node;
import org.opengis.util.ScopedName;

public final class WarningEvent {
    public static final ThreadLocal<Consumer<WarningEvent>> LISTENER = new ThreadLocal();
    private final Node source;
    public final Exception exception;

    public WarningEvent(Node source, Exception exception) {
        this.source = source;
        this.exception = exception;
    }

    public Optional<Enum<?>> getOperatorType() {
        if (this.source instanceof Filter) {
            return Optional.of(((Filter)((Object)this.source)).getOperatorType());
        }
        return Optional.empty();
    }

    public Optional<ScopedName> getFunctionName() {
        if (this.source instanceof Expression) {
            return Optional.of(((Expression)((Object)this.source)).getFunctionName());
        }
        return Optional.empty();
    }

    public <P extends Expression<?, ?>> Optional<P> getParameter(Class<P> type) {
        if (this.source instanceof Filter) {
            for (Expression parameter : ((Filter)((Object)this.source)).getExpressions()) {
                if (!type.isInstance(parameter)) continue;
                return Optional.of(parameter);
            }
        }
        if (this.source instanceof Expression) {
            for (Expression parameter : ((Expression)((Object)this.source)).getParameters()) {
                if (!type.isInstance(parameter)) continue;
                return Optional.of(parameter);
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return String.valueOf(this.source.getDisplayName()) + ": " + this.exception.toString();
    }
}

