/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.governance.handler.RateLimitingHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ProviderRateLimitingFilter
extends AbstractFilter
implements ProviderFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderRateLimitingFilter.class);
    private final RateLimitingHandler rateLimitingHandler;

    @Autowired
    public ProviderRateLimitingFilter(RateLimitingHandler rateLimitingHandler) {
        this.rateLimitingHandler = rateLimitingHandler;
    }

    public int getOrder() {
        return -1900;
    }

    public String getName() {
        return "rate-limiting";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation, nextNode);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest((Invocation)invocation);
        this.addRateLimiting((Decorators.DecorateCompletionStage<Response>)dcs, request);
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                future.complete((Response)r);
                return;
            }
            if (e instanceof RequestNotPermitted) {
                future.completeExceptionally((Throwable)new InvocationException(429, "rate limited.", (Object)new CommonExceptionData("rate limited.")));
                LOGGER.warn("the request is rate limit by policy : {}", (Object)e.getMessage());
            } else {
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    private void addRateLimiting(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequestExtractor request) {
        RateLimiter rateLimiter = (RateLimiter)this.rateLimitingHandler.getActuator(request);
        if (rateLimiter != null) {
            dcs.withRateLimiter(rateLimiter);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation, FilterNode nextNode) {
        return () -> nextNode.onFilter(invocation);
    }
}

