/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WeakMessager<E> {
    List<WeakReference<Changed<E>>> dispatchees = new ArrayList<WeakReference<Changed<E>>>();

    public void fire(E message) {
        this.dumpVoids();
        for (WeakReference<Changed<E>> d : this.dispatchees) {
            Changed c = (Changed)d.get();
            if (c == null) continue;
            c.changed(message);
        }
    }

    public void add(Changed toAdd) {
        this.dumpVoids();
        this.dispatchees.add(new WeakReference<Changed>(toAdd));
    }

    public void addIfNew(Changed toAdd) {
        this.dumpVoids();
        for (WeakReference<Changed<E>> d : this.dispatchees) {
            Changed c = (Changed)d.get();
            if (c == null || c != toAdd) continue;
            return;
        }
        this.dumpVoids();
        this.dispatchees.add(new WeakReference<Changed>(toAdd));
    }

    public void remove(Changed toKill) {
        for (WeakReference<Changed<E>> d : this.dispatchees) {
            Changed c = (Changed)d.get();
            if (c == null || c != toKill) continue;
            d.clear();
        }
        this.dumpVoids();
    }

    private void dumpVoids() {
        Iterator<WeakReference<Changed<E>>> it = this.dispatchees.iterator();
        while (it.hasNext()) {
            if (it.next().get() != null) continue;
            it.remove();
        }
    }

    public static interface Changed<E> {
        public void changed(E var1);
    }
}

