/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.kafka;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.inject.Inject;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.service.Service;
import org.apache.atlas.util.CommandHandlerUtility;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import scala.Option;

@Component
@Order(value=3)
public class EmbeddedKafkaServer
implements Service {
    public static final Logger LOG = LoggerFactory.getLogger(EmbeddedKafkaServer.class);
    public static final String PROPERTY_PREFIX = "atlas.kafka";
    private static final String ATLAS_KAFKA_DATA = "data";
    public static final String PROPERTY_EMBEDDED = "atlas.notification.embedded";
    private static final int MAX_RETRY_TO_ACQUIRE_PORT = 3;
    private final boolean isEmbedded;
    private Properties properties;
    private KafkaServer kafkaServer;
    private ServerCnxnFactory factory;

    @Inject
    public EmbeddedKafkaServer(Configuration applicationProperties) throws AtlasException {
        Configuration kafkaConf = ApplicationProperties.getSubsetConfiguration((Configuration)applicationProperties, (String)PROPERTY_PREFIX);
        this.isEmbedded = applicationProperties.getBoolean(PROPERTY_EMBEDDED, false);
        this.properties = ConfigurationConverter.getProperties((Configuration)kafkaConf);
    }

    public void start() throws AtlasException {
        LOG.info("==> EmbeddedKafkaServer.start(isEmbedded={})", (Object)this.isEmbedded);
        if (this.isEmbedded) {
            try {
                this.startZk();
                this.startKafka();
            }
            catch (Exception e) {
                throw new AtlasException("Failed to start embedded kafka", (Throwable)e);
            }
        } else {
            LOG.info("==> EmbeddedKafkaServer.start(): not embedded..nothing todo");
        }
        LOG.info("<== EmbeddedKafkaServer.start(isEmbedded={})", (Object)this.isEmbedded);
    }

    public void stop() {
        LOG.info("==> EmbeddedKafkaServer.stop(isEmbedded={})", (Object)this.isEmbedded);
        if (this.kafkaServer != null) {
            this.kafkaServer.shutdown();
        }
        if (this.factory != null) {
            this.factory.shutdown();
        }
        LOG.info("<== EmbeddedKafka.stop(isEmbedded={})", (Object)this.isEmbedded);
    }

    private String startZk() throws IOException, InterruptedException {
        String zkValue = this.properties.getProperty("zookeeper.connect");
        LOG.info("Starting zookeeper at {}", (Object)zkValue);
        URL zkAddress = this.getURL(zkValue);
        File snapshotDir = this.constructDir("zk/txn");
        File logDir = this.constructDir("zk/snap");
        for (int attemptCount = 0; attemptCount < 3; ++attemptCount) {
            try {
                this.factory = NIOServerCnxnFactory.createFactory((InetSocketAddress)new InetSocketAddress(zkAddress.getHost(), zkAddress.getPort()), (int)1024);
                break;
            }
            catch (BindException e) {
                LOG.warn("Attempt {}: Starting zookeeper at {} failed", (Object)attemptCount, (Object)zkValue);
                if (attemptCount == 2) {
                    throw e;
                }
                CommandHandlerUtility.tryKillingProcessUsingPort(zkAddress.getPort(), attemptCount != 0);
                continue;
            }
        }
        this.factory.startup(new ZooKeeperServer(snapshotDir, logDir, 500));
        String ret = this.factory.getLocalAddress().getAddress().toString();
        LOG.info("Embedded zookeeper for Kafka started at {}", (Object)ret);
        return ret;
    }

    private void startKafka() throws IOException {
        String kafkaValue = this.properties.getProperty("bootstrap.servers");
        LOG.info("Starting kafka at {}", (Object)kafkaValue);
        URL kafkaAddress = this.getURL(kafkaValue);
        Properties brokerConfig = this.properties;
        for (int attemptCount = 0; attemptCount < 3; ++attemptCount) {
            try {
                brokerConfig.setProperty("broker.id", "1");
                brokerConfig.setProperty("host.name", kafkaAddress.getHost());
                brokerConfig.setProperty("port", String.valueOf(kafkaAddress.getPort()));
                brokerConfig.setProperty("log.dirs", this.constructDir("kafka").getAbsolutePath());
                brokerConfig.setProperty("log.flush.interval.messages", String.valueOf(1));
                this.kafkaServer = new KafkaServer(KafkaConfig.fromProps((Properties)brokerConfig), Time.SYSTEM, Option.apply((Object)this.getClass().getName()), false);
                this.kafkaServer.startup();
                break;
            }
            catch (ZooKeeperClientException | KafkaException e) {
                LOG.warn("Attempt {}: kafka server with broker config {} failed", (Object)attemptCount, (Object)brokerConfig);
                if (attemptCount == 2) {
                    throw e;
                }
                if (this.kafkaServer != null) {
                    try {
                        this.kafkaServer.shutdown();
                    }
                    catch (Exception ex) {
                        LOG.info("Failed to shutdown kafka server", (Throwable)ex);
                    }
                }
                CommandHandlerUtility.tryKillingProcessUsingPort(kafkaAddress.getPort(), attemptCount != 0);
                continue;
            }
        }
        LOG.info("Embedded kafka server started with broker config {}", (Object)brokerConfig);
    }

    private File constructDir(String dirPrefix) {
        File file = new File(this.properties.getProperty(ATLAS_KAFKA_DATA), dirPrefix);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("could not create temp directory: " + file.getAbsolutePath());
        }
        return file;
    }

    private URL getURL(String url) throws MalformedURLException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return new URL("http://" + url);
        }
    }
}

