/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hdfs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.hdfs.client.HdfsResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceHdfs
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceHdfs.class);
    private static final String AUDITTOHDFS_KMS_PATH = "/ranger/audit/kms";
    private static final String AUDITTOHDFS_POLICY_NAME = "kms-audit-path";
    public static final String ACCESS_TYPE_READ = "read";
    private static final String HBASE_ARCHIVE_POLICY_NAME = "hbase-archive";
    private static final String HBASE_ARCHIVE_POLICY_PATH = "/hbase/archive";
    private static final String HBASE_ARCHIVE_POLICY_DESC = "Policy for hbase archive location";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = HdfsResourceMgr.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException e) {
                LOG.error("<== RangerServiceHdfs.validateConfig Error: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.lookupResource Context: (" + context + ")");
        }
        if (context != null) {
            try {
                ret = HdfsResourceMgr.getHdfsResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceHdfs.lookupResource Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.lookupResource Response: (" + ret + ")");
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHdfs.getDefaultRangerPolicies() ");
        }
        List ret = super.getDefaultRangerPolicies();
        String pathResourceName = "path";
        for (RangerPolicy defaultPolicy : ret) {
            RangerPolicy.RangerPolicyResource pathPolicyResource;
            if (!defaultPolicy.getName().contains("all")) continue;
            if (StringUtils.isNotBlank((String)this.lookUpUser)) {
                RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
                policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
                policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ)));
                policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
                defaultPolicy.addPolicyItem(policyItemForLookupUser);
            }
            if ((pathPolicyResource = (RangerPolicy.RangerPolicyResource)defaultPolicy.getResources().get(pathResourceName)) != null) {
                List resourceDefs = this.serviceDef.getResources();
                RangerServiceDef.RangerResourceDef pathResourceDef = null;
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    if (!resourceDef.getName().equals(pathResourceName)) continue;
                    pathResourceDef = resourceDef;
                    break;
                }
                if (pathResourceDef != null) {
                    String pathSeparator = (String)pathResourceDef.getMatcherOptions().get("pathSeparatorChar");
                    if (StringUtils.isBlank((String)pathSeparator)) {
                        pathSeparator = Character.toString('/');
                    }
                    String value = pathSeparator + "*";
                    pathPolicyResource.setValue(value);
                    continue;
                }
                LOG.warn("No resourceDef found in HDFS service-definition for '" + pathResourceName + "'");
                continue;
            }
            LOG.warn("No '" + pathResourceName + "' found in default policy");
        }
        try {
            RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef);
            for (List aHierarchy : serviceDefHelper.filterHierarchies_containsOnlyMandatoryResources(Integer.valueOf(0))) {
                RangerPolicy hbaseArchivePolicy;
                RangerPolicy policy = this.getPolicyForKMSAudit(aHierarchy);
                if (policy != null) {
                    ret.add(policy);
                }
                if ((hbaseArchivePolicy = this.getPolicyForHBaseArchive(aHierarchy)) == null) continue;
                ret.add(hbaseArchivePolicy);
            }
        }
        catch (Exception e) {
            LOG.error("Error creating policy for keyadmin for audit to HDFS : " + this.service.getName(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.getDefaultRangerPolicies() : " + ret);
        }
        return ret;
    }

    private RangerPolicy getPolicyForKMSAudit(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHdfs.getPolicyForKMSAudit()");
        }
        RangerPolicy policy = new RangerPolicy();
        policy.setIsEnabled(Boolean.valueOf(true));
        policy.setVersion(Long.valueOf(1L));
        policy.setName(AUDITTOHDFS_POLICY_NAME);
        policy.setService(this.service.getName());
        policy.setDescription("Policy for kms-audit-path");
        policy.setIsAuditEnabled(Boolean.valueOf(true));
        policy.setResources(this.createPathBasedResourceMap(resourceHierarchy, AUDITTOHDFS_KMS_PATH));
        ArrayList<RangerPolicy.RangerPolicyItem> policyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
        RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
        ArrayList<String> userKeyAdmin = new ArrayList<String>();
        userKeyAdmin.add("keyadmin");
        policyItem.setUsers(userKeyAdmin);
        policyItem.setAccesses(this.getAllowedAccesses(policy.getResources()));
        policyItem.setDelegateAdmin(Boolean.valueOf(false));
        policyItems.add(policyItem);
        policy.setPolicyItems(policyItems);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.getPolicyForKMSAudit()" + policy);
        }
        return policy;
    }

    private RangerPolicy getPolicyForHBaseArchive(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHdfs.getPolicyForHBaseArchive()");
        }
        RangerPolicy policy = new RangerPolicy();
        policy.setIsEnabled(Boolean.valueOf(true));
        policy.setVersion(Long.valueOf(1L));
        policy.setName(HBASE_ARCHIVE_POLICY_NAME);
        policy.setService(this.service.getName());
        policy.setDescription(HBASE_ARCHIVE_POLICY_DESC);
        policy.setIsAuditEnabled(Boolean.valueOf(true));
        policy.setResources(this.createPathBasedResourceMap(resourceHierarchy, HBASE_ARCHIVE_POLICY_PATH));
        ArrayList<RangerPolicy.RangerPolicyItem> policyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
        RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
        ArrayList<String> user = new ArrayList<String>();
        user.add("hbase");
        policyItem.setUsers(user);
        policyItem.setAccesses(this.getAllowedAccesses(policy.getResources()));
        policyItem.setDelegateAdmin(Boolean.valueOf(false));
        policyItems.add(policyItem);
        policy.setPolicyItems(policyItems);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.getPolicyForHBaseArchive(): ret=" + policy);
        }
        return policy;
    }

    private Map<String, RangerPolicy.RangerPolicyResource> createPathBasedResourceMap(List<RangerServiceDef.RangerResourceDef> resourceHierarchy, String resourcePath) throws Exception {
        Map ret;
        RangerPolicy.RangerPolicyResource pathResource;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceHdfs.createPathBasedResourceMap()");
        }
        if ((pathResource = (RangerPolicy.RangerPolicyResource)(ret = super.createDefaultPolicyResource(resourceHierarchy)).get("path")) != null) {
            pathResource.setValue(resourcePath);
        } else {
            LOG.error("Internal error: Could not find RangerPolicyResource corresponding to path in default policy-resource");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceHdfs.createPathBasedResourceMap(): ret=" + ret);
        }
        return ret;
    }
}

