/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangerHdfsAuditHandler
extends RangerDefaultAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHdfsAuditHandler.class);
    private boolean isAuditEnabled = false;
    private AuthzAuditEvent auditEvent = null;
    private final String pathToBeValidated;
    private final boolean auditOnlyIfDenied;
    private final String hadoopModuleName;
    private final Set<String> excludeUsers;
    private final String callerContext;

    public RangerHdfsAuditHandler(String pathToBeValidated, boolean auditOnlyIfDenied, String hadoopModuleName, Set<String> excludedUsers, String callerContext) {
        this.pathToBeValidated = pathToBeValidated;
        this.auditOnlyIfDenied = auditOnlyIfDenied;
        this.hadoopModuleName = hadoopModuleName;
        this.excludeUsers = excludedUsers;
        this.callerContext = callerContext;
    }

    public void processResult(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuditHandler.logAudit(" + result + ")");
        }
        if (result != null) {
            this.isAuditEnabled = result.getIsAudited();
            if (this.auditEvent == null) {
                this.auditEvent = super.getAuthzEvents(result);
            }
            if (this.auditEvent != null) {
                RangerAccessRequest request = result.getAccessRequest();
                RangerAccessResource resource = request.getResource();
                String resourcePath = resource != null ? resource.getAsString() : null;
                this.auditEvent.setEventTime(request.getAccessTime() != null ? request.getAccessTime() : new Date());
                this.auditEvent.setAccessType(request.getAction());
                this.auditEvent.setResourcePath(this.pathToBeValidated);
                this.auditEvent.setResultReason(resourcePath);
                this.auditEvent.setAccessResult((short)(result.getIsAllowed() ? 1 : 0));
                this.auditEvent.setPolicyId(result.getPolicyId());
                this.auditEvent.setPolicyVersion(result.getPolicyVersion());
                this.setRequestData();
                this.auditEvent.setAction(this.getAccessType(request.getAccessType()));
                this.auditEvent.setAdditionalInfo(this.getAdditionalInfo(request));
                Set tags = this.getTags(request);
                if (tags != null) {
                    this.auditEvent.setTags(tags);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuditHandler.logAudit(" + result + "): " + this.auditEvent);
        }
    }

    public String getAdditionalInfo(RangerAccessRequest request) {
        String additionalInfo = super.getAdditionalInfo(request);
        HashMap<String, String> addInfoMap = JsonUtils.jsonToMapStringString((String)additionalInfo);
        if (addInfoMap == null || addInfoMap.isEmpty()) {
            addInfoMap = new HashMap<String, String>();
        }
        String accessTypes = this.getAccessTypesAsString(request);
        if (addInfoMap != null && accessTypes != null) {
            addInfoMap.put("accessTypes", "[" + accessTypes + "]");
        }
        return JsonUtils.mapToJson(addInfoMap);
    }

    public void logHadoopEvent(String path, FsAction action, boolean accessGranted) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuditHandler.logHadoopEvent(" + path + ", " + action + ", " + accessGranted + ")");
        }
        if (this.auditEvent != null) {
            String accessType;
            this.auditEvent.setResultReason(path);
            this.auditEvent.setAccessResult((short)(accessGranted ? 1 : 0));
            this.auditEvent.setAclEnforcer(this.hadoopModuleName);
            this.auditEvent.setPolicyId(-1L);
            String string = accessType = action == null ? null : action.toString();
            if (StringUtils.isBlank((String)this.auditEvent.getAccessType())) {
                this.auditEvent.setAccessType(accessType);
            }
            if (accessType != null) {
                this.auditEvent.setAction(this.getAccessType(accessType));
            }
            this.setRequestData();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuditHandler.logHadoopEvent(" + path + ", " + action + ", " + accessGranted + "): " + this.auditEvent);
        }
    }

    public void flushAudit() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuditHandler.flushAudit(" + this.isAuditEnabled + ", " + this.auditEvent + ")");
        }
        if (this.isAuditEnabled && this.auditEvent != null && !StringUtils.isEmpty((String)this.auditEvent.getAccessType())) {
            boolean skipLog;
            String username = this.auditEvent.getUser();
            String accessType = this.auditEvent.getAccessType();
            boolean bl = skipLog = username != null && this.excludeUsers != null && this.excludeUsers.contains(username) || this.auditOnlyIfDenied && this.auditEvent.getAccessResult() != 0 || "monitorHealth".equals(accessType);
            if (!skipLog) {
                super.logAuthzAudit(this.auditEvent);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuditHandler.flushAudit(" + this.isAuditEnabled + ", " + this.auditEvent + ")");
        }
    }

    private String getAccessType(String accessType) {
        String ret = accessType;
        switch (accessType) {
            case "READ_EXECUTE": {
                ret = "read";
                break;
            }
            case "WRITE_EXECUTE": 
            case "READ_WRITE": 
            case "ALL": {
                ret = "write";
                break;
            }
        }
        return ret.toLowerCase();
    }

    private String getAccessTypesAsString(RangerAccessRequest request) {
        String ret = null;
        Set accessTypes = RangerAccessRequestUtil.getAllRequestedAccessTypes((RangerAccessRequest)request);
        if (CollectionUtils.isNotEmpty((Collection)accessTypes)) {
            try {
                ret = this.getFormattedAccessType(accessTypes);
            }
            catch (Throwable t) {
                LOG.error("getAccessTypesAsString(): failed to get accessTypes from context", t);
            }
        } else {
            ret = request.getAccessType();
        }
        return ret;
    }

    private String getFormattedAccessType(Set<String> accessTypes) {
        String ret = null;
        if (CollectionUtils.isNotEmpty(accessTypes)) {
            ret = String.join((CharSequence)", ", accessTypes);
        }
        return ret;
    }

    private void setRequestData() {
        if (StringUtils.isNotBlank((String)this.auditEvent.getAccessType()) && StringUtils.isNotBlank((String)this.callerContext)) {
            this.auditEvent.setRequestData(this.auditEvent.getAccessType() + "/" + this.callerContext);
        }
    }
}

