/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.module;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import tools.jackson.core.Version;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.module.SimpleAbstractTypeResolver;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.module.SimpleKeyDeserializers;
import tools.jackson.databind.module.SimpleSerializers;
import tools.jackson.databind.module.SimpleValueInstantiators;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.util.UniqueId;

public class SimpleModule
extends JacksonModule
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final String _name;
    protected final Version _version;
    protected final Object _id;
    protected SimpleSerializers _serializers = null;
    protected SimpleDeserializers _deserializers = null;
    protected SimpleSerializers _keySerializers = null;
    protected SimpleKeyDeserializers _keyDeserializers = null;
    protected ValueSerializer<?> _defaultNullKeySerializer = null;
    protected ValueSerializer<?> _defaultNullValueSerializer = null;
    protected SimpleAbstractTypeResolver _abstractTypes = null;
    protected SimpleValueInstantiators _valueInstantiators = null;
    protected ValueDeserializerModifier _deserializerModifier = null;
    protected ValueSerializerModifier _serializerModifier = null;
    protected HashMap<Class<?>, Class<?>> _mixins = null;
    protected LinkedHashSet<NamedType> _subtypes = null;
    protected PropertyNamingStrategy _namingStrategy = null;

    public SimpleModule() {
        this(null, Version.unknownVersion());
    }

    public SimpleModule(String name) {
        this(name, Version.unknownVersion());
    }

    public SimpleModule(Version version) {
        this(version.getArtifactId(), version);
    }

    public SimpleModule(String name, Version version) {
        this(name, version, null);
    }

    public SimpleModule(String name, Version version, Object registrationId) {
        if (name == null || ((String)name).isEmpty()) {
            if (this.getClass() == SimpleModule.class) {
                if (registrationId == null) {
                    registrationId = UniqueId.create("SimpleModule-");
                }
                name = "SimpleModule-" + String.valueOf(registrationId);
            } else {
                name = this.getClass().getName();
                if (registrationId == null) {
                    registrationId = name;
                }
            }
        } else if (registrationId == null) {
            registrationId = name;
        }
        this._name = name;
        this._version = version;
        this._id = registrationId;
    }

    @Override
    public Version version() {
        return this._version;
    }

    @Override
    public Object getRegistrationId() {
        return this._id;
    }

    public SimpleModule setSerializers(SimpleSerializers s) {
        this._serializers = s;
        return this;
    }

    public SimpleModule setDeserializers(SimpleDeserializers d) {
        this._deserializers = d;
        return this;
    }

    public SimpleModule setKeySerializers(SimpleSerializers ks) {
        this._keySerializers = ks;
        return this;
    }

    public SimpleModule setKeyDeserializers(SimpleKeyDeserializers kd) {
        this._keyDeserializers = kd;
        return this;
    }

    public SimpleModule setDefaultNullKeySerializer(ValueSerializer<?> ser) {
        this._defaultNullKeySerializer = ser;
        return this;
    }

    public SimpleModule setDefaultNullValueSerializer(ValueSerializer<?> ser) {
        this._defaultNullValueSerializer = ser;
        return this;
    }

    public SimpleModule setAbstractTypes(SimpleAbstractTypeResolver atr) {
        this._abstractTypes = atr;
        return this;
    }

    public SimpleModule setValueInstantiators(SimpleValueInstantiators svi) {
        this._valueInstantiators = svi;
        return this;
    }

    public SimpleModule setDeserializerModifier(ValueDeserializerModifier mod) {
        this._deserializerModifier = mod;
        return this;
    }

    public SimpleModule setSerializerModifier(ValueSerializerModifier mod) {
        this._serializerModifier = mod;
        return this;
    }

    protected SimpleModule setNamingStrategy(PropertyNamingStrategy naming) {
        this._namingStrategy = naming;
        return this;
    }

    public SimpleModule addSerializer(ValueSerializer<?> ser) {
        this._checkNotNull(ser, "serializer");
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(ser);
        return this;
    }

    public <T> SimpleModule addSerializer(Class<? extends T> type, ValueSerializer<T> ser) {
        this._checkNotNull(type, "type to register serializer for");
        this._checkNotNull(ser, "serializer");
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(type, ser);
        return this;
    }

    public <T> SimpleModule addKeySerializer(Class<? extends T> type, ValueSerializer<T> ser) {
        this._checkNotNull(type, "type to register key serializer for");
        this._checkNotNull(ser, "key serializer");
        if (this._keySerializers == null) {
            this._keySerializers = new SimpleSerializers();
        }
        this._keySerializers.addSerializer(type, ser);
        return this;
    }

    public <T> SimpleModule addDeserializer(Class<T> type, ValueDeserializer<? extends T> deser) {
        this._checkNotNull(type, "type to register deserializer for");
        this._checkNotNull(deser, "deserializer");
        if (this._deserializers == null) {
            this._deserializers = new SimpleDeserializers();
        }
        this._deserializers.addDeserializer(type, deser);
        return this;
    }

    public SimpleModule addKeyDeserializer(Class<?> type, KeyDeserializer deser) {
        this._checkNotNull(type, "type to register key deserializer for");
        this._checkNotNull(deser, "key deserializer");
        if (this._keyDeserializers == null) {
            this._keyDeserializers = new SimpleKeyDeserializers();
        }
        this._keyDeserializers.addDeserializer(type, deser);
        return this;
    }

    public <T> SimpleModule addAbstractTypeMapping(Class<T> superType, Class<? extends T> subType) {
        this._checkNotNull(superType, "abstract type to map");
        this._checkNotNull(subType, "concrete type to map to");
        if (this._abstractTypes == null) {
            this._abstractTypes = new SimpleAbstractTypeResolver();
        }
        this._abstractTypes = this._abstractTypes.addMapping(superType, subType);
        return this;
    }

    public SimpleModule registerSubtypes(Class<?> ... subtypes) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet();
        }
        for (Class<?> subtype : subtypes) {
            this._checkNotNull(subtype, "subtype to register");
            this._subtypes.add(new NamedType(subtype));
        }
        return this;
    }

    public SimpleModule registerSubtypes(NamedType ... subtypes) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet();
        }
        for (NamedType subtype : subtypes) {
            this._checkNotNull(subtype, "subtype to register");
            this._subtypes.add(subtype);
        }
        return this;
    }

    public SimpleModule registerSubtypes(Collection<Class<?>> subtypes) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet();
        }
        for (Class<?> subtype : subtypes) {
            this._checkNotNull(subtype, "subtype to register");
            this._subtypes.add(new NamedType(subtype));
        }
        return this;
    }

    public SimpleModule addValueInstantiator(Class<?> beanType, ValueInstantiator inst) {
        this._checkNotNull(beanType, "class to register value instantiator for");
        this._checkNotNull(inst, "value instantiator");
        if (this._valueInstantiators == null) {
            this._valueInstantiators = new SimpleValueInstantiators();
        }
        this._valueInstantiators = this._valueInstantiators.addValueInstantiator(beanType, inst);
        return this;
    }

    public SimpleModule setMixInAnnotation(Class<?> targetType, Class<?> mixinClass) {
        this._checkNotNull(targetType, "target type");
        this._checkNotNull(mixinClass, "mixin class");
        if (this._mixins == null) {
            this._mixins = new HashMap();
        }
        this._mixins.put(targetType, mixinClass);
        return this;
    }

    @Override
    public String getModuleName() {
        return this._name;
    }

    @Override
    public void setupModule(JacksonModule.SetupContext context) {
        if (this._serializers != null) {
            context.addSerializers(this._serializers);
        }
        if (this._deserializers != null) {
            context.addDeserializers(this._deserializers);
        }
        if (this._keySerializers != null) {
            context.addKeySerializers(this._keySerializers);
        }
        if (this._keyDeserializers != null) {
            context.addKeyDeserializers(this._keyDeserializers);
        }
        if (this._abstractTypes != null) {
            context.addAbstractTypeResolver(this._abstractTypes);
        }
        if (this._valueInstantiators != null) {
            context.addValueInstantiators(this._valueInstantiators);
        }
        if (this._deserializerModifier != null) {
            context.addDeserializerModifier(this._deserializerModifier);
        }
        if (this._serializerModifier != null) {
            context.addSerializerModifier(this._serializerModifier);
        }
        if (this._defaultNullKeySerializer != null) {
            context.overrideDefaultNullKeySerializer(this._defaultNullKeySerializer);
        }
        if (this._defaultNullValueSerializer != null) {
            context.overrideDefaultNullValueSerializer(this._defaultNullValueSerializer);
        }
        if (this._subtypes != null && this._subtypes.size() > 0) {
            context.registerSubtypes(this._subtypes.toArray(new NamedType[0]));
        }
        if (this._mixins != null) {
            for (Map.Entry<Class<?>, Class<?>> entry : this._mixins.entrySet()) {
                context.setMixIn(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void _checkNotNull(Object thingy, String type) {
        if (thingy == null) {
            throw new IllegalArgumentException(String.format("Cannot pass `null` as %s", type));
        }
    }
}

