/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
package org.apache.qpid.tests.protocol.v0_8.extension.exchange;

import static org.apache.qpid.tests.utils.BrokerAdmin.KIND_BROKER_J;

import java.util.Map;

import org.junit.jupiter.api.Test;

import org.apache.qpid.server.protocol.v0_8.transport.ChannelOpenOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeclareOkBody;
import org.apache.qpid.tests.protocol.v0_8.FrameTransport;
import org.apache.qpid.tests.protocol.v0_8.Interaction;
import org.apache.qpid.tests.utils.BrokerAdminUsingTestBase;
import org.apache.qpid.tests.utils.BrokerSpecific;
import org.apache.qpid.tests.utils.ConfigItem;

@BrokerSpecific(kind = KIND_BROKER_J)
@ConfigItem(name = "exchange.behaviourOnUnknownDeclareArgument", value = "IGNORE")
public class ExchangeDeclareInvalidOptionBehaviourTest extends BrokerAdminUsingTestBase
{
    private static final String TEST_EXCHANGE = "testExchange";

    @Test
    public void exchangeDeclareInvalidWireArguments() throws Exception
    {
        try (FrameTransport transport = new FrameTransport(getBrokerAdmin()).connect())
        {
            final Interaction interaction = transport.newInteraction();
            interaction.negotiateOpen()
                       .channel()
                       .open()
                       .consumeResponse(ChannelOpenOkBody.class)
                       .exchange()
                       .declareName(TEST_EXCHANGE)
                       .declareArguments(Map.of("foo", "bar"))
                       .declare()
                       .consumeResponse(ExchangeDeclareOkBody.class);
        }
    }
}
