/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.management.plugin.servlet.ServletConnectionPrincipal;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public class InteractiveAuthenticationFilter
implements Filter {
    private static final Collection<HttpRequestInteractiveAuthenticator> AUTHENTICATORS;
    private HttpManagementConfiguration _managementConfiguration;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Subject subject = HttpManagementUtil.getAuthorisedSubject(httpRequest);
        if (subject != null && !subject.getPrincipals(AuthenticatedPrincipal.class).isEmpty()) {
            chain.doFilter(request, response);
        } else {
            HttpRequestInteractiveAuthenticator authenticator;
            HttpRequestInteractiveAuthenticator.AuthenticationHandler handler = null;
            Iterator<HttpRequestInteractiveAuthenticator> iterator = AUTHENTICATORS.iterator();
            while (iterator.hasNext() && (handler = (authenticator = iterator.next()).getAuthenticationHandler(httpRequest, this._managementConfiguration)) == null) {
            }
            if (handler != null) {
                this.invokeAuthenticationHandler(httpRequest, httpResponse, handler);
            } else {
                httpResponse.sendError(403);
            }
        }
    }

    private void invokeAuthenticationHandler(HttpServletRequest httpRequest, HttpServletResponse httpResponse, HttpRequestInteractiveAuthenticator.AuthenticationHandler handler) throws ServletException {
        Subject tempSubject = new Subject(true, Set.of(new ServletConnectionPrincipal(httpRequest)), Set.of(), Set.of());
        try {
            Subject.doAs(tempSubject, () -> {
                handler.handleAuthentication(httpResponse);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new ServletException((Throwable)e);
        }
    }

    static {
        ArrayList<HttpRequestInteractiveAuthenticator> authenticators = new ArrayList<HttpRequestInteractiveAuthenticator>();
        for (HttpRequestInteractiveAuthenticator authenticator : new QpidServiceLoader().instancesOf(HttpRequestInteractiveAuthenticator.class)) {
            authenticators.add(authenticator);
        }
        AUTHENTICATORS = Collections.unmodifiableList(authenticators);
    }
}

