/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.auth;

import io.grpc.Metadata;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.api.EncodedAuthenticationParameterSupport;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Supplier;

public class TokenAuthentication
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final Metadata.Key<String> AUTHORIZATION_METADATA_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String BEARER_TYPE = "Bearer";
    private Supplier<String> tokenSupplier;

    private TokenAuthentication() {
    }

    public TokenAuthentication(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public TokenAuthentication(String token) {
        this(() -> token);
    }

    public Metadata generateCredentials() {
        Metadata credentials = new Metadata();
        credentials.put(AUTHORIZATION_METADATA_KEY, (Object)String.format("%s %s", BEARER_TYPE, this.tokenSupplier.get()));
        return credentials;
    }

    public void configure(String encodedAuthParamString) {
        if (encodedAuthParamString.startsWith("token:")) {
            this.tokenSupplier = new TokenSupplier(encodedAuthParamString.substring("token:".length()));
        } else if (encodedAuthParamString.startsWith("file:")) {
            URI filePath = URI.create(encodedAuthParamString);
            this.tokenSupplier = new URITokenSupplier(filePath);
        } else {
            throw new IllegalArgumentException("Invalid token configuration: " + encodedAuthParamString);
        }
    }

    private record TokenSupplier(String token) implements Supplier<String>
    {
        @Override
        public String get() {
            return this.token;
        }
    }

    private record URITokenSupplier(URI uri) implements Supplier<String>
    {
        @Override
        public String get() {
            try {
                return Files.readString(Paths.get(this.uri)).trim();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read token from file", e);
            }
        }
    }
}

