/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.stats.BrokerOperabilityMetrics;
import org.apache.pulsar.broker.stats.BrokerStats;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStats
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(PulsarStats.class);
    private volatile ByteBuf topicStatsBuf;
    private volatile ByteBuf tempTopicStatsBuf;
    private BrokerStats brokerStats;
    private NamespaceStats nsStats;
    private final ClusterReplicationMetrics clusterReplicationMetrics;
    private Map<String, NamespaceBundleStats> bundleStats;
    private List<Metrics> tempMetricsCollection;
    private List<Metrics> metricsCollection;
    private List<NonPersistentTopic> tempNonPersistentTopics;
    private final BrokerOperabilityMetrics brokerOperabilityMetrics;
    private final boolean exposePublisherStats;
    private final ReentrantReadWriteLock bufferLock = new ReentrantReadWriteLock();
    private long updatedAt;

    public PulsarStats(PulsarService pulsar) {
        this.topicStatsBuf = Unpooled.buffer((int)16384);
        this.tempTopicStatsBuf = Unpooled.buffer((int)16384);
        this.nsStats = new NamespaceStats(pulsar.getConfig().getStatsUpdateFrequencyInSecs());
        this.brokerStats = new BrokerStats(pulsar.getConfig().getStatsUpdateFrequencyInSecs());
        this.clusterReplicationMetrics = new ClusterReplicationMetrics(pulsar.getConfiguration().getClusterName(), pulsar.getConfiguration().isReplicationMetricsEnabled());
        this.bundleStats = new ConcurrentHashMap<String, NamespaceBundleStats>();
        this.tempMetricsCollection = new ArrayList<Metrics>();
        this.metricsCollection = new ArrayList<Metrics>();
        this.brokerOperabilityMetrics = new BrokerOperabilityMetrics(pulsar.getConfiguration().getClusterName(), pulsar.getAdvertisedAddress());
        this.tempNonPersistentTopics = new ArrayList<NonPersistentTopic>();
        this.exposePublisherStats = pulsar.getConfiguration().isExposePublisherStats();
        this.updatedAt = 0L;
    }

    @Override
    public void close() {
        this.bufferLock.writeLock().lock();
        try {
            ReferenceCountUtil.safeRelease((Object)this.topicStatsBuf);
            ReferenceCountUtil.safeRelease((Object)this.tempTopicStatsBuf);
        }
        finally {
            this.bufferLock.writeLock().unlock();
        }
    }

    public ClusterReplicationMetrics getClusterReplicationMetrics() {
        return this.clusterReplicationMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateStats(ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> topicsMap) {
        StatsOutputStream topicStatsStream = new StatsOutputStream(this.tempTopicStatsBuf);
        try {
            this.tempMetricsCollection.clear();
            this.bundleStats.clear();
            this.brokerOperabilityMetrics.reset();
            this.brokerStats.reset();
            topicStatsStream.startObject();
            topicsMap.forEach((namespaceName, bundles) -> {
                if (bundles.isEmpty()) {
                    return;
                }
                try {
                    topicStatsStream.startObject((String)namespaceName);
                    this.nsStats.reset();
                    bundles.forEach((bundle, topics) -> {
                        NamespaceBundleStats currentBundleStats = this.bundleStats.computeIfAbsent((String)bundle, k -> new NamespaceBundleStats());
                        currentBundleStats.reset();
                        currentBundleStats.topics = topics.size();
                        this.brokerStats.topics += topics.size();
                        topicStatsStream.startObject(NamespaceBundle.getBundleRange(bundle));
                        this.tempNonPersistentTopics.clear();
                        topicStatsStream.startObject("persistent");
                        topics.forEach((name, topic) -> {
                            if (topic instanceof PersistentTopic) {
                                try {
                                    topic.updateRates(this.nsStats, currentBundleStats, topicStatsStream, this.clusterReplicationMetrics, (String)namespaceName, this.exposePublisherStats);
                                }
                                catch (Exception e) {
                                    log.error("Failed to generate topic stats for topic {}: {}", new Object[]{name, e.getMessage(), e});
                                }
                                topic.checkBackloggedCursors();
                                topic.checkCursorsToCacheEntries();
                                ((PersistentTopic)topic).checkInactiveLedgers();
                            } else if (topic instanceof NonPersistentTopic) {
                                this.tempNonPersistentTopics.add((NonPersistentTopic)topic);
                            } else {
                                log.warn("Unsupported type of topic {}", (Object)topic.getClass().getName());
                            }
                        });
                        topicStatsStream.endObject();
                        if (!this.tempNonPersistentTopics.isEmpty()) {
                            topicStatsStream.startObject("non-persistent");
                            this.tempNonPersistentTopics.forEach(topic -> {
                                try {
                                    topic.updateRates(this.nsStats, currentBundleStats, topicStatsStream, this.clusterReplicationMetrics, (String)namespaceName, this.exposePublisherStats);
                                }
                                catch (Exception e) {
                                    log.error("Failed to generate topic stats for topic {}: {}", new Object[]{topic.getName(), e.getMessage(), e});
                                }
                            });
                            topicStatsStream.endObject();
                        }
                        topicStatsStream.endObject();
                    });
                    this.brokerStats.bundleCount += bundles.size();
                    this.brokerStats.producerCount += this.nsStats.producerCount;
                    this.brokerStats.replicatorCount += this.nsStats.replicatorCount;
                    this.brokerStats.subsCount += this.nsStats.subsCount;
                    this.brokerStats.consumerCount += this.nsStats.consumerCount;
                    this.brokerStats.msgBacklog += this.nsStats.msgBacklog;
                    this.brokerStats.msgRateIn += this.nsStats.msgRateIn;
                    this.brokerStats.msgRateOut += this.nsStats.msgRateOut;
                    this.brokerStats.msgThroughputIn += this.nsStats.msgThroughputIn;
                    this.brokerStats.msgThroughputOut += this.nsStats.msgThroughputOut;
                    NamespaceStats.add(this.nsStats.addLatencyBucket, this.brokerStats.addLatencyBucket);
                    topicStatsStream.endObject();
                    this.tempMetricsCollection.add(this.nsStats.add((String)namespaceName));
                }
                catch (Exception e) {
                    log.error("Failed to generate namespace stats for namespace {}: {}", new Object[]{namespaceName, e.getMessage(), e});
                }
            });
            if (this.clusterReplicationMetrics.isMetricsEnabled()) {
                this.tempMetricsCollection.addAll(this.clusterReplicationMetrics.get());
                this.clusterReplicationMetrics.reset();
            }
            this.tempMetricsCollection.addAll(this.brokerOperabilityMetrics.getMetrics());
            topicStatsStream.endObject();
        }
        catch (Exception e) {
            log.error("Unable to update topic stats", (Throwable)e);
        }
        List<Metrics> tempRefMetrics = this.metricsCollection;
        this.metricsCollection = this.tempMetricsCollection;
        this.tempMetricsCollection = tempRefMetrics;
        this.bufferLock.writeLock().lock();
        try {
            ByteBuf tmp = this.topicStatsBuf;
            this.topicStatsBuf = this.tempTopicStatsBuf;
            this.tempTopicStatsBuf = tmp;
            this.tempTopicStatsBuf.clear();
        }
        finally {
            this.bufferLock.writeLock().unlock();
        }
        this.updatedAt = System.currentTimeMillis();
    }

    public synchronized NamespaceBundleStats invalidBundleStats(String bundleName) {
        return this.bundleStats.remove(bundleName);
    }

    public void getDimensionMetrics(Consumer<ByteBuf> consumer) {
        this.bufferLock.readLock().lock();
        try {
            consumer.accept(this.topicStatsBuf);
        }
        finally {
            this.bufferLock.readLock().unlock();
        }
    }

    public List<Metrics> getTopicMetrics() {
        return this.metricsCollection;
    }

    public BrokerOperabilityMetrics getBrokerOperabilityMetrics() {
        return this.brokerOperabilityMetrics;
    }

    public synchronized Map<String, NamespaceBundleStats> getBundleStats() {
        return this.bundleStats;
    }

    public void recordTopicLoadTimeValue(String topic, long topicLoadLatencyMs) {
        try {
            this.brokerOperabilityMetrics.recordTopicLoadTimeValue(topicLoadLatencyMs);
        }
        catch (Exception ex) {
            log.warn("Exception while recording topic load time for topic {}, {}", (Object)topic, (Object)ex.getMessage());
        }
    }

    public void recordTopicLoadFailed() {
        this.brokerOperabilityMetrics.recordTopicLoadFailed();
    }

    public void recordConnectionCreate() {
        this.brokerOperabilityMetrics.recordConnectionCreate();
    }

    public void recordConnectionClose() {
        this.brokerOperabilityMetrics.recordConnectionClose();
    }

    public void recordConnectionCreateSuccess() {
        this.brokerOperabilityMetrics.recordConnectionCreateSuccess();
    }

    public void recordConnectionCreateFail() {
        this.brokerOperabilityMetrics.recordConnectionCreateFail();
    }

    @Generated
    public BrokerStats getBrokerStats() {
        return this.brokerStats;
    }

    @Generated
    public long getUpdatedAt() {
        return this.updatedAt;
    }
}

