/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AmsTCPPacket implements Message {

  // Properties.
  protected final AmsPacket userdata;

  public AmsTCPPacket(AmsPacket userdata) {
    super();
    this.userdata = userdata;
  }

  public AmsPacket getUserdata() {
    return userdata;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AmsTCPPacket");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (int) 0x0000,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Implicit Field (length) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    long length = (long) (getUserdata().getLengthInBytes());
    writeImplicitField(
        "length",
        length,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (userdata)
    writeSimpleField(
        "userdata",
        userdata,
        writeComplex(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("AmsTCPPacket");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AmsTCPPacket _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 16;

    // Implicit Field (length)
    lengthInBits += 32;

    // Simple field (userdata)
    lengthInBits += userdata.getLengthInBits();

    return lengthInBits;
  }

  public static AmsTCPPacket staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AmsTCPPacket");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Integer reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedInt(readBuffer, 16),
            (int) 0x0000,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    long length =
        readImplicitField(
            "length",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    AmsPacket userdata =
        readSimpleField(
            "userdata",
            readComplex(() -> AmsPacket.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("AmsTCPPacket");
    // Create the instance
    AmsTCPPacket _amsTCPPacket;
    _amsTCPPacket = new AmsTCPPacket(userdata);
    return _amsTCPPacket;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AmsTCPPacket)) {
      return false;
    }
    AmsTCPPacket that = (AmsTCPPacket) o;
    return (getUserdata() == that.getUserdata()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getUserdata());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
