/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RawDouble
implements DataType<Double> {
    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(Double val) {
        return 8;
    }

    @Override
    public Class<Double> encodedClass() {
        return Double.class;
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + 8);
        return 8;
    }

    @Override
    public Double decode(PositionedByteRange src) {
        double val = Bytes.toDouble(src.getBytes(), src.getOffset() + src.getPosition());
        this.skip(src);
        return val;
    }

    @Override
    public int encode(PositionedByteRange dst, Double val) {
        Bytes.putDouble(dst.getBytes(), dst.getOffset() + dst.getPosition(), val);
        return this.skip(dst);
    }

    public double decodeDouble(byte[] buff, int offset) {
        double val = Bytes.toDouble(buff, offset);
        return val;
    }

    public int encodeDouble(byte[] buff, int offset, double val) {
        return Bytes.putDouble(buff, offset, val);
    }
}

