/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.blacklist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.BlacklistManager;

public class SimpleBlacklistManager
implements BlacklistManager {
    private int numberOfNodeManagerHosts;
    private final double blacklistDisableFailureThreshold;
    private final Set<String> blacklistNodes = new HashSet<String>();
    private static final ArrayList<String> EMPTY_LIST = new ArrayList();
    private static final Log LOG = LogFactory.getLog(SimpleBlacklistManager.class);

    public SimpleBlacklistManager(int numberOfNodeManagerHosts, double blacklistDisableFailureThreshold) {
        this.numberOfNodeManagerHosts = numberOfNodeManagerHosts;
        this.blacklistDisableFailureThreshold = blacklistDisableFailureThreshold;
    }

    @Override
    public void addNode(String node) {
        this.blacklistNodes.add(node);
    }

    @Override
    public void refreshNodeHostCount(int nodeHostCount) {
        this.numberOfNodeManagerHosts = nodeHostCount;
    }

    @Override
    public ResourceBlacklistRequest getBlacklistUpdates() {
        ResourceBlacklistRequest ret;
        double failureThreshold;
        ArrayList<String> blacklist = new ArrayList<String>(this.blacklistNodes);
        int currentBlacklistSize = blacklist.size();
        if ((double)currentBlacklistSize < (failureThreshold = this.blacklistDisableFailureThreshold * (double)this.numberOfNodeManagerHosts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("blacklist size " + currentBlacklistSize + " is less than " + "failure threshold ratio " + this.blacklistDisableFailureThreshold + " out of total usable nodes " + this.numberOfNodeManagerHosts));
            }
            ret = ResourceBlacklistRequest.newInstance(blacklist, EMPTY_LIST);
        } else {
            LOG.warn((Object)("Ignoring Blacklists, blacklist size " + currentBlacklistSize + " is more than failure threshold ratio " + this.blacklistDisableFailureThreshold + " out of total usable nodes " + this.numberOfNodeManagerHosts));
            ret = ResourceBlacklistRequest.newInstance(EMPTY_LIST, blacklist);
        }
        return ret;
    }
}

