/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Collection;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorFilterOperator
extends FilterOperator {
    private static final long serialVersionUID = 1L;
    private VectorExpression conditionEvaluator = null;
    private transient int[] temporarySelected;
    private transient int filterMode = 0;

    public VectorFilterOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        ExprNodeDesc oldExpression = ((FilterDesc)conf).getPredicate();
        this.conditionEvaluator = vContext.getVectorExpression(oldExpression, VectorExpressionDescriptor.Mode.FILTER);
        this.conf = (FilterDesc)conf;
    }

    public VectorFilterOperator() {
    }

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        Collection<Future<?>> result = super.initializeOp(hconf);
        try {
            this.heartbeatInterval = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESENDHEARTBEAT);
        }
        catch (Throwable e) {
            throw new HiveException(e);
        }
        if (this.conditionEvaluator instanceof ConstantVectorExpression) {
            ConstantVectorExpression cve = (ConstantVectorExpression)this.conditionEvaluator;
            this.filterMode = cve.getLongValue() == 1L ? 1 : -1;
        }
        this.temporarySelected = new int[1024];
        return result;
    }

    public void setFilterCondition(VectorExpression expr) {
        this.conditionEvaluator = expr;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)row;
        System.arraycopy(vrg.selected, 0, this.temporarySelected, 0, vrg.size);
        int[] selectedBackup = vrg.selected;
        vrg.selected = this.temporarySelected;
        int sizeBackup = vrg.size;
        boolean selectedInUseBackup = vrg.selectedInUse;
        switch (this.filterMode) {
            case 0: {
                this.conditionEvaluator.evaluate(vrg);
                break;
            }
            case -1: {
                vrg.size = 0;
                break;
            }
        }
        if (vrg.size > 0) {
            this.forward(vrg, null);
        }
        vrg.selected = selectedBackup;
        vrg.size = sizeBackup;
        vrg.selectedInUse = selectedInUseBackup;
    }

    public static String getOperatorName() {
        return "FIL";
    }

    public VectorExpression getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    public void setConditionEvaluator(VectorExpression conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
    }
}

