/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jline.ConsoleReader;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class ConfigCommand
extends Shell.Command {
    private Option tableOpt;
    private Option deleteOpt;
    private Option setOpt;
    private Option filterOpt;
    private Option disablePaginationOpt;
    private Option outputFileOpt;
    private int COL1 = 8;
    private int COL2 = 7;
    private ConsoleReader reader;

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        Token cmd = new Token(this.getName());
        Token sub = new Token("-" + this.setOpt.getOpt());
        for (Property p : Property.values()) {
            if (p.getKey().endsWith(".") || p.isExperimental()) continue;
            sub.addSubcommand(new Token(p.toString()));
        }
        cmd.addSubcommand(sub);
        root.addSubcommand(cmd);
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ClassNotFoundException {
        this.reader = shellState.getReader();
        String tableName = cl.getOptionValue(this.tableOpt.getOpt());
        if (tableName != null && !shellState.getConnector().tableOperations().exists(tableName)) {
            throw new TableNotFoundException(null, tableName, null);
        }
        if (cl.hasOption(this.deleteOpt.getOpt())) {
            String property = cl.getOptionValue(this.deleteOpt.getOpt());
            if (property.contains("=")) {
                throw new BadArgumentException("Invalid '=' operator in delete operation.", fullCommand, fullCommand.indexOf(61));
            }
            if (tableName != null) {
                if (!Property.isValidTablePropertyKey(property)) {
                    Shell.log.warn((Object)("Invalid per-table property : " + property + ", still removing from zookeeper if it's there."));
                }
                shellState.getConnector().tableOperations().removeProperty(tableName, property);
                Shell.log.debug((Object)"Successfully deleted table configuration option.");
            } else {
                if (!Property.isValidZooPropertyKey(property)) {
                    Shell.log.warn((Object)("Invalid per-table property : " + property + ", still removing from zookeeper if it's there."));
                }
                shellState.getConnector().instanceOperations().removeProperty(property);
                Shell.log.debug((Object)"Successfully deleted system configuration option");
            }
        } else if (cl.hasOption(this.setOpt.getOpt())) {
            String property = cl.getOptionValue(this.setOpt.getOpt());
            String value = null;
            if (!property.contains("=")) {
                throw new BadArgumentException("Missing '=' operator in set operation.", fullCommand, fullCommand.indexOf(property));
            }
            String[] pair = property.split("=", 2);
            property = pair[0];
            value = pair[1];
            if (tableName != null) {
                if (!Property.isValidTablePropertyKey(property)) {
                    throw new BadArgumentException("Invalid per-table property.", fullCommand, fullCommand.indexOf(property));
                }
                if (property.equals(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey())) {
                    new ColumnVisibility(value);
                }
                shellState.getConnector().tableOperations().setProperty(tableName, property, value);
                Shell.log.debug((Object)"Successfully set table configuration option.");
            } else {
                if (!Property.isValidZooPropertyKey(property)) {
                    throw new BadArgumentException("Property cannot be modified in zookeeper", fullCommand, fullCommand.indexOf(property));
                }
                shellState.getConnector().instanceOperations().setProperty(property, value);
                Shell.log.debug((Object)"Successfully set system configuration option");
            }
        } else {
            TreeMap<String, String> systemConfig = new TreeMap<String, String>();
            systemConfig.putAll(shellState.getConnector().instanceOperations().getSystemConfiguration());
            String outputFile = cl.getOptionValue(this.outputFileOpt.getOpt());
            Shell.PrintFile printFile = outputFile == null ? null : new Shell.PrintFile(outputFile);
            TreeMap<String, String> siteConfig = new TreeMap<String, String>();
            siteConfig.putAll(shellState.getConnector().instanceOperations().getSiteConfiguration());
            TreeMap<String, String> defaults = new TreeMap<String, String>();
            for (Map.Entry<String, String> defaultEntry : AccumuloConfiguration.getDefaultConfiguration()) {
                defaults.put(defaultEntry.getKey(), defaultEntry.getValue());
            }
            Iterable<Map.Entry<String, String>> acuconf = shellState.getConnector().instanceOperations().getSystemConfiguration().entrySet();
            if (tableName != null) {
                acuconf = shellState.getConnector().tableOperations().getProperties(tableName);
            }
            TreeMap sortedConf = new TreeMap();
            for (Map.Entry entry : acuconf) {
                sortedConf.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : acuconf) {
                String key = (String)entry.getKey();
                if (cl.hasOption(this.filterOpt.getOpt()) && !key.contains(cl.getOptionValue(this.filterOpt.getOpt())) || tableName != null && !Property.isValidTablePropertyKey(key)) continue;
                this.COL2 = Math.max(this.COL2, ((String)entry.getKey()).length() + 3);
            }
            ArrayList<String> output = new ArrayList<String>();
            this.printConfHeader(output);
            for (Map.Entry propEntry : sortedConf.entrySet()) {
                String key = (String)propEntry.getKey();
                if (cl.hasOption(this.filterOpt.getOpt()) && !key.contains(cl.getOptionValue(this.filterOpt.getOpt())) || tableName != null && !Property.isValidTablePropertyKey(key)) continue;
                String siteVal = (String)siteConfig.get(key);
                String sysVal = (String)systemConfig.get(key);
                String curVal = (String)propEntry.getValue();
                String dfault = (String)defaults.get(key);
                boolean printed = false;
                if (dfault != null && key.toLowerCase().contains("password")) {
                    dfault = curVal = curVal.replaceAll(".", "*");
                    sysVal = curVal;
                    siteVal = curVal;
                }
                if (sysVal != null) {
                    if (defaults.containsKey(key)) {
                        this.printConfLine(output, "default", key, dfault);
                        printed = true;
                    }
                    if (!defaults.containsKey(key) || !((String)defaults.get(key)).equals(siteVal)) {
                        this.printConfLine(output, "site", printed ? "   @override" : key, siteVal == null ? "" : siteVal);
                        printed = true;
                    }
                    if (!siteConfig.containsKey(key) || !siteVal.equals(sysVal)) {
                        this.printConfLine(output, "system", printed ? "   @override" : key, sysVal == null ? "" : sysVal);
                        printed = true;
                    }
                }
                if (tableName == null || curVal.equals(sysVal)) continue;
                this.printConfLine(output, "table", printed ? "   @override" : key, curVal);
            }
            this.printConfFooter(output);
            shellState.printLines(output.iterator(), !cl.hasOption(this.disablePaginationOpt.getOpt()), printFile);
            if (printFile != null) {
                printFile.close();
            }
        }
        return 0;
    }

    private void printConfHeader(List<String> output) {
        this.printConfFooter(output);
        output.add(String.format("%-" + this.COL1 + "s | %-" + this.COL2 + "s | %s", "SCOPE", "NAME", "VALUE"));
        this.printConfFooter(output);
    }

    private void printConfLine(List<String> output, String s1, String s2, String s3) {
        if (s2.length() < this.COL2) {
            s2 = s2 + " " + Shell.repeat(".", this.COL2 - s2.length() - 1);
        }
        output.add(String.format("%-" + this.COL1 + "s | %-" + this.COL2 + "s | %s", s1, s2, s3.replace("\n", "\n" + Shell.repeat(" ", this.COL1 + 1) + "|" + Shell.repeat(" ", this.COL2 + 2) + "|" + " ")));
    }

    private void printConfFooter(List<String> output) {
        int col3 = Math.max(1, Math.min(Integer.MAX_VALUE, this.reader.getTermwidth() - this.COL1 - this.COL2 - 6));
        output.add(String.format("%" + this.COL1 + "s-+-%" + this.COL2 + "s-+-%-" + col3 + "s", Shell.repeat("-", this.COL1), Shell.repeat("-", this.COL2), Shell.repeat("-", col3)));
    }

    @Override
    public String description() {
        return "prints system properties and table specific properties";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup og = new OptionGroup();
        this.tableOpt = new Option("t", "table", true, "table to display/set/delete properties for");
        this.deleteOpt = new Option("d", "delete", true, "delete a per-table property");
        this.setOpt = new Option("s", "set", true, "set a per-table property");
        this.filterOpt = new Option("f", "filter", true, "show only properties that contain this string");
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disables pagination of output");
        this.outputFileOpt = new Option("o", "output", true, "local file to write the scan output to");
        this.tableOpt.setArgName("table");
        this.deleteOpt.setArgName("property");
        this.setOpt.setArgName("property=value");
        this.filterOpt.setArgName("string");
        this.outputFileOpt.setArgName("file");
        og.addOption(this.deleteOpt);
        og.addOption(this.setOpt);
        og.addOption(this.filterOpt);
        o.addOption(this.tableOpt);
        o.addOptionGroup(og);
        o.addOption(this.disablePaginationOpt);
        o.addOption(this.outputFileOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

