/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.BoundedRegionGroupingProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALPerformanceEvaluation;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestBoundedRegionGroupingProvider {
    protected static final Log LOG = LogFactory.getLog(TestBoundedRegionGroupingProvider.class);
    @Rule
    public TestName currentTest = new TestName();
    protected static Configuration conf;
    protected static FileSystem fs;
    protected static final HBaseTestingUtility TEST_UTIL;

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(new Path("/"))) {
            fs.delete(dir.getPath(), true);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.client.socket-timeout", 5000);
        conf.setInt("hbase.ipc.client.connect.max.retries", 1);
        conf.setInt("dfs.client.block.recovery.retries", 1);
        conf.setInt("hbase.ipc.client.connection.maxidletime", 500);
        conf.setClass("hbase.wal.provider", BoundedRegionGroupingProvider.class, WALProvider.class);
        TEST_UTIL.startMiniDFSCluster(3);
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        int errCode = WALPerformanceEvaluation.innerMain(new Configuration(conf), new String[]{"-threads", "3", "-verify", "-noclosefs", "-iterations", "3000"});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    @Test
    public void testMoreRegionsThanBound() throws Exception {
        String parallelism = Integer.toString(4);
        int errCode = WALPerformanceEvaluation.innerMain(new Configuration(conf), new String[]{"-threads", parallelism, "-verify", "-noclosefs", "-iterations", "3000", "-regions", parallelism});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoundsGreaterThanDefault() throws Exception {
        int temp = conf.getInt("hbase.wal.regiongrouping.numgroups", 2);
        try {
            conf.setInt("hbase.wal.regiongrouping.numgroups", temp * 4);
            String parallelism = Integer.toString(temp * 4);
            int errCode = WALPerformanceEvaluation.innerMain(new Configuration(conf), new String[]{"-threads", parallelism, "-verify", "-noclosefs", "-iterations", "3000", "-regions", parallelism});
            Assert.assertEquals((long)0L, (long)errCode);
        }
        finally {
            conf.setInt("hbase.wal.regiongrouping.numgroups", temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreRegionsThanBoundWithBoundsGreaterThanDefault() throws Exception {
        int temp = conf.getInt("hbase.wal.regiongrouping.numgroups", 2);
        try {
            conf.setInt("hbase.wal.regiongrouping.numgroups", temp * 4);
            String parallelism = Integer.toString(temp * 4 * 2);
            int errCode = WALPerformanceEvaluation.innerMain(new Configuration(conf), new String[]{"-threads", parallelism, "-verify", "-noclosefs", "-iterations", "3000", "-regions", parallelism});
            Assert.assertEquals((long)0L, (long)errCode);
        }
        finally {
            conf.setInt("hbase.wal.regiongrouping.numgroups", temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setMembershipDedups() throws IOException {
        int temp = conf.getInt("hbase.wal.regiongrouping.numgroups", 2);
        WALFactory wals = null;
        try {
            conf.setInt("hbase.wal.regiongrouping.numgroups", temp * 4);
            FSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDirOnTestFS());
            wals = new WALFactory(conf, null, this.currentTest.getMethodName());
            HashSet<WAL> seen = new HashSet<WAL>(temp * 4);
            Random random = new Random();
            int count = 0;
            for (int i = 0; i < temp * 8; ++i) {
                WAL maybeNewWAL = wals.getWAL(Bytes.toBytes((int)random.nextInt()));
                LOG.info((Object)("Iteration " + i + ", checking wal " + maybeNewWAL));
                if (!seen.add(maybeNewWAL)) continue;
                ++count;
            }
            Assert.assertEquals((String)"received back a different number of WALs that are not equal() to each other than the bound we placed.", (long)(temp * 4), (long)count);
        }
        finally {
            if (wals != null) {
                wals.close();
            }
            conf.setInt("hbase.wal.regiongrouping.numgroups", temp);
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }
}

