/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestTableSnapshotInputFormat
extends TableSnapshotInputFormatTestBase {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final byte[] bbb = Bytes.toBytes((String)"bbb");
    private static final byte[] yyy = Bytes.toBytes((String)"yyy");

    @Override
    protected byte[] getStartRow() {
        return bbb;
    }

    @Override
    protected byte[] getEndRow() {
        return yyy;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetBestLocations() throws IOException {
        TableSnapshotInputFormatImpl tsif = new TableSnapshotInputFormatImpl();
        Configuration conf = this.UTIL.getConfiguration();
        HDFSBlocksDistribution blockDistribution = new HDFSBlocksDistribution();
        Assert.assertEquals((Object)Lists.newArrayList(), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution = new HDFSBlocksDistribution();
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 10L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 7L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 5L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 2L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1", "h2"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 3L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h2", "h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 6L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 9L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h2", "h3", "h4", "h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitTableSnapshotMapperJobConfig() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)"testInitTableSnapshotMapperJobConfig");
        String snapshotName = "foo";
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 1);
            Job job = new Job(this.UTIL.getConfiguration());
            Path tmpTableDir = this.UTIL.getRandomDir();
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)new Scan(), TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
            Assert.assertEquals((String)"Snapshot job should be configured for default LruBlockCache.", (double)0.4f, (double)job.getConfiguration().getFloat("hfile.block.cache.size", -1.0f), (double)0.01);
            Assert.assertEquals((String)"Snapshot job should not use BucketCache.", (double)0.0, (double)job.getConfiguration().getFloat("hbase.bucketcache.size", -1.0f), (double)0.01);
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    @Override
    public void testRestoreSnapshotDoesNotCreateBackRefLinksInit(TableName tableName, String snapshotName, Path tmpTableDir) throws Exception {
        Job job = new Job(this.UTIL.getConfiguration());
        TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)new Scan(), TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testWithMockedMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int expectedNumSplits) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)"testWithMockedMapReduce");
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), numRegions);
            Job job = new Job(util.getConfiguration());
            Path tmpTableDir = util.getRandomDir();
            Scan scan = new Scan(this.getStartRow(), this.getEndRow());
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
            this.verifyWithMockedMapReduce(job, numRegions, expectedNumSplits, this.getStartRow(), this.getEndRow());
        }
        finally {
            util.getHBaseAdmin().deleteSnapshot(snapshotName);
            util.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    private void verifyWithMockedMapReduce(Job job, int numRegions, int expectedNumSplits, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        TableSnapshotInputFormat tsif = new TableSnapshotInputFormat();
        List splits = tsif.getSplits((JobContext)job);
        Assert.assertEquals((long)expectedNumSplits, (long)splits.size());
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow);
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assert.assertTrue((boolean)(split instanceof TableSnapshotInputFormat.TableSnapshotRegionSplit));
            TaskAttemptContext taskAttemptContext = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
            Mockito.when((Object)taskAttemptContext.getConfiguration()).thenReturn((Object)job.getConfiguration());
            RecordReader rr = tsif.createRecordReader(split, taskAttemptContext);
            rr.initialize(split, taskAttemptContext);
            while (rr.nextKeyValue()) {
                byte[] row = ((ImmutableBytesWritable)rr.getCurrentKey()).get();
                TestTableSnapshotInputFormat.verifyRowFromMap((ImmutableBytesWritable)rr.getCurrentKey(), (Result)rr.getCurrentValue());
                rowTracker.addRow(row);
            }
            rr.close();
        }
        rowTracker.validate();
    }

    @Override
    protected void testWithMapReduceImpl(HBaseTestingUtility util, TableName tableName, String snapshotName, Path tableDir, int numRegions, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.doTestWithMapReduce(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), tableDir, numRegions, expectedNumSplits, shutdownCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestWithMapReduce(HBaseTestingUtility util, TableName tableName, String snapshotName, byte[] startRow, byte[] endRow, Path tableDir, int numRegions, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, startRow, endRow, numRegions);
        if (shutdownCluster) {
            util.shutdownMiniHBaseCluster();
        }
        try {
            Job job = new Job(util.getConfiguration());
            Scan scan = new Scan(startRow, endRow);
            job.setJarByClass(((Object)((Object)util)).getClass());
            TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{TestTableSnapshotInputFormat.class});
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)true, (Path)tableDir);
            job.setReducerClass(TestTableSnapshotReducer.class);
            job.setNumReduceTasks(1);
            job.setOutputFormatClass(NullOutputFormat.class);
            Assert.assertTrue((boolean)job.waitForCompletion(true));
        }
        finally {
            if (!shutdownCluster) {
                util.getHBaseAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
            }
        }
    }

    static /* synthetic */ byte[] access$000() {
        return bbb;
    }

    static /* synthetic */ byte[] access$100() {
        return yyy;
    }

    public static class TestTableSnapshotReducer
    extends Reducer<ImmutableBytesWritable, NullWritable, NullWritable, NullWritable> {
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(TestTableSnapshotInputFormat.access$000(), TestTableSnapshotInputFormat.access$100());

        protected void reduce(ImmutableBytesWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.addRow(key.get());
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.validate();
        }
    }

    public static class TestTableSnapshotMapper
    extends TableMapper<ImmutableBytesWritable, NullWritable> {
        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            TableSnapshotInputFormatTestBase.verifyRowFromMap(key, value);
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static enum TestTableSnapshotCounters {
        VALIDATION_ERROR;

    }
}

