/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.FinishCreateTable;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.TableInfo;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.hadoop.io.Text;

class PopulateMetadata
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    PopulateMetadata(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        KeyExtent extent = new KeyExtent(new Text(this.tableInfo.tableId), null, null);
        MetadataTable.addTablet(extent, "/default_tablet", SecurityConstants.getSystemCredentials(), this.tableInfo.timeType, environment.getMasterLock());
        return new FinishCreateTable(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTable.deleteTable(this.tableInfo.tableId, false, SecurityConstants.getSystemCredentials(), environment.getMasterLock());
    }
}

