/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.wb;

import com.github.openjson.JSONObject;
import java.io.IOException;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.wb.WbAction;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class AbstractWbPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected static final String ROLE_NONE = "NONE";
    protected final RoomPanel rp;
    protected boolean inited = false;

    protected AbstractWbPanel(String id, RoomPanel rp) {
        super(id);
        this.rp = rp;
        this.setOutputMarkupId(true);
    }

    public CharSequence getInitScript() {
        StringBuilder sb = new StringBuilder("WbArea.init(() => {");
        this.internalWbLoad(sb);
        this.inited = true;
        sb.append("});");
        return sb;
    }

    public AbstractWbPanel update(IPartialPageRequestHandler handler) {
        if (this.inited && handler != null) {
            handler.appendJavaScript((CharSequence)String.format("WbArea.setRole('%s');", this.getRole()));
        }
        return this;
    }

    public void reloadWb(IPartialPageRequestHandler handler) {
    }

    protected abstract String getRole();

    void internalWbLoad(StringBuilder sb) {
    }

    public void sendFileToWb(BaseFileItem fi, boolean clean) {
    }

    public abstract void processWbAction(WbAction var1, JSONObject var2, IPartialPageRequestHandler var3) throws IOException;
}

