/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.wan.impl.ConsistencyCheckResult;
import com.hazelcast.wan.impl.WanSyncStats;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalWanPublisherStatsImpl
implements LocalWanPublisherStats {
    private static final AtomicLongFieldUpdater<LocalWanPublisherStatsImpl> TOTAL_PUBLISH_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalWanPublisherStatsImpl.class, "totalPublishLatency");
    private static final AtomicLongFieldUpdater<LocalWanPublisherStatsImpl> TOTAL_PUBLISHED_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(LocalWanPublisherStatsImpl.class, "totalPublishedEventCount");
    private volatile boolean connected;
    private volatile WanPublisherState state;
    @Probe(name="outboundQueueSize")
    private volatile int outboundQueueSize;
    @Probe(name="totalPublishLatency", unit=ProbeUnit.MS)
    private volatile long totalPublishLatency;
    @Probe(name="totalPublishedEventCount")
    private volatile long totalPublishedEventCount;
    private volatile Map<String, WanEventCounters.DistributedObjectWanEventCounters> sentMapEventCounter;
    private volatile Map<String, WanEventCounters.DistributedObjectWanEventCounters> sentCacheEventCounter;
    private volatile Map<String, ConsistencyCheckResult> lastConsistencyCheckResults;
    private volatile Map<String, WanSyncStats> lastSyncStats;

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public int getOutboundQueueSize() {
        return this.outboundQueueSize;
    }

    public void setOutboundQueueSize(int outboundQueueSize) {
        this.outboundQueueSize = outboundQueueSize;
    }

    @Override
    public WanPublisherState getPublisherState() {
        return this.state;
    }

    public void setState(WanPublisherState state) {
        this.state = state;
    }

    @Override
    public long getTotalPublishLatency() {
        return this.totalPublishLatency;
    }

    @Override
    public long getTotalPublishedEventCount() {
        return this.totalPublishedEventCount;
    }

    @Override
    public Map<String, WanEventCounters.DistributedObjectWanEventCounters> getSentMapEventCounter() {
        return this.sentMapEventCounter;
    }

    public void setSentMapEventCounter(Map<String, WanEventCounters.DistributedObjectWanEventCounters> sentMapEventCounter) {
        this.sentMapEventCounter = sentMapEventCounter;
    }

    @Override
    public Map<String, WanEventCounters.DistributedObjectWanEventCounters> getSentCacheEventCounter() {
        return this.sentCacheEventCounter;
    }

    public void setSentCacheEventCounter(Map<String, WanEventCounters.DistributedObjectWanEventCounters> sentCacheEventCounter) {
        this.sentCacheEventCounter = sentCacheEventCounter;
    }

    public void setLastConsistencyCheckResults(Map<String, ConsistencyCheckResult> lastConsistencyCheckResults) {
        this.lastConsistencyCheckResults = lastConsistencyCheckResults;
    }

    @Override
    public Map<String, ConsistencyCheckResult> getLastConsistencyCheckResults() {
        return this.lastConsistencyCheckResults;
    }

    public void setLastSyncStats(Map<String, WanSyncStats> lastSyncStats) {
        this.lastSyncStats = lastSyncStats;
    }

    @Override
    public Map<String, WanSyncStats> getLastSyncStats() {
        return this.lastSyncStats;
    }

    public void incrementPublishedEventCount(long latency) {
        TOTAL_PUBLISHED_EVENT_COUNT.incrementAndGet(this);
        TOTAL_PUBLISH_LATENCY.addAndGet(this, latency);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("isConnected", this.connected);
        root.add("state", this.state.name());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.connected = JsonUtil.getBoolean(json, "isConnected", false);
        this.state = WanPublisherState.valueOf(JsonUtil.getString(json, "state", WanPublisherState.REPLICATING.name()));
    }

    public String toString() {
        return "LocalPublisherStatsImpl{connected=" + this.connected + ", totalPublishLatency=" + this.totalPublishLatency + ", totalPublishedEventCount=" + this.totalPublishedEventCount + ", outboundQueueSize=" + this.outboundQueueSize + ", state=" + this.state + "}";
    }
}

