/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.querycache.event.DefaultQueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;

public final class QueryCacheEventDataCodec {
    private static final int SEQUENCE_FIELD_OFFSET = 0;
    private static final int EVENT_TYPE_FIELD_OFFSET = 8;
    private static final int PARTITION_ID_FIELD_OFFSET = 12;
    private static final int INITIAL_FRAME_SIZE = 16;

    private QueryCacheEventDataCodec() {
    }

    public static void encode(ClientMessage clientMessage, QueryCacheEventData queryCacheEventData) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, queryCacheEventData.getSequence());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, queryCacheEventData.getEventType());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, queryCacheEventData.getPartitionId());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, queryCacheEventData.getDataKey(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, queryCacheEventData.getDataNewValue(), DataCodec::encode);
        StringCodec.encode(clientMessage, queryCacheEventData.getMapName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static DefaultQueryCacheEventData decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        long sequence = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        int eventType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 12);
        Data dataKey = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data dataNewValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        boolean isMapNameExists = false;
        String mapName = null;
        if (!iterator.peekNext().isEndFrame()) {
            mapName = StringCodec.decode(iterator);
            isMapNameExists = true;
        }
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createQueryCacheEventData(dataKey, dataNewValue, sequence, eventType, partitionId, isMapNameExists, mapName);
    }
}

