/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.enums.EnumConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.jqplot.lib.Chart;
import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;
import org.wicketstuff.jqplot.lib.support.JqPlotJsonMapHierarchicalWriter;

public class JqPlotUtils {
    public static List<String> retriveJavaScriptResources(Chart<?> chart) {
        ArrayList<String> resources = new ArrayList<String>();
        Class<?> clazz = chart.getClass();
        if (clazz.isAnnotationPresent(JqPlotPlugin.class)) {
            JqPlotResources[] jqPlotResourceses;
            for (JqPlotResources jqPlotResources : jqPlotResourceses = clazz.getAnnotation(JqPlotPlugin.class).values()) {
                resources.add(jqPlotResources.getResource());
            }
        }
        if (chart.getChartConfiguration().getHighlighter() != null) {
            resources.add(JqPlotResources.Highlighter.getResource());
        }
        return resources;
    }

    public static String createJquery(Chart<?> chart, String divId) {
        return JqPlotUtils.createJquery(chart, divId, null);
    }

    public static String createJquery(Chart<?> chart, String divId, String javaScriptVar) {
        StringBuilder builder = new StringBuilder();
        builder.append("$(document).ready(function(){\r\n");
        if (javaScriptVar != null) {
            builder.append("   var ").append(javaScriptVar).append("=");
        }
        builder.append("   $.jqplot('").append(divId).append("', ");
        builder.append(chart.getChartData().toJsonString());
        builder.append(", ");
        builder.append(JqPlotUtils.jqPlotToJson(chart.getChartConfiguration()));
        builder.append(");\r\n");
        builder.append("});\r\n");
        return builder.toString();
    }

    public static String jqPlotToJson(ChartConfiguration<?> jqPlot) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver(){

            public HierarchicalStreamWriter createWriter(Writer writer) {
                return new JqPlotJsonMapHierarchicalWriter(writer, 1){

                    @Override
                    public void addAttribute(String name, String value) {
                        if (!name.contains("class")) {
                            super.addAttribute(name, value);
                        }
                    }
                };
            }
        }){};
        EnumConverter converter = new EnumConverter(){

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (source instanceof JqPlotResources) {
                    JqPlotResources plugin = (JqPlotResources)((Object)source);
                    writer.setValue(plugin.getClassName());
                } else {
                    super.marshal(source, writer, context);
                }
            }
        };
        converter.canConvert(JqPlotResources.class);
        xstream.registerConverter((Converter)converter);
        return xstream.toXML(jqPlot);
    }
}

