/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAJoinClause;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLJoinContextView;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectContext;

public class JPQLJoinSelectContext
extends JPQLSelectContext
implements JPQLJoinContextView {
    private List<JPAJoinClause> jpaJoinClauses = null;

    protected void setJPAOuterJoinClause(List<JPAJoinClause> jpaOuterJoinClauses) {
        this.jpaJoinClauses = jpaOuterJoinClauses;
    }

    public JPQLJoinSelectContext(boolean isCountOnly) {
        super(isCountOnly);
    }

    public List<JPAJoinClause> getJPAJoinClauses() {
        return this.jpaJoinClauses;
    }

    public class JPQLJoinContextBuilder
    extends JPQLSelectContext.JPQLSelectContextBuilder {
        protected int relationShipAliasCounter;

        public JPQLJoinContextBuilder() {
            super(JPQLJoinSelectContext.this);
            this.relationShipAliasCounter = 0;
        }

        @Override
        public JPQLContext build() throws ODataJPAModelException, ODataJPARuntimeException {
            try {
                if (JPQLJoinSelectContext.this.isCountOnly) {
                    JPQLJoinSelectContext.this.setType(JPQLContextType.JOIN_COUNT);
                } else {
                    JPQLJoinSelectContext.this.setType(JPQLContextType.JOIN);
                }
                if (this.withPaging) {
                    JPQLJoinSelectContext.this.isPagingRequested(this.withPaging);
                }
                JPQLJoinSelectContext.this.setJPAOuterJoinClause(this.generateJoinClauses());
                if (!JPQLJoinSelectContext.this.jpaJoinClauses.isEmpty()) {
                    JPAJoinClause joinClause = JPQLJoinSelectContext.this.jpaJoinClauses.get(JPQLJoinSelectContext.this.jpaJoinClauses.size() - 1);
                    JPQLJoinSelectContext.this.setJPAEntityName(joinClause.getEntityName());
                    JPQLJoinSelectContext.this.setJPAEntityAlias(joinClause.getEntityRelationShipAlias());
                }
                JPQLJoinSelectContext.this.setOrderByCollection(this.generateOrderByFileds());
                JPQLJoinSelectContext.this.setSelectExpression(this.generateSelectExpression());
                JPQLJoinSelectContext.this.setWhereExpression(this.generateWhereExpression());
                JPQLJoinSelectContext.setJPQLContext((JPQLContext)JPQLJoinSelectContext.this);
            }
            catch (ODataException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
            }
            return JPQLJoinSelectContext.this;
        }

        protected List<JPAJoinClause> generateJoinClauses() throws ODataJPARuntimeException, EdmException {
            ArrayList<JPAJoinClause> jpaOuterJoinClauses = new ArrayList<JPAJoinClause>();
            JPAJoinClause jpaOuterJoinClause = null;
            String joinCondition = null;
            HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
            String entityAlias = this.generateJPAEntityAlias();
            joinCondition = ODataExpressionParser.parseKeyPredicates(this.entitySetView.getKeyPredicates(), entityAlias);
            if (joinCondition != null) {
                parameterizedExpressionMap.put(joinCondition, ODataExpressionParser.getPositionalParametersThreadLocal());
            }
            EdmEntityType entityType = this.entitySetView.getStartEntitySet().getEntityType();
            Mapping mapping = (Mapping)entityType.getMapping();
            String entityTypeName = null;
            entityTypeName = mapping != null ? mapping.getInternalName() : entityType.getName();
            jpaOuterJoinClause = new JPAJoinClause(entityTypeName, entityAlias, null, null, joinCondition, JPAJoinClause.JOIN.INNER);
            jpaOuterJoinClauses.add(jpaOuterJoinClause);
            for (NavigationSegment navigationSegment : this.entitySetView.getNavigationSegments()) {
                EdmNavigationProperty navigationProperty = navigationSegment.getNavigationProperty();
                String relationShipAlias = this.generateRelationShipAlias();
                joinCondition = ODataExpressionParser.parseKeyPredicates(navigationSegment.getKeyPredicates(), relationShipAlias);
                if (joinCondition != null) {
                    parameterizedExpressionMap.put(joinCondition, ODataExpressionParser.getPositionalParametersThreadLocal());
                }
                jpaOuterJoinClause = new JPAJoinClause(this.getFromEntityName(navigationProperty), entityAlias, this.getRelationShipName(navigationProperty), relationShipAlias, joinCondition, JPAJoinClause.JOIN.INNER);
                jpaOuterJoinClauses.add(jpaOuterJoinClause);
            }
            JPQLJoinSelectContext.this.setParameterizedQueryMap(parameterizedExpressionMap);
            return jpaOuterJoinClauses;
        }

        private String getFromEntityName(EdmNavigationProperty navigationProperty) throws EdmException {
            String fromRole = navigationProperty.getFromRole();
            EdmEntityType toEntityType = navigationProperty.getRelationship().getEnd(fromRole).getEntityType();
            EdmMapping mapping = toEntityType.getMapping();
            String entityName = null;
            entityName = mapping != null ? mapping.getInternalName() : toEntityType.getName();
            return entityName;
        }

        private String getRelationShipName(EdmNavigationProperty navigationProperty) throws EdmException {
            EdmMapping mapping = navigationProperty.getMapping();
            String relationShipName = null;
            relationShipName = mapping != null ? mapping.getInternalName() : navigationProperty.getName();
            return relationShipName;
        }

        private String generateRelationShipAlias() {
            return new String("R" + ++this.relationShipAliasCounter);
        }
    }
}

