/****************************************************************************
 * drivers/video/new_logo.c
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* Script-generated framebuffer splashscreen bitmap file.
 * Generated from drivers/video/new_nx_logo.png
 * by splashscreen_converter.py
 */

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/video/fb.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/****************************************************************************
 * Private Data
 ****************************************************************************/

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0, 0),
  MKRGB(255, 4, 15, 22),
  MKRGB(255, 10, 31, 50),
  MKRGB(255, 6, 19, 32),
  MKRGB(255, 6, 17, 27),
  MKRGB(255, 3, 7, 13),
  MKRGB(255, 9, 33, 56),
  MKRGB(255, 8, 25, 39),
  MKRGB(255, 8, 24, 44),
  MKRGB(255, 10, 28, 44),
  MKRGB(255, 6, 23, 39),
  MKRGB(255, 17, 41, 62),
  MKRGB(255, 5, 22, 47),
  MKRGB(255, 9, 42, 68),
  MKRGB(255, 7, 53, 89),
  MKRGB(255, 33, 51, 64),
  MKRGB(255, 5, 39, 74),
  MKRGB(255, 35, 200, 246),
  MKRGB(255, 11, 54, 82),
  MKRGB(255, 66, 226, 249),
  MKRGB(255, 57, 201, 231),
  MKRGB(255, 32, 71, 96),
  MKRGB(255, 11, 129, 208),
  MKRGB(255, 12, 76, 122),
  MKRGB(255, 32, 185, 244),
  MKRGB(255, 22, 162, 231),
  MKRGB(255, 8, 101, 162),
  MKRGB(255, 18, 129, 185),
  MKRGB(255, 42, 100, 126),
  MKRGB(255, 28, 162, 213),
  MKRGB(255, 58, 130, 159),
  MKRGB(255, 61, 162, 189),
  MKRGB(255, 20, 100, 147),
};
#endif

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0),
  MKRGB(4, 15, 22),
  MKRGB(10, 31, 50),
  MKRGB(6, 19, 32),
  MKRGB(6, 17, 27),
  MKRGB(3, 7, 13),
  MKRGB(9, 33, 56),
  MKRGB(8, 25, 39),
  MKRGB(8, 24, 44),
  MKRGB(10, 28, 44),
  MKRGB(6, 23, 39),
  MKRGB(17, 41, 62),
  MKRGB(5, 22, 47),
  MKRGB(9, 42, 68),
  MKRGB(7, 53, 89),
  MKRGB(33, 51, 64),
  MKRGB(5, 39, 74),
  MKRGB(35, 200, 246),
  MKRGB(11, 54, 82),
  MKRGB(66, 226, 249),
  MKRGB(57, 201, 231),
  MKRGB(32, 71, 96),
  MKRGB(11, 129, 208),
  MKRGB(12, 76, 122),
  MKRGB(32, 185, 244),
  MKRGB(22, 162, 231),
  MKRGB(8, 101, 162),
  MKRGB(18, 129, 185),
  MKRGB(42, 100, 126),
  MKRGB(28, 162, 213),
  MKRGB(58, 130, 159),
  MKRGB(61, 162, 189),
  MKRGB(20, 100, 147),
};
#endif

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0),
  MKRGB(0, 3, 2),
  MKRGB(1, 7, 6),
  MKRGB(0, 4, 4),
  MKRGB(0, 4, 3),
  MKRGB(0, 1, 1),
  MKRGB(1, 8, 7),
  MKRGB(1, 6, 4),
  MKRGB(1, 6, 5),
  MKRGB(1, 7, 5),
  MKRGB(0, 5, 4),
  MKRGB(2, 10, 7),
  MKRGB(0, 5, 5),
  MKRGB(1, 10, 8),
  MKRGB(0, 13, 11),
  MKRGB(4, 12, 8),
  MKRGB(0, 9, 9),
  MKRGB(4, 50, 30),
  MKRGB(1, 13, 10),
  MKRGB(8, 56, 31),
  MKRGB(7, 50, 28),
  MKRGB(4, 17, 12),
  MKRGB(1, 32, 26),
  MKRGB(1, 19, 15),
  MKRGB(4, 46, 30),
  MKRGB(2, 40, 28),
  MKRGB(1, 25, 20),
  MKRGB(2, 32, 23),
  MKRGB(5, 25, 15),
  MKRGB(3, 40, 26),
  MKRGB(7, 32, 19),
  MKRGB(7, 40, 23),
  MKRGB(2, 25, 18),
};
#endif

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const struct splscr_bitmap_s bitmap[] =
{
  {160, 0},
  {67, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {10, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {12, 4},
  {8, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {37, 3},
  {1, 4},
  {7, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 10},
  {3, 3},
  {1, 10},
  {3, 3},
  {1, 10},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {17, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {42, 4},
  {2, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {69, 5},
  {160, 0},
  {160, 0},
  {54, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {4, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {3, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {61, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {16, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {8, 4},
  {3, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {47, 5},
  {160, 0},
  {160, 0},
  {56, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {53, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {4, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {12, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {14, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {9, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {45, 5},
  {160, 0},
  {160, 0},
  {53, 5},
  {1, 1},
  {12, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {13, 4},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {7, 3},
  {1, 7},
  {7, 3},
  {2, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {14, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {14, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {28, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {3, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {64, 5},
  {160, 0},
  {160, 0},
  {55, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {3, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {7, 3},
  {1, 4},
  {14, 3},
  {1, 4},
  {9, 3},
  {1, 8},
  {17, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {3, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {3, 7},
  {4, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {7, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {10, 3},
  {1, 12},
  {1, 4},
  {7, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {4, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {14, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {1, 4},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {49, 5},
  {160, 0},
  {160, 0},
  {57, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {6, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {4, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 8},
  {1, 4},
  {1, 12},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {7, 3},
  {1, 4},
  {1, 12},
  {5, 3},
  {1, 10},
  {12, 3},
  {1, 7},
  {4, 3},
  {1, 10},
  {1, 3},
  {8, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {10, 10},
  {1, 3},
  {2, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {5, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {7, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {13, 4},
  {2, 3},
  {6, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {10, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {4, 4},
  {2, 5},
  {1, 4},
  {3, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {46, 5},
  {160, 0},
  {160, 0},
  {42, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {6, 4},
  {4, 3},
  {1, 4},
  {11, 3},
  {1, 4},
  {13, 3},
  {1, 4},
  {8, 3},
  {1, 4},
  {4, 3},
  {1, 8},
  {2, 4},
  {18, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {14, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {11, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {8, 10},
  {1, 3},
  {6, 10},
  {5, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {17, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {17, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {50, 5},
  {160, 0},
  {160, 0},
  {53, 5},
  {4, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 4},
  {2, 5},
  {1, 1},
  {2, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {8, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 12},
  {6, 3},
  {1, 8},
  {6, 3},
  {1, 8},
  {6, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {6, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 8},
  {5, 10},
  {3, 7},
  {1, 3},
  {3, 7},
  {1, 4},
  {3, 7},
  {2, 3},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {8, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {7, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {6, 3},
  {1, 8},
  {1, 4},
  {1, 8},
  {22, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {20, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {42, 5},
  {160, 0},
  {160, 0},
  {52, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {5, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {5, 4},
  {3, 3},
  {1, 4},
  {11, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {11, 3},
  {1, 8},
  {7, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 3},
  {5, 10},
  {1, 7},
  {8, 10},
  {7, 7},
  {15, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 8},
  {1, 10},
  {1, 7},
  {13, 10},
  {1, 8},
  {1, 3},
  {2, 10},
  {5, 7},
  {5, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 8},
  {1, 10},
  {1, 8},
  {4, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {15, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {11, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 5},
  {9, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {40, 5},
  {160, 0},
  {160, 0},
  {53, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {5, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {5, 4},
  {1, 3},
  {3, 4},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {7, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 12},
  {8, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 4},
  {1, 8},
  {1, 10},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {10, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {6, 10},
  {1, 7},
  {2, 10},
  {5, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {16, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {3, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 8},
  {4, 10},
  {6, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {4, 3},
  {1, 10},
  {1, 3},
  {2, 8},
  {1, 10},
  {4, 3},
  {2, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 4},
  {1, 12},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {6, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {6, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {2, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {43, 5},
  {160, 0},
  {160, 0},
  {44, 5},
  {1, 1},
  {7, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {10, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {5, 4},
  {9, 3},
  {1, 4},
  {7, 3},
  {1, 12},
  {1, 4},
  {8, 3},
  {1, 8},
  {1, 4},
  {2, 3},
  {1, 8},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {5, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {8, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 7},
  {4, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {2, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 8},
  {1, 10},
  {1, 8},
  {3, 10},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {3, 3},
  {1, 7},
  {10, 3},
  {1, 8},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {4, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 5},
  {11, 4},
  {1, 5},
  {4, 4},
  {1, 1},
  {4, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {39, 5},
  {160, 0},
  {160, 0},
  {54, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {8, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {9, 3},
  {1, 4},
  {9, 3},
  {1, 5},
  {1, 8},
  {5, 3},
  {1, 7},
  {5, 3},
  {2, 10},
  {2, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {5, 10},
  {1, 8},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {2, 10},
  {1, 9},
  {9, 10},
  {1, 3},
  {8, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {8, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {3, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {3, 10},
  {7, 7},
  {5, 10},
  {1, 3},
  {6, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {11, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {7, 4},
  {1, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {6, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {44, 5},
  {160, 0},
  {160, 0},
  {47, 5},
  {1, 1},
  {5, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 3},
  {10, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {6, 3},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 12},
  {1, 4},
  {4, 3},
  {1, 12},
  {1, 4},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {9, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {10, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {5, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {8, 7},
  {1, 9},
  {8, 10},
  {1, 8},
  {1, 10},
  {1, 8},
  {1, 10},
  {1, 8},
  {2, 10},
  {1, 7},
  {6, 10},
  {1, 8},
  {1, 10},
  {1, 8},
  {5, 10},
  {1, 8},
  {1, 9},
  {3, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {2, 10},
  {1, 8},
  {1, 10},
  {1, 8},
  {2, 10},
  {8, 7},
  {6, 10},
  {1, 7},
  {13, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {6, 10},
  {1, 3},
  {3, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {3, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {10, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {37, 5},
  {160, 0},
  {160, 0},
  {39, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {11, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {13, 3},
  {1, 5},
  {1, 12},
  {2, 3},
  {2, 4},
  {11, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {2, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {7, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {8, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {11, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {6, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {9, 10},
  {10, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {8, 3},
  {1, 8},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {8, 4},
  {1, 5},
  {4, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {5, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {47, 5},
  {160, 0},
  {160, 0},
  {35, 5},
  {1, 1},
  {8, 5},
  {1, 1},
  {8, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {5, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {8, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {5, 3},
  {1, 12},
  {1, 4},
  {6, 3},
  {1, 8},
  {1, 5},
  {6, 3},
  {1, 8},
  {1, 4},
  {2, 3},
  {1, 8},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {3, 10},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {5, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {4, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {8, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {7, 10},
  {1, 3},
  {2, 10},
  {4, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 8},
  {2, 4},
  {7, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {5, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {9, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {38, 5},
  {160, 0},
  {160, 0},
  {39, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {2, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {5, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {11, 3},
  {1, 8},
  {7, 3},
  {1, 8},
  {3, 3},
  {1, 4},
  {1, 12},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 7},
  {9, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 8},
  {7, 10},
  {1, 9},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {9, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 7},
  {8, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {4, 10},
  {1, 7},
  {14, 10},
  {1, 3},
  {9, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {8, 7},
  {1, 10},
  {4, 7},
  {1, 8},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {9, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {7, 4},
  {1, 5},
  {6, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {6, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {37, 5},
  {160, 0},
  {160, 0},
  {37, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {7, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 12},
  {1, 5},
  {3, 3},
  {1, 8},
  {1, 4},
  {15, 3},
  {1, 8},
  {3, 3},
  {1, 10},
  {1, 3},
  {7, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {5, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {8, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {11, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {6, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {7, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {8, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {12, 5},
  {1, 1},
  {35, 5},
  {160, 0},
  {160, 0},
  {40, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {2, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {6, 3},
  {1, 8},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {6, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 8},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {6, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 1},
  {6, 4},
  {1, 5},
  {21, 4},
  {7, 1},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {33, 5},
  {160, 0},
  {160, 0},
  {37, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {11, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 8},
  {6, 3},
  {1, 8},
  {1, 4},
  {5, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {4, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {9, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {4, 9},
  {1, 10},
  {2, 9},
  {3, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 8},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 10},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 1},
  {11, 4},
  {1, 5},
  {6, 4},
  {1, 5},
  {6, 4},
  {11, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {38, 5},
  {160, 0},
  {160, 0},
  {40, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {8, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 12},
  {7, 3},
  {1, 8},
  {2, 3},
  {1, 7},
  {2, 3},
  {3, 7},
  {1, 3},
  {8, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {15, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {3, 9},
  {1, 8},
  {4, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {2, 9},
  {4, 10},
  {5, 9},
  {1, 10},
  {17, 9},
  {1, 10},
  {15, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 8},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {2, 3},
  {3, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {11, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {9, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {33, 5},
  {160, 0},
  {160, 0},
  {31, 5},
  {1, 1},
  {6, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {12, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {8, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {5, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 9},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {3, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {8, 9},
  {1, 10},
  {6, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {3, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {10, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {5, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 1},
  {2, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {7, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {5, 4},
  {10, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {31, 5},
  {160, 0},
  {160, 0},
  {38, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 4},
  {5, 5},
  {2, 1},
  {3, 5},
  {3, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {6, 4},
  {1, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {13, 3},
  {5, 7},
  {3, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {6, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {7, 9},
  {1, 7},
  {8, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {19, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {12, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 4},
  {2, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {34, 5},
  {160, 0},
  {160, 0},
  {27, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {8, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {11, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {10, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {6, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {2, 10},
  {1, 8},
  {1, 10},
  {1, 7},
  {9, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {4, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {6, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {17, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {11, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {7, 4},
  {1, 5},
  {8, 4},
  {9, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {36, 5},
  {160, 0},
  {160, 0},
  {24, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {6, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 9},
  {4, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {3, 10},
  {1, 3},
  {21, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {3, 9},
  {1, 7},
  {2, 9},
  {7, 8},
  {6, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {13, 8},
  {1, 2},
  {13, 8},
  {1, 9},
  {1, 8},
  {8, 7},
  {7, 9},
  {4, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {5, 9},
  {3, 10},
  {5, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {7, 4},
  {1, 5},
  {9, 4},
  {1, 5},
  {2, 4},
  {18, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {33, 5},
  {160, 0},
  {160, 0},
  {32, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {7, 3},
  {1, 9},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {8, 10},
  {1, 8},
  {3, 10},
  {1, 9},
  {10, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {7, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 9},
  {7, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {4, 9},
  {4, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {12, 10},
  {3, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 1},
  {8, 4},
  {1, 5},
  {11, 4},
  {22, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {35, 5},
  {160, 0},
  {160, 0},
  {25, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {4, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {4, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {10, 9},
  {1, 2},
  {11, 8},
  {1, 6},
  {8, 8},
  {1, 2},
  {4, 8},
  {1, 6},
  {3, 8},
  {1, 7},
  {4, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {4, 8},
  {7, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {5, 10},
  {5, 7},
  {2, 3},
  {1, 7},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {5, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {3, 1},
  {1, 4},
  {1, 1},
  {7, 4},
  {1, 5},
  {6, 4},
  {18, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {32, 5},
  {160, 0},
  {160, 0},
  {32, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {6, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 8},
  {8, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {7, 9},
  {1, 10},
  {3, 9},
  {7, 8},
  {8, 9},
  {4, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {3, 8},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {8, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {2, 4},
  {3, 3},
  {3, 4},
  {2, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {12, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {4, 4},
  {19, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {29, 5},
  {160, 0},
  {160, 0},
  {25, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {8, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {9, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 9},
  {2, 7},
  {1, 8},
  {2, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {7, 10},
  {1, 8},
  {3, 10},
  {1, 8},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {2, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 2},
  {2, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 6},
  {3, 8},
  {1, 6},
  {12, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 10},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 10},
  {3, 9},
  {1, 10},
  {7, 9},
  {1, 10},
  {4, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 4},
  {7, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {3, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {3, 4},
  {2, 1},
  {4, 4},
  {1, 5},
  {11, 4},
  {20, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 4},
  {28, 5},
  {160, 0},
  {160, 0},
  {27, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 7},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {10, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {4, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {2, 9},
  {1, 7},
  {1, 8},
  {4, 9},
  {4, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {3, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {3, 9},
  {4, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 7},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {3, 4},
  {1, 1},
  {9, 4},
  {1, 5},
  {7, 4},
  {17, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {4, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {27, 5},
  {160, 0},
  {160, 0},
  {24, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {5, 5},
  {6, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 3},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 2},
  {3, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {3, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {2, 8},
  {3, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {2, 12},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 12},
  {1, 8},
  {1, 6},
  {5, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {7, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {6, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {4, 9},
  {1, 10},
  {7, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 3},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {2, 4},
  {1, 7},
  {10, 4},
  {1, 5},
  {8, 4},
  {1, 1},
  {1, 7},
  {17, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 5},
  {5, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {27, 5},
  {160, 0},
  {160, 0},
  {26, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {7, 4},
  {1, 3},
  {5, 4},
  {1, 5},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {8, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 8},
  {1, 7},
  {5, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {12, 9},
  {5, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {11, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {3, 8},
  {1, 6},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {7, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {10, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {10, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 8},
  {1, 7},
  {2, 10},
  {1, 8},
  {5, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {2, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {5, 4},
  {3, 1},
  {1, 4},
  {17, 1},
  {1, 5},
  {1, 4},
  {9, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {30, 5},
  {160, 0},
  {160, 0},
  {23, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {12, 4},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 8},
  {2, 7},
  {2, 10},
  {1, 9},
  {9, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {7, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {6, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 1},
  {1, 7},
  {18, 1},
  {1, 5},
  {8, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {32, 5},
  {160, 0},
  {160, 0},
  {25, 5},
  {1, 1},
  {5, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {8, 4},
  {1, 5},
  {7, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 8},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {5, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {7, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 4},
  {5, 7},
  {3, 3},
  {1, 9},
  {4, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 7},
  {2, 1},
  {2, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {6, 4},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 4},
  {12, 1},
  {1, 5},
  {9, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {26, 5},
  {160, 0},
  {160, 0},
  {22, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {10, 4},
  {1, 3},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 7},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {5, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {3, 8},
  {1, 2},
  {9, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 12},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {6, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {2, 3},
  {1, 7},
  {6, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 4},
  {1, 1},
  {11, 4},
  {1, 1},
  {1, 4},
  {5, 1},
  {2, 4},
  {24, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {29, 5},
  {160, 0},
  {160, 0},
  {24, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {9, 4},
  {1, 5},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 8},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {7, 9},
  {1, 7},
  {3, 9},
  {7, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 9},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 8},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {4, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {3, 7},
  {4, 3},
  {1, 9},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {4, 1},
  {1, 7},
  {2, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {3, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {3, 4},
  {21, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {25, 5},
  {160, 0},
  {160, 0},
  {24, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {7, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 8},
  {6, 7},
  {1, 3},
  {2, 7},
  {1, 8},
  {3, 7},
  {1, 8},
  {3, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {8, 9},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {2, 2},
  {1, 9},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {3, 10},
  {2, 7},
  {1, 10},
  {4, 7},
  {1, 4},
  {3, 7},
  {1, 3},
  {1, 9},
  {6, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 5},
  {1, 15},
  {4, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {3, 4},
  {1, 1},
  {3, 4},
  {15, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {19, 5},
  {160, 0},
  {160, 0},
  {31, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {17, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {5, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {3, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 10},
  {7, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {4, 9},
  {1, 10},
  {9, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {5, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {1, 8},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 7},
  {3, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 1},
  {3, 4},
  {2, 1},
  {4, 4},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 7},
  {1, 1},
  {5, 4},
  {17, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {20, 5},
  {160, 0},
  {160, 0},
  {19, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {9, 4},
  {2, 3},
  {9, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 3},
  {1, 8},
  {2, 7},
  {1, 8},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {9, 9},
  {1, 6},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 7},
  {8, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 8},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 4},
  {3, 3},
  {1, 7},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 1},
  {1, 7},
  {3, 1},
  {1, 7},
  {1, 1},
  {4, 4},
  {1, 1},
  {7, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {3, 4},
  {21, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {18, 5},
  {160, 0},
  {160, 0},
  {21, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {4, 7},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 3},
  {1, 9},
  {3, 7},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {8, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {6, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {17, 7},
  {1, 9},
  {2, 7},
  {2, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {12, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {2, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {21, 5},
  {160, 0},
  {160, 0},
  {15, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {6, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {3, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {2, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {9, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {17, 7},
  {1, 9},
  {2, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 9},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 4},
  {1, 1},
  {1, 7},
  {5, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {7, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {5, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {5, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {18, 5},
  {160, 0},
  {160, 0},
  {20, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {2, 1},
  {4, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 7},
  {1, 3},
  {7, 7},
  {5, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 3},
  {2, 9},
  {2, 10},
  {1, 8},
  {1, 7},
  {1, 9},
  {2, 10},
  {5, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {7, 9},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {12, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {13, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {3, 2},
  {2, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {18, 7},
  {2, 9},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {7, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {8, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {2, 1},
  {3, 4},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {2, 5},
  {1, 1},
  {8, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {11, 5},
  {160, 0},
  {160, 0},
  {17, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {4, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {4, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 10},
  {2, 7},
  {2, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {3, 9},
  {2, 10},
  {1, 8},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {5, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {4, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {7, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {16, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {1, 9},
  {4, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 7},
  {3, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {3, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {17, 5},
  {160, 0},
  {160, 0},
  {22, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {4, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {5, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 4},
  {3, 3},
  {2, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 3},
  {1, 7},
  {2, 10},
  {2, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {17, 7},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 8},
  {2, 3},
  {5, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {2, 3},
  {2, 4},
  {3, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {11, 5},
  {160, 0},
  {160, 0},
  {15, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {11, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {6, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 5},
  {1, 15},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {3, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 3},
  {2, 10},
  {2, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {7, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {7, 9},
  {1, 10},
  {12, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 9},
  {6, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {4, 4},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {5, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {10, 5},
  {160, 0},
  {160, 0},
  {22, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 1},
  {5, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {8, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {7, 9},
  {1, 7},
  {5, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {3, 9},
  {8, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {4, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {8, 3},
  {3, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {12, 5},
  {160, 0},
  {160, 0},
  {16, 5},
  {1, 1},
  {3, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 5},
  {12, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {12, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {4, 4},
  {6, 3},
  {1, 7},
  {2, 3},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {4, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {5, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {4, 9},
  {1, 8},
  {5, 9},
  {1, 8},
  {3, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 2},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 2},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {2, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {11, 7},
  {1, 9},
  {8, 7},
  {1, 9},
  {1, 3},
  {3, 9},
  {1, 3},
  {1, 8},
  {1, 9},
  {1, 3},
  {4, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {22, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {3, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {9, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {15, 5},
  {160, 0},
  {160, 0},
  {12, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {15, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 9},
  {6, 3},
  {1, 7},
  {1, 10},
  {9, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 10},
  {5, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {4, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {11, 7},
  {1, 3},
  {1, 9},
  {7, 7},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 4},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {6, 4},
  {1, 1},
  {17, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {1, 4},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {11, 5},
  {160, 0},
  {160, 0},
  {13, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {16, 1},
  {1, 5},
  {3, 4},
  {1, 3},
  {6, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {2, 3},
  {1, 4},
  {1, 8},
  {6, 3},
  {1, 7},
  {7, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {1, 10},
  {7, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 9},
  {7, 8},
  {2, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 12},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {2, 8},
  {3, 9},
  {1, 7},
  {2, 9},
  {3, 7},
  {3, 10},
  {4, 9},
  {14, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 4},
  {5, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {12, 4},
  {1, 5},
  {10, 4},
  {1, 5},
  {1, 4},
  {9, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {9, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {15, 1},
  {10, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 7},
  {4, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 10},
  {2, 9},
  {1, 8},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {6, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 9},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {7, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 8},
  {1, 3},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 1},
  {1, 7},
  {2, 1},
  {12, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {11, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {15, 1},
  {1, 5},
  {8, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {9, 3},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {6, 10},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {2, 10},
  {2, 7},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {4, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {3, 9},
  {2, 10},
  {4, 9},
  {1, 8},
  {3, 9},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {4, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {8, 9},
  {1, 7},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {11, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {2, 7},
  {1, 3},
  {1, 8},
  {1, 10},
  {2, 7},
  {1, 4},
  {7, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {3, 1},
  {3, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {9, 5},
  {160, 0},
  {160, 0},
  {8, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {11, 1},
  {6, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 9},
  {4, 3},
  {1, 8},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 8},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {4, 9},
  {1, 8},
  {4, 9},
  {1, 10},
  {1, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {10, 7},
  {1, 9},
  {2, 7},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 1},
  {1, 15},
  {1, 5},
  {1, 1},
  {2, 4},
  {3, 3},
  {11, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {160, 0},
  {160, 0},
  {10, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {13, 1},
  {1, 5},
  {7, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {11, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {2, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {8, 9},
  {1, 10},
  {5, 9},
  {1, 7},
  {4, 9},
  {5, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {8, 2},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {10, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 9},
  {7, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {5, 1},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {4, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {7, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {2, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 1},
  {1, 5},
  {16, 1},
  {7, 4},
  {1, 3},
  {5, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 15},
  {1, 5},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 4},
  {4, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 8},
  {2, 7},
  {1, 9},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 9},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {5, 2},
  {7, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {7, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 2},
  {3, 6},
  {1, 8},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {6, 9},
  {1, 10},
  {2, 9},
  {2, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 3},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {11, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 9},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {4, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {3, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {5, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {8, 5},
  {160, 0},
  {160, 0},
  {8, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {16, 1},
  {1, 4},
  {1, 1},
  {6, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {3, 4},
  {1, 5},
  {1, 4},
  {9, 3},
  {1, 9},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {9, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {10, 6},
  {1, 12},
  {11, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 8},
  {3, 9},
  {21, 7},
  {1, 9},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 4},
  {1, 7},
  {3, 4},
  {1, 1},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 5},
  {7, 4},
  {11, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {12, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {9, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {3, 4},
  {1, 3},
  {9, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {7, 3},
  {1, 9},
  {1, 4},
  {1, 9},
  {4, 3},
  {2, 7},
  {1, 3},
  {5, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 8},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 7},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 12},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 3},
  {6, 7},
  {2, 9},
  {14, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 1},
  {1, 4},
  {18, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {5, 5},
  {160, 0},
  {160, 0},
  {7, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {12, 1},
  {4, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 15},
  {9, 3},
  {4, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {7, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {5, 6},
  {1, 12},
  {5, 6},
  {1, 11},
  {1, 12},
  {6, 6},
  {1, 12},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 9},
  {1, 7},
  {11, 9},
  {7, 7},
  {3, 9},
  {7, 7},
  {1, 9},
  {4, 7},
  {1, 9},
  {1, 4},
  {6, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 1},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {2, 4},
  {10, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {11, 5},
  {1, 1},
  {3, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {12, 1},
  {7, 4},
  {3, 3},
  {5, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 3},
  {1, 8},
  {1, 4},
  {1, 9},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {4, 7},
  {1, 9},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 8},
  {1, 7},
  {6, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 16},
  {1, 2},
  {5, 6},
  {1, 2},
  {1, 11},
  {7, 6},
  {1, 12},
  {1, 16},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {2, 9},
  {7, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {5, 7},
  {1, 8},
  {3, 7},
  {1, 9},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {2, 4},
  {1, 1},
  {3, 4},
  {15, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {5, 5},
  {160, 0},
  {160, 0},
  {12, 5},
  {1, 1},
  {3, 5},
  {5, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {14, 1},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 8},
  {5, 3},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {7, 6},
  {1, 12},
  {7, 6},
  {1, 11},
  {1, 2},
  {1, 16},
  {1, 12},
  {5, 6},
  {1, 12},
  {2, 6},
  {1, 16},
  {4, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 8},
  {5, 9},
  {7, 7},
  {5, 9},
  {5, 7},
  {1, 9},
  {1, 10},
  {7, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {4, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {2, 3},
  {3, 4},
  {1, 1},
  {3, 4},
  {12, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {7, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {4, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 5},
  {14, 1},
  {7, 4},
  {2, 3},
  {5, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {14, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 4},
  {6, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {5, 9},
  {1, 10},
  {14, 9},
  {1, 7},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {7, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {5, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {6, 7},
  {1, 3},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {13, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {9, 5},
  {160, 0},
  {160, 0},
  {11, 5},
  {1, 1},
  {4, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {3, 1},
  {1, 5},
  {13, 1},
  {4, 4},
  {1, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 9},
  {10, 3},
  {1, 4},
  {8, 7},
  {1, 9},
  {1, 10},
  {3, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {7, 6},
  {1, 2},
  {6, 6},
  {1, 16},
  {1, 6},
  {1, 8},
  {1, 16},
  {8, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {3, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {11, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {8, 4},
  {16, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {6, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {8, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {19, 1},
  {5, 4},
  {1, 3},
  {7, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 9},
  {2, 3},
  {1, 7},
  {1, 9},
  {1, 3},
  {5, 9},
  {1, 3},
  {2, 9},
  {1, 3},
  {6, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {5, 9},
  {1, 10},
  {4, 9},
  {1, 8},
  {1, 7},
  {4, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {8, 6},
  {1, 12},
  {6, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {12, 6},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {9, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {18, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {9, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {4, 8},
  {1, 2},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {22, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {3, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {3, 4},
  {20, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {8, 5},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {6, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {16, 1},
  {6, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 9},
  {2, 3},
  {1, 9},
  {7, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 10},
  {7, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {5, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {13, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {4, 8},
  {1, 2},
  {5, 8},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {11, 9},
  {13, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {6, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {9, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {7, 4},
  {11, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {5, 5},
  {1, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {1, 4},
  {18, 1},
  {2, 4},
  {1, 1},
  {13, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {2, 10},
  {3, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {9, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {6, 9},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {7, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {12, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 16},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {10, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {14, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 9},
  {3, 7},
  {1, 9},
  {5, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {8, 4},
  {1, 1},
  {5, 4},
  {1, 1},
  {5, 4},
  {11, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {8, 5},
  {160, 0},
  {160, 0},
  {2, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 4},
  {13, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {4, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 8},
  {4, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {2, 10},
  {2, 7},
  {1, 9},
  {9, 7},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 6},
  {1, 12},
  {1, 16},
  {3, 6},
  {1, 8},
  {1, 16},
  {3, 6},
  {1, 16},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {7, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {7, 6},
  {1, 8},
  {1, 16},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 6},
  {1, 12},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {8, 6},
  {1, 11},
  {1, 2},
  {9, 6},
  {1, 12},
  {1, 16},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {9, 8},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {5, 7},
  {1, 9},
  {5, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {10, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {4, 4},
  {2, 1},
  {9, 4},
  {1, 1},
  {2, 4},
  {11, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {8, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {19, 1},
  {1, 4},
  {2, 1},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {4, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {4, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {2, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 16},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 16},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 8},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {7, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {5, 7},
  {2, 9},
  {4, 7},
  {1, 9},
  {8, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {7, 4},
  {12, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {7, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {17, 1},
  {1, 7},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 9},
  {1, 3},
  {1, 9},
  {4, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {6, 7},
  {3, 9},
  {1, 10},
  {7, 9},
  {1, 7},
  {1, 8},
  {3, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 8},
  {3, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {4, 6},
  {1, 16},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {5, 6},
  {1, 2},
  {14, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {5, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 9},
  {1, 15},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {6, 8},
  {1, 2},
  {2, 8},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {5, 9},
  {5, 7},
  {3, 9},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {6, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {3, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {7, 4},
  {12, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {8, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 1},
  {1, 5},
  {18, 1},
  {6, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 15},
  {1, 5},
  {1, 9},
  {1, 4},
  {3, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {3, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 7},
  {3, 10},
  {5, 7},
  {4, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 7},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {12, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {6, 4},
  {2, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {6, 4},
  {13, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {9, 5},
  {160, 0},
  {160, 0},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 1},
  {1, 4},
  {18, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 9},
  {1, 4},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 9},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 10},
  {2, 7},
  {6, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {2, 8},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {14, 6},
  {1, 8},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {4, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {6, 6},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {4, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 12},
  {4, 6},
  {1, 12},
  {11, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {6, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {9, 7},
  {1, 1},
  {3, 7},
  {1, 4},
  {6, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 4},
  {1, 5},
  {1, 15},
  {2, 4},
  {1, 5},
  {1, 15},
  {1, 4},
  {1, 5},
  {1, 15},
  {7, 4},
  {1, 1},
  {6, 4},
  {12, 1},
  {2, 4},
  {6, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {6, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {3, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {14, 1},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {4, 7},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {4, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {7, 6},
  {1, 11},
  {7, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 16},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 2},
  {4, 11},
  {1, 6},
  {4, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {3, 6},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {3, 6},
  {2, 2},
  {3, 6},
  {1, 2},
  {9, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {9, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {11, 9},
  {1, 7},
  {1, 9},
  {12, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {3, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 3},
  {2, 4},
  {1, 7},
  {11, 4},
  {6, 1},
  {1, 4},
  {4, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {7, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {4, 5},
  {1, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {16, 1},
  {1, 5},
  {2, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {9, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 10},
  {1, 9},
  {5, 10},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {14, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {3, 11},
  {1, 2},
  {1, 16},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {9, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 16},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {9, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 2},
  {1, 9},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {3, 2},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {11, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {4, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {5, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {9, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {3, 1},
  {3, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {2, 5},
  {1, 1},
  {4, 5},
  {5, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {10, 1},
  {1, 7},
  {4, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 9},
  {2, 7},
  {1, 3},
  {3, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {2, 7},
  {1, 8},
  {2, 7},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 8},
  {7, 6},
  {1, 11},
  {7, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 16},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 8},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {9, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {8, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {15, 9},
  {10, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {6, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {4, 4},
  {1, 7},
  {2, 4},
  {3, 3},
  {5, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {1, 1},
  {1, 15},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {10, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {160, 0},
  {160, 0},
  {9, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {12, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 9},
  {1, 4},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {4, 9},
  {2, 8},
  {1, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {5, 6},
  {1, 16},
  {1, 8},
  {1, 16},
  {2, 6},
  {1, 8},
  {1, 16},
  {2, 6},
  {1, 12},
  {6, 6},
  {2, 11},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 13},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {4, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {4, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 16},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 6},
  {3, 2},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 15},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 7},
  {1, 15},
  {7, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {14, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {4, 4},
  {1, 9},
  {2, 4},
  {3, 3},
  {2, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {2, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {12, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {2, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {11, 1},
  {7, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {3, 6},
  {1, 8},
  {3, 6},
  {1, 8},
  {2, 6},
  {1, 16},
  {1, 8},
  {3, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 12},
  {7, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 15},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {10, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {8, 7},
  {1, 1},
  {2, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {8, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {5, 5},
  {160, 0},
  {160, 0},
  {8, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {12, 1},
  {7, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 8},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 7},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {7, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {2, 6},
  {1, 11},
  {1, 16},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 6},
  {1, 12},
  {3, 6},
  {2, 2},
  {3, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {2, 9},
  {1, 7},
  {1, 15},
  {4, 9},
  {1, 7},
  {12, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {8, 9},
  {12, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {4, 7},
  {4, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 1},
  {1, 4},
  {20, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {3, 1},
  {2, 4},
  {2, 1},
  {1, 4},
  {10, 1},
  {1, 4},
  {1, 1},
  {7, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {5, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {4, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {6, 6},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 8},
  {2, 2},
  {1, 11},
  {2, 6},
  {1, 8},
  {2, 6},
  {1, 16},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {9, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {3, 9},
  {2, 7},
  {5, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {10, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {7, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {11, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {4, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {12, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {4, 3},
  {1, 4},
  {1, 9},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {4, 7},
  {1, 9},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {2, 10},
  {1, 7},
  {1, 9},
  {5, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {8, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {3, 11},
  {1, 12},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 13},
  {2, 6},
  {1, 13},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 11},
  {2, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 6},
  {1, 11},
  {14, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 7},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {12, 7},
  {1, 4},
  {2, 7},
  {1, 9},
  {1, 4},
  {2, 7},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {16, 4},
  {1, 1},
  {1, 4},
  {3, 1},
  {1, 7},
  {24, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {15, 1},
  {1, 4},
  {3, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {5, 3},
  {1, 9},
  {1, 8},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {3, 7},
  {1, 10},
  {1, 3},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 8},
  {1, 7},
  {1, 9},
  {4, 10},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {9, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 11},
  {2, 6},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {2, 11},
  {1, 13},
  {2, 11},
  {3, 13},
  {1, 6},
  {2, 13},
  {2, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 16},
  {1, 6},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {5, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 2},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {7, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {7, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {8, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {4, 7},
  {2, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 9},
  {5, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {14, 4},
  {1, 1},
  {3, 4},
  {1, 1},
  {1, 15},
  {1, 5},
  {2, 1},
  {1, 7},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {11, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {5, 1},
  {1, 4},
  {11, 1},
  {1, 4},
  {3, 1},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {3, 3},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 3},
  {1, 8},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {11, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 12},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 6},
  {1, 11},
  {3, 6},
  {2, 11},
  {1, 6},
  {3, 11},
  {1, 16},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {18, 13},
  {1, 11},
  {15, 13},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 16},
  {1, 6},
  {1, 13},
  {2, 11},
  {1, 13},
  {1, 6},
  {4, 11},
  {1, 6},
  {5, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {9, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 15},
  {3, 4},
  {1, 5},
  {1, 15},
  {1, 1},
  {3, 4},
  {4, 1},
  {2, 4},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 4},
  {2, 1},
  {5, 4},
  {16, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {15, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 5},
  {7, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 9},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {7, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {3, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {4, 11},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 11},
  {5, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {14, 13},
  {2, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {4, 9},
  {1, 8},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {5, 9},
  {1, 7},
  {8, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 1},
  {7, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 5},
  {2, 4},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 1},
  {1, 15},
  {1, 5},
  {1, 1},
  {1, 15},
  {1, 5},
  {2, 1},
  {1, 15},
  {1, 5},
  {3, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {2, 1},
  {1, 4},
  {13, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {15, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 9},
  {3, 7},
  {2, 10},
  {4, 7},
  {1, 10},
  {2, 7},
  {3, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 8},
  {4, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {9, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 16},
  {2, 6},
  {1, 12},
  {6, 6},
  {1, 2},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {6, 11},
  {1, 6},
  {8, 13},
  {1, 16},
  {2, 13},
  {1, 16},
  {4, 13},
  {1, 18},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 16},
  {3, 13},
  {1, 16},
  {8, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {3, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {4, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {4, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {3, 9},
  {8, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 4},
  {3, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {1, 5},
  {1, 15},
  {3, 1},
  {1, 4},
  {5, 5},
  {2, 1},
  {2, 5},
  {2, 1},
  {1, 4},
  {1, 1},
  {9, 4},
  {16, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {16, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {2, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {7, 11},
  {6, 13},
  {1, 11},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 13},
  {4, 14},
  {1, 16},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {8, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 13},
  {1, 11},
  {1, 6},
  {4, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 16},
  {1, 8},
  {5, 6},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 8},
  {2, 9},
  {1, 8},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {11, 7},
  {1, 1},
  {3, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 15},
  {1, 5},
  {2, 1},
  {1, 4},
  {3, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 1},
  {8, 4},
  {13, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {14, 1},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {4, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {2, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {2, 10},
  {4, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {6, 11},
  {1, 2},
  {3, 11},
  {5, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {2, 14},
  {1, 16},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {3, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {7, 13},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 13},
  {3, 11},
  {1, 2},
  {8, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 11},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {5, 9},
  {8, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 1},
  {3, 5},
  {1, 15},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {2, 4},
  {1, 1},
  {2, 5},
  {2, 1},
  {4, 4},
  {1, 1},
  {3, 4},
  {14, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {14, 1},
  {4, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {8, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {3, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {2, 10},
  {4, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {4, 6},
  {1, 8},
  {2, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 2},
  {2, 11},
  {6, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {4, 14},
  {1, 13},
  {2, 14},
  {1, 16},
  {5, 14},
  {1, 16},
  {4, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 13},
  {3, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {3, 14},
  {1, 13},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {4, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {2, 18},
  {2, 13},
  {1, 14},
  {1, 11},
  {1, 18},
  {1, 13},
  {1, 18},
  {5, 13},
  {1, 11},
  {2, 13},
  {6, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 11},
  {4, 6},
  {1, 11},
  {6, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {9, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 9},
  {3, 8},
  {2, 9},
  {1, 2},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {11, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 5},
  {4, 4},
  {2, 5},
  {3, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {1, 4},
  {15, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {16, 1},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 3},
  {1, 5},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {7, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {3, 7},
  {1, 10},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {8, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {4, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {9, 6},
  {1, 8},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {3, 6},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 16},
  {3, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {2, 13},
  {1, 14},
  {4, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {3, 13},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 16},
  {20, 14},
  {1, 16},
  {2, 14},
  {2, 18},
  {1, 13},
  {2, 18},
  {1, 13},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {4, 13},
  {1, 11},
  {1, 2},
  {5, 11},
  {1, 13},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 12},
  {1, 6},
  {2, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 6},
  {20, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {6, 8},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {14, 7},
  {1, 4},
  {6, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 5},
  {1, 15},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {1, 7},
  {13, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {3, 4},
  {12, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {2, 1},
  {1, 5},
  {4, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {10, 1},
  {5, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {4, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {7, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {7, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {3, 13},
  {1, 6},
  {11, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 13},
  {4, 18},
  {5, 14},
  {1, 16},
  {3, 14},
  {2, 18},
  {1, 14},
  {1, 16},
  {5, 14},
  {4, 18},
  {9, 14},
  {1, 21},
  {9, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {4, 18},
  {1, 13},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 13},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 14},
  {4, 13},
  {1, 14},
  {6, 13},
  {1, 11},
  {2, 13},
  {2, 11},
  {1, 2},
  {6, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {2, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {8, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {11, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {24, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {11, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {2, 4},
  {1, 3},
  {5, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {6, 4},
  {3, 1},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 1},
  {1, 4},
  {3, 1},
  {2, 4},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {4, 1},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {3, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {12, 1},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {1, 9},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {7, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {8, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {3, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 13},
  {3, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 13},
  {3, 14},
  {1, 13},
  {4, 18},
  {13, 14},
  {1, 16},
  {13, 14},
  {1, 23},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 14},
  {1, 21},
  {4, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {7, 14},
  {3, 18},
  {4, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {3, 13},
  {1, 11},
  {4, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {8, 6},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {24, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {4, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {12, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {6, 4},
  {2, 1},
  {6, 4},
  {2, 1},
  {6, 4},
  {1, 1},
  {3, 4},
  {6, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {3, 1},
  {1, 5},
  {1, 4},
  {3, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {12, 1},
  {5, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {11, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 7},
  {5, 10},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {6, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 12},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 6},
  {1, 8},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 11},
  {2, 2},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {9, 13},
  {1, 18},
  {3, 13},
  {1, 14},
  {2, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 16},
  {3, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {4, 14},
  {1, 23},
  {1, 16},
  {4, 14},
  {1, 23},
  {2, 14},
  {1, 23},
  {3, 14},
  {4, 21},
  {1, 28},
  {1, 21},
  {4, 28},
  {1, 30},
  {7, 28},
  {3, 21},
  {1, 23},
  {2, 21},
  {1, 18},
  {2, 14},
  {3, 18},
  {2, 14},
  {2, 18},
  {1, 23},
  {2, 14},
  {1, 23},
  {10, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {12, 13},
  {1, 11},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {6, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 15},
  {1, 8},
  {8, 2},
  {1, 15},
  {1, 9},
  {4, 2},
  {1, 15},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {15, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {9, 4},
  {8, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {12, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {12, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 9},
  {4, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {5, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {2, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {5, 13},
  {1, 18},
  {3, 13},
  {1, 14},
  {2, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 16},
  {10, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 23},
  {1, 14},
  {2, 23},
  {1, 14},
  {3, 28},
  {3, 31},
  {1, 20},
  {1, 31},
  {1, 19},
  {2, 20},
  {9, 19},
  {1, 20},
  {2, 19},
  {8, 20},
  {3, 31},
  {1, 30},
  {1, 31},
  {3, 28},
  {1, 21},
  {1, 23},
  {1, 14},
  {1, 23},
  {7, 14},
  {1, 18},
  {6, 14},
  {1, 16},
  {4, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 11},
  {4, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {6, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 8},
  {1, 11},
  {3, 6},
  {1, 8},
  {4, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 15},
  {2, 2},
  {1, 9},
  {1, 15},
  {2, 2},
  {1, 9},
  {5, 2},
  {2, 9},
  {3, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {5, 9},
  {9, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {7, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {1, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {12, 4},
  {8, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {2, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {3, 1},
  {1, 5},
  {3, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {12, 1},
  {1, 4},
  {1, 5},
  {1, 3},
  {5, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 4},
  {3, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {4, 10},
  {1, 3},
  {1, 7},
  {2, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 9},
  {7, 7},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 16},
  {1, 12},
  {5, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 6},
  {4, 11},
  {1, 2},
  {8, 11},
  {1, 6},
  {6, 13},
  {2, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {11, 14},
  {1, 23},
  {1, 14},
  {1, 23},
  {1, 21},
  {1, 28},
  {1, 30},
  {2, 31},
  {2, 20},
  {38, 19},
  {3, 20},
  {2, 31},
  {1, 30},
  {2, 28},
  {1, 14},
  {1, 23},
  {1, 18},
  {1, 14},
  {1, 21},
  {8, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 14},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {12, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {6, 11},
  {4, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {13, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {12, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {4, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {3, 5},
  {1, 1},
  {4, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {11, 4},
  {7, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 4},
  {2, 1},
  {1, 4},
  {10, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {5, 4},
  {5, 3},
  {1, 9},
  {4, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 10},
  {9, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {3, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {3, 6},
  {1, 12},
  {1, 2},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {7, 11},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {5, 14},
  {1, 16},
  {6, 14},
  {1, 23},
  {1, 21},
  {1, 23},
  {1, 21},
  {1, 28},
  {2, 31},
  {2, 20},
  {15, 19},
  {4, 20},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 17},
  {1, 31},
  {1, 17},
  {1, 31},
  {1, 29},
  {1, 31},
  {1, 17},
  {1, 29},
  {2, 17},
  {4, 20},
  {1, 17},
  {14, 19},
  {1, 20},
  {2, 31},
  {2, 28},
  {2, 21},
  {1, 18},
  {1, 23},
  {8, 14},
  {1, 16},
  {4, 14},
  {1, 16},
  {3, 14},
  {2, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {2, 13},
  {1, 11},
  {6, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {10, 6},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {10, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 15},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {6, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {9, 7},
  {1, 1},
  {5, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {5, 4},
  {1, 1},
  {4, 4},
  {6, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {3, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {14, 1},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 4},
  {2, 3},
  {1, 9},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {5, 7},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {4, 2},
  {1, 11},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {9, 6},
  {2, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {5, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {4, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 14},
  {1, 16},
  {5, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {3, 14},
  {1, 23},
  {1, 16},
  {3, 23},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 20},
  {11, 19},
  {2, 20},
  {1, 17},
  {4, 29},
  {1, 27},
  {1, 30},
  {1, 27},
  {1, 31},
  {1, 27},
  {1, 32},
  {2, 27},
  {1, 26},
  {2, 27},
  {1, 26},
  {1, 27},
  {1, 26},
  {9, 27},
  {1, 29},
  {1, 27},
  {1, 29},
  {1, 25},
  {1, 27},
  {3, 29},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 20},
  {10, 19},
  {1, 20},
  {2, 31},
  {2, 28},
  {2, 21},
  {2, 14},
  {1, 23},
  {1, 16},
  {1, 23},
  {1, 16},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {4, 13},
  {3, 11},
  {4, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {3, 2},
  {3, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {4, 6},
  {11, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {15, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {3, 9},
  {1, 7},
  {11, 9},
  {2, 7},
  {1, 9},
  {7, 7},
  {1, 1},
  {5, 7},
  {1, 4},
  {4, 7},
  {1, 1},
  {2, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 1},
  {4, 4},
  {1, 1},
  {3, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 1},
  {2, 4},
  {15, 1},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {15, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {3, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 9},
  {4, 3},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {4, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {2, 9},
  {8, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {7, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 11},
  {8, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {6, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 16},
  {3, 18},
  {1, 14},
  {2, 18},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {5, 14},
  {1, 21},
  {1, 28},
  {2, 31},
  {1, 20},
  {8, 19},
  {3, 20},
  {1, 31},
  {2, 29},
  {6, 27},
  {1, 26},
  {2, 27},
  {2, 26},
  {1, 32},
  {1, 26},
  {1, 32},
  {21, 26},
  {1, 27},
  {1, 26},
  {1, 27},
  {1, 26},
  {4, 27},
  {3, 29},
  {1, 17},
  {2, 20},
  {8, 19},
  {2, 20},
  {1, 31},
  {1, 30},
  {1, 28},
  {1, 23},
  {2, 14},
  {1, 23},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {5, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {4, 13},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {2, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {8, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 9},
  {1, 11},
  {14, 2},
  {1, 11},
  {5, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {6, 9},
  {5, 7},
  {1, 1},
  {5, 7},
  {1, 1},
  {10, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {7, 4},
  {17, 1},
  {160, 0},
  {160, 0},
  {18, 1},
  {2, 4},
  {1, 1},
  {3, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {6, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 8},
  {1, 7},
  {4, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {8, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 6},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {5, 11},
  {1, 6},
  {4, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 11},
  {8, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 14},
  {1, 32},
  {1, 30},
  {1, 31},
  {1, 20},
  {7, 19},
  {2, 20},
  {2, 29},
  {3, 27},
  {1, 22},
  {1, 32},
  {1, 27},
  {4, 32},
  {3, 26},
  {2, 32},
  {1, 23},
  {1, 32},
  {1, 23},
  {1, 32},
  {1, 23},
  {1, 32},
  {1, 23},
  {1, 28},
  {1, 23},
  {2, 32},
  {6, 23},
  {1, 21},
  {1, 23},
  {1, 14},
  {2, 23},
  {1, 32},
  {1, 23},
  {3, 32},
  {1, 26},
  {1, 32},
  {4, 26},
  {1, 27},
  {2, 26},
  {2, 27},
  {1, 26},
  {3, 27},
  {1, 29},
  {1, 31},
  {2, 20},
  {8, 19},
  {2, 31},
  {1, 30},
  {1, 28},
  {1, 21},
  {2, 18},
  {2, 14},
  {2, 18},
  {1, 13},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 13},
  {2, 18},
  {8, 13},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {7, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {7, 2},
  {1, 15},
  {1, 9},
  {5, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {6, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {3, 4},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 15},
  {1, 5},
  {1, 1},
  {2, 4},
  {2, 1},
  {4, 4},
  {1, 1},
  {4, 4},
  {15, 1},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {9, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 5},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {7, 3},
  {1, 4},
  {2, 9},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 2},
  {4, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 15},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {6, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {3, 6},
  {1, 2},
  {2, 11},
  {1, 13},
  {1, 6},
  {6, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {4, 14},
  {3, 18},
  {4, 14},
  {1, 23},
  {1, 21},
  {2, 31},
  {1, 20},
  {6, 19},
  {2, 20},
  {1, 31},
  {1, 29},
  {5, 27},
  {5, 26},
  {1, 32},
  {1, 26},
  {1, 32},
  {3, 23},
  {1, 14},
  {1, 23},
  {2, 21},
  {1, 23},
  {1, 14},
  {1, 23},
  {1, 14},
  {1, 21},
  {1, 14},
  {1, 21},
  {1, 11},
  {5, 18},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {4, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 23},
  {1, 14},
  {1, 21},
  {1, 32},
  {2, 23},
  {1, 32},
  {5, 26},
  {1, 22},
  {2, 26},
  {1, 27},
  {1, 22},
  {2, 27},
  {2, 29},
  {1, 17},
  {2, 20},
  {7, 19},
  {1, 31},
  {1, 30},
  {1, 28},
  {1, 21},
  {2, 18},
  {4, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {6, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 16},
  {8, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 9},
  {1, 11},
  {3, 2},
  {1, 9},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 15},
  {9, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {12, 9},
  {1, 7},
  {2, 9},
  {14, 7},
  {1, 4},
  {5, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {3, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 9},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {2, 4},
  {1, 5},
  {1, 15},
  {4, 1},
  {1, 5},
  {4, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {5, 4},
  {17, 1},
  {160, 0},
  {160, 0},
  {2, 1},
  {1, 5},
  {13, 1},
  {9, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 4},
  {1, 8},
  {1, 4},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 6},
  {4, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 31},
  {1, 20},
  {6, 19},
  {2, 20},
  {2, 29},
  {4, 27},
  {3, 26},
  {1, 32},
  {1, 26},
  {4, 23},
  {1, 14},
  {1, 23},
  {6, 14},
  {1, 21},
  {3, 18},
  {1, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 11},
  {1, 18},
  {2, 11},
  {6, 13},
  {1, 18},
  {1, 13},
  {9, 18},
  {1, 21},
  {1, 14},
  {1, 23},
  {1, 18},
  {5, 23},
  {1, 32},
  {1, 26},
  {1, 23},
  {4, 26},
  {1, 32},
  {3, 27},
  {2, 29},
  {2, 20},
  {5, 19},
  {1, 20},
  {1, 31},
  {1, 30},
  {1, 28},
  {2, 18},
  {3, 14},
  {1, 16},
  {4, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {3, 13},
  {1, 14},
  {6, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 8},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 9},
  {6, 2},
  {1, 15},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {11, 7},
  {1, 1},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {2, 4},
  {1, 5},
  {2, 1},
  {1, 7},
  {3, 1},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 1},
  {6, 4},
  {1, 1},
  {1, 4},
  {13, 1},
  {1, 5},
  {4, 1},
  {160, 0},
  {160, 0},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {10, 1},
  {8, 4},
  {2, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {3, 3},
  {1, 4},
  {1, 8},
  {4, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {4, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {11, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {9, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {2, 13},
  {1, 18},
  {3, 13},
  {1, 16},
  {2, 18},
  {1, 16},
  {4, 14},
  {1, 16},
  {4, 14},
  {2, 21},
  {1, 28},
  {2, 31},
  {6, 19},
  {1, 17},
  {1, 31},
  {1, 29},
  {4, 27},
  {1, 32},
  {4, 26},
  {2, 23},
  {2, 14},
  {1, 23},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 18},
  {2, 14},
  {2, 18},
  {1, 13},
  {2, 11},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 13},
  {2, 16},
  {1, 6},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 16},
  {2, 6},
  {1, 16},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {5, 14},
  {1, 23},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 23},
  {5, 26},
  {1, 27},
  {1, 26},
  {1, 27},
  {2, 29},
  {1, 17},
  {1, 20},
  {5, 19},
  {1, 20},
  {1, 31},
  {1, 30},
  {1, 28},
  {1, 18},
  {1, 23},
  {2, 14},
  {2, 18},
  {4, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {6, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {1, 12},
  {1, 16},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {1, 15},
  {11, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 15},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 15},
  {2, 7},
  {1, 1},
  {11, 7},
  {1, 4},
  {5, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {5, 1},
  {1, 7},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 1},
  {6, 4},
  {1, 1},
  {1, 4},
  {12, 1},
  {1, 5},
  {5, 1},
  {160, 0},
  {160, 0},
  {5, 1},
  {1, 5},
  {10, 1},
  {4, 4},
  {1, 5},
  {4, 4},
  {2, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {11, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 3},
  {1, 8},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 8},
  {3, 9},
  {1, 8},
  {2, 9},
  {4, 10},
  {2, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 11},
  {2, 8},
  {9, 2},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {8, 13},
  {1, 11},
  {5, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {3, 14},
  {1, 23},
  {1, 16},
  {1, 23},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 20},
  {5, 19},
  {2, 20},
  {1, 29},
  {3, 27},
  {4, 26},
  {1, 23},
  {1, 32},
  {2, 23},
  {1, 14},
  {1, 18},
  {2, 14},
  {2, 18},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {4, 2},
  {1, 6},
  {4, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {3, 18},
  {1, 13},
  {2, 18},
  {5, 21},
  {1, 18},
  {1, 21},
  {1, 18},
  {1, 21},
  {1, 14},
  {4, 18},
  {1, 11},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 13},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 18},
  {2, 16},
  {1, 14},
  {4, 23},
  {7, 26},
  {2, 27},
  {2, 29},
  {1, 20},
  {5, 19},
  {1, 20},
  {1, 31},
  {2, 28},
  {1, 18},
  {1, 14},
  {1, 21},
  {4, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 18},
  {8, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {2, 9},
  {1, 2},
  {1, 9},
  {7, 2},
  {1, 15},
  {1, 9},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 7},
  {1, 9},
  {1, 7},
  {8, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {5, 7},
  {2, 1},
  {15, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 15},
  {1, 5},
  {6, 1},
  {3, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {12, 1},
  {1, 5},
  {4, 1},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {1, 5},
  {12, 1},
  {7, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 4},
  {1, 9},
  {2, 3},
  {1, 9},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 9},
  {5, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 15},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {12, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {3, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {4, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 16},
  {2, 14},
  {3, 18},
  {5, 14},
  {1, 21},
  {1, 28},
  {1, 31},
  {1, 20},
  {5, 19},
  {1, 20},
  {1, 29},
  {3, 27},
  {3, 26},
  {1, 32},
  {5, 23},
  {1, 14},
  {1, 21},
  {1, 18},
  {1, 15},
  {2, 18},
  {2, 13},
  {4, 6},
  {1, 11},
  {1, 9},
  {2, 11},
  {2, 18},
  {1, 14},
  {2, 21},
  {2, 28},
  {1, 30},
  {1, 28},
  {1, 31},
  {1, 30},
  {5, 31},
  {2, 20},
  {1, 31},
  {2, 20},
  {1, 31},
  {2, 20},
  {5, 31},
  {1, 30},
  {1, 31},
  {1, 30},
  {3, 28},
  {2, 21},
  {1, 18},
  {5, 13},
  {1, 16},
  {1, 11},
  {3, 2},
  {3, 6},
  {1, 13},
  {4, 14},
  {2, 23},
  {1, 32},
  {5, 26},
  {3, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {5, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 23},
  {2, 14},
  {4, 18},
  {4, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {4, 13},
  {1, 11},
  {4, 13},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 9},
  {3, 2},
  {2, 9},
  {6, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {1, 15},
  {1, 1},
  {16, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 15},
  {14, 4},
  {14, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {10, 1},
  {4, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 5},
  {1, 4},
  {2, 3},
  {1, 15},
  {1, 5},
  {1, 8},
  {3, 3},
  {1, 9},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 9},
  {5, 10},
  {6, 7},
  {5, 9},
  {1, 8},
  {1, 7},
  {3, 10},
  {2, 8},
  {1, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 8},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 6},
  {1, 11},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 13},
  {2, 16},
  {2, 14},
  {3, 18},
  {1, 14},
  {1, 23},
  {1, 21},
  {1, 30},
  {1, 20},
  {5, 19},
  {1, 20},
  {1, 29},
  {2, 27},
  {4, 26},
  {4, 23},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 8},
  {3, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {2, 13},
  {1, 18},
  {1, 21},
  {3, 28},
  {1, 30},
  {3, 31},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {6, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 19},
  {3, 20},
  {1, 17},
  {1, 20},
  {2, 31},
  {2, 30},
  {2, 28},
  {1, 21},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 11},
  {2, 13},
  {1, 2},
  {2, 11},
  {3, 18},
  {2, 14},
  {1, 21},
  {3, 23},
  {4, 32},
  {1, 26},
  {2, 27},
  {1, 25},
  {1, 17},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {2, 21},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {10, 13},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {2, 11},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {5, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {13, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {12, 9},
  {1, 7},
  {10, 9},
  {4, 7},
  {1, 4},
  {4, 7},
  {1, 9},
  {13, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {2, 3},
  {1, 7},
  {2, 4},
  {1, 7},
  {3, 4},
  {4, 1},
  {1, 7},
  {1, 1},
  {1, 5},
  {1, 1},
  {14, 4},
  {12, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {11, 1},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 3},
  {1, 5},
  {1, 4},
  {3, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {6, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {5, 8},
  {1, 6},
  {4, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {3, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 11},
  {2, 13},
  {1, 18},
  {6, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {2, 14},
  {2, 21},
  {1, 31},
  {5, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {3, 27},
  {1, 32},
  {1, 26},
  {1, 32},
  {3, 23},
  {3, 14},
  {1, 16},
  {1, 13},
  {3, 6},
  {1, 16},
  {2, 6},
  {1, 13},
  {2, 18},
  {3, 28},
  {2, 31},
  {3, 20},
  {1, 19},
  {1, 20},
  {2, 19},
  {3, 20},
  {7, 17},
  {2, 24},
  {4, 29},
  {1, 24},
  {1, 29},
  {1, 17},
  {1, 29},
  {1, 17},
  {1, 29},
  {1, 17},
  {1, 24},
  {4, 17},
  {3, 20},
  {2, 17},
  {2, 20},
  {1, 17},
  {1, 19},
  {4, 20},
  {3, 31},
  {2, 28},
  {1, 21},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 13},
  {1, 6},
  {1, 16},
  {1, 13},
  {3, 18},
  {3, 14},
  {1, 21},
  {2, 23},
  {5, 26},
  {1, 27},
  {1, 25},
  {1, 29},
  {1, 20},
  {5, 19},
  {1, 31},
  {1, 28},
  {1, 21},
  {2, 18},
  {1, 14},
  {8, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 11},
  {2, 13},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {5, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 9},
  {1, 11},
  {11, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {8, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {3, 7},
  {3, 9},
  {12, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 4},
  {1, 9},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 5},
  {1, 15},
  {5, 1},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {6, 4},
  {1, 1},
  {1, 7},
  {11, 1},
  {3, 5},
  {160, 0},
  {160, 0},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 5},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 12},
  {2, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 7},
  {2, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {6, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 15},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {7, 6},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {7, 11},
  {1, 6},
  {8, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {3, 14},
  {1, 18},
  {3, 14},
  {1, 28},
  {1, 31},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 29},
  {2, 27},
  {3, 32},
  {1, 26},
  {2, 23},
  {3, 14},
  {1, 13},
  {1, 16},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 13},
  {1, 18},
  {2, 28},
  {2, 31},
  {2, 20},
  {1, 19},
  {1, 20},
  {2, 19},
  {2, 20},
  {2, 17},
  {1, 24},
  {1, 29},
  {1, 17},
  {5, 29},
  {1, 30},
  {3, 27},
  {1, 30},
  {2, 27},
  {1, 30},
  {1, 27},
  {1, 30},
  {4, 32},
  {2, 27},
  {1, 32},
  {1, 27},
  {1, 32},
  {3, 27},
  {2, 29},
  {1, 25},
  {2, 29},
  {1, 17},
  {1, 29},
  {1, 17},
  {1, 29},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 20},
  {5, 17},
  {1, 31},
  {1, 30},
  {2, 28},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {2, 16},
  {1, 13},
  {1, 16},
  {2, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {2, 26},
  {2, 22},
  {1, 27},
  {1, 29},
  {2, 20},
  {4, 19},
  {1, 20},
  {2, 28},
  {1, 21},
  {1, 11},
  {3, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {4, 13},
  {1, 14},
  {5, 13},
  {4, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 15},
  {1, 9},
  {9, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 15},
  {1, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 9},
  {4, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {9, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {5, 1},
  {1, 7},
  {2, 1},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {2, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {7, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 5},
  {7, 1},
  {1, 4},
  {2, 1},
  {6, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 9},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 2},
  {2, 8},
  {10, 2},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {5, 6},
  {1, 11},
  {7, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 13},
  {1, 18},
  {4, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 28},
  {1, 31},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 30},
  {1, 27},
  {4, 26},
  {2, 23},
  {2, 14},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 12},
  {4, 6},
  {2, 18},
  {2, 30},
  {1, 31},
  {3, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 17},
  {2, 29},
  {1, 30},
  {1, 29},
  {2, 32},
  {1, 27},
  {3, 32},
  {1, 23},
  {1, 32},
  {1, 26},
  {5, 23},
  {1, 32},
  {6, 23},
  {1, 14},
  {1, 21},
  {1, 32},
  {1, 21},
  {1, 32},
  {2, 23},
  {1, 32},
  {1, 26},
  {1, 23},
  {6, 32},
  {1, 27},
  {1, 32},
  {3, 27},
  {3, 29},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 30},
  {2, 28},
  {1, 18},
  {1, 13},
  {1, 6},
  {2, 12},
  {1, 6},
  {1, 11},
  {1, 18},
  {1, 13},
  {2, 16},
  {1, 14},
  {2, 23},
  {5, 26},
  {1, 27},
  {1, 25},
  {1, 29},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 30},
  {1, 21},
  {4, 18},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {3, 13},
  {1, 18},
  {4, 13},
  {5, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 9},
  {1, 11},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 11},
  {2, 7},
  {11, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {17, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 4},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 1},
  {1, 5},
  {1, 15},
  {2, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {2, 1},
  {8, 4},
  {7, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {3, 1},
  {9, 4},
  {1, 3},
  {2, 4},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 9},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 7},
  {6, 9},
  {1, 10},
  {3, 9},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 8},
  {15, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 2},
  {4, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {5, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {7, 14},
  {1, 28},
  {1, 31},
  {4, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 26},
  {4, 32},
  {1, 23},
  {1, 14},
  {1, 23},
  {4, 16},
  {1, 13},
  {2, 6},
  {2, 13},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 31},
  {2, 20},
  {1, 19},
  {2, 20},
  {4, 17},
  {2, 29},
  {4, 27},
  {2, 32},
  {4, 23},
  {2, 21},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 16},
  {3, 18},
  {1, 14},
  {1, 28},
  {2, 14},
  {4, 18},
  {1, 6},
  {1, 13},
  {1, 11},
  {2, 18},
  {2, 14},
  {1, 21},
  {1, 18},
  {2, 21},
  {1, 14},
  {1, 23},
  {1, 21},
  {1, 23},
  {1, 32},
  {1, 23},
  {4, 32},
  {2, 27},
  {3, 29},
  {1, 24},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 31},
  {1, 30},
  {1, 28},
  {1, 18},
  {2, 16},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 13},
  {1, 16},
  {3, 14},
  {1, 23},
  {5, 26},
  {1, 22},
  {1, 27},
  {1, 29},
  {1, 20},
  {4, 19},
  {1, 20},
  {2, 28},
  {1, 11},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {7, 13},
  {7, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 15},
  {1, 9},
  {13, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {4, 9},
  {1, 15},
  {1, 7},
  {4, 9},
  {1, 7},
  {10, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {5, 7},
  {4, 9},
  {9, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {7, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {9, 4},
  {8, 1},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {3, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 15},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {3, 13},
  {1, 14},
  {3, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {7, 14},
  {1, 21},
  {1, 28},
  {1, 31},
  {4, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 27},
  {1, 26},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 18},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 14},
  {1, 16},
  {1, 28},
  {1, 31},
  {2, 20},
  {3, 19},
  {1, 20},
  {2, 17},
  {2, 29},
  {3, 27},
  {3, 32},
  {1, 21},
  {1, 23},
  {1, 28},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 28},
  {4, 18},
  {1, 14},
  {3, 13},
  {3, 18},
  {2, 16},
  {1, 21},
  {1, 12},
  {1, 28},
  {1, 18},
  {1, 6},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 2},
  {2, 13},
  {3, 11},
  {2, 18},
  {1, 21},
  {1, 28},
  {1, 13},
  {1, 16},
  {2, 13},
  {2, 18},
  {4, 14},
  {1, 23},
  {3, 32},
  {1, 30},
  {1, 27},
  {1, 25},
  {1, 29},
  {1, 24},
  {3, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 30},
  {1, 28},
  {2, 18},
  {2, 13},
  {2, 6},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 21},
  {1, 23},
  {6, 26},
  {1, 27},
  {1, 29},
  {2, 20},
  {3, 19},
  {1, 20},
  {1, 30},
  {2, 21},
  {3, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 2},
  {7, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {8, 2},
  {1, 9},
  {1, 15},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {2, 7},
  {9, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {6, 7},
  {2, 9},
  {6, 7},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 7},
  {3, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {5, 4},
  {1, 1},
  {3, 4},
  {9, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 5},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {3, 10},
  {5, 7},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {2, 9},
  {2, 2},
  {1, 15},
  {1, 9},
  {4, 2},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 13},
  {1, 11},
  {1, 6},
  {6, 13},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {6, 14},
  {1, 21},
  {1, 28},
  {1, 31},
  {4, 19},
  {1, 20},
  {2, 29},
  {1, 27},
  {2, 26},
  {4, 23},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {2, 11},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 30},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {2, 29},
  {1, 27},
  {1, 30},
  {3, 32},
  {1, 21},
  {2, 23},
  {7, 14},
  {1, 21},
  {1, 16},
  {1, 18},
  {1, 28},
  {1, 21},
  {1, 16},
  {2, 12},
  {2, 6},
  {2, 11},
  {1, 30},
  {1, 21},
  {1, 15},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 4},
  {1, 2},
  {2, 11},
  {1, 12},
  {1, 2},
  {1, 21},
  {1, 15},
  {2, 11},
  {1, 2},
  {1, 6},
  {2, 28},
  {1, 5},
  {1, 2},
  {4, 6},
  {3, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {3, 23},
  {1, 26},
  {1, 23},
  {2, 26},
  {1, 22},
  {2, 29},
  {1, 25},
  {1, 24},
  {1, 17},
  {1, 20},
  {2, 19},
  {2, 20},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 11},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {2, 13},
  {2, 14},
  {1, 23},
  {6, 26},
  {1, 29},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 28},
  {2, 21},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {2, 13},
  {1, 18},
  {5, 13},
  {2, 11},
  {1, 2},
  {6, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {2, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {7, 2},
  {1, 15},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {8, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 15},
  {6, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {8, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 1},
  {1, 7},
  {2, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 1},
  {5, 4},
  {10, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 5},
  {4, 4},
  {1, 5},
  {3, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 15},
  {1, 3},
  {1, 8},
  {4, 3},
  {1, 5},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {4, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {3, 9},
  {1, 2},
  {2, 9},
  {2, 2},
  {2, 8},
  {4, 2},
  {1, 8},
  {1, 15},
  {6, 2},
  {1, 12},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {5, 14},
  {3, 18},
  {1, 14},
  {2, 21},
  {1, 31},
  {3, 19},
  {2, 20},
  {2, 29},
  {1, 26},
  {1, 23},
  {2, 26},
  {3, 23},
  {4, 18},
  {2, 13},
  {1, 11},
  {2, 18},
  {1, 28},
  {1, 30},
  {4, 20},
  {3, 17},
  {2, 29},
  {1, 27},
  {2, 32},
  {1, 23},
  {1, 32},
  {1, 23},
  {1, 21},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 6},
  {2, 11},
  {1, 6},
  {3, 11},
  {1, 8},
  {1, 10},
  {1, 12},
  {2, 8},
  {1, 4},
  {3, 15},
  {1, 8},
  {1, 2},
  {1, 12},
  {2, 11},
  {1, 8},
  {1, 21},
  {1, 2},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 12},
  {1, 5},
  {1, 30},
  {1, 21},
  {1, 15},
  {1, 28},
  {1, 5},
  {3, 15},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {2, 16},
  {1, 23},
  {4, 16},
  {1, 23},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 23},
  {3, 27},
  {2, 29},
  {2, 17},
  {4, 20},
  {1, 31},
  {1, 28},
  {1, 21},
  {2, 13},
  {3, 11},
  {1, 13},
  {1, 14},
  {2, 16},
  {2, 23},
  {2, 32},
  {2, 26},
  {2, 27},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 28},
  {2, 21},
  {2, 18},
  {1, 13},
  {1, 18},
  {5, 14},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {4, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {5, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {3, 6},
  {1, 11},
  {7, 6},
  {1, 11},
  {3, 2},
  {1, 11},
  {17, 2},
  {1, 9},
  {7, 2},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {2, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {7, 7},
  {4, 9},
  {2, 7},
  {1, 9},
  {3, 7},
  {1, 4},
  {3, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {9, 4},
  {1, 1},
  {2, 4},
  {10, 1},
  {160, 0},
  {160, 0},
  {8, 1},
  {3, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {3, 3},
  {1, 8},
  {4, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {3, 9},
  {1, 15},
  {1, 3},
  {2, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {10, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 2},
  {1, 11},
  {1, 2},
  {8, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {5, 14},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {1, 32},
  {2, 26},
  {2, 23},
  {2, 14},
  {1, 21},
  {1, 15},
  {4, 13},
  {1, 16},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 20},
  {1, 19},
  {2, 20},
  {2, 17},
  {1, 29},
  {1, 27},
  {3, 32},
  {2, 23},
  {1, 21},
  {1, 14},
  {1, 18},
  {1, 21},
  {2, 16},
  {2, 13},
  {2, 6},
  {1, 13},
  {1, 21},
  {1, 12},
  {2, 6},
  {1, 10},
  {2, 3},
  {3, 12},
  {1, 4},
  {2, 3},
  {1, 12},
  {1, 8},
  {1, 9},
  {1, 5},
  {1, 15},
  {1, 7},
  {1, 15},
  {2, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 4},
  {1, 3},
  {2, 8},
  {2, 11},
  {1, 4},
  {5, 15},
  {1, 12},
  {1, 15},
  {1, 9},
  {1, 15},
  {1, 11},
  {1, 3},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 12},
  {1, 6},
  {2, 16},
  {1, 23},
  {1, 14},
  {7, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 23},
  {2, 26},
  {2, 27},
  {2, 29},
  {1, 17},
  {2, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 1},
  {1, 15},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 32},
  {3, 26},
  {2, 27},
  {1, 20},
  {4, 19},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 18},
  {3, 14},
  {2, 18},
  {1, 13},
  {2, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 18},
  {3, 13},
  {4, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 11},
  {7, 2},
  {1, 9},
  {6, 2},
  {1, 9},
  {1, 7},
  {10, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {2, 7},
  {4, 9},
  {7, 7},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {14, 4},
  {7, 1},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 3},
  {1, 8},
  {1, 15},
  {2, 9},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {4, 14},
  {1, 21},
  {1, 28},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 29},
  {2, 27},
  {1, 26},
  {1, 32},
  {3, 23},
  {1, 14},
  {1, 18},
  {1, 2},
  {1, 15},
  {1, 9},
  {2, 11},
  {2, 18},
  {1, 28},
  {1, 30},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 27},
  {3, 32},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 13},
  {2, 18},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 2},
  {1, 8},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 6},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 6},
  {1, 3},
  {2, 4},
  {1, 12},
  {1, 2},
  {1, 15},
  {1, 11},
  {3, 8},
  {2, 3},
  {1, 9},
  {1, 2},
  {1, 15},
  {1, 4},
  {1, 5},
  {1, 8},
  {3, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 15},
  {1, 2},
  {1, 8},
  {1, 12},
  {2, 6},
  {1, 8},
  {1, 12},
  {2, 13},
  {1, 18},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 16},
  {1, 12},
  {3, 16},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 23},
  {1, 28},
  {1, 32},
  {2, 27},
  {2, 29},
  {2, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 30},
  {1, 21},
  {1, 13},
  {1, 6},
  {1, 9},
  {2, 11},
  {1, 15},
  {2, 18},
  {1, 21},
  {1, 23},
  {2, 26},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {4, 19},
  {1, 31},
  {1, 28},
  {3, 14},
  {5, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {6, 13},
  {5, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {6, 2},
  {1, 9},
  {11, 2},
  {1, 9},
  {2, 2},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {2, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {10, 4},
  {1, 1},
  {2, 4},
  {3, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {160, 0},
  {160, 0},
  {8, 1},
  {3, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {10, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {9, 7},
  {3, 9},
  {2, 10},
  {2, 9},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {4, 9},
  {1, 3},
  {2, 9},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 13},
  {3, 11},
  {4, 13},
  {1, 18},
  {1, 13},
  {3, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 28},
  {1, 31},
  {4, 19},
  {1, 24},
  {1, 29},
  {1, 27},
  {2, 26},
  {3, 23},
  {1, 14},
  {1, 13},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {2, 17},
  {3, 27},
  {1, 28},
  {2, 23},
  {1, 21},
  {2, 16},
  {1, 13},
  {1, 16},
  {3, 11},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 9},
  {1, 15},
  {2, 8},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 18},
  {1, 8},
  {2, 2},
  {1, 11},
  {1, 15},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 2},
  {1, 7},
  {1, 3},
  {1, 11},
  {1, 21},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 3},
  {1, 2},
  {1, 21},
  {1, 11},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 16},
  {2, 21},
  {1, 11},
  {5, 12},
  {1, 11},
  {1, 12},
  {7, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 26},
  {2, 27},
  {2, 29},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 30},
  {1, 28},
  {1, 10},
  {1, 6},
  {3, 2},
  {1, 13},
  {2, 14},
  {1, 21},
  {2, 32},
  {3, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 31},
  {2, 21},
  {4, 14},
  {1, 16},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {4, 13},
  {2, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 11},
  {5, 6},
  {1, 2},
  {6, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 15},
  {1, 9},
  {9, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 15},
  {1, 7},
  {5, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 15},
  {2, 7},
  {2, 9},
  {8, 7},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 3},
  {5, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {9, 4},
  {1, 1},
  {2, 4},
  {3, 1},
  {1, 4},
  {3, 1},
  {160, 0},
  {160, 0},
  {8, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {2, 4},
  {4, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 8},
  {1, 4},
  {1, 8},
  {3, 3},
  {1, 4},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 10},
  {7, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 10},
  {2, 9},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {7, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {1, 31},
  {4, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {3, 26},
  {2, 23},
  {2, 18},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 18},
  {1, 21},
  {1, 30},
  {2, 20},
  {1, 19},
  {1, 20},
  {2, 17},
  {2, 29},
  {1, 27},
  {1, 32},
  {4, 23},
  {2, 14},
  {1, 16},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 2},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 9},
  {2, 12},
  {2, 6},
  {3, 11},
  {1, 15},
  {1, 2},
  {1, 12},
  {1, 2},
  {1, 21},
  {1, 2},
  {1, 8},
  {1, 4},
  {1, 9},
  {1, 8},
  {1, 4},
  {1, 12},
  {1, 15},
  {1, 21},
  {5, 11},
  {4, 21},
  {2, 15},
  {1, 11},
  {1, 8},
  {2, 15},
  {1, 11},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 15},
  {1, 21},
  {1, 6},
  {1, 8},
  {1, 11},
  {2, 8},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 21},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 21},
  {1, 13},
  {1, 18},
  {2, 16},
  {1, 13},
  {2, 16},
  {1, 13},
  {2, 16},
  {1, 27},
  {1, 23},
  {2, 32},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 18},
  {2, 6},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 16},
  {2, 21},
  {4, 26},
  {2, 27},
  {1, 17},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 28},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {3, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {4, 13},
  {2, 11},
  {3, 13},
  {3, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {5, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {4, 2},
  {1, 9},
  {5, 2},
  {1, 9},
  {1, 15},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 15},
  {2, 9},
  {2, 7},
  {4, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {2, 9},
  {5, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {3, 4},
  {4, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {8, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {2, 4},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {8, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {9, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {6, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 15},
  {1, 3},
  {1, 2},
  {1, 9},
  {1, 15},
  {1, 3},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {7, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {2, 18},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 18},
  {1, 28},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 29},
  {4, 26},
  {3, 23},
  {2, 14},
  {1, 18},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 18},
  {1, 28},
  {1, 31},
  {1, 17},
  {2, 20},
  {1, 17},
  {1, 20},
  {2, 29},
  {3, 32},
  {1, 21},
  {2, 23},
  {1, 14},
  {1, 16},
  {1, 21},
  {1, 14},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 9},
  {1, 4},
  {1, 3},
  {1, 15},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 12},
  {1, 18},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 13},
  {2, 16},
  {1, 21},
  {1, 18},
  {4, 11},
  {2, 2},
  {2, 15},
  {1, 2},
  {1, 9},
  {1, 15},
  {2, 21},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {2, 8},
  {1, 3},
  {1, 12},
  {1, 6},
  {2, 11},
  {1, 8},
  {2, 11},
  {1, 18},
  {1, 13},
  {1, 6},
  {1, 16},
  {1, 30},
  {2, 16},
  {1, 23},
  {1, 32},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {2, 20},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 28},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 32},
  {1, 26},
  {1, 32},
  {1, 29},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {4, 14},
  {3, 18},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 14},
  {2, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {4, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {6, 3},
  {1, 8},
  {4, 3},
  {1, 10},
  {2, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {4, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 7},
  {3, 9},
  {1, 3},
  {2, 9},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {6, 6},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 16},
  {4, 13},
  {1, 18},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {2, 18},
  {1, 13},
  {1, 28},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 22},
  {2, 26},
  {3, 23},
  {2, 14},
  {1, 16},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 15},
  {1, 28},
  {1, 31},
  {1, 17},
  {2, 20},
  {2, 17},
  {2, 29},
  {2, 32},
  {3, 23},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 12},
  {1, 18},
  {1, 11},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 3},
  {2, 7},
  {1, 8},
  {1, 3},
  {2, 8},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 9},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 6},
  {2, 2},
  {2, 11},
  {1, 15},
  {1, 11},
  {2, 8},
  {1, 3},
  {1, 9},
  {2, 15},
  {1, 9},
  {1, 3},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {3, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 8},
  {1, 3},
  {1, 9},
  {2, 5},
  {1, 15},
  {1, 13},
  {2, 6},
  {1, 15},
  {1, 4},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {1, 2},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 8},
  {3, 12},
  {1, 13},
  {1, 21},
  {1, 18},
  {1, 15},
  {2, 16},
  {3, 14},
  {3, 23},
  {1, 26},
  {2, 27},
  {2, 17},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 18},
  {3, 13},
  {3, 16},
  {1, 21},
  {1, 23},
  {1, 32},
  {4, 26},
  {1, 29},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 30},
  {1, 21},
  {5, 18},
  {3, 14},
  {11, 13},
  {2, 6},
  {2, 11},
  {1, 6},
  {3, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {1, 15},
  {10, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {6, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 15},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 3},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {2, 7},
  {2, 4},
  {1, 7},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 1},
  {8, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 5},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {8, 3},
  {1, 8},
  {1, 4},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {2, 9},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {6, 2},
  {1, 15},
  {1, 12},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {6, 6},
  {4, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 6},
  {6, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {3, 19},
  {1, 17},
  {2, 27},
  {3, 26},
  {2, 23},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 13},
  {2, 16},
  {1, 18},
  {1, 28},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 29},
  {2, 32},
  {1, 18},
  {2, 23},
  {1, 13},
  {1, 16},
  {1, 8},
  {1, 13},
  {1, 15},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 11},
  {2, 3},
  {2, 7},
  {1, 3},
  {1, 2},
  {1, 8},
  {1, 12},
  {1, 4},
  {1, 2},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 9},
  {2, 15},
  {3, 12},
  {1, 13},
  {1, 11},
  {2, 8},
  {1, 6},
  {2, 21},
  {1, 15},
  {1, 12},
  {1, 9},
  {2, 8},
  {1, 15},
  {2, 21},
  {1, 8},
  {2, 11},
  {1, 21},
  {1, 28},
  {2, 15},
  {1, 11},
  {1, 15},
  {1, 9},
  {1, 15},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 11},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 6},
  {1, 21},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 5},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 18},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 11},
  {1, 6},
  {1, 18},
  {1, 11},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 15},
  {1, 16},
  {1, 3},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 18},
  {2, 16},
  {1, 14},
  {2, 23},
  {2, 32},
  {2, 29},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 28},
  {2, 13},
  {1, 16},
  {1, 6},
  {1, 13},
  {2, 18},
  {2, 23},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 26},
  {1, 27},
  {1, 29},
  {4, 19},
  {1, 31},
  {2, 21},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 11},
  {2, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {11, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 8},
  {3, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {3, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 8},
  {4, 7},
  {1, 4},
  {6, 7},
  {2, 4},
  {1, 7},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {8, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 4},
  {160, 0},
  {160, 0},
  {7, 1},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 8},
  {5, 3},
  {1, 9},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {3, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {8, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {7, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 9},
  {3, 2},
  {1, 8},
  {8, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 13},
  {5, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {6, 13},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 11},
  {1, 31},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {2, 26},
  {3, 23},
  {1, 14},
  {1, 18},
  {1, 13},
  {3, 11},
  {1, 7},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 17},
  {1, 31},
  {2, 27},
  {1, 32},
  {2, 23},
  {3, 18},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 2},
  {1, 9},
  {2, 12},
  {1, 15},
  {3, 21},
  {1, 2},
  {1, 4},
  {1, 3},
  {1, 1},
  {1, 15},
  {1, 4},
  {1, 9},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 8},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 8},
  {2, 5},
  {2, 3},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 2},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 4},
  {2, 15},
  {1, 12},
  {1, 2},
  {1, 15},
  {1, 21},
  {1, 28},
  {2, 12},
  {1, 8},
  {2, 3},
  {1, 9},
  {1, 2},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 12},
  {1, 28},
  {1, 6},
  {1, 12},
  {2, 11},
  {1, 21},
  {1, 8},
  {2, 12},
  {1, 9},
  {2, 12},
  {1, 15},
  {1, 8},
  {2, 3},
  {1, 11},
  {1, 18},
  {1, 2},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {4, 12},
  {2, 15},
  {1, 12},
  {2, 16},
  {1, 18},
  {2, 14},
  {2, 23},
  {2, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 21},
  {4, 13},
  {3, 14},
  {1, 23},
  {2, 32},
  {1, 26},
  {2, 27},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 28},
  {1, 21},
  {2, 18},
  {5, 14},
  {2, 18},
  {5, 13},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 6},
  {4, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {4, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {3, 2},
  {1, 9},
  {1, 15},
  {8, 2},
  {1, 8},
  {1, 9},
  {9, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {4, 8},
  {2, 2},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {10, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {3, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 5},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 9},
  {4, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {7, 7},
  {2, 10},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {7, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {5, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {3, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 11},
  {1, 2},
  {3, 13},
  {2, 18},
  {1, 13},
  {1, 18},
  {1, 16},
  {5, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {2, 20},
  {2, 19},
  {1, 29},
  {1, 27},
  {3, 26},
  {2, 23},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 32},
  {4, 14},
  {1, 6},
  {1, 12},
  {2, 11},
  {1, 6},
  {1, 8},
  {1, 10},
  {1, 21},
  {1, 15},
  {1, 6},
  {1, 11},
  {1, 15},
  {2, 11},
  {1, 15},
  {3, 3},
  {1, 12},
  {1, 7},
  {2, 4},
  {1, 2},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 3},
  {2, 15},
  {1, 12},
  {3, 3},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 6},
  {1, 21},
  {1, 15},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {2, 8},
  {1, 11},
  {4, 12},
  {1, 3},
  {1, 12},
  {1, 8},
  {4, 3},
  {1, 8},
  {1, 12},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 6},
  {1, 9},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 18},
  {3, 12},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 3},
  {1, 12},
  {2, 8},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 8},
  {1, 21},
  {1, 15},
  {2, 21},
  {1, 5},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 13},
  {1, 16},
  {1, 12},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 21},
  {1, 32},
  {2, 26},
  {3, 27},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 15},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {4, 13},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 6},
  {5, 2},
  {2, 9},
  {9, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {8, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {10, 4},
  {1, 3},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {6, 1},
  {1, 5},
  {5, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {7, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {10, 3},
  {1, 8},
  {4, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {4, 10},
  {7, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {3, 9},
  {1, 3},
  {1, 15},
  {2, 9},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 12},
  {1, 15},
  {3, 2},
  {1, 8},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {3, 13},
  {1, 16},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 16},
  {3, 14},
  {1, 11},
  {1, 31},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {3, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {2, 23},
  {1, 14},
  {2, 16},
  {1, 18},
  {1, 12},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 21},
  {8, 12},
  {2, 9},
  {1, 3},
  {1, 7},
  {1, 9},
  {2, 12},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 11},
  {1, 3},
  {1, 8},
  {1, 12},
  {2, 3},
  {2, 8},
  {1, 11},
  {3, 12},
  {1, 11},
  {1, 6},
  {2, 12},
  {2, 8},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 12},
  {2, 6},
  {2, 8},
  {3, 3},
  {2, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 12},
  {1, 15},
  {1, 3},
  {1, 4},
  {1, 12},
  {1, 2},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 15},
  {1, 18},
  {1, 13},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 11},
  {2, 21},
  {1, 15},
  {2, 8},
  {1, 9},
  {1, 12},
  {3, 6},
  {2, 8},
  {1, 3},
  {1, 21},
  {2, 15},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 15},
  {2, 12},
  {1, 16},
  {3, 14},
  {1, 23},
  {1, 28},
  {3, 27},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 28},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 18},
  {2, 14},
  {3, 26},
  {2, 27},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 28},
  {3, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {8, 13},
  {1, 6},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {12, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {5, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 15},
  {1, 9},
  {1, 7},
  {3, 9},
  {8, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {4, 7},
  {1, 3},
  {4, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {4, 4},
  {1, 1},
  {14, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {7, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 8},
  {3, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 10},
  {1, 8},
  {1, 3},
  {5, 10},
  {8, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 3},
  {3, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {7, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 2},
  {3, 11},
  {1, 6},
  {7, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 20},
  {2, 27},
  {3, 26},
  {4, 16},
  {1, 6},
  {1, 9},
  {1, 11},
  {1, 18},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 32},
  {1, 18},
  {1, 14},
  {2, 16},
  {1, 12},
  {1, 13},
  {1, 2},
  {1, 4},
  {1, 3},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 28},
  {2, 8},
  {1, 3},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 21},
  {3, 3},
  {2, 8},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 6},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 21},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 15},
  {3, 11},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 4},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 3},
  {1, 8},
  {1, 12},
  {3, 8},
  {1, 11},
  {1, 15},
  {1, 11},
  {3, 3},
  {1, 12},
  {1, 15},
  {1, 16},
  {3, 12},
  {1, 18},
  {1, 21},
  {1, 16},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 18},
  {2, 11},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 6},
  {4, 11},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 15},
  {2, 5},
  {1, 3},
  {1, 2},
  {1, 12},
  {1, 6},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 32},
  {1, 27},
  {2, 29},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 15},
  {4, 11},
  {1, 13},
  {2, 14},
  {1, 23},
  {2, 26},
  {1, 22},
  {1, 27},
  {1, 29},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 21},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 11},
  {1, 9},
  {10, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {8, 9},
  {3, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {12, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 1},
  {1, 7},
  {2, 1},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {6, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 3},
  {3, 4},
  {3, 3},
  {3, 4},
  {9, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 6},
  {3, 8},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {3, 2},
  {1, 8},
  {8, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 13},
  {1, 6},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 23},
  {1, 14},
  {1, 30},
  {1, 20},
  {3, 19},
  {1, 29},
  {1, 27},
  {2, 26},
  {4, 23},
  {1, 16},
  {1, 13},
  {1, 11},
  {2, 6},
  {1, 18},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 32},
  {2, 23},
  {1, 14},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 6},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 3},
  {2, 7},
  {1, 9},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 18},
  {1, 15},
  {1, 6},
  {1, 2},
  {2, 12},
  {1, 5},
  {1, 28},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 12},
  {1, 18},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 2},
  {1, 11},
  {2, 8},
  {2, 12},
  {1, 6},
  {2, 12},
  {1, 5},
  {1, 15},
  {2, 21},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 18},
  {7, 21},
  {1, 11},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 18},
  {1, 13},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 28},
  {1, 15},
  {4, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 8},
  {2, 11},
  {1, 13},
  {2, 11},
  {2, 12},
  {1, 8},
  {1, 12},
  {1, 21},
  {2, 12},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 4},
  {1, 8},
  {3, 9},
  {1, 4},
  {2, 3},
  {1, 11},
  {1, 6},
  {3, 9},
  {1, 6},
  {1, 16},
  {1, 14},
  {3, 23},
  {1, 32},
  {1, 27},
  {1, 25},
  {1, 29},
  {3, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {1, 13},
  {1, 11},
  {1, 13},
  {2, 18},
  {1, 21},
  {1, 23},
  {1, 32},
  {3, 26},
  {1, 29},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 21},
  {2, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {4, 13},
  {1, 6},
  {3, 13},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {1, 11},
  {2, 2},
  {1, 9},
  {9, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {2, 8},
  {1, 6},
  {3, 8},
  {1, 6},
  {3, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {7, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {3, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {2, 4},
  {2, 5},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {3, 3},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 3},
  {7, 10},
  {1, 3},
  {1, 10},
  {8, 7},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {8, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {7, 2},
  {1, 8},
  {4, 2},
  {1, 15},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {6, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 21},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 27},
  {1, 26},
  {2, 23},
  {4, 16},
  {1, 12},
  {1, 6},
  {1, 18},
  {1, 28},
  {1, 31},
  {3, 20},
  {1, 29},
  {2, 27},
  {1, 32},
  {1, 23},
  {2, 14},
  {1, 16},
  {1, 21},
  {1, 28},
  {1, 18},
  {1, 6},
  {1, 18},
  {1, 6},
  {1, 12},
  {1, 15},
  {1, 11},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 6},
  {1, 2},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 18},
  {1, 12},
  {1, 16},
  {2, 15},
  {1, 11},
  {1, 12},
  {2, 8},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {2, 11},
  {2, 12},
  {1, 6},
  {2, 12},
  {3, 16},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 16},
  {6, 12},
  {3, 16},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 16},
  {1, 6},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 16},
  {6, 12},
  {1, 16},
  {2, 11},
  {2, 8},
  {1, 4},
  {1, 12},
  {1, 8},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 8},
  {1, 11},
  {1, 6},
  {2, 12},
  {1, 18},
  {1, 11},
  {3, 12},
  {1, 3},
  {4, 15},
  {3, 3},
  {1, 4},
  {1, 8},
  {2, 11},
  {1, 3},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 12},
  {2, 16},
  {1, 28},
  {1, 23},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 18},
  {1, 2},
  {2, 11},
  {2, 18},
  {1, 21},
  {1, 23},
  {3, 26},
  {1, 27},
  {1, 17},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 15},
  {1, 9},
  {11, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {5, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {14, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 1},
  {1, 7},
  {2, 1},
  {11, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {5, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 3},
  {3, 4},
  {3, 3},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {9, 3},
  {1, 8},
  {11, 10},
  {7, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 8},
  {1, 2},
  {3, 8},
  {7, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 15},
  {6, 2},
  {1, 9},
  {3, 2},
  {2, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 13},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {1, 16},
  {2, 18},
  {1, 14},
  {3, 18},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 24},
  {1, 27},
  {3, 26},
  {2, 23},
  {1, 14},
  {2, 16},
  {1, 6},
  {1, 2},
  {1, 12},
  {1, 28},
  {1, 31},
  {1, 17},
  {1, 19},
  {1, 20},
  {2, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {2, 21},
  {1, 14},
  {1, 12},
  {1, 13},
  {1, 14},
  {1, 30},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 6},
  {2, 12},
  {1, 2},
  {2, 12},
  {1, 5},
  {1, 12},
  {2, 5},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 8},
  {1, 12},
  {1, 15},
  {1, 28},
  {1, 21},
  {1, 11},
  {1, 15},
  {1, 18},
  {1, 15},
  {2, 11},
  {1, 16},
  {1, 11},
  {2, 8},
  {1, 3},
  {2, 8},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 21},
  {1, 12},
  {1, 8},
  {1, 16},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 21},
  {4, 28},
  {4, 30},
  {1, 32},
  {3, 30},
  {1, 32},
  {3, 30},
  {1, 28},
  {1, 32},
  {1, 28},
  {1, 21},
  {1, 28},
  {3, 21},
  {1, 18},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 12},
  {2, 11},
  {1, 16},
  {2, 11},
  {2, 8},
  {1, 4},
  {1, 5},
  {2, 12},
  {1, 28},
  {1, 11},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 18},
  {1, 14},
  {2, 21},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 3},
  {2, 4},
  {1, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 2},
  {2, 3},
  {1, 12},
  {1, 11},
  {2, 21},
  {3, 16},
  {1, 23},
  {1, 32},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {2, 11},
  {1, 13},
  {3, 14},
  {1, 32},
  {3, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 21},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {6, 13},
  {1, 6},
  {4, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {4, 2},
  {2, 9},
  {1, 2},
  {1, 9},
  {1, 15},
  {1, 2},
  {1, 9},
  {1, 15},
  {5, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {7, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {6, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {6, 1},
  {4, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {8, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 15},
  {1, 5},
  {1, 8},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {5, 10},
  {5, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {3, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {3, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {4, 6},
  {3, 2},
  {1, 11},
  {3, 2},
  {1, 13},
  {1, 6},
  {7, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 18},
  {2, 14},
  {2, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 26},
  {2, 23},
  {4, 16},
  {1, 13},
  {1, 2},
  {1, 18},
  {1, 28},
  {1, 20},
  {3, 17},
  {1, 29},
  {1, 27},
  {2, 28},
  {1, 32},
  {1, 21},
  {1, 16},
  {1, 18},
  {2, 21},
  {2, 12},
  {1, 15},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 8},
  {3, 11},
  {2, 15},
  {1, 11},
  {5, 15},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 11},
  {1, 12},
  {1, 6},
  {3, 16},
  {1, 18},
  {3, 28},
  {2, 30},
  {3, 31},
  {1, 30},
  {1, 29},
  {3, 30},
  {1, 28},
  {1, 30},
  {3, 28},
  {1, 32},
  {5, 28},
  {7, 30},
  {2, 31},
  {3, 30},
  {1, 32},
  {1, 28},
  {2, 23},
  {1, 14},
  {2, 11},
  {1, 15},
  {1, 6},
  {1, 11},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 21},
  {3, 14},
  {1, 21},
  {1, 16},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 28},
  {1, 21},
  {1, 11},
  {1, 8},
  {1, 5},
  {1, 3},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 13},
  {2, 12},
  {1, 8},
  {2, 3},
  {1, 7},
  {1, 12},
  {1, 11},
  {1, 28},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 28},
  {2, 14},
  {1, 23},
  {1, 32},
  {2, 29},
  {1, 24},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 15},
  {3, 13},
  {2, 14},
  {1, 23},
  {1, 32},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 9},
  {1, 14},
  {2, 18},
  {1, 13},
  {2, 16},
  {1, 18},
  {1, 13},
  {1, 14},
  {5, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 9},
  {8, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 10},
  {1, 7},
  {2, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 9},
  {16, 7},
  {1, 3},
  {4, 7},
  {5, 3},
  {3, 4},
  {1, 3},
  {2, 4},
  {2, 1},
  {1, 7},
  {3, 1},
  {5, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {160, 0},
  {160, 0},
  {3, 1},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {8, 3},
  {1, 7},
  {1, 10},
  {1, 3},
  {6, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 13},
  {4, 18},
  {1, 21},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 26},
  {2, 23},
  {3, 14},
  {1, 16},
  {1, 13},
  {1, 15},
  {1, 21},
  {1, 31},
  {3, 20},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 28},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 9},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 8},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 8},
  {2, 12},
  {2, 6},
  {1, 14},
  {1, 21},
  {2, 28},
  {3, 30},
  {2, 31},
  {2, 30},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 21},
  {1, 15},
  {1, 18},
  {1, 14},
  {2, 16},
  {1, 12},
  {3, 16},
  {1, 12},
  {2, 11},
  {1, 16},
  {1, 6},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 21},
  {1, 32},
  {1, 28},
  {6, 30},
  {2, 28},
  {1, 21},
  {2, 14},
  {3, 16},
  {1, 14},
  {1, 21},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 15},
  {3, 12},
  {1, 16},
  {1, 6},
  {2, 8},
  {6, 15},
  {1, 11},
  {1, 6},
  {2, 12},
  {3, 8},
  {1, 3},
  {1, 9},
  {1, 4},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 18},
  {1, 21},
  {1, 6},
  {2, 14},
  {2, 23},
  {3, 27},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 13},
  {1, 11},
  {3, 18},
  {1, 21},
  {1, 23},
  {2, 26},
  {2, 27},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 21},
  {1, 18},
  {2, 14},
  {3, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {5, 13},
  {5, 11},
  {3, 2},
  {1, 6},
  {2, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {13, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {13, 7},
  {1, 10},
  {2, 7},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {4, 1},
  {1, 7},
  {2, 4},
  {1, 1},
  {9, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {6, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 10},
  {10, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 11},
  {1, 6},
  {7, 13},
  {1, 14},
  {1, 13},
  {3, 18},
  {1, 14},
  {2, 18},
  {1, 21},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {3, 26},
  {2, 23},
  {5, 16},
  {1, 18},
  {1, 30},
  {3, 20},
  {1, 17},
  {1, 29},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 14},
  {1, 11},
  {1, 10},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 8},
  {3, 15},
  {1, 12},
  {2, 6},
  {1, 8},
  {3, 12},
  {2, 8},
  {1, 3},
  {1, 8},
  {3, 3},
  {1, 12},
  {2, 4},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {3, 11},
  {1, 16},
  {1, 21},
  {2, 16},
  {2, 11},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 31},
  {3, 30},
  {2, 28},
  {1, 16},
  {1, 5},
  {1, 12},
  {2, 5},
  {1, 4},
  {3, 8},
  {1, 9},
  {1, 12},
  {1, 5},
  {1, 12},
  {4, 5},
  {2, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 8},
  {2, 12},
  {1, 4},
  {1, 5},
  {1, 9},
  {1, 3},
  {3, 12},
  {1, 13},
  {1, 21},
  {2, 28},
  {4, 30},
  {1, 27},
  {1, 28},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 14},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 15},
  {2, 12},
  {2, 16},
  {1, 11},
  {1, 2},
  {1, 4},
  {1, 3},
  {2, 8},
  {2, 12},
  {2, 8},
  {1, 12},
  {3, 8},
  {1, 10},
  {1, 2},
  {1, 3},
  {1, 8},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 15},
  {2, 12},
  {1, 16},
  {1, 21},
  {4, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 18},
  {1, 13},
  {1, 11},
  {2, 18},
  {1, 21},
  {1, 23},
  {3, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 14},
  {3, 18},
  {1, 11},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {13, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {2, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {10, 7},
  {5, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {2, 1},
  {1, 15},
  {1, 5},
  {4, 1},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {2, 4},
  {10, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {1, 7},
  {2, 3},
  {8, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {8, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 9},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 18},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 1},
  {1, 31},
  {3, 19},
  {1, 24},
  {1, 22},
  {3, 26},
  {1, 23},
  {3, 14},
  {1, 16},
  {2, 13},
  {1, 21},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 21},
  {2, 18},
  {1, 6},
  {1, 12},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 15},
  {1, 2},
  {2, 8},
  {1, 15},
  {1, 21},
  {1, 2},
  {1, 12},
  {2, 11},
  {2, 12},
  {2, 8},
  {1, 3},
  {1, 4},
  {2, 8},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 2},
  {1, 8},
  {1, 3},
  {2, 12},
  {2, 8},
  {2, 14},
  {2, 16},
  {1, 21},
  {2, 28},
  {4, 30},
  {1, 28},
  {1, 32},
  {1, 14},
  {1, 11},
  {1, 2},
  {6, 12},
  {4, 3},
  {1, 4},
  {3, 5},
  {2, 4},
  {1, 3},
  {9, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 3},
  {2, 5},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 5},
  {2, 16},
  {2, 21},
  {5, 30},
  {1, 28},
  {1, 23},
  {1, 14},
  {2, 16},
  {5, 12},
  {1, 18},
  {1, 2},
  {1, 9},
  {2, 3},
  {2, 2},
  {2, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 3},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {4, 12},
  {2, 16},
  {3, 14},
  {1, 23},
  {1, 26},
  {2, 27},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 15},
  {2, 11},
  {1, 18},
  {1, 16},
  {2, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 28},
  {4, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {6, 13},
  {1, 11},
  {1, 13},
  {3, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {1, 15},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {1, 9},
  {9, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 15},
  {1, 4},
  {1, 3},
  {1, 9},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {2, 7},
  {7, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {7, 2},
  {1, 9},
  {7, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {2, 13},
  {1, 16},
  {2, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {3, 26},
  {1, 23},
  {2, 16},
  {1, 14},
  {1, 16},
  {1, 6},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 32},
  {1, 23},
  {2, 13},
  {1, 14},
  {2, 12},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 2},
  {1, 15},
  {1, 2},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {4, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {2, 30},
  {1, 31},
  {2, 30},
  {2, 28},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {4, 1},
  {2, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {4, 12},
  {1, 16},
  {1, 14},
  {1, 21},
  {2, 30},
  {1, 29},
  {2, 30},
  {1, 32},
  {1, 21},
  {1, 15},
  {2, 14},
  {1, 23},
  {1, 16},
  {1, 11},
  {1, 6},
  {1, 15},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 12},
  {1, 8},
  {1, 3},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 3},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 3},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 16},
  {2, 14},
  {2, 26},
  {1, 22},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 15},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 22},
  {1, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 30},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {4, 13},
  {1, 2},
  {4, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {6, 2},
  {2, 9},
  {8, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {10, 7},
  {1, 10},
  {4, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {4, 4},
  {9, 1},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 5},
  {4, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {4, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {4, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 15},
  {3, 2},
  {1, 8},
  {1, 15},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {8, 13},
  {3, 14},
  {1, 16},
  {3, 18},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 29},
  {1, 27},
  {1, 22},
  {1, 26},
  {2, 23},
  {2, 14},
  {2, 13},
  {1, 18},
  {1, 15},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 18},
  {1, 23},
  {1, 6},
  {1, 12},
  {1, 21},
  {1, 28},
  {3, 15},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 21},
  {1, 15},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 12},
  {2, 8},
  {2, 12},
  {1, 16},
  {2, 11},
  {1, 14},
  {1, 21},
  {1, 18},
  {4, 30},
  {1, 28},
  {2, 21},
  {1, 1},
  {1, 5},
  {1, 1},
  {1, 12},
  {1, 3},
  {3, 4},
  {1, 3},
  {3, 4},
  {4, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {3, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {8, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 3},
  {6, 5},
  {1, 9},
  {4, 12},
  {1, 21},
  {1, 28},
  {2, 30},
  {1, 31},
  {1, 30},
  {1, 28},
  {1, 23},
  {2, 14},
  {1, 28},
  {1, 13},
  {1, 2},
  {2, 8},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 3},
  {1, 12},
  {2, 15},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 12},
  {2, 3},
  {1, 15},
  {1, 10},
  {1, 2},
  {1, 11},
  {1, 8},
  {2, 12},
  {2, 16},
  {1, 23},
  {1, 14},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 18},
  {1, 13},
  {1, 6},
  {3, 16},
  {1, 23},
  {1, 32},
  {1, 26},
  {2, 27},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {2, 18},
  {1, 13},
  {1, 14},
  {3, 18},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 9},
  {1, 11},
  {1, 9},
  {11, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {8, 9},
  {7, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 4},
  {1, 7},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 1},
  {6, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {4, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 11},
  {5, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 22},
  {2, 26},
  {2, 23},
  {4, 16},
  {1, 11},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 21},
  {1, 13},
  {1, 18},
  {1, 11},
  {1, 8},
  {3, 15},
  {1, 12},
  {1, 3},
  {2, 15},
  {1, 21},
  {1, 8},
  {1, 6},
  {1, 15},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 5},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 6},
  {2, 11},
  {1, 18},
  {2, 11},
  {3, 12},
  {1, 16},
  {1, 18},
  {1, 28},
  {4, 30},
  {1, 21},
  {1, 14},
  {1, 13},
  {1, 2},
  {4, 1},
  {1, 5},
  {4, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {8, 1},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {12, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {4, 5},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 32},
  {1, 30},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 8},
  {1, 12},
  {1, 6},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 15},
  {4, 12},
  {1, 9},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 8},
  {2, 12},
  {4, 16},
  {2, 23},
  {1, 26},
  {1, 25},
  {1, 24},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 18},
  {1, 2},
  {1, 6},
  {2, 16},
  {2, 14},
  {1, 32},
  {2, 26},
  {1, 27},
  {1, 24},
  {3, 19},
  {1, 31},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 13},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 15},
  {1, 9},
  {5, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {10, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {3, 4},
  {1, 7},
  {1, 1},
  {2, 4},
  {2, 1},
  {1, 15},
  {1, 5},
  {3, 1},
  {1, 7},
  {2, 1},
  {1, 4},
  {1, 1},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {8, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {3, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {4, 13},
  {1, 16},
  {1, 14},
  {1, 16},
  {4, 18},
  {2, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {3, 26},
  {2, 23},
  {1, 16},
  {1, 14},
  {1, 6},
  {2, 15},
  {1, 28},
  {1, 31},
  {1, 19},
  {2, 20},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 21},
  {1, 18},
  {1, 13},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 12},
  {1, 15},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 14},
  {1, 21},
  {1, 16},
  {2, 12},
  {1, 16},
  {2, 21},
  {1, 23},
  {1, 32},
  {3, 30},
  {1, 21},
  {3, 12},
  {1, 9},
  {5, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {11, 1},
  {1, 5},
  {3, 1},
  {2, 5},
  {1, 15},
  {15, 1},
  {1, 5},
  {2, 4},
  {2, 5},
  {1, 1},
  {1, 4},
  {2, 1},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {4, 5},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 10},
  {2, 12},
  {2, 16},
  {1, 21},
  {1, 32},
  {2, 30},
  {1, 28},
  {1, 21},
  {2, 16},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 8},
  {3, 12},
  {2, 15},
  {2, 5},
  {1, 8},
  {1, 15},
  {1, 8},
  {7, 12},
  {1, 21},
  {1, 11},
  {2, 3},
  {1, 4},
  {1, 12},
  {1, 16},
  {1, 28},
  {2, 16},
  {1, 23},
  {1, 14},
  {2, 23},
  {2, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 6},
  {2, 11},
  {1, 18},
  {2, 16},
  {3, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 31},
  {1, 21},
  {6, 18},
  {1, 13},
  {1, 18},
  {4, 13},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 9},
  {9, 7},
  {1, 10},
  {6, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {4, 1},
  {1, 7},
  {2, 1},
  {10, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 15},
  {1, 5},
  {3, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 3},
  {3, 10},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {4, 7},
  {6, 9},
  {1, 7},
  {3, 8},
  {1, 2},
  {3, 8},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {11, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {5, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {2, 14},
  {5, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 26},
  {2, 23},
  {4, 16},
  {1, 11},
  {1, 18},
  {1, 30},
  {3, 19},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 21},
  {1, 14},
  {1, 13},
  {1, 11},
  {1, 21},
  {1, 28},
  {2, 15},
  {3, 5},
  {1, 4},
  {1, 8},
  {1, 4},
  {2, 5},
  {1, 2},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 8},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 9},
  {1, 15},
  {1, 14},
  {1, 21},
  {1, 14},
  {2, 16},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 27},
  {1, 15},
  {1, 12},
  {2, 5},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {26, 1},
  {4, 5},
  {17, 1},
  {1, 4},
  {3, 1},
  {1, 5},
  {8, 1},
  {2, 4},
  {3, 5},
  {3, 4},
  {2, 3},
  {3, 12},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 30},
  {1, 23},
  {1, 14},
  {1, 23},
  {1, 6},
  {3, 8},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 13},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 30},
  {1, 12},
  {2, 16},
  {4, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {2, 20},
  {1, 31},
  {1, 21},
  {1, 14},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 14},
  {2, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {2, 21},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 14},
  {2, 13},
  {1, 18},
  {4, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {9, 2},
  {1, 6},
  {10, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {3, 9},
  {1, 10},
  {16, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {3, 3},
  {6, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {5, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {8, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {7, 9},
  {2, 2},
  {3, 8},
  {6, 2},
  {1, 9},
  {1, 15},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {7, 13},
  {1, 14},
  {2, 16},
  {3, 18},
  {2, 21},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 27},
  {3, 26},
  {1, 23},
  {2, 14},
  {1, 13},
  {1, 8},
  {2, 15},
  {1, 30},
  {2, 20},
  {1, 19},
  {1, 31},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 2},
  {3, 15},
  {1, 12},
  {1, 2},
  {3, 15},
  {2, 3},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 3},
  {2, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 14},
  {1, 23},
  {1, 28},
  {1, 30},
  {1, 29},
  {1, 30},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 4},
  {32, 1},
  {2, 5},
  {31, 1},
  {1, 5},
  {1, 1},
  {2, 4},
  {4, 1},
  {1, 4},
  {4, 5},
  {1, 4},
  {1, 5},
  {1, 8},
  {3, 12},
  {1, 16},
  {3, 30},
  {1, 28},
  {1, 23},
  {1, 14},
  {1, 6},
  {2, 15},
  {1, 5},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 6},
  {1, 8},
  {2, 12},
  {1, 11},
  {1, 18},
  {3, 12},
  {1, 11},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 15},
  {2, 21},
  {2, 12},
  {2, 21},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {2, 17},
  {1, 19},
  {1, 31},
  {1, 28},
  {2, 16},
  {1, 12},
  {1, 16},
  {2, 14},
  {1, 32},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 28},
  {2, 18},
  {1, 13},
  {3, 18},
  {1, 14},
  {4, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 13},
  {3, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {2, 7},
  {2, 9},
  {17, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {4, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {2, 10},
  {3, 7},
  {1, 9},
  {4, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 15},
  {1, 3},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 8},
  {5, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {4, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {5, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 30},
  {3, 19},
  {1, 17},
  {1, 27},
  {3, 26},
  {1, 16},
  {1, 23},
  {2, 16},
  {1, 2},
  {1, 11},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 13},
  {1, 18},
  {1, 6},
  {1, 9},
  {2, 8},
  {1, 11},
  {2, 12},
  {1, 8},
  {2, 12},
  {1, 8},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 28},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 11},
  {2, 3},
  {1, 6},
  {1, 16},
  {2, 14},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 16},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 4},
  {74, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 8},
  {1, 3},
  {2, 12},
  {1, 14},
  {1, 28},
  {2, 30},
  {1, 32},
  {1, 21},
  {1, 18},
  {2, 12},
  {2, 11},
  {6, 12},
  {2, 15},
  {2, 12},
  {1, 3},
  {1, 4},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 8},
  {1, 21},
  {2, 15},
  {1, 8},
  {1, 6},
  {3, 16},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 29},
  {1, 28},
  {1, 13},
  {3, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 18},
  {1, 14},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 18},
  {5, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 8},
  {3, 9},
  {1, 10},
  {16, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 8},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {2, 10},
  {3, 9},
  {1, 7},
  {2, 9},
  {6, 8},
  {1, 2},
  {4, 9},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 16},
  {2, 13},
  {2, 14},
  {2, 18},
  {2, 14},
  {1, 21},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 27},
  {3, 26},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 7},
  {1, 15},
  {1, 28},
  {1, 31},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 32},
  {2, 23},
  {1, 14},
  {1, 6},
  {1, 18},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 11},
  {2, 12},
  {1, 2},
  {3, 8},
  {2, 12},
  {1, 6},
  {1, 15},
  {2, 21},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 6},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {2, 14},
  {1, 28},
  {3, 30},
  {1, 21},
  {1, 16},
  {2, 12},
  {1, 3},
  {1, 5},
  {2, 4},
  {1, 5},
  {73, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 12},
  {2, 14},
  {1, 28},
  {3, 30},
  {1, 23},
  {1, 14},
  {1, 16},
  {6, 12},
  {1, 21},
  {1, 11},
  {2, 12},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 9},
  {1, 4},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 6},
  {1, 2},
  {2, 11},
  {1, 18},
  {2, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 12},
  {2, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {2, 18},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {4, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {7, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 7},
  {1, 15},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {17, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {160, 0},
  {160, 0},
  {7, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 5},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {4, 9},
  {1, 10},
  {3, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {5, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {1, 16},
  {1, 14},
  {4, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 27},
  {3, 26},
  {2, 16},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 28},
  {1, 21},
  {1, 13},
  {1, 2},
  {1, 15},
  {1, 10},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 9},
  {1, 11},
  {1, 3},
  {1, 8},
  {1, 2},
  {1, 15},
  {1, 6},
  {2, 12},
  {1, 11},
  {2, 15},
  {1, 18},
  {2, 12},
  {1, 15},
  {1, 28},
  {1, 6},
  {1, 12},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 30},
  {1, 15},
  {1, 1},
  {4, 5},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 4},
  {81, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 8},
  {1, 12},
  {1, 13},
  {1, 28},
  {1, 27},
  {1, 31},
  {1, 30},
  {1, 23},
  {1, 21},
  {2, 16},
  {1, 12},
  {1, 11},
  {1, 21},
  {2, 12},
  {3, 3},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 8},
  {3, 15},
  {1, 12},
  {3, 5},
  {2, 21},
  {1, 5},
  {1, 2},
  {1, 7},
  {2, 2},
  {1, 13},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 13},
  {2, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {3, 2},
  {1, 9},
  {2, 7},
  {6, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {4, 9},
  {11, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 5},
  {2, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {8, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {6, 8},
  {1, 2},
  {7, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {7, 13},
  {5, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {3, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 26},
  {3, 16},
  {1, 2},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 28},
  {1, 18},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 28},
  {1, 11},
  {1, 3},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 12},
  {1, 15},
  {1, 28},
  {1, 11},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 15},
  {2, 12},
  {2, 21},
  {1, 14},
  {1, 28},
  {3, 30},
  {1, 18},
  {1, 7},
  {1, 8},
  {1, 3},
  {2, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {82, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {3, 12},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 30},
  {1, 21},
  {2, 16},
  {1, 21},
  {3, 12},
  {1, 8},
  {1, 9},
  {1, 3},
  {3, 15},
  {1, 11},
  {1, 21},
  {1, 8},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 5},
  {2, 15},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 2},
  {2, 7},
  {1, 2},
  {1, 18},
  {1, 23},
  {2, 32},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 23},
  {2, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {6, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {3, 2},
  {1, 11},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {1, 11},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {6, 9},
  {1, 7},
  {2, 9},
  {16, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {6, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 8},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 15},
  {1, 12},
  {1, 8},
  {3, 2},
  {1, 8},
  {11, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {5, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 27},
  {3, 26},
  {5, 16},
  {1, 18},
  {1, 30},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 21},
  {1, 16},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 13},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 4},
  {3, 7},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 18},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 29},
  {1, 30},
  {1, 28},
  {2, 5},
  {1, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {85, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 3},
  {3, 12},
  {1, 15},
  {1, 28},
  {2, 31},
  {1, 28},
  {1, 21},
  {1, 16},
  {2, 12},
  {1, 8},
  {1, 3},
  {1, 15},
  {3, 3},
  {1, 12},
  {1, 15},
  {1, 12},
  {3, 3},
  {1, 11},
  {1, 8},
  {3, 15},
  {2, 21},
  {2, 4},
  {1, 7},
  {1, 10},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {3, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {2, 13},
  {1, 14},
  {4, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {4, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {11, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 3},
  {2, 5},
  {1, 4},
  {2, 5},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 5},
  {1, 15},
  {2, 4},
  {1, 9},
  {1, 4},
  {1, 8},
  {1, 7},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {10, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 12},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {9, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {4, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 15},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 27},
  {4, 26},
  {1, 23},
  {2, 16},
  {2, 15},
  {1, 28},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 18},
  {3, 11},
  {3, 12},
  {1, 8},
  {2, 5},
  {2, 15},
  {2, 3},
  {1, 4},
  {1, 8},
  {1, 5},
  {2, 15},
  {1, 8},
  {1, 3},
  {1, 15},
  {1, 8},
  {1, 12},
  {2, 5},
  {1, 15},
  {1, 21},
  {1, 18},
  {1, 23},
  {3, 30},
  {1, 18},
  {2, 12},
  {2, 3},
  {3, 4},
  {1, 5},
  {1, 4},
  {38, 1},
  {1, 5},
  {1, 15},
  {53, 1},
  {1, 5},
  {3, 4},
  {3, 5},
  {1, 4},
  {3, 5},
  {1, 12},
  {2, 30},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 15},
  {2, 4},
  {1, 5},
  {1, 8},
  {1, 11},
  {1, 15},
  {3, 12},
  {1, 15},
  {2, 21},
  {1, 11},
  {1, 12},
  {1, 5},
  {3, 4},
  {1, 1},
  {1, 3},
  {1, 9},
  {1, 13},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 28},
  {2, 16},
  {3, 18},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 21},
  {2, 14},
  {1, 16},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 13},
  {2, 11},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 9},
  {1, 15},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 7},
  {6, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {16, 7},
  {1, 3},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {6, 4},
  {160, 0},
  {160, 0},
  {5, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {4, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {11, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {8, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {3, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {4, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {3, 26},
  {5, 16},
  {1, 18},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 32},
  {1, 21},
  {1, 14},
  {1, 11},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 11},
  {2, 12},
  {1, 11},
  {3, 3},
  {1, 15},
  {1, 9},
  {1, 3},
  {2, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 11},
  {2, 15},
  {1, 9},
  {2, 12},
  {1, 21},
  {1, 32},
  {2, 30},
  {1, 23},
  {1, 3},
  {1, 12},
  {1, 5},
  {4, 4},
  {1, 1},
  {1, 5},
  {40, 1},
  {3, 5},
  {54, 1},
  {1, 5},
  {1, 4},
  {3, 5},
  {2, 4},
  {2, 3},
  {2, 12},
  {1, 14},
  {1, 30},
  {1, 31},
  {1, 32},
  {2, 21},
  {1, 16},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 15},
  {2, 12},
  {1, 15},
  {2, 11},
  {1, 21},
  {1, 15},
  {4, 3},
  {3, 4},
  {2, 15},
  {1, 8},
  {1, 6},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {2, 29},
  {2, 19},
  {1, 31},
  {1, 28},
  {2, 12},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {2, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 18},
  {4, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 11},
  {1, 6},
  {2, 13},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {2, 2},
  {3, 9},
  {1, 2},
  {1, 9},
  {2, 8},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {7, 7},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {2, 3},
  {1, 8},
  {6, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {4, 7},
  {1, 9},
  {1, 7},
  {9, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 11},
  {1, 6},
  {3, 11},
  {6, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 28},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 25},
  {3, 26},
  {2, 23},
  {3, 16},
  {1, 12},
  {1, 31},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 23},
  {1, 13},
  {1, 2},
  {1, 7},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 8},
  {1, 4},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 5},
  {2, 12},
  {2, 11},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 14},
  {2, 30},
  {1, 28},
  {1, 7},
  {1, 3},
  {1, 5},
  {1, 4},
  {2, 5},
  {102, 1},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 3},
  {1, 5},
  {1, 8},
  {1, 21},
  {1, 30},
  {1, 31},
  {1, 32},
  {1, 16},
  {1, 12},
  {1, 3},
  {2, 8},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 8},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 10},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 16},
  {2, 14},
  {1, 23},
  {2, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 21},
  {2, 16},
  {2, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 13},
  {1, 11},
  {4, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 11},
  {8, 2},
  {1, 8},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {3, 8},
  {2, 2},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {8, 7},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 5},
  {6, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 15},
  {1, 5},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {5, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {5, 13},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 27},
  {1, 22},
  {2, 26},
  {5, 16},
  {1, 18},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 29},
  {2, 23},
  {1, 14},
  {1, 21},
  {1, 15},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {2, 4},
  {1, 15},
  {2, 8},
  {2, 3},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 14},
  {1, 32},
  {2, 30},
  {1, 16},
  {1, 12},
  {1, 5},
  {1, 3},
  {2, 4},
  {52, 1},
  {1, 15},
  {1, 5},
  {3, 1},
  {1, 15},
  {1, 5},
  {49, 1},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 8},
  {1, 16},
  {1, 23},
  {2, 30},
  {1, 28},
  {1, 9},
  {1, 11},
  {1, 8},
  {2, 12},
  {1, 3},
  {1, 11},
  {2, 12},
  {1, 5},
  {3, 4},
  {2, 3},
  {1, 12},
  {1, 11},
  {1, 28},
  {1, 15},
  {1, 5},
  {1, 8},
  {1, 10},
  {1, 8},
  {1, 12},
  {2, 16},
  {2, 23},
  {1, 32},
  {1, 25},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 16},
  {1, 12},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {7, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {10, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {8, 7},
  {7, 10},
  {1, 3},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 3},
  {2, 5},
  {1, 12},
  {1, 4},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {4, 10},
  {2, 7},
  {1, 10},
  {6, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {3, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {6, 2},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 16},
  {1, 12},
  {7, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {2, 14},
  {2, 18},
  {1, 14},
  {1, 12},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 26},
  {3, 16},
  {1, 6},
  {1, 21},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 14},
  {1, 13},
  {1, 11},
  {1, 15},
  {1, 7},
  {2, 3},
  {1, 12},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 2},
  {1, 11},
  {4, 12},
  {1, 11},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 23},
  {2, 30},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 3},
  {52, 1},
  {3, 5},
  {2, 1},
  {2, 5},
  {5, 1},
  {1, 5},
  {1, 15},
  {46, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 30},
  {1, 31},
  {1, 30},
  {1, 15},
  {1, 16},
  {4, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 8},
  {3, 15},
  {1, 12},
  {1, 3},
  {1, 10},
  {4, 3},
  {1, 21},
  {2, 14},
  {1, 23},
  {1, 28},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 16},
  {1, 12},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 21},
  {5, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {5, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {22, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 7},
  {7, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {8, 7},
  {4, 10},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {2, 5},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 1},
  {3, 7},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {7, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 12},
  {5, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {4, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {3, 18},
  {1, 21},
  {1, 30},
  {3, 19},
  {1, 29},
  {1, 27},
  {2, 26},
  {5, 16},
  {1, 14},
  {1, 31},
  {3, 20},
  {1, 29},
  {1, 27},
  {1, 32},
  {2, 14},
  {1, 16},
  {1, 7},
  {2, 15},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 11},
  {2, 8},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 6},
  {1, 15},
  {3, 12},
  {1, 6},
  {2, 14},
  {1, 23},
  {1, 30},
  {1, 32},
  {1, 14},
  {1, 16},
  {1, 12},
  {2, 5},
  {1, 3},
  {1, 5},
  {1, 4},
  {63, 1},
  {3, 5},
  {46, 1},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {5, 5},
  {1, 28},
  {2, 31},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 15},
  {2, 11},
  {4, 15},
  {1, 6},
  {2, 12},
  {1, 11},
  {1, 12},
  {2, 3},
  {1, 7},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 28},
  {1, 16},
  {1, 12},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 18},
  {4, 14},
  {1, 18},
  {2, 13},
  {1, 18},
  {3, 13},
  {1, 2},
  {2, 11},
  {2, 2},
  {1, 11},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {4, 2},
  {1, 15},
  {1, 8},
  {10, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 6},
  {1, 10},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {8, 7},
  {5, 10},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 5},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {3, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {4, 7},
  {4, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {4, 6},
  {1, 2},
  {6, 6},
  {2, 11},
  {1, 2},
  {3, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 21},
  {1, 28},
  {3, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 26},
  {1, 23},
  {3, 16},
  {1, 12},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 23},
  {1, 18},
  {1, 13},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 15},
  {1, 2},
  {1, 5},
  {1, 12},
  {1, 4},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 6},
  {1, 2},
  {1, 3},
  {2, 12},
  {1, 16},
  {1, 30},
  {1, 27},
  {1, 21},
  {1, 13},
  {1, 3},
  {2, 5},
  {1, 4},
  {115, 1},
  {1, 5},
  {2, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {3, 5},
  {1, 11},
  {1, 28},
  {1, 31},
  {1, 30},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 28},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 8},
  {3, 12},
  {1, 6},
  {1, 15},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 5},
  {1, 21},
  {1, 15},
  {2, 7},
  {2, 2},
  {2, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 31},
  {1, 21},
  {3, 16},
  {2, 14},
  {1, 23},
  {1, 32},
  {2, 27},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 21},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {4, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {12, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 10},
  {3, 9},
  {9, 7},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {3, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {1, 5},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 15},
  {1, 1},
  {2, 7},
  {1, 3},
  {8, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 8},
  {1, 9},
  {3, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {6, 6},
  {1, 8},
  {7, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 2},
  {3, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {5, 18},
  {1, 28},
  {3, 19},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 23},
  {5, 16},
  {1, 30},
  {2, 20},
  {2, 17},
  {1, 32},
  {1, 23},
  {1, 12},
  {1, 16},
  {2, 18},
  {1, 8},
  {1, 12},
  {1, 2},
  {1, 8},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 13},
  {2, 12},
  {1, 11},
  {1, 9},
  {1, 4},
  {2, 11},
  {1, 16},
  {1, 21},
  {2, 30},
  {1, 12},
  {1, 5},
  {1, 12},
  {3, 4},
  {43, 1},
  {1, 15},
  {1, 5},
  {56, 1},
  {1, 15},
  {1, 5},
  {23, 1},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 31},
  {1, 30},
  {1, 14},
  {3, 16},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 5},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 21},
  {2, 8},
  {1, 3},
  {1, 2},
  {1, 28},
  {1, 5},
  {1, 4},
  {2, 1},
  {1, 7},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 23},
  {1, 18},
  {1, 12},
  {1, 13},
  {1, 18},
  {1, 21},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 13},
  {3, 14},
  {2, 18},
  {1, 14},
  {3, 13},
  {5, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {4, 2},
  {1, 15},
  {1, 9},
  {6, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {8, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {1, 9},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 1},
  {2, 3},
  {4, 10},
  {1, 3},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 9},
  {5, 7},
  {6, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {7, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {6, 13},
  {2, 18},
  {1, 13},
  {1, 14},
  {2, 18},
  {1, 15},
  {1, 28},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 22},
  {2, 26},
  {2, 23},
  {2, 16},
  {1, 12},
  {1, 4},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 2},
  {2, 8},
  {1, 21},
  {1, 13},
  {2, 8},
  {1, 12},
  {1, 8},
  {1, 2},
  {2, 12},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 12},
  {1, 11},
  {2, 21},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 21},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 12},
  {3, 3},
  {1, 4},
  {43, 1},
  {2, 5},
  {56, 1},
  {3, 5},
  {25, 1},
  {1, 5},
  {1, 3},
  {3, 5},
  {1, 16},
  {2, 30},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {2, 15},
  {1, 16},
  {1, 15},
  {1, 11},
  {1, 21},
  {1, 28},
  {1, 2},
  {1, 5},
  {1, 15},
  {1, 21},
  {2, 15},
  {1, 4},
  {2, 1},
  {1, 3},
  {1, 12},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 14},
  {1, 16},
  {1, 6},
  {1, 13},
  {1, 16},
  {2, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {1, 18},
  {2, 16},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {4, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 2},
  {2, 11},
  {2, 2},
  {9, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {24, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {4, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {2, 3},
  {1, 10},
  {1, 7},
  {8, 10},
  {2, 7},
  {1, 10},
  {4, 7},
  {1, 9},
  {4, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {7, 8},
  {1, 2},
  {6, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 12},
  {5, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 18},
  {2, 21},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 27},
  {2, 26},
  {6, 16},
  {1, 28},
  {3, 20},
  {1, 24},
  {1, 27},
  {1, 21},
  {1, 14},
  {1, 16},
  {1, 6},
  {1, 2},
  {1, 12},
  {1, 13},
  {1, 21},
  {2, 12},
  {2, 8},
  {1, 6},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 12},
  {2, 6},
  {2, 11},
  {1, 12},
  {3, 16},
  {1, 14},
  {2, 30},
  {1, 28},
  {1, 2},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 5},
  {94, 1},
  {1, 15},
  {1, 5},
  {5, 1},
  {1, 5},
  {27, 1},
  {3, 4},
  {1, 3},
  {2, 12},
  {1, 28},
  {1, 31},
  {1, 28},
  {2, 16},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 5},
  {3, 12},
  {1, 15},
  {2, 12},
  {1, 9},
  {3, 15},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 2},
  {1, 15},
  {1, 2},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 14},
  {1, 16},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 21},
  {5, 14},
  {1, 16},
  {1, 13},
  {1, 18},
  {4, 13},
  {3, 11},
  {2, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {13, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {7, 7},
  {1, 9},
  {8, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 5},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {3, 7},
  {1, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {9, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {4, 6},
  {1, 12},
  {1, 16},
  {6, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 18},
  {3, 13},
  {2, 18},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 27},
  {3, 26},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 6},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 31},
  {1, 27},
  {2, 23},
  {1, 16},
  {1, 12},
  {1, 9},
  {1, 8},
  {2, 12},
  {1, 18},
  {1, 13},
  {4, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 16},
  {5, 12},
  {1, 16},
  {1, 32},
  {2, 30},
  {1, 15},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {96, 1},
  {3, 5},
  {33, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {3, 12},
  {1, 28},
  {2, 30},
  {1, 14},
  {2, 16},
  {2, 12},
  {1, 3},
  {1, 4},
  {2, 8},
  {1, 6},
  {3, 15},
  {1, 12},
  {1, 11},
  {2, 3},
  {1, 1},
  {2, 15},
  {1, 9},
  {1, 3},
  {1, 9},
  {1, 12},
  {1, 18},
  {1, 23},
  {2, 27},
  {1, 17},
  {2, 20},
  {1, 31},
  {1, 18},
  {2, 16},
  {1, 6},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 28},
  {2, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {5, 13},
  {5, 11},
  {1, 2},
  {6, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {15, 7},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 5},
  {5, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 5},
  {4, 4},
  {1, 3},
  {5, 10},
  {1, 8},
  {1, 3},
  {2, 10},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {8, 9},
  {1, 8},
  {1, 9},
  {6, 8},
  {1, 2},
  {7, 9},
  {4, 2},
  {1, 8},
  {11, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {8, 6},
  {2, 11},
  {1, 6},
  {5, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 22},
  {1, 26},
  {1, 23},
  {4, 16},
  {1, 12},
  {1, 21},
  {1, 31},
  {1, 19},
  {2, 17},
  {1, 32},
  {1, 23},
  {2, 14},
  {1, 21},
  {1, 18},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 18},
  {1, 6},
  {2, 12},
  {2, 11},
  {1, 15},
  {4, 12},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 28},
  {1, 31},
  {1, 30},
  {2, 15},
  {2, 5},
  {2, 4},
  {1, 5},
  {40, 1},
  {1, 15},
  {10, 1},
  {1, 15},
  {1, 5},
  {25, 1},
  {1, 15},
  {1, 5},
  {53, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 15},
  {2, 30},
  {1, 21},
  {1, 16},
  {2, 11},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 28},
  {2, 15},
  {1, 5},
  {1, 11},
  {1, 4},
  {1, 9},
  {3, 15},
  {1, 8},
  {2, 4},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 18},
  {4, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {11, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 7},
  {2, 9},
  {1, 3},
  {1, 15},
  {2, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {10, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 18},
  {2, 14},
  {1, 15},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 29},
  {3, 26},
  {1, 23},
  {3, 16},
  {1, 11},
  {1, 15},
  {1, 31},
  {2, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 18},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 11},
  {2, 12},
  {1, 21},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 5},
  {1, 15},
  {1, 11},
  {4, 12},
  {1, 8},
  {1, 21},
  {1, 28},
  {1, 31},
  {1, 28},
  {1, 8},
  {56, 1},
  {2, 5},
  {26, 1},
  {1, 5},
  {55, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {3, 12},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 28},
  {2, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 30},
  {1, 15},
  {1, 5},
  {2, 4},
  {2, 15},
  {2, 21},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 9},
  {1, 15},
  {1, 2},
  {1, 11},
  {2, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 30},
  {1, 18},
  {2, 13},
  {2, 14},
  {2, 32},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {4, 14},
  {1, 18},
  {1, 16},
  {1, 18},
  {4, 13},
  {3, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 9},
  {1, 15},
  {9, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {4, 9},
  {11, 7},
  {2, 10},
  {2, 7},
  {1, 8},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {7, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 3},
  {5, 4},
  {1, 7},
  {2, 3},
  {5, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {7, 9},
  {1, 10},
  {1, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {9, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {8, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {3, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 29},
  {1, 27},
  {2, 26},
  {5, 16},
  {1, 11},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 14},
  {1, 13},
  {1, 11},
  {1, 9},
  {2, 21},
  {1, 16},
  {1, 18},
  {4, 12},
  {1, 16},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 16},
  {1, 18},
  {1, 30},
  {1, 31},
  {1, 15},
  {1, 12},
  {3, 4},
  {88, 1},
  {1, 15},
  {51, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 16},
  {1, 28},
  {1, 31},
  {1, 28},
  {1, 16},
  {3, 12},
  {1, 11},
  {1, 28},
  {3, 5},
  {1, 3},
  {4, 15},
  {1, 5},
  {1, 8},
  {1, 10},
  {1, 11},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 11},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {2, 20},
  {1, 28},
  {1, 6},
  {1, 16},
  {1, 13},
  {1, 14},
  {2, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 21},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {14, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 8},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {2, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 8},
  {4, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 16},
  {1, 12},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 27},
  {3, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 13},
  {1, 8},
  {1, 5},
  {1, 12},
  {2, 21},
  {1, 16},
  {1, 12},
  {2, 15},
  {1, 8},
  {2, 12},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 8},
  {1, 5},
  {1, 8},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 12},
  {1, 8},
  {1, 3},
  {89, 1},
  {1, 5},
  {5, 1},
  {1, 15},
  {16, 1},
  {1, 5},
  {1, 15},
  {28, 1},
  {2, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {2, 12},
  {1, 14},
  {1, 31},
  {1, 30},
  {1, 14},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 9},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 2},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 28},
  {1, 16},
  {1, 6},
  {1, 16},
  {3, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 14},
  {2, 18},
  {2, 14},
  {1, 16},
  {1, 18},
  {3, 13},
  {4, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {12, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {4, 9},
  {11, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {10, 3},
  {2, 7},
  {1, 3},
  {3, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {3, 7},
  {1, 10},
  {3, 9},
  {3, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {5, 2},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {9, 2},
  {1, 15},
  {1, 9},
  {3, 2},
  {1, 11},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {4, 2},
  {2, 11},
  {1, 13},
  {1, 11},
  {4, 13},
  {2, 18},
  {1, 14},
  {4, 18},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 13},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 14},
  {2, 16},
  {2, 12},
  {1, 9},
  {1, 11},
  {3, 12},
  {1, 16},
  {1, 28},
  {1, 11},
  {1, 16},
  {1, 21},
  {2, 14},
  {1, 4},
  {2, 15},
  {2, 12},
  {1, 16},
  {1, 12},
  {1, 14},
  {2, 30},
  {1, 21},
  {3, 5},
  {1, 4},
  {36, 1},
  {1, 15},
  {41, 1},
  {1, 15},
  {16, 1},
  {1, 5},
  {16, 1},
  {3, 5},
  {30, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 12},
  {1, 18},
  {1, 31},
  {1, 30},
  {1, 14},
  {2, 21},
  {1, 5},
  {1, 15},
  {1, 3},
  {1, 11},
  {1, 21},
  {2, 5},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {3, 3},
  {3, 7},
  {1, 8},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 14},
  {1, 6},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 15},
  {1, 18},
  {2, 14},
  {3, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 6},
  {1, 13},
  {3, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {4, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {9, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {6, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 5},
  {3, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {2, 7},
  {4, 9},
  {1, 7},
  {1, 8},
  {4, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {4, 2},
  {1, 9},
  {1, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {4, 2},
  {1, 11},
  {1, 2},
  {4, 13},
  {1, 18},
  {1, 16},
  {2, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 23},
  {2, 14},
  {1, 13},
  {1, 15},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 21},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 8},
  {4, 12},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 11},
  {2, 12},
  {2, 16},
  {1, 12},
  {2, 14},
  {2, 30},
  {1, 11},
  {1, 10},
  {1, 3},
  {1, 4},
  {144, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {6, 5},
  {1, 12},
  {1, 16},
  {1, 31},
  {1, 30},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 15},
  {2, 21},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 12},
  {1, 6},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 10},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 6},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 24},
  {2, 20},
  {1, 30},
  {1, 21},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 32},
  {2, 27},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {5, 13},
  {2, 11},
  {1, 13},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {9, 2},
  {1, 9},
  {8, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {7, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {9, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {3, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {8, 2},
  {1, 8},
  {9, 2},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 24},
  {2, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 28},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 5},
  {8, 12},
  {1, 15},
  {1, 12},
  {2, 3},
  {1, 12},
  {2, 16},
  {1, 23},
  {2, 30},
  {1, 16},
  {1, 11},
  {1, 4},
  {1, 3},
  {1, 4},
  {72, 1},
  {1, 15},
  {1, 5},
  {73, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 21},
  {2, 30},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 15},
  {2, 5},
  {1, 3},
  {2, 8},
  {1, 15},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {1, 21},
  {1, 23},
  {1, 14},
  {1, 32},
  {1, 27},
  {2, 17},
  {1, 20},
  {1, 30},
  {1, 14},
  {1, 12},
  {1, 13},
  {2, 14},
  {1, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 15},
  {4, 14},
  {1, 18},
  {1, 14},
  {3, 13},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 9},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {2, 10},
  {7, 7},
  {1, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 9},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {5, 10},
  {3, 7},
  {3, 10},
  {3, 7},
  {3, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 12},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {4, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {3, 18},
  {1, 1},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 14},
  {1, 13},
  {2, 15},
  {1, 31},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 5},
  {1, 8},
  {1, 18},
  {5, 12},
  {1, 8},
  {1, 11},
  {1, 3},
  {1, 11},
  {3, 16},
  {1, 21},
  {2, 30},
  {1, 11},
  {1, 3},
  {1, 1},
  {1, 5},
  {64, 1},
  {1, 15},
  {41, 1},
  {1, 5},
  {1, 15},
  {41, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 7},
  {1, 14},
  {2, 30},
  {1, 11},
  {2, 15},
  {1, 4},
  {3, 8},
  {1, 12},
  {2, 15},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 21},
  {2, 9},
  {2, 4},
  {1, 10},
  {2, 15},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 30},
  {1, 27},
  {2, 17},
  {1, 20},
  {1, 32},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {3, 14},
  {1, 16},
  {3, 18},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 9},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {9, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {3, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 15},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {8, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 6},
  {5, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 26},
  {2, 23},
  {2, 16},
  {1, 13},
  {1, 18},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 22},
  {1, 23},
  {1, 26},
  {2, 16},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 3},
  {1, 12},
  {2, 21},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 15},
  {1, 2},
  {1, 4},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {2, 30},
  {1, 16},
  {1, 12},
  {2, 5},
  {1, 4},
  {107, 1},
  {2, 5},
  {44, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 8},
  {1, 18},
  {2, 30},
  {1, 21},
  {1, 11},
  {3, 12},
  {1, 2},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 15},
  {1, 28},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 21},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 32},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {6, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {11, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {3, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {10, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {2, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 18},
  {1, 6},
  {1, 28},
  {1, 31},
  {2, 19},
  {1, 29},
  {3, 26},
  {1, 23},
  {2, 14},
  {1, 7},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {3, 12},
  {1, 11},
  {3, 12},
  {1, 5},
  {2, 15},
  {1, 11},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 14},
  {1, 31},
  {1, 30},
  {1, 2},
  {2, 3},
  {127, 1},
  {1, 5},
  {1, 15},
  {31, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 21},
  {2, 30},
  {1, 18},
  {1, 16},
  {1, 12},
  {2, 15},
  {1, 2},
  {2, 8},
  {1, 3},
  {2, 8},
  {1, 12},
  {1, 2},
  {1, 4},
  {2, 3},
  {1, 9},
  {1, 3},
  {1, 11},
  {2, 21},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 23},
  {2, 14},
  {2, 18},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 18},
  {5, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {8, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 8},
  {2, 9},
  {8, 7},
  {2, 10},
  {2, 7},
  {1, 3},
  {1, 8},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {5, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 10},
  {2, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {11, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {2, 18},
  {1, 14},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 14},
  {2, 16},
  {2, 14},
  {2, 15},
  {2, 12},
  {2, 11},
  {1, 12},
  {1, 3},
  {3, 12},
  {1, 15},
  {1, 16},
  {2, 11},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 21},
  {2, 30},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {127, 1},
  {2, 5},
  {33, 1},
  {1, 5},
  {1, 1},
  {1, 21},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 21},
  {2, 11},
  {3, 3},
  {1, 8},
  {1, 4},
  {2, 8},
  {1, 4},
  {1, 3},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 2},
  {1, 21},
  {1, 18},
  {1, 16},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 30},
  {1, 14},
  {1, 12},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 21},
  {2, 14},
  {2, 18},
  {1, 14},
  {6, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 2},
  {3, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {5, 2},
  {1, 15},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 8},
  {6, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {3, 9},
  {2, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {3, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 9},
  {5, 2},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 16},
  {6, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 13},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 12},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 14},
  {1, 11},
  {2, 15},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 11},
  {1, 16},
  {4, 12},
  {1, 11},
  {3, 12},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 6},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 16},
  {1, 7},
  {1, 3},
  {34, 1},
  {1, 15},
  {87, 1},
  {1, 5},
  {1, 15},
  {42, 1},
  {2, 5},
  {1, 15},
  {2, 30},
  {1, 21},
  {1, 16},
  {2, 12},
  {2, 8},
  {2, 3},
  {1, 4},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 12},
  {3, 15},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 32},
  {1, 13},
  {1, 15},
  {1, 18},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 14},
  {3, 18},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 9},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 9},
  {7, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {5, 10},
  {1, 3},
  {2, 10},
  {2, 7},
  {2, 10},
  {4, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {3, 2},
  {2, 8},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 11},
  {3, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {3, 18},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 11},
  {1, 30},
  {2, 19},
  {1, 17},
  {1, 32},
  {1, 26},
  {2, 14},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 16},
  {2, 5},
  {1, 15},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 15},
  {2, 12},
  {2, 4},
  {1, 3},
  {2, 12},
  {1, 16},
  {1, 21},
  {2, 30},
  {1, 21},
  {1, 15},
  {1, 5},
  {124, 1},
  {2, 5},
  {42, 1},
  {1, 3},
  {1, 2},
  {1, 21},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 11},
  {1, 12},
  {2, 8},
  {2, 3},
  {1, 9},
  {1, 3},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 8},
  {2, 15},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 14},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 13},
  {1, 18},
  {6, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {12, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 9},
  {1, 2},
  {11, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {4, 9},
  {15, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {9, 10},
  {6, 7},
  {3, 9},
  {3, 7},
  {5, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {8, 2},
  {1, 9},
  {4, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {5, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 15},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 2},
  {1, 1},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 15},
  {2, 21},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 9},
  {1, 8},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 21},
  {2, 30},
  {1, 18},
  {1, 12},
  {1, 3},
  {26, 1},
  {1, 15},
  {142, 1},
  {3, 5},
  {1, 21},
  {1, 31},
  {1, 28},
  {1, 13},
  {1, 16},
  {2, 8},
  {1, 5},
  {1, 12},
  {2, 3},
  {2, 12},
  {1, 15},
  {2, 12},
  {2, 15},
  {1, 3},
  {1, 8},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 21},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 6},
  {3, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 11},
  {3, 13},
  {1, 6},
  {2, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {2, 2},
  {1, 6},
  {11, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {8, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {15, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 15},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {4, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 2},
  {5, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 13},
  {2, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {2, 16},
  {2, 11},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 26},
  {1, 14},
  {2, 16},
  {2, 12},
  {1, 28},
  {2, 15},
  {1, 5},
  {1, 12},
  {2, 15},
  {3, 12},
  {1, 11},
  {1, 15},
  {1, 2},
  {1, 3},
  {2, 12},
  {1, 6},
  {1, 28},
  {1, 31},
  {1, 21},
  {59, 1},
  {1, 15},
  {61, 1},
  {1, 15},
  {1, 5},
  {50, 1},
  {1, 4},
  {1, 8},
  {1, 12},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 16},
  {2, 11},
  {1, 28},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 8},
  {1, 11},
  {3, 12},
  {1, 8},
  {1, 15},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 6},
  {1, 18},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 20},
  {1, 28},
  {1, 18},
  {1, 6},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {4, 13},
  {2, 6},
  {2, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {8, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {10, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 10},
  {4, 9},
  {14, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {7, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {5, 7},
  {1, 9},
  {1, 7},
  {10, 9},
  {5, 8},
  {1, 2},
  {1, 8},
  {7, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {12, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {8, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {3, 11},
  {6, 13},
  {3, 14},
  {1, 18},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {2, 14},
  {1, 2},
  {1, 15},
  {1, 1},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {2, 23},
  {1, 21},
  {1, 28},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 28},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 3},
  {2, 12},
  {2, 11},
  {2, 12},
  {1, 11},
  {1, 28},
  {1, 31},
  {1, 21},
  {1, 7},
  {50, 1},
  {1, 15},
  {12, 1},
  {1, 15},
  {108, 1},
  {3, 5},
  {2, 12},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 15},
  {1, 21},
  {1, 30},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 12},
  {3, 8},
  {1, 12},
  {2, 3},
  {1, 9},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 21},
  {3, 16},
  {3, 23},
  {1, 26},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 13},
  {1, 18},
  {4, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 9},
  {1, 15},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {1, 15},
  {10, 9},
  {1, 7},
  {4, 9},
  {2, 10},
  {19, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 7},
  {2, 3},
  {5, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {5, 9},
  {1, 7},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 14},
  {2, 16},
  {1, 13},
  {1, 7},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 14},
  {2, 16},
  {1, 28},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 15},
  {2, 5},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 5},
  {2, 12},
  {1, 8},
  {2, 13},
  {1, 28},
  {1, 31},
  {1, 21},
  {1, 9},
  {1, 7},
  {138, 1},
  {1, 15},
  {11, 1},
  {1, 15},
  {1, 5},
  {3, 1},
  {1, 15},
  {1, 5},
  {17, 1},
  {2, 5},
  {1, 8},
  {1, 11},
  {1, 28},
  {1, 31},
  {1, 21},
  {1, 16},
  {1, 5},
  {1, 15},
  {1, 6},
  {1, 12},
  {2, 8},
  {1, 3},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 11},
  {2, 8},
  {1, 15},
  {1, 9},
  {2, 11},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 31},
  {1, 17},
  {1, 20},
  {1, 31},
  {2, 16},
  {2, 13},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 31},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {3, 13},
  {1, 18},
  {1, 6},
  {2, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 9},
  {3, 7},
  {2, 9},
  {1, 15},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {15, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {5, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 2},
  {3, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {1, 15},
  {5, 9},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 15},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 13},
  {1, 16},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 21},
  {1, 15},
  {1, 20},
  {2, 19},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 6},
  {1, 7},
  {1, 5},
  {1, 31},
  {2, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 28},
  {1, 21},
  {2, 8},
  {2, 3},
  {1, 15},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 11},
  {1, 6},
  {1, 3},
  {2, 12},
  {1, 13},
  {1, 18},
  {1, 31},
  {1, 28},
  {1, 15},
  {1, 7},
  {1, 4},
  {106, 1},
  {1, 15},
  {41, 1},
  {3, 5},
  {2, 1},
  {3, 5},
  {16, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {2, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 13},
  {1, 16},
  {2, 8},
  {1, 12},
  {1, 15},
  {2, 9},
  {1, 3},
  {1, 2},
  {1, 8},
  {2, 12},
  {1, 2},
  {1, 12},
  {1, 11},
  {1, 9},
  {1, 1},
  {1, 3},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 16},
  {2, 14},
  {2, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {4, 13},
  {1, 6},
  {1, 13},
  {3, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {7, 9},
  {3, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {16, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {4, 10},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {3, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 9},
  {2, 7},
  {4, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 2},
  {4, 11},
  {1, 6},
  {2, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 27},
  {2, 26},
  {1, 14},
  {2, 16},
  {2, 6},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 32},
  {1, 23},
  {3, 16},
  {3, 12},
  {1, 21},
  {1, 15},
  {2, 4},
  {2, 3},
  {2, 15},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 18},
  {2, 30},
  {1, 12},
  {1, 3},
  {1, 4},
  {174, 1},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 13},
  {2, 30},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 18},
  {1, 6},
  {1, 15},
  {1, 6},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 2},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 30},
  {1, 17},
  {1, 19},
  {1, 29},
  {1, 21},
  {1, 13},
  {1, 11},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 16},
  {4, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {4, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {5, 2},
  {1, 11},
  {2, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 9},
  {1, 15},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 15},
  {2, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {17, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {10, 3},
  {1, 10},
  {1, 3},
  {7, 10},
  {1, 7},
  {2, 10},
  {3, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 11},
  {3, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {7, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {6, 13},
  {2, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 15},
  {1, 20},
  {2, 19},
  {1, 29},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 18},
  {2, 11},
  {1, 1},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {2, 23},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 12},
  {2, 8},
  {1, 6},
  {1, 15},
  {3, 8},
  {1, 5},
  {1, 12},
  {2, 15},
  {3, 12},
  {1, 11},
  {1, 13},
  {1, 18},
  {2, 30},
  {1, 11},
  {1, 10},
  {1, 3},
  {20, 1},
  {1, 15},
  {56, 1},
  {1, 15},
  {65, 1},
  {1, 5},
  {1, 15},
  {29, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 12},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 16},
  {1, 28},
  {3, 15},
  {1, 2},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 6},
  {1, 11},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 15},
  {1, 9},
  {2, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 24},
  {2, 20},
  {1, 30},
  {1, 14},
  {2, 16},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 21},
  {1, 18},
  {4, 14},
  {1, 16},
  {1, 18},
  {4, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {6, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {7, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {14, 7},
  {1, 9},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 9},
  {3, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 7},
  {9, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {7, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {6, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 27},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 2},
  {1, 11},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 9},
  {1, 12},
  {2, 15},
  {3, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {3, 8},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 8},
  {2, 12},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 15},
  {1, 5},
  {177, 1},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 21},
  {1, 31},
  {1, 21},
  {2, 14},
  {2, 12},
  {2, 15},
  {2, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 2},
  {1, 3},
  {1, 7},
  {1, 15},
  {1, 4},
  {1, 9},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {2, 20},
  {1, 17},
  {1, 21},
  {1, 11},
  {1, 13},
  {2, 14},
  {1, 23},
  {2, 26},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {15, 2},
  {2, 8},
  {1, 9},
  {1, 6},
  {2, 8},
  {1, 2},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {15, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {10, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {3, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {11, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {3, 13},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {3, 26},
  {2, 14},
  {1, 13},
  {1, 7},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 11},
  {2, 12},
  {2, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 15},
  {1, 8},
  {1, 5},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 4},
  {1, 7},
  {114, 1},
  {1, 15},
  {46, 1},
  {1, 5},
  {1, 15},
  {14, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 12},
  {1, 28},
  {1, 31},
  {1, 21},
  {1, 16},
  {1, 12},
  {2, 15},
  {1, 21},
  {2, 12},
  {1, 6},
  {2, 12},
  {1, 3},
  {2, 15},
  {1, 28},
  {1, 15},
  {1, 4},
  {1, 3},
  {1, 16},
  {1, 21},
  {2, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 8},
  {2, 13},
  {1, 14},
  {2, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 21},
  {4, 14},
  {2, 16},
  {1, 13},
  {1, 18},
  {2, 13},
  {2, 11},
  {1, 2},
  {4, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 8},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 7},
  {2, 9},
  {13, 7},
  {1, 10},
  {2, 7},
  {1, 8},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {3, 3},
  {4, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {3, 10},
  {3, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 13},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 24},
  {1, 29},
  {2, 26},
  {4, 16},
  {1, 18},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 26},
  {3, 16},
  {1, 18},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 5},
  {1, 3},
  {2, 18},
  {1, 30},
  {1, 28},
  {2, 5},
  {1, 4},
  {91, 1},
  {1, 15},
  {5, 1},
  {1, 15},
  {63, 1},
  {3, 5},
  {16, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 12},
  {1, 16},
  {1, 30},
  {1, 31},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 8},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 4},
  {1, 12},
  {3, 15},
  {1, 4},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 28},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {5, 14},
  {1, 16},
  {1, 14},
  {2, 13},
  {4, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 2},
  {2, 11},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 9},
  {6, 2},
  {3, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {13, 7},
  {1, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {11, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 10},
  {5, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 1},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {2, 23},
  {1, 16},
  {1, 13},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 23},
  {3, 16},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {3, 3},
  {1, 7},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 11},
  {1, 7},
  {1, 4},
  {44, 1},
  {1, 15},
  {134, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 4},
  {1, 2},
  {1, 11},
  {1, 31},
  {1, 28},
  {2, 11},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 15},
  {1, 5},
  {3, 8},
  {2, 11},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 21},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 23},
  {4, 14},
  {1, 16},
  {1, 14},
  {5, 13},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {8, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 3},
  {8, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {4, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {3, 18},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 17},
  {3, 26},
  {4, 16},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 18},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {3, 12},
  {2, 15},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 21},
  {1, 30},
  {1, 15},
  {87, 1},
  {1, 15},
  {45, 1},
  {1, 15},
  {52, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 9},
  {1, 2},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 12},
  {1, 8},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {2, 17},
  {1, 28},
  {1, 14},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {2, 21},
  {5, 14},
  {1, 16},
  {2, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {10, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {2, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 18},
  {2, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 1},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {3, 26},
  {3, 16},
  {1, 5},
  {1, 30},
  {2, 19},
  {1, 29},
  {1, 26},
  {2, 23},
  {1, 11},
  {1, 15},
  {1, 16},
  {1, 15},
  {4, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {3, 12},
  {1, 11},
  {1, 15},
  {2, 2},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 9},
  {16, 1},
  {1, 15},
  {22, 1},
  {1, 15},
  {35, 1},
  {1, 15},
  {109, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 2},
  {2, 12},
  {2, 30},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 11},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 15},
  {2, 4},
  {1, 12},
  {1, 16},
  {1, 18},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 17},
  {1, 31},
  {1, 23},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 21},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {2, 13},
  {1, 11},
  {1, 13},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 9},
  {3, 8},
  {1, 2},
  {2, 8},
  {7, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {7, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 9},
  {2, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {4, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 17},
  {3, 26},
  {3, 16},
  {1, 12},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 21},
  {1, 12},
  {1, 3},
  {1, 12},
  {2, 8},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 18},
  {1, 16},
  {2, 30},
  {1, 12},
  {1, 3},
  {1, 4},
  {177, 1},
  {1, 15},
  {1, 5},
  {9, 1},
  {2, 4},
  {1, 8},
  {1, 12},
  {1, 13},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 3},
  {2, 12},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 18},
  {2, 6},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 25},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 21},
  {4, 14},
  {1, 18},
  {1, 16},
  {4, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 13},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {2, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 8},
  {3, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {10, 2},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {3, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 14},
  {1, 13},
  {2, 16},
  {1, 14},
  {2, 18},
  {1, 15},
  {1, 7},
  {2, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 21},
  {1, 15},
  {5, 12},
  {1, 15},
  {1, 8},
  {1, 16},
  {1, 11},
  {3, 12},
  {1, 21},
  {1, 32},
  {1, 30},
  {1, 15},
  {1, 3},
  {1, 4},
  {176, 1},
  {3, 5},
  {10, 1},
  {3, 5},
  {2, 15},
  {1, 21},
  {1, 30},
  {2, 21},
  {4, 15},
  {1, 4},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 21},
  {1, 6},
  {1, 12},
  {1, 14},
  {1, 16},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 21},
  {4, 16},
  {1, 23},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 21},
  {2, 14},
  {4, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {3, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 3},
  {1, 7},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {3, 3},
  {2, 4},
  {6, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {13, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 13},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {3, 16},
  {1, 6},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 23},
  {2, 14},
  {1, 18},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 18},
  {2, 8},
  {2, 12},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 8},
  {1, 3},
  {1, 4},
  {31, 1},
  {1, 15},
  {71, 1},
  {1, 15},
  {69, 1},
  {1, 15},
  {1, 5},
  {2, 1},
  {1, 5},
  {12, 1},
  {1, 4},
  {2, 5},
  {1, 1},
  {1, 11},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 18},
  {1, 4},
  {2, 15},
  {2, 12},
  {1, 21},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 9},
  {1, 6},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 30},
  {1, 14},
  {2, 16},
  {2, 23},
  {2, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 18},
  {2, 14},
  {1, 18},
  {2, 13},
  {1, 18},
  {3, 13},
  {2, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {11, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {11, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 7},
  {2, 3},
  {2, 10},
  {1, 7},
  {3, 10},
  {2, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {3, 7},
  {1, 15},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {4, 8},
  {1, 6},
  {3, 8},
  {1, 6},
  {2, 8},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 15},
  {7, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 13},
  {3, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {3, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 15},
  {1, 20},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {2, 23},
  {1, 21},
  {1, 16},
  {1, 15},
  {4, 12},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 6},
  {3, 12},
  {1, 16},
  {1, 12},
  {2, 30},
  {1, 2},
  {1, 3},
  {55, 1},
  {1, 15},
  {67, 1},
  {1, 15},
  {49, 1},
  {3, 5},
  {18, 1},
  {1, 5},
  {1, 15},
  {1, 11},
  {1, 15},
  {2, 30},
  {1, 6},
  {2, 12},
  {1, 11},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 4},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 3},
  {1, 18},
  {1, 2},
  {2, 12},
  {1, 16},
  {2, 23},
  {1, 27},
  {1, 17},
  {2, 20},
  {1, 21},
  {2, 16},
  {2, 14},
  {2, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 21},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 2},
  {1, 13},
  {3, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {14, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {3, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 8},
  {4, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {1, 3},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 9},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {2, 13},
  {1, 14},
  {1, 13},
  {4, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 26},
  {1, 22},
  {4, 16},
  {1, 6},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 8},
  {2, 12},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 32},
  {1, 30},
  {1, 15},
  {1, 1},
  {1, 4},
  {69, 1},
  {1, 15},
  {125, 1},
  {1, 5},
  {1, 3},
  {1, 2},
  {1, 28},
  {1, 31},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 2},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 15},
  {3, 8},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {2, 16},
  {1, 11},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {3, 13},
  {3, 11},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 2},
  {7, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {14, 9},
  {1, 7},
  {2, 9},
  {5, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {9, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {3, 3},
  {2, 4},
  {4, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {3, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {4, 13},
  {1, 16},
  {1, 18},
  {1, 13},
  {2, 14},
  {1, 11},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 6},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {2, 12},
  {1, 16},
  {1, 15},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 21},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 18},
  {1, 30},
  {1, 28},
  {1, 9},
  {1, 4},
  {156, 1},
  {1, 15},
  {40, 1},
  {3, 5},
  {2, 30},
  {2, 16},
  {2, 21},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 9},
  {1, 12},
  {1, 9},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 2},
  {1, 8},
  {3, 12},
  {1, 14},
  {1, 28},
  {1, 27},
  {2, 17},
  {1, 31},
  {1, 21},
  {3, 13},
  {1, 14},
  {3, 26},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 18},
  {1, 14},
  {3, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 11},
  {1, 2},
  {2, 13},
  {3, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 15},
  {3, 2},
  {1, 9},
  {1, 15},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {7, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 8},
  {8, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 15},
  {1, 9},
  {3, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 2},
  {2, 11},
  {2, 13},
  {1, 18},
  {1, 16},
  {4, 14},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 22},
  {2, 23},
  {2, 16},
  {1, 6},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {3, 16},
  {4, 12},
  {1, 16},
  {1, 21},
  {1, 12},
  {1, 11},
  {1, 5},
  {2, 12},
  {2, 21},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 32},
  {1, 30},
  {1, 21},
  {1, 5},
  {1, 4},
  {166, 1},
  {1, 15},
  {32, 1},
  {1, 4},
  {1, 15},
  {1, 31},
  {1, 23},
  {1, 16},
  {2, 21},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 11},
  {1, 15},
  {1, 5},
  {1, 15},
  {2, 2},
  {1, 8},
  {2, 12},
  {1, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 2},
  {1, 13},
  {4, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 10},
  {4, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 15},
  {1, 7},
  {7, 9},
  {1, 7},
  {4, 9},
  {5, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {4, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 2},
  {2, 8},
  {2, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {4, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 13},
  {3, 14},
  {1, 13},
  {1, 5},
  {1, 20},
  {2, 19},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 2},
  {1, 5},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 5},
  {4, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 4},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 10},
  {1, 4},
  {62, 1},
  {1, 15},
  {48, 1},
  {1, 15},
  {69, 1},
  {1, 5},
  {1, 15},
  {16, 1},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 14},
  {1, 21},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 7},
  {1, 15},
  {2, 12},
  {2, 6},
  {1, 2},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 13},
  {2, 14},
  {2, 23},
  {2, 26},
  {1, 17},
  {2, 19},
  {1, 30},
  {1, 18},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 16},
  {2, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 13},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {9, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 15},
  {2, 9},
  {2, 7},
  {6, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {4, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 8},
  {4, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {5, 7},
  {8, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {11, 2},
  {1, 11},
  {4, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 16},
  {1, 18},
  {1, 21},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {2, 16},
  {1, 13},
  {1, 2},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 14},
  {2, 16},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 30},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 5},
  {2, 12},
  {3, 16},
  {1, 28},
  {1, 30},
  {1, 6},
  {1, 8},
  {1, 4},
  {25, 1},
  {1, 15},
  {22, 1},
  {1, 15},
  {91, 1},
  {1, 15},
  {40, 1},
  {3, 5},
  {16, 1},
  {1, 5},
  {1, 8},
  {1, 18},
  {1, 30},
  {1, 28},
  {2, 16},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 2},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 2},
  {1, 15},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 13},
  {1, 21},
  {1, 23},
  {1, 32},
  {1, 29},
  {2, 17},
  {1, 30},
  {1, 16},
  {1, 13},
  {1, 16},
  {2, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 9},
  {7, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 9},
  {1, 3},
  {1, 7},
  {8, 3},
  {1, 4},
  {3, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 11},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 17},
  {2, 26},
  {2, 23},
  {1, 13},
  {1, 2},
  {1, 5},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 11},
  {2, 8},
  {2, 5},
  {1, 28},
  {1, 30},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 15},
  {2, 8},
  {1, 11},
  {1, 14},
  {1, 23},
  {1, 30},
  {1, 18},
  {1, 9},
  {150, 1},
  {1, 15},
  {50, 1},
  {2, 5},
  {1, 8},
  {1, 15},
  {1, 23},
  {1, 31},
  {1, 14},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 11},
  {1, 12},
  {2, 15},
  {1, 9},
  {1, 11},
  {2, 8},
  {1, 6},
  {1, 28},
  {2, 32},
  {1, 27},
  {2, 17},
  {1, 31},
  {1, 18},
  {2, 16},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {5, 14},
  {1, 16},
  {1, 18},
  {4, 13},
  {2, 11},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {8, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 9},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 9},
  {7, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 32},
  {3, 16},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 18},
  {1, 30},
  {1, 28},
  {1, 11},
  {1, 4},
  {44, 1},
  {1, 15},
  {37, 1},
  {1, 15},
  {36, 1},
  {1, 15},
  {83, 1},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 30},
  {1, 28},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 3},
  {2, 12},
  {1, 14},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 16},
  {1, 12},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 18},
  {1, 21},
  {1, 16},
  {2, 14},
  {1, 13},
  {1, 18},
  {5, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 10},
  {4, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 11},
  {2, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {6, 6},
  {1, 2},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {7, 13},
  {1, 14},
  {2, 18},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 7},
  {1, 21},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {2, 12},
  {1, 5},
  {2, 15},
  {1, 8},
  {1, 16},
  {1, 11},
  {2, 15},
  {2, 12},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 21},
  {1, 16},
  {1, 12},
  {2, 30},
  {1, 18},
  {1, 9},
  {11, 1},
  {1, 15},
  {80, 1},
  {1, 15},
  {4, 1},
  {1, 15},
  {35, 1},
  {1, 15},
  {69, 1},
  {1, 4},
  {2, 5},
  {1, 15},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 12},
  {1, 18},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 14},
  {1, 2},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 32},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 18},
  {4, 13},
  {1, 2},
  {1, 13},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {9, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {5, 7},
  {10, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 11},
  {1, 13},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {3, 16},
  {1, 18},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 14},
  {1, 16},
  {2, 21},
  {2, 15},
  {1, 5},
  {1, 12},
  {4, 11},
  {1, 21},
  {5, 12},
  {1, 16},
  {1, 14},
  {1, 30},
  {1, 28},
  {1, 16},
  {1, 5},
  {205, 1},
  {2, 5},
  {1, 9},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 3},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 2},
  {2, 8},
  {1, 11},
  {1, 21},
  {1, 11},
  {1, 16},
  {1, 14},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 32},
  {1, 7},
  {1, 6},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 28},
  {1, 21},
  {3, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 9},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {3, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 10},
  {5, 7},
  {1, 9},
  {3, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 9},
  {10, 2},
  {12, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 15},
  {1, 30},
  {2, 19},
  {1, 17},
  {1, 22},
  {2, 26},
  {2, 14},
  {1, 13},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {3, 15},
  {1, 8},
  {1, 5},
  {1, 12},
  {2, 11},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 6},
  {1, 7},
  {38, 1},
  {1, 15},
  {17, 1},
  {1, 15},
  {70, 1},
  {1, 15},
  {78, 1},
  {2, 5},
  {1, 1},
  {1, 15},
  {1, 30},
  {3, 21},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {2, 21},
  {1, 12},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 12},
  {1, 21},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 30},
  {2, 13},
  {1, 11},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 23},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 14},
  {5, 13},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 10},
  {6, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 10},
  {4, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {11, 9},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 11},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {3, 16},
  {1, 8},
  {2, 4},
  {2, 8},
  {1, 3},
  {1, 12},
  {1, 2},
  {1, 4},
  {1, 12},
  {1, 21},
  {1, 30},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 32},
  {1, 4},
  {1, 3},
  {19, 1},
  {1, 15},
  {48, 1},
  {1, 15},
  {6, 1},
  {1, 15},
  {133, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 14},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 11},
  {3, 12},
  {2, 21},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 25},
  {2, 20},
  {1, 21},
  {1, 12},
  {1, 13},
  {1, 18},
  {1, 21},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {10, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 9},
  {1, 10},
  {3, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 9},
  {5, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {4, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {5, 13},
  {1, 14},
  {1, 13},
  {2, 18},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 12},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 21},
  {2, 11},
  {1, 16},
  {1, 14},
  {2, 30},
  {1, 11},
  {1, 3},
  {100, 1},
  {1, 15},
  {108, 1},
  {1, 4},
  {1, 15},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 14},
  {1, 11},
  {1, 14},
  {4, 12},
  {2, 11},
  {2, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 21},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 12},
  {1, 11},
  {1, 6},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 23},
  {4, 14},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {6, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 9},
  {1, 15},
  {5, 2},
  {1, 9},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {6, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {2, 7},
  {1, 8},
  {1, 7},
  {1, 8},
  {5, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 10},
  {1, 7},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {2, 9},
  {4, 7},
  {3, 9},
  {1, 8},
  {1, 7},
  {4, 9},
  {1, 2},
  {3, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 11},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 30},
  {2, 19},
  {1, 17},
  {3, 26},
  {2, 16},
  {1, 11},
  {1, 13},
  {1, 30},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {2, 4},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 14},
  {1, 23},
  {1, 31},
  {1, 28},
  {1, 8},
  {1, 7},
  {31, 1},
  {1, 15},
  {72, 1},
  {1, 15},
  {56, 1},
  {1, 15},
  {48, 1},
  {1, 3},
  {1, 6},
  {2, 30},
  {1, 14},
  {1, 16},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 14},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 29},
  {1, 15},
  {1, 2},
  {2, 13},
  {2, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 15},
  {3, 14},
  {1, 16},
  {2, 14},
  {2, 16},
  {1, 13},
  {1, 16},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {2, 9},
  {3, 2},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {4, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {4, 7},
  {2, 10},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {5, 7},
  {1, 9},
  {1, 7},
  {9, 9},
  {1, 3},
  {1, 15},
  {1, 9},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 9},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {4, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 21},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 2},
  {1, 12},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 16},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 16},
  {2, 30},
  {1, 13},
  {1, 7},
  {62, 1},
  {1, 15},
  {25, 1},
  {1, 15},
  {87, 1},
  {1, 15},
  {33, 1},
  {2, 5},
  {1, 12},
  {1, 14},
  {1, 30},
  {1, 23},
  {1, 14},
  {1, 21},
  {1, 14},
  {5, 12},
  {2, 15},
  {2, 12},
  {1, 21},
  {1, 16},
  {1, 6},
  {2, 13},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 6},
  {1, 2},
  {2, 14},
  {2, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {5, 13},
  {1, 2},
  {1, 13},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {17, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {7, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {2, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 8},
  {3, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {8, 10},
  {2, 7},
  {1, 10},
  {4, 7},
  {2, 9},
  {4, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 15},
  {1, 3},
  {2, 9},
  {1, 8},
  {1, 3},
  {3, 2},
  {1, 8},
  {10, 2},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 11},
  {5, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 13},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {1, 23},
  {1, 16},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 5},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 11},
  {1, 4},
  {83, 1},
  {1, 15},
  {26, 1},
  {1, 15},
  {75, 1},
  {1, 15},
  {1, 5},
  {23, 1},
  {1, 5},
  {1, 4},
  {1, 6},
  {2, 28},
  {1, 14},
  {1, 28},
  {1, 30},
  {2, 21},
  {1, 16},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 14},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 8},
  {2, 6},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 22},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 21},
  {5, 14},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 15},
  {1, 9},
  {12, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {3, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {4, 7},
  {1, 9},
  {5, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 8},
  {1, 3},
  {5, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {6, 2},
  {1, 9},
  {7, 2},
  {1, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 16},
  {1, 6},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 13},
  {3, 15},
  {1, 4},
  {2, 15},
  {2, 12},
  {1, 15},
  {1, 4},
  {1, 12},
  {1, 6},
  {1, 21},
  {1, 12},
  {1, 21},
  {1, 28},
  {1, 31},
  {1, 15},
  {1, 7},
  {169, 1},
  {1, 15},
  {15, 1},
  {2, 5},
  {24, 1},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 6},
  {1, 18},
  {1, 30},
  {1, 21},
  {1, 23},
  {1, 28},
  {1, 16},
  {1, 12},
  {1, 28},
  {1, 21},
  {3, 12},
  {2, 21},
  {2, 12},
  {1, 21},
  {1, 6},
  {1, 8},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 16},
  {3, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 23},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {4, 13},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 9},
  {12, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 7},
  {6, 10},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {11, 10},
  {4, 7},
  {3, 9},
  {5, 7},
  {4, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {9, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {5, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 32},
  {1, 23},
  {3, 16},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 14},
  {2, 11},
  {2, 15},
  {1, 3},
  {1, 12},
  {1, 21},
  {1, 16},
  {2, 12},
  {2, 3},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 6},
  {1, 30},
  {1, 28},
  {1, 15},
  {1, 5},
  {213, 1},
  {1, 4},
  {1, 3},
  {1, 6},
  {1, 30},
  {1, 28},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 21},
  {1, 30},
  {1, 4},
  {3, 12},
  {1, 21},
  {1, 16},
  {1, 8},
  {1, 15},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 25},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 12},
  {2, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 18},
  {3, 14},
  {1, 18},
  {5, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 13},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {10, 2},
  {1, 15},
  {1, 9},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {6, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {2, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {3, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 3},
  {1, 15},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {2, 26},
  {2, 14},
  {1, 7},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 18},
  {1, 21},
  {1, 15},
  {1, 16},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 2},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 1},
  {1, 21},
  {1, 31},
  {1, 18},
  {1, 4},
  {25, 1},
  {1, 15},
  {24, 1},
  {1, 15},
  {89, 1},
  {1, 15},
  {71, 1},
  {1, 4},
  {3, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 15},
  {2, 21},
  {1, 16},
  {2, 12},
  {1, 8},
  {1, 11},
  {2, 8},
  {1, 15},
  {1, 12},
  {3, 16},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 16},
  {1, 6},
  {2, 23},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {3, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {2, 13},
  {4, 11},
  {1, 2},
  {3, 11},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {1, 15},
  {2, 2},
  {1, 9},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 10},
  {1, 15},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {6, 10},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {6, 10},
  {1, 3},
  {2, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {4, 7},
  {2, 9},
  {1, 8},
  {1, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 11},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 11},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 13},
  {3, 18},
  {1, 13},
  {1, 30},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {1, 26},
  {1, 14},
  {2, 16},
  {1, 11},
  {1, 21},
  {2, 11},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 14},
  {1, 12},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 28},
  {1, 10},
  {1, 4},
  {116, 1},
  {1, 15},
  {97, 1},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 16},
  {1, 31},
  {1, 28},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 8},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 16},
  {1, 23},
  {2, 26},
  {1, 24},
  {1, 17},
  {1, 20},
  {1, 21},
  {2, 16},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 25},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {4, 13},
  {2, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {5, 2},
  {2, 9},
  {5, 2},
  {1, 15},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 7},
  {10, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {5, 10},
  {4, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {1, 3},
  {1, 7},
  {2, 9},
  {1, 3},
  {5, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {3, 11},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 1},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {3, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 18},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 13},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 7},
  {44, 1},
  {1, 15},
  {32, 1},
  {1, 15},
  {73, 1},
  {1, 15},
  {29, 1},
  {1, 15},
  {31, 1},
  {1, 4},
  {3, 5},
  {1, 12},
  {1, 5},
  {2, 30},
  {1, 11},
  {2, 8},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {3, 2},
  {1, 3},
  {1, 2},
  {1, 3},
  {1, 4},
  {2, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 13},
  {2, 11},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 22},
  {1, 20},
  {2, 19},
  {1, 28},
  {4, 14},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {4, 11},
  {1, 2},
  {2, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {5, 2},
  {1, 9},
  {2, 2},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {11, 7},
  {3, 9},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 7},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 11},
  {1, 9},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {2, 16},
  {2, 12},
  {1, 3},
  {1, 15},
  {1, 28},
  {1, 5},
  {2, 12},
  {1, 28},
  {1, 16},
  {1, 12},
  {1, 5},
  {1, 21},
  {1, 15},
  {1, 4},
  {1, 16},
  {1, 21},
  {1, 30},
  {2, 15},
  {1, 5},
  {13, 1},
  {1, 15},
  {23, 1},
  {1, 15},
  {32, 1},
  {1, 15},
  {34, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {106, 1},
  {3, 5},
  {1, 4},
  {1, 15},
  {1, 30},
  {1, 21},
  {3, 15},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 15},
  {2, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 29},
  {1, 3},
  {1, 11},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 9},
  {5, 2},
  {3, 9},
  {1, 2},
  {3, 9},
  {6, 2},
  {2, 8},
  {5, 9},
  {1, 7},
  {2, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {2, 10},
  {1, 3},
  {4, 10},
  {2, 7},
  {1, 10},
  {10, 7},
  {1, 3},
  {2, 9},
  {1, 7},
  {1, 8},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 15},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {6, 13},
  {2, 14},
  {1, 18},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 7},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 5},
  {2, 15},
  {2, 12},
  {1, 15},
  {1, 11},
  {1, 9},
  {3, 15},
  {1, 7},
  {1, 21},
  {2, 30},
  {1, 4},
  {44, 1},
  {1, 21},
  {3, 30},
  {1, 32},
  {2, 30},
  {1, 32},
  {1, 28},
  {1, 30},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 30},
  {1, 32},
  {4, 30},
  {1, 15},
  {43, 1},
  {2, 30},
  {1, 27},
  {2, 30},
  {1, 32},
  {15, 30},
  {1, 28},
  {1, 30},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 30},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 30},
  {1, 32},
  {1, 30},
  {2, 28},
  {36, 1},
  {1, 5},
  {1, 15},
  {1, 28},
  {1, 32},
  {1, 27},
  {1, 28},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 32},
  {1, 30},
  {3, 28},
  {1, 21},
  {14, 1},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 15},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 15},
  {2, 11},
  {2, 12},
  {1, 18},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {3, 16},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 31},
  {1, 21},
  {1, 13},
  {3, 16},
  {1, 26},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 18},
  {3, 14},
  {2, 18},
  {3, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {11, 2},
  {1, 7},
  {1, 15},
  {6, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 7},
  {6, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {2, 10},
  {2, 7},
  {2, 10},
  {9, 7},
  {2, 9},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 2},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 28},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 4},
  {3, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 2},
  {1, 21},
  {1, 31},
  {1, 11},
  {1, 8},
  {1, 5},
  {9, 1},
  {1, 15},
  {33, 1},
  {1, 32},
  {1, 29},
  {1, 27},
  {1, 25},
  {1, 29},
  {1, 25},
  {3, 29},
  {1, 25},
  {1, 29},
  {1, 27},
  {1, 25},
  {2, 29},
  {2, 25},
  {1, 29},
  {1, 25},
  {1, 30},
  {28, 1},
  {1, 15},
  {13, 1},
  {1, 21},
  {2, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {3, 25},
  {4, 29},
  {1, 25},
  {1, 29},
  {3, 25},
  {1, 29},
  {1, 25},
  {1, 27},
  {1, 25},
  {2, 29},
  {1, 27},
  {1, 25},
  {2, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {3, 29},
  {1, 31},
  {1, 21},
  {3, 1},
  {1, 15},
  {32, 1},
  {1, 21},
  {1, 29},
  {3, 25},
  {1, 29},
  {5, 25},
  {1, 29},
  {1, 25},
  {2, 29},
  {1, 25},
  {2, 29},
  {1, 25},
  {1, 27},
  {1, 29},
  {1, 30},
  {1, 21},
  {1, 5},
  {17, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {4, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {4, 11},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {7, 2},
  {3, 7},
  {1, 9},
  {1, 15},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 3},
  {3, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 9},
  {4, 7},
  {7, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 14},
  {1, 13},
  {1, 16},
  {3, 14},
  {1, 18},
  {1, 5},
  {1, 20},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 5},
  {1, 2},
  {2, 19},
  {1, 29},
  {1, 26},
  {2, 23},
  {1, 18},
  {1, 15},
  {2, 30},
  {2, 15},
  {1, 5},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 21},
  {1, 3},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 28},
  {1, 30},
  {1, 8},
  {1, 7},
  {31, 1},
  {1, 15},
  {10, 1},
  {1, 5},
  {1, 15},
  {1, 32},
  {1, 24},
  {1, 29},
  {5, 25},
  {1, 22},
  {10, 25},
  {1, 29},
  {1, 21},
  {40, 1},
  {1, 15},
  {1, 21},
  {31, 25},
  {2, 24},
  {2, 29},
  {1, 30},
  {1, 15},
  {12, 1},
  {1, 15},
  {20, 1},
  {1, 5},
  {1, 21},
  {2, 27},
  {4, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {4, 25},
  {1, 29},
  {1, 28},
  {1, 15},
  {17, 1},
  {1, 5},
  {1, 9},
  {1, 21},
  {1, 30},
  {1, 32},
  {1, 18},
  {1, 16},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 18},
  {1, 6},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 28},
  {1, 11},
  {1, 21},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 25},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 14},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 17},
  {2, 19},
  {1, 28},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {3, 13},
  {1, 2},
  {3, 11},
  {8, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {1, 15},
  {3, 2},
  {1, 9},
  {2, 7},
  {3, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {7, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {6, 10},
  {2, 3},
  {1, 8},
  {5, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {3, 7},
  {2, 10},
  {5, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 3},
  {3, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {10, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {3, 13},
  {1, 16},
  {6, 14},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 32},
  {1, 23},
  {2, 14},
  {2, 2},
  {1, 30},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 8},
  {2, 15},
  {1, 12},
  {1, 3},
  {1, 4},
  {2, 15},
  {1, 8},
  {1, 3},
  {2, 15},
  {2, 12},
  {1, 18},
  {2, 30},
  {1, 5},
  {1, 10},
  {42, 1},
  {1, 5},
  {1, 1},
  {1, 27},
  {17, 25},
  {1, 24},
  {1, 25},
  {1, 27},
  {1, 15},
  {39, 1},
  {1, 5},
  {1, 32},
  {4, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {20, 25},
  {3, 24},
  {1, 29},
  {1, 28},
  {1, 5},
  {32, 1},
  {1, 15},
  {1, 27},
  {19, 25},
  {1, 29},
  {1, 30},
  {1, 12},
  {2, 5},
  {17, 1},
  {1, 3},
  {1, 16},
  {2, 30},
  {1, 23},
  {2, 15},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 17},
  {1, 31},
  {1, 21},
  {2, 16},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 11},
  {4, 14},
  {1, 16},
  {1, 14},
  {2, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 9},
  {3, 2},
  {7, 9},
  {1, 8},
  {3, 2},
  {3, 8},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {7, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {7, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 9},
  {8, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 7},
  {1, 1},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 21},
  {1, 6},
  {1, 12},
  {3, 11},
  {1, 5},
  {3, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 31},
  {1, 15},
  {1, 10},
  {43, 1},
  {2, 5},
  {1, 29},
  {4, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {3, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 28},
  {30, 1},
  {1, 15},
  {7, 1},
  {1, 3},
  {1, 4},
  {1, 27},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {3, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {4, 25},
  {2, 29},
  {1, 30},
  {1, 15},
  {31, 1},
  {1, 9},
  {1, 28},
  {1, 29},
  {6, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {3, 25},
  {1, 24},
  {2, 25},
  {1, 27},
  {1, 18},
  {1, 5},
  {18, 1},
  {1, 5},
  {1, 4},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 23},
  {1, 16},
  {1, 15},
  {1, 8},
  {3, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 5},
  {2, 8},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 24},
  {2, 20},
  {1, 28},
  {1, 13},
  {1, 6},
  {1, 14},
  {1, 16},
  {2, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 21},
  {6, 14},
  {2, 13},
  {4, 11},
  {1, 2},
  {7, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {7, 2},
  {1, 9},
  {1, 15},
  {6, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {5, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 4},
  {1, 8},
  {5, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {5, 7},
  {5, 9},
  {1, 7},
  {4, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {14, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {3, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 27},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 2},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {2, 16},
  {2, 11},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 7},
  {1, 10},
  {19, 1},
  {1, 15},
  {24, 1},
  {1, 15},
  {1, 29},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {3, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 27},
  {1, 5},
  {16, 1},
  {1, 15},
  {21, 1},
  {1, 5},
  {1, 27},
  {2, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {2, 25},
  {4, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {4, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {2, 25},
  {2, 24},
  {2, 25},
  {2, 24},
  {1, 20},
  {1, 23},
  {31, 1},
  {1, 28},
  {1, 29},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 15},
  {1, 4},
  {1, 5},
  {20, 1},
  {1, 8},
  {1, 18},
  {1, 30},
  {1, 32},
  {1, 12},
  {1, 15},
  {1, 8},
  {2, 12},
  {2, 8},
  {1, 12},
  {1, 21},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 12},
  {1, 11},
  {1, 6},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 25},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {10, 2},
  {1, 9},
  {3, 2},
  {1, 15},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {7, 9},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {6, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {5, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {3, 2},
  {1, 9},
  {1, 15},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {3, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 15},
  {1, 20},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 15},
  {1, 1},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 4},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 5},
  {2, 15},
  {2, 12},
  {2, 15},
  {1, 16},
  {1, 18},
  {1, 30},
  {1, 28},
  {1, 7},
  {42, 1},
  {4, 5},
  {1, 29},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 29},
  {1, 28},
  {36, 1},
  {2, 5},
  {1, 15},
  {1, 27},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 17},
  {1, 31},
  {1, 15},
  {28, 1},
  {1, 4},
  {1, 16},
  {2, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {3, 25},
  {1, 29},
  {1, 27},
  {1, 28},
  {1, 15},
  {20, 1},
  {2, 5},
  {1, 3},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 15},
  {1, 3},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 15},
  {1, 21},
  {4, 16},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 31},
  {1, 14},
  {1, 13},
  {2, 16},
  {1, 23},
  {2, 32},
  {1, 17},
  {2, 19},
  {1, 28},
  {3, 14},
  {3, 18},
  {5, 13},
  {3, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 9},
  {1, 11},
  {1, 9},
  {7, 2},
  {2, 8},
  {3, 2},
  {6, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {1, 7},
  {5, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {5, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {3, 10},
  {5, 7},
  {3, 9},
  {1, 7},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {4, 14},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 32},
  {1, 14},
  {1, 18},
  {1, 11},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 23},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 2},
  {1, 4},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 14},
  {1, 30},
  {1, 21},
  {2, 4},
  {42, 1},
  {2, 5},
  {1, 21},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {3, 25},
  {1, 24},
  {1, 29},
  {1, 31},
  {1, 13},
  {36, 1},
  {1, 5},
  {1, 15},
  {1, 29},
  {1, 25},
  {11, 24},
  {2, 25},
  {2, 24},
  {1, 29},
  {3, 25},
  {1, 24},
  {1, 25},
  {11, 24},
  {1, 25},
  {3, 24},
  {1, 29},
  {1, 28},
  {1, 15},
  {27, 1},
  {1, 15},
  {2, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {2, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 30},
  {1, 12},
  {3, 5},
  {20, 1},
  {1, 4},
  {1, 9},
  {1, 21},
  {1, 30},
  {1, 14},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {2, 15},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {2, 20},
  {1, 16},
  {1, 12},
  {2, 16},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 19},
  {1, 20},
  {1, 31},
  {4, 14},
  {2, 18},
  {1, 13},
  {1, 18},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {7, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 3},
  {5, 10},
  {6, 7},
  {4, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 6},
  {1, 13},
  {3, 2},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 16},
  {1, 18},
  {1, 13},
  {2, 14},
  {1, 18},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 4},
  {1, 5},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 21},
  {2, 3},
  {1, 28},
  {1, 12},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 6},
  {1, 7},
  {24, 1},
  {1, 15},
  {15, 1},
  {1, 5},
  {1, 15},
  {3, 5},
  {1, 21},
  {1, 29},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {3, 24},
  {2, 25},
  {1, 24},
  {1, 29},
  {1, 30},
  {1, 15},
  {33, 1},
  {3, 5},
  {1, 11},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {4, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {2, 26},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 29},
  {1, 21},
  {18, 1},
  {1, 15},
  {7, 1},
  {1, 5},
  {1, 30},
  {1, 29},
  {1, 24},
  {4, 25},
  {11, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 5},
  {23, 1},
  {1, 3},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 3},
  {1, 21},
  {1, 8},
  {1, 3},
  {1, 11},
  {1, 8},
  {1, 16},
  {2, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {3, 16},
  {2, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 23},
  {3, 14},
  {2, 18},
  {5, 13},
  {1, 6},
  {2, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {13, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 4},
  {1, 8},
  {5, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {8, 10},
  {7, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {10, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {5, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {3, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 32},
  {2, 14},
  {1, 16},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 12},
  {2, 15},
  {2, 16},
  {1, 30},
  {1, 21},
  {1, 5},
  {42, 1},
  {4, 5},
  {1, 28},
  {1, 29},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 29},
  {1, 21},
  {6, 1},
  {1, 15},
  {27, 1},
  {2, 5},
  {1, 18},
  {1, 29},
  {11, 24},
  {1, 25},
  {4, 24},
  {1, 29},
  {1, 32},
  {1, 14},
  {1, 29},
  {2, 25},
  {14, 24},
  {1, 25},
  {2, 24},
  {1, 30},
  {1, 15},
  {25, 1},
  {1, 32},
  {1, 29},
  {3, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {3, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {3, 24},
  {1, 29},
  {1, 27},
  {1, 15},
  {1, 12},
  {2, 5},
  {7, 1},
  {1, 15},
  {1, 5},
  {14, 1},
  {1, 8},
  {1, 11},
  {2, 30},
  {1, 21},
  {1, 16},
  {1, 8},
  {1, 4},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 21},
  {2, 15},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 16},
  {1, 6},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 30},
  {2, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 15},
  {1, 21},
  {3, 14},
  {2, 18},
  {1, 13},
  {1, 18},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 7},
  {4, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {2, 7},
  {3, 10},
  {6, 7},
  {3, 9},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 9},
  {10, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 14},
  {2, 13},
  {2, 14},
  {1, 16},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 18},
  {2, 15},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 32},
  {2, 23},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 6},
  {1, 11},
  {1, 23},
  {1, 30},
  {1, 15},
  {44, 1},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 30},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {15, 24},
  {1, 30},
  {1, 15},
  {32, 1},
  {2, 5},
  {1, 15},
  {1, 21},
  {1, 29},
  {1, 24},
  {1, 25},
  {6, 24},
  {1, 25},
  {3, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 14},
  {1, 5},
  {1, 28},
  {1, 24},
  {2, 25},
  {10, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 29},
  {1, 28},
  {9, 1},
  {1, 15},
  {13, 1},
  {1, 5},
  {1, 28},
  {1, 29},
  {12, 24},
  {1, 25},
  {6, 24},
  {1, 29},
  {1, 21},
  {2, 5},
  {7, 1},
  {2, 5},
  {15, 1},
  {3, 5},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 21},
  {1, 15},
  {2, 8},
  {1, 12},
  {1, 21},
  {1, 13},
  {2, 12},
  {2, 16},
  {2, 32},
  {1, 24},
  {1, 20},
  {1, 31},
  {1, 13},
  {3, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 23},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 9},
  {1, 11},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {2, 9},
  {1, 7},
  {7, 9},
  {1, 8},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 4},
  {1, 8},
  {5, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {5, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {5, 9},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 15},
  {1, 9},
  {7, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {3, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 27},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 5},
  {4, 12},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 16},
  {2, 15},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 3},
  {44, 1},
  {1, 4},
  {1, 5},
  {1, 32},
  {1, 25},
  {4, 24},
  {1, 25},
  {4, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 29},
  {1, 28},
  {1, 15},
  {32, 1},
  {2, 5},
  {1, 28},
  {1, 29},
  {10, 24},
  {1, 25},
  {5, 24},
  {1, 29},
  {1, 21},
  {1, 5},
  {1, 15},
  {1, 30},
  {19, 24},
  {1, 29},
  {23, 1},
  {1, 21},
  {1, 29},
  {2, 24},
  {1, 25},
  {5, 24},
  {1, 25},
  {8, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 28},
  {1, 15},
  {2, 5},
  {25, 1},
  {2, 4},
  {1, 21},
  {1, 31},
  {1, 14},
  {1, 16},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 24},
  {1, 17},
  {1, 31},
  {1, 21},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 14},
  {1, 23},
  {4, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {4, 2},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {7, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {3, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {2, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {6, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 13},
  {1, 15},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 21},
  {1, 18},
  {1, 10},
  {1, 1},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {2, 16},
  {1, 12},
  {3, 8},
  {1, 12},
  {1, 15},
  {3, 12},
  {1, 15},
  {2, 11},
  {1, 21},
  {1, 12},
  {2, 16},
  {1, 30},
  {1, 32},
  {1, 7},
  {44, 1},
  {2, 5},
  {1, 21},
  {1, 30},
  {1, 29},
  {1, 24},
  {1, 25},
  {4, 24},
  {1, 25},
  {13, 24},
  {1, 25},
  {3, 24},
  {1, 29},
  {1, 15},
  {30, 1},
  {3, 5},
  {1, 15},
  {1, 32},
  {12, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 28},
  {1, 29},
  {19, 24},
  {1, 30},
  {21, 1},
  {1, 5},
  {1, 29},
  {3, 24},
  {1, 25},
  {6, 24},
  {1, 25},
  {7, 24},
  {1, 17},
  {1, 24},
  {1, 28},
  {2, 5},
  {28, 1},
  {1, 5},
  {1, 18},
  {1, 30},
  {1, 23},
  {1, 16},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 21},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {2, 17},
  {1, 28},
  {1, 8},
  {2, 16},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 23},
  {2, 14},
  {1, 16},
  {2, 14},
  {3, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {11, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {4, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {2, 9},
  {1, 2},
  {11, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 11},
  {1, 9},
  {3, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 28},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 6},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 15},
  {2, 12},
  {2, 21},
  {2, 12},
  {1, 14},
  {1, 32},
  {1, 21},
  {1, 4},
  {31, 1},
  {1, 15},
  {12, 1},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 29},
  {23, 24},
  {1, 25},
  {2, 24},
  {1, 28},
  {1, 15},
  {13, 1},
  {1, 15},
  {13, 1},
  {1, 15},
  {1, 5},
  {2, 1},
  {2, 5},
  {1, 30},
  {5, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {5, 24},
  {1, 31},
  {3, 5},
  {1, 12},
  {1, 30},
  {1, 24},
  {1, 20},
  {13, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 29},
  {1, 21},
  {19, 1},
  {1, 15},
  {1, 30},
  {4, 24},
  {1, 17},
  {5, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {1, 30},
  {1, 11},
  {1, 15},
  {1, 5},
  {29, 1},
  {1, 2},
  {2, 30},
  {1, 23},
  {1, 21},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 28},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 5},
  {1, 11},
  {5, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {2, 17},
  {1, 30},
  {1, 3},
  {1, 8},
  {1, 16},
  {1, 14},
  {2, 26},
  {1, 25},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 28},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 14},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 9},
  {6, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {3, 9},
  {1, 2},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {5, 7},
  {2, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {11, 7},
  {10, 9},
  {1, 7},
  {4, 9},
  {3, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {2, 11},
  {4, 13},
  {1, 16},
  {1, 18},
  {2, 16},
  {1, 14},
  {1, 13},
  {1, 15},
  {1, 30},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 1},
  {1, 28},
  {2, 19},
  {1, 31},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 8},
  {1, 12},
  {1, 5},
  {2, 15},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 11},
  {1, 28},
  {1, 30},
  {1, 13},
  {43, 1},
  {5, 5},
  {1, 29},
  {26, 24},
  {1, 31},
  {1, 15},
  {25, 1},
  {3, 5},
  {2, 1},
  {2, 5},
  {1, 3},
  {1, 30},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {7, 24},
  {1, 30},
  {2, 4},
  {1, 9},
  {1, 7},
  {1, 21},
  {1, 31},
  {2, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 30},
  {1, 15},
  {17, 1},
  {1, 5},
  {1, 21},
  {1, 20},
  {2, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 29},
  {1, 24},
  {1, 31},
  {1, 15},
  {2, 5},
  {28, 1},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 32},
  {1, 30},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 8},
  {2, 12},
  {1, 16},
  {3, 12},
  {1, 14},
  {1, 32},
  {1, 27},
  {2, 17},
  {1, 30},
  {1, 11},
  {3, 16},
  {1, 23},
  {1, 26},
  {1, 25},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 18},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {5, 13},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {11, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {8, 7},
  {1, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 10},
  {1, 4},
  {1, 12},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {11, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 15},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 30},
  {2, 19},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 11},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 15},
  {2, 16},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 28},
  {1, 30},
  {2, 12},
  {8, 1},
  {1, 15},
  {33, 1},
  {4, 5},
  {1, 15},
  {1, 29},
  {9, 24},
  {1, 25},
  {6, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {3, 17},
  {1, 30},
  {1, 5},
  {30, 1},
  {1, 5},
  {1, 2},
  {1, 31},
  {3, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 30},
  {1, 15},
  {1, 4},
  {2, 1},
  {1, 11},
  {1, 30},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {2, 17},
  {1, 31},
  {1, 28},
  {17, 1},
  {1, 21},
  {1, 31},
  {1, 17},
  {4, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {2, 17},
  {1, 31},
  {1, 23},
  {2, 4},
  {29, 1},
  {2, 5},
  {1, 3},
  {1, 23},
  {1, 30},
  {1, 23},
  {2, 12},
  {2, 15},
  {2, 12},
  {1, 15},
  {1, 11},
  {1, 3},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 14},
  {1, 21},
  {1, 32},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 5},
  {1, 2},
  {2, 14},
  {2, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 14},
  {3, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {9, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {8, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {3, 3},
  {1, 4},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {11, 7},
  {5, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {2, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {7, 13},
  {1, 14},
  {1, 16},
  {1, 21},
  {1, 1},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 6},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 9},
  {2, 4},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 30},
  {1, 28},
  {1, 9},
  {15, 1},
  {1, 15},
  {28, 1},
  {3, 5},
  {1, 21},
  {2, 29},
  {17, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {2, 24},
  {2, 17},
  {1, 21},
  {28, 1},
  {2, 5},
  {1, 12},
  {1, 11},
  {1, 29},
  {2, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {1, 30},
  {3, 1},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 31},
  {1, 24},
  {2, 17},
  {3, 24},
  {3, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {2, 17},
  {1, 31},
  {1, 15},
  {15, 1},
  {1, 21},
  {1, 29},
  {1, 24},
  {2, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {4, 24},
  {2, 17},
  {4, 24},
  {1, 17},
  {1, 28},
  {1, 4},
  {31, 1},
  {2, 5},
  {1, 15},
  {1, 8},
  {1, 29},
  {1, 28},
  {1, 16},
  {2, 15},
  {2, 12},
  {2, 15},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 6},
  {1, 12},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 21},
  {4, 16},
  {2, 26},
  {1, 17},
  {2, 19},
  {1, 28},
  {2, 14},
  {1, 18},
  {2, 14},
  {5, 13},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {8, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 10},
  {8, 7},
  {6, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {2, 3},
  {8, 10},
  {12, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 16},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 18},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 11},
  {2, 4},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 21},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 21},
  {1, 2},
  {45, 1},
  {1, 15},
  {1, 5},
  {1, 28},
  {1, 20},
  {1, 17},
  {2, 24},
  {1, 17},
  {9, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 29},
  {1, 31},
  {1, 10},
  {15, 1},
  {1, 15},
  {12, 1},
  {2, 5},
  {1, 15},
  {1, 29},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 21},
  {1, 7},
  {4, 1},
  {1, 4},
  {1, 32},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 31},
  {1, 30},
  {1, 5},
  {13, 1},
  {1, 15},
  {1, 30},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {3, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 20},
  {1, 28},
  {2, 4},
  {32, 1},
  {2, 5},
  {1, 12},
  {2, 30},
  {2, 21},
  {2, 12},
  {2, 15},
  {1, 11},
  {2, 12},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 5},
  {2, 16},
  {1, 23},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {4, 2},
  {1, 6},
  {10, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {4, 9},
  {3, 7},
  {1, 10},
  {8, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {9, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {4, 10},
  {11, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {4, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 14},
  {1, 15},
  {1, 21},
  {2, 19},
  {1, 20},
  {1, 22},
  {2, 26},
  {1, 14},
  {1, 6},
  {1, 15},
  {1, 1},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 14},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 4},
  {1, 12},
  {1, 15},
  {3, 12},
  {1, 21},
  {1, 12},
  {1, 16},
  {1, 32},
  {1, 30},
  {1, 15},
  {43, 1},
  {5, 5},
  {1, 16},
  {1, 20},
  {1, 24},
  {1, 29},
  {1, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {3, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 20},
  {1, 28},
  {29, 1},
  {1, 5},
  {1, 15},
  {2, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 28},
  {4, 1},
  {1, 5},
  {1, 15},
  {1, 8},
  {1, 31},
  {1, 20},
  {2, 17},
  {2, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {4, 17},
  {1, 24},
  {1, 17},
  {1, 31},
  {1, 15},
  {12, 1},
  {1, 2},
  {1, 30},
  {1, 20},
  {1, 24},
  {2, 17},
  {3, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {3, 17},
  {1, 31},
  {1, 15},
  {33, 1},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 16},
  {2, 30},
  {1, 18},
  {4, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 16},
  {2, 12},
  {2, 15},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {2, 20},
  {1, 28},
  {3, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {2, 14},
  {1, 18},
  {2, 14},
  {5, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {10, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 9},
  {4, 8},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {10, 7},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 8},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 13},
  {1, 18},
  {1, 16},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 28},
  {2, 19},
  {1, 17},
  {2, 26},
  {3, 16},
  {1, 6},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 26},
  {2, 23},
  {2, 16},
  {2, 11},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 8},
  {1, 5},
  {3, 12},
  {1, 16},
  {1, 15},
  {1, 16},
  {1, 32},
  {1, 30},
  {1, 18},
  {1, 9},
  {20, 1},
  {1, 15},
  {15, 1},
  {1, 15},
  {6, 1},
  {4, 5},
  {1, 32},
  {1, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 29},
  {1, 31},
  {1, 11},
  {29, 1},
  {1, 28},
  {1, 31},
  {5, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 18},
  {1, 4},
  {4, 1},
  {2, 5},
  {1, 28},
  {1, 31},
  {1, 20},
  {1, 17},
  {1, 24},
  {4, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {7, 17},
  {1, 24},
  {1, 17},
  {1, 30},
  {1, 5},
  {11, 1},
  {1, 28},
  {2, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 16},
  {1, 4},
  {9, 1},
  {1, 15},
  {24, 1},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 21},
  {2, 5},
  {1, 15},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 16},
  {3, 12},
  {1, 2},
  {1, 12},
  {2, 16},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 15},
  {1, 13},
  {2, 16},
  {2, 26},
  {1, 25},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 16},
  {3, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {2, 11},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 9},
  {1, 11},
  {1, 9},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {2, 7},
  {2, 10},
  {7, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {4, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {3, 10},
  {11, 7},
  {7, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {3, 9},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 30},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 6},
  {1, 1},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 3},
  {2, 12},
  {1, 15},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 6},
  {1, 14},
  {1, 16},
  {1, 30},
  {1, 32},
  {1, 2},
  {45, 1},
  {3, 5},
  {1, 30},
  {1, 24},
  {1, 17},
  {2, 24},
  {3, 17},
  {1, 24},
  {3, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {3, 24},
  {1, 20},
  {1, 30},
  {27, 1},
  {1, 5},
  {1, 9},
  {1, 30},
  {1, 20},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {9, 17},
  {1, 18},
  {5, 1},
  {1, 5},
  {1, 11},
  {1, 13},
  {1, 31},
  {1, 20},
  {2, 17},
  {1, 24},
  {3, 17},
  {1, 24},
  {2, 17},
  {2, 24},
  {6, 17},
  {1, 24},
  {1, 29},
  {1, 21},
  {9, 1},
  {1, 5},
  {1, 28},
  {1, 31},
  {18, 17},
  {1, 24},
  {1, 17},
  {1, 21},
  {1, 5},
  {18, 1},
  {1, 15},
  {15, 1},
  {1, 5},
  {2, 4},
  {1, 12},
  {1, 21},
  {1, 31},
  {1, 18},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 16},
  {2, 12},
  {1, 11},
  {1, 4},
  {2, 12},
  {2, 23},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 31},
  {1, 18},
  {3, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 23},
  {1, 14},
  {1, 18},
  {3, 14},
  {5, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {9, 6},
  {2, 2},
  {1, 7},
  {1, 15},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {4, 8},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {2, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {9, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {7, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 31},
  {2, 19},
  {1, 25},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 9},
  {1, 30},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 23},
  {3, 16},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {2, 12},
  {1, 16},
  {1, 30},
  {1, 28},
  {1, 6},
  {45, 1},
  {1, 15},
  {2, 5},
  {1, 31},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {5, 17},
  {1, 31},
  {1, 28},
  {1, 5},
  {26, 1},
  {1, 5},
  {1, 30},
  {8, 17},
  {1, 24},
  {8, 17},
  {1, 31},
  {1, 15},
  {7, 1},
  {1, 5},
  {1, 21},
  {2, 20},
  {17, 17},
  {1, 24},
  {1, 30},
  {1, 15},
  {1, 1},
  {1, 15},
  {6, 1},
  {1, 21},
  {1, 31},
  {1, 20},
  {8, 17},
  {2, 20},
  {8, 17},
  {1, 20},
  {1, 28},
  {2, 5},
  {35, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 15},
  {1, 30},
  {1, 23},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 15},
  {2, 3},
  {1, 15},
  {1, 5},
  {2, 12},
  {2, 16},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 31},
  {1, 15},
  {1, 11},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {7, 6},
  {3, 2},
  {1, 9},
  {10, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {10, 10},
  {2, 3},
  {1, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {7, 10},
  {11, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 9},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 21},
  {1, 16},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {2, 12},
  {1, 23},
  {1, 30},
  {1, 21},
  {1, 3},
  {1, 15},
  {24, 1},
  {1, 15},
  {17, 1},
  {3, 5},
  {2, 12},
  {1, 30},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {14, 17},
  {1, 20},
  {1, 31},
  {19, 1},
  {1, 15},
  {8, 1},
  {1, 30},
  {17, 17},
  {1, 31},
  {1, 15},
  {7, 1},
  {2, 5},
  {1, 32},
  {1, 20},
  {18, 17},
  {1, 20},
  {1, 28},
  {6, 1},
  {1, 5},
  {1, 21},
  {1, 30},
  {1, 20},
  {4, 17},
  {3, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {3, 17},
  {2, 20},
  {3, 17},
  {1, 30},
  {1, 15},
  {35, 1},
  {1, 5},
  {4, 1},
  {1, 15},
  {1, 30},
  {1, 32},
  {1, 12},
  {1, 6},
  {1, 11},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 11},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {2, 20},
  {1, 21},
  {1, 12},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 28},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {3, 11},
  {5, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {4, 6},
  {14, 2},
  {2, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {4, 8},
  {2, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 10},
  {3, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {7, 10},
  {10, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {11, 2},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 16},
  {1, 14},
  {1, 12},
  {1, 11},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 32},
  {3, 16},
  {1, 21},
  {1, 16},
  {1, 15},
  {4, 12},
  {1, 11},
  {2, 21},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 18},
  {1, 30},
  {1, 21},
  {1, 8},
  {1, 5},
  {42, 1},
  {4, 5},
  {1, 15},
  {1, 31},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {17, 17},
  {1, 29},
  {1, 28},
  {18, 1},
  {2, 5},
  {6, 1},
  {1, 15},
  {1, 31},
  {12, 17},
  {2, 20},
  {2, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 5},
  {7, 1},
  {1, 5},
  {1, 15},
  {1, 31},
  {1, 20},
  {17, 17},
  {1, 20},
  {1, 31},
  {1, 5},
  {6, 1},
  {1, 28},
  {1, 20},
  {4, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {2, 17},
  {1, 19},
  {3, 17},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 31},
  {2, 15},
  {1, 5},
  {39, 1},
  {1, 15},
  {2, 30},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 11},
  {1, 5},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 5},
  {1, 11},
  {1, 12},
  {1, 14},
  {1, 23},
  {1, 22},
  {1, 29},
  {2, 20},
  {1, 18},
  {3, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 32},
  {1, 21},
  {3, 14},
  {2, 16},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {6, 2},
  {1, 9},
  {6, 2},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {1, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {2, 4},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {12, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {5, 13},
  {3, 14},
  {1, 11},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 14},
  {1, 13},
  {1, 9},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 21},
  {1, 14},
  {4, 12},
  {1, 5},
  {1, 11},
  {1, 15},
  {1, 16},
  {1, 15},
  {1, 6},
  {1, 8},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 13},
  {1, 7},
  {44, 1},
  {2, 5},
  {1, 3},
  {1, 16},
  {1, 31},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {21, 17},
  {1, 31},
  {1, 15},
  {23, 1},
  {1, 5},
  {1, 4},
  {1, 18},
  {1, 31},
  {1, 17},
  {9, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {3, 17},
  {1, 30},
  {9, 1},
  {1, 2},
  {1, 9},
  {1, 30},
  {2, 20},
  {12, 17},
  {1, 19},
  {2, 20},
  {3, 17},
  {1, 28},
  {5, 1},
  {1, 21},
  {1, 20},
  {7, 17},
  {1, 19},
  {2, 20},
  {7, 17},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 5},
  {40, 1},
  {2, 5},
  {2, 30},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 24},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 13},
  {3, 14},
  {1, 32},
  {1, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {5, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 6},
  {2, 11},
  {1, 2},
  {14, 6},
  {2, 2},
  {1, 9},
  {1, 15},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {9, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {5, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {4, 10},
  {1, 3},
  {7, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {9, 2},
  {1, 11},
  {1, 2},
  {8, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 13},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {2, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 6},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 29},
  {1, 26},
  {4, 16},
  {1, 21},
  {4, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 2},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 15},
  {1, 3},
  {46, 1},
  {1, 5},
  {1, 18},
  {2, 17},
  {1, 24},
  {27, 17},
  {3, 20},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 15},
  {24, 1},
  {1, 11},
  {1, 29},
  {1, 17},
  {2, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {3, 17},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 15},
  {1, 5},
  {9, 1},
  {1, 5},
  {1, 31},
  {15, 17},
  {1, 19},
  {3, 17},
  {1, 20},
  {1, 12},
  {3, 1},
  {1, 15},
  {1, 31},
  {1, 20},
  {4, 17},
  {2, 20},
  {3, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {2, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 28},
  {1, 15},
  {1, 5},
  {41, 1},
  {1, 3},
  {1, 28},
  {1, 30},
  {1, 14},
  {1, 21},
  {1, 15},
  {1, 16},
  {4, 12},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 28},
  {1, 15},
  {1, 8},
  {2, 15},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 25},
  {2, 20},
  {1, 30},
  {1, 12},
  {1, 6},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 25},
  {2, 19},
  {1, 31},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 12},
  {7, 6},
  {1, 12},
  {3, 6},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 15},
  {1, 9},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {9, 3},
  {160, 0},
  {160, 0},
  {1, 10},
  {2, 3},
  {1, 1},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {11, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {6, 6},
  {1, 11},
  {4, 13},
  {3, 14},
  {2, 21},
  {2, 19},
  {1, 20},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 6},
  {1, 8},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 25},
  {1, 26},
  {1, 23},
  {3, 16},
  {1, 15},
  {4, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 28},
  {1, 30},
  {1, 6},
  {46, 1},
  {3, 5},
  {2, 17},
  {1, 24},
  {28, 17},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 20},
  {1, 15},
  {23, 1},
  {1, 15},
  {1, 21},
  {1, 20},
  {3, 17},
  {1, 20},
  {5, 17},
  {4, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 28},
  {10, 1},
  {2, 5},
  {1, 23},
  {5, 20},
  {11, 17},
  {1, 20},
  {2, 17},
  {1, 20},
  {1, 30},
  {2, 1},
  {1, 18},
  {1, 31},
  {1, 17},
  {1, 20},
  {1, 19},
  {3, 17},
  {1, 19},
  {3, 20},
  {2, 17},
  {2, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 30},
  {43, 1},
  {2, 5},
  {1, 32},
  {1, 30},
  {1, 14},
  {1, 12},
  {2, 16},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 4},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 2},
  {2, 21},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 13},
  {2, 11},
  {3, 23},
  {1, 25},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 16},
  {1, 12},
  {5, 6},
  {6, 2},
  {2, 9},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {6, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {3, 10},
  {10, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {7, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 18},
  {5, 14},
  {1, 28},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {3, 16},
  {1, 23},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 12},
  {4, 8},
  {1, 16},
  {2, 30},
  {1, 5},
  {1, 4},
  {46, 1},
  {1, 5},
  {1, 28},
  {1, 20},
  {14, 17},
  {6, 20},
  {1, 19},
  {5, 17},
  {1, 20},
  {2, 17},
  {1, 20},
  {5, 17},
  {1, 30},
  {1, 15},
  {23, 1},
  {1, 28},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 3},
  {10, 1},
  {1, 5},
  {1, 1},
  {1, 31},
  {2, 17},
  {9, 20},
  {4, 17},
  {1, 20},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 15},
  {1, 5},
  {1, 28},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {5, 17},
  {1, 19},
  {1, 17},
  {3, 20},
  {1, 19},
  {2, 17},
  {2, 20},
  {1, 17},
  {1, 30},
  {1, 15},
  {1, 5},
  {43, 1},
  {1, 12},
  {1, 21},
  {1, 31},
  {2, 16},
  {1, 12},
  {2, 21},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 3},
  {3, 15},
  {1, 12},
  {1, 4},
  {1, 9},
  {1, 8},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {4, 14},
  {2, 16},
  {1, 18},
  {3, 13},
  {1, 2},
  {1, 13},
  {1, 2},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {7, 6},
  {13, 2},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 10},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {5, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {11, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {1, 11},
  {1, 30},
  {2, 19},
  {1, 17},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 8},
  {1, 12},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 25},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 28},
  {1, 15},
  {1, 16},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 6},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 4},
  {1, 7},
  {1, 5},
  {1, 1},
  {1, 30},
  {1, 28},
  {1, 7},
  {12, 1},
  {1, 15},
  {32, 1},
  {3, 5},
  {1, 28},
  {1, 20},
  {6, 17},
  {6, 20},
  {3, 17},
  {1, 19},
  {2, 20},
  {3, 17},
  {1, 20},
  {2, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {4, 20},
  {2, 17},
  {1, 20},
  {1, 28},
  {21, 1},
  {1, 5},
  {1, 3},
  {1, 28},
  {1, 20},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 19},
  {4, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 21},
  {10, 1},
  {1, 4},
  {2, 5},
  {1, 21},
  {1, 17},
  {6, 20},
  {1, 17},
  {1, 19},
  {3, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {2, 20},
  {1, 17},
  {1, 27},
  {1, 23},
  {2, 20},
  {2, 17},
  {4, 20},
  {4, 17},
  {1, 19},
  {1, 20},
  {4, 17},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 11},
  {43, 1},
  {3, 5},
  {1, 16},
  {1, 31},
  {1, 21},
  {2, 12},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 21},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 4},
  {1, 5},
  {1, 8},
  {2, 15},
  {1, 13},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 17},
  {1, 31},
  {2, 13},
  {1, 18},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 23},
  {5, 14},
  {1, 16},
  {3, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {6, 6},
  {1, 2},
  {1, 11},
  {1, 9},
  {10, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {4, 8},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 10},
  {8, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 8},
  {9, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 1},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 9},
  {4, 7},
  {6, 9},
  {1, 7},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 14},
  {1, 13},
  {2, 18},
  {2, 14},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 2},
  {1, 6},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 23},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 14},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 15},
  {2, 30},
  {1, 5},
  {7, 1},
  {1, 15},
  {19, 1},
  {1, 15},
  {20, 1},
  {1, 30},
  {4, 17},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {2, 20},
  {4, 17},
  {1, 20},
  {1, 19},
  {5, 17},
  {2, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 31},
  {1, 15},
  {1, 1},
  {1, 15},
  {20, 1},
  {1, 28},
  {1, 20},
  {2, 17},
  {1, 19},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 4},
  {12, 1},
  {2, 5},
  {1, 30},
  {2, 17},
  {1, 19},
  {3, 17},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 17},
  {2, 20},
  {2, 17},
  {1, 20},
  {1, 19},
  {3, 17},
  {1, 29},
  {2, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {4, 20},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 31},
  {1, 21},
  {1, 7},
  {45, 1},
  {1, 3},
  {1, 16},
  {1, 30},
  {1, 28},
  {2, 16},
  {1, 28},
  {1, 12},
  {2, 21},
  {1, 11},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 8},
  {1, 15},
  {2, 13},
  {1, 14},
  {1, 26},
  {1, 22},
  {1, 24},
  {1, 20},
  {1, 31},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {2, 14},
  {1, 18},
  {3, 14},
  {1, 13},
  {1, 14},
  {1, 6},
  {2, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 2},
  {7, 6},
  {4, 2},
  {1, 15},
  {1, 9},
  {9, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {1, 10},
  {3, 9},
  {9, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {6, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 7},
  {1, 1},
  {3, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {5, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {3, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 11},
  {1, 2},
  {5, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 13},
  {1, 2},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 22},
  {1, 26},
  {2, 16},
  {1, 21},
  {2, 12},
  {1, 11},
  {1, 15},
  {2, 11},
  {1, 12},
  {2, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 7},
  {2, 15},
  {1, 30},
  {1, 21},
  {1, 15},
  {35, 1},
  {1, 15},
  {10, 1},
  {2, 5},
  {1, 30},
  {1, 20},
  {3, 17},
  {1, 19},
  {3, 17},
  {1, 20},
  {4, 17},
  {1, 19},
  {3, 20},
  {1, 29},
  {5, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {3, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 30},
  {21, 1},
  {1, 15},
  {1, 30},
  {1, 19},
  {3, 17},
  {1, 19},
  {2, 17},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 15},
  {12, 1},
  {1, 5},
  {1, 1},
  {1, 15},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {3, 17},
  {1, 19},
  {3, 20},
  {2, 17},
  {1, 19},
  {2, 20},
  {3, 17},
  {1, 20},
  {3, 17},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {4, 20},
  {2, 17},
  {2, 20},
  {1, 28},
  {46, 1},
  {1, 5},
  {1, 1},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 7},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 19},
  {1, 31},
  {1, 18},
  {1, 6},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 23},
  {1, 14},
  {1, 18},
  {4, 14},
  {4, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {8, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {3, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {3, 13},
  {1, 14},
  {3, 18},
  {1, 16},
  {1, 14},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 12},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {2, 16},
  {1, 14},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 14},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 7},
  {1, 11},
  {1, 21},
  {1, 30},
  {1, 21},
  {48, 1},
  {1, 15},
  {1, 31},
  {1, 20},
  {3, 17},
  {1, 20},
  {2, 17},
  {6, 20},
  {1, 17},
  {1, 19},
  {2, 17},
  {1, 31},
  {1, 30},
  {1, 20},
  {5, 17},
  {2, 20},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 11},
  {20, 1},
  {1, 5},
  {1, 31},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 31},
  {1, 12},
  {1, 5},
  {13, 1},
  {1, 15},
  {1, 28},
  {2, 20},
  {3, 17},
  {3, 20},
  {3, 17},
  {1, 19},
  {1, 17},
  {4, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {3, 20},
  {1, 19},
  {3, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 28},
  {30, 1},
  {1, 15},
  {18, 1},
  {1, 11},
  {2, 30},
  {1, 21},
  {1, 14},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 11},
  {1, 18},
  {3, 21},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 20},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 21},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 23},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 11},
  {1, 6},
  {2, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {8, 2},
  {2, 9},
  {4, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 10},
  {8, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 12},
  {1, 4},
  {4, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 7},
  {1, 1},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {6, 7},
  {1, 9},
  {6, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 9},
  {5, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {3, 11},
  {1, 6},
  {4, 13},
  {1, 14},
  {2, 18},
  {2, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 26},
  {2, 23},
  {1, 13},
  {1, 3},
  {1, 13},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {2, 21},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {4, 12},
  {1, 11},
  {1, 21},
  {1, 6},
  {1, 12},
  {1, 13},
  {1, 28},
  {1, 30},
  {1, 18},
  {18, 1},
  {1, 15},
  {27, 1},
  {3, 5},
  {3, 20},
  {2, 17},
  {1, 19},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 19},
  {2, 17},
  {1, 28},
  {1, 5},
  {1, 20},
  {1, 17},
  {3, 20},
  {1, 17},
  {1, 19},
  {4, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 15},
  {18, 1},
  {1, 5},
  {1, 1},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 24},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {16, 1},
  {1, 4},
  {1, 31},
  {1, 17},
  {7, 20},
  {4, 17},
  {1, 19},
  {1, 20},
  {7, 17},
  {1, 19},
  {1, 20},
  {4, 17},
  {1, 20},
  {2, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {2, 20},
  {1, 31},
  {1, 15},
  {49, 1},
  {1, 15},
  {2, 30},
  {1, 21},
  {3, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 12},
  {2, 21},
  {1, 11},
  {1, 16},
  {1, 21},
  {2, 30},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 21},
  {1, 12},
  {2, 14},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 28},
  {5, 14},
  {4, 13},
  {1, 11},
  {1, 13},
  {2, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {7, 2},
  {1, 9},
  {1, 15},
  {5, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {4, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {7, 7},
  {5, 10},
  {1, 3},
  {1, 8},
  {8, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 1},
  {4, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {5, 7},
  {1, 9},
  {4, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {12, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 27},
  {1, 26},
  {1, 21},
  {1, 16},
  {1, 6},
  {1, 14},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {2, 23},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 16},
  {3, 12},
  {1, 11},
  {3, 21},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 21},
  {49, 1},
  {1, 31},
  {1, 17},
  {6, 20},
  {2, 17},
  {1, 20},
  {2, 17},
  {3, 20},
  {1, 17},
  {1, 20},
  {1, 21},
  {1, 5},
  {1, 28},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 28},
  {19, 1},
  {1, 11},
  {1, 31},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 19},
  {1, 17},
  {2, 20},
  {1, 19},
  {1, 17},
  {1, 30},
  {1, 5},
  {16, 1},
  {1, 28},
  {1, 20},
  {3, 17},
  {1, 19},
  {1, 17},
  {6, 20},
  {2, 17},
  {1, 20},
  {8, 17},
  {3, 20},
  {1, 19},
  {4, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 31},
  {3, 5},
  {48, 1},
  {1, 3},
  {1, 30},
  {1, 31},
  {1, 16},
  {5, 12},
  {1, 15},
  {2, 12},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 28},
  {1, 14},
  {1, 16},
  {1, 23},
  {1, 22},
  {1, 29},
  {2, 17},
  {1, 21},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 32},
  {1, 14},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {3, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {9, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 7},
  {1, 9},
  {3, 7},
  {1, 10},
  {1, 3},
  {3, 10},
  {10, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 1},
  {1, 4},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {5, 10},
  {5, 7},
  {1, 9},
  {5, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {4, 13},
  {1, 14},
  {1, 16},
  {2, 18},
  {1, 13},
  {1, 5},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 32},
  {1, 23},
  {2, 13},
  {1, 12},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 22},
  {1, 23},
  {1, 16},
  {1, 6},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 4},
  {2, 21},
  {2, 12},
  {2, 15},
  {1, 2},
  {2, 12},
  {1, 21},
  {1, 32},
  {1, 30},
  {1, 11},
  {47, 1},
  {1, 12},
  {1, 14},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 17},
  {1, 19},
  {4, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 20},
  {2, 17},
  {3, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 15},
  {16, 1},
  {1, 5},
  {2, 15},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 30},
  {15, 1},
  {3, 5},
  {1, 31},
  {4, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {6, 20},
  {3, 17},
  {1, 19},
  {1, 20},
  {3, 17},
  {1, 20},
  {3, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 29},
  {1, 21},
  {15, 1},
  {1, 15},
  {34, 1},
  {2, 5},
  {1, 28},
  {1, 31},
  {1, 16},
  {3, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 16},
  {4, 12},
  {3, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 21},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 18},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 14},
  {4, 13},
  {1, 2},
  {3, 11},
  {4, 2},
  {5, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {12, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 10},
  {3, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {6, 7},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 12},
  {5, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {4, 2},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 18},
  {1, 16},
  {2, 14},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 6},
  {1, 14},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 32},
  {2, 23},
  {1, 16},
  {1, 15},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 15},
  {2, 11},
  {2, 15},
  {1, 21},
  {3, 12},
  {1, 16},
  {1, 32},
  {1, 30},
  {1, 16},
  {1, 5},
  {47, 1},
  {1, 18},
  {6, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {4, 17},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 18},
  {2, 5},
  {1, 21},
  {1, 17},
  {2, 20},
  {1, 19},
  {3, 17},
  {1, 19},
  {3, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {1, 30},
  {17, 1},
  {1, 5},
  {1, 21},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 28},
  {1, 15},
  {1, 5},
  {15, 1},
  {1, 5},
  {1, 8},
  {1, 31},
  {1, 17},
  {1, 24},
  {11, 17},
  {5, 20},
  {7, 17},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 28},
  {1, 5},
  {1, 4},
  {50, 1},
  {1, 3},
  {1, 28},
  {1, 30},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 12},
  {2, 8},
  {1, 18},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 16},
  {4, 14},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {8, 6},
  {3, 2},
  {1, 11},
  {10, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {7, 9},
  {1, 10},
  {2, 7},
  {1, 9},
  {3, 7},
  {7, 10},
  {3, 3},
  {2, 4},
  {4, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {8, 7},
  {3, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {8, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {2, 14},
  {1, 18},
  {2, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 4},
  {1, 5},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 15},
  {3, 12},
  {1, 5},
  {1, 15},
  {1, 9},
  {1, 15},
  {1, 21},
  {1, 14},
  {1, 32},
  {1, 30},
  {1, 15},
  {46, 1},
  {1, 4},
  {1, 5},
  {1, 21},
  {2, 17},
  {3, 20},
  {1, 17},
  {2, 20},
  {6, 17},
  {1, 19},
  {2, 20},
  {1, 31},
  {1, 7},
  {1, 3},
  {2, 5},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 20},
  {3, 17},
  {1, 19},
  {2, 20},
  {2, 17},
  {2, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 15},
  {15, 1},
  {2, 5},
  {1, 23},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {17, 1},
  {1, 2},
  {1, 16},
  {1, 28},
  {11, 17},
  {6, 20},
  {6, 17},
  {1, 20},
  {5, 17},
  {2, 20},
  {1, 30},
  {1, 4},
  {22, 1},
  {1, 15},
  {28, 1},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 31},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 12},
  {1, 18},
  {2, 21},
  {2, 13},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 16},
  {1, 13},
  {2, 16},
  {2, 26},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 30},
  {6, 14},
  {4, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {13, 6},
  {1, 11},
  {4, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 8},
  {3, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {9, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 6},
  {2, 2},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {3, 11},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {3, 14},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 32},
  {1, 14},
  {1, 18},
  {1, 2},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 32},
  {1, 23},
  {3, 16},
  {2, 12},
  {1, 11},
  {2, 8},
  {1, 12},
  {2, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 16},
  {1, 30},
  {1, 32},
  {1, 4},
  {48, 1},
  {1, 28},
  {1, 17},
  {3, 20},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 17},
  {6, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 15},
  {3, 5},
  {1, 21},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {3, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 5},
  {16, 1},
  {1, 28},
  {1, 17},
  {2, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {5, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {1, 18},
  {18, 1},
  {1, 7},
  {1, 11},
  {1, 31},
  {1, 24},
  {10, 17},
  {6, 20},
  {3, 17},
  {4, 20},
  {4, 17},
  {1, 20},
  {1, 30},
  {1, 4},
  {1, 5},
  {52, 1},
  {1, 5},
  {1, 28},
  {1, 31},
  {4, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 27},
  {1, 5},
  {1, 11},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 30},
  {4, 14},
  {1, 16},
  {2, 13},
  {1, 18},
  {1, 6},
  {1, 13},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 10},
  {2, 3},
  {1, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {5, 7},
  {1, 1},
  {3, 7},
  {2, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 21},
  {1, 11},
  {1, 9},
  {1, 21},
  {2, 20},
  {1, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 2},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 16},
  {1, 30},
  {1, 28},
  {1, 1},
  {1, 15},
  {46, 1},
  {1, 15},
  {1, 30},
  {1, 17},
  {1, 19},
  {1, 20},
  {3, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {2, 17},
  {2, 20},
  {1, 31},
  {4, 5},
  {1, 12},
  {1, 30},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {2, 17},
  {2, 20},
  {4, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {3, 20},
  {1, 28},
  {14, 1},
  {2, 5},
  {1, 30},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 21},
  {18, 1},
  {1, 4},
  {1, 12},
  {1, 28},
  {1, 20},
  {9, 17},
  {16, 20},
  {2, 17},
  {1, 30},
  {1, 9},
  {53, 1},
  {2, 5},
  {1, 12},
  {1, 31},
  {1, 14},
  {1, 11},
  {1, 2},
  {1, 5},
  {1, 15},
  {1, 16},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 6},
  {3, 12},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 6},
  {2, 16},
  {2, 23},
  {1, 26},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 14},
  {1, 18},
  {4, 14},
  {4, 13},
  {1, 11},
  {9, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {5, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {2, 7},
  {5, 10},
  {4, 3},
  {1, 10},
  {3, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {7, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 13},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {4, 11},
  {4, 13},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {3, 26},
  {1, 18},
  {2, 11},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 26},
  {2, 16},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 21},
  {1, 5},
  {3, 12},
  {1, 15},
  {2, 12},
  {1, 3},
  {2, 12},
  {2, 32},
  {1, 15},
  {21, 1},
  {1, 15},
  {26, 1},
  {1, 31},
  {1, 17},
  {1, 20},
  {8, 17},
  {1, 20},
  {2, 17},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 4},
  {1, 21},
  {1, 17},
  {7, 20},
  {1, 19},
  {2, 17},
  {3, 20},
  {1, 17},
  {4, 20},
  {1, 17},
  {1, 29},
  {1, 15},
  {14, 1},
  {1, 4},
  {1, 30},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 16},
  {1, 5},
  {17, 1},
  {2, 5},
  {1, 12},
  {1, 30},
  {1, 24},
  {4, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {11, 17},
  {5, 20},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 15},
  {1, 5},
  {53, 1},
  {1, 3},
  {1, 21},
  {1, 30},
  {1, 23},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {4, 13},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {3, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 7},
  {6, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 3},
  {1, 10},
  {7, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 21},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 2},
  {1, 5},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 26},
  {2, 23},
  {1, 21},
  {1, 30},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 21},
  {1, 4},
  {1, 12},
  {1, 4},
  {1, 12},
  {1, 16},
  {4, 11},
  {1, 14},
  {1, 30},
  {1, 32},
  {1, 9},
  {35, 1},
  {1, 15},
  {10, 1},
  {2, 5},
  {1, 31},
  {1, 17},
  {1, 20},
  {1, 19},
  {3, 17},
  {1, 19},
  {3, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {2, 20},
  {1, 28},
  {2, 1},
  {1, 4},
  {3, 5},
  {1, 28},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {4, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 15},
  {12, 1},
  {1, 4},
  {1, 16},
  {1, 31},
  {1, 19},
  {2, 17},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 9},
  {18, 1},
  {1, 5},
  {1, 3},
  {1, 1},
  {1, 21},
  {1, 31},
  {3, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {4, 17},
  {1, 20},
  {5, 17},
  {1, 31},
  {1, 28},
  {1, 5},
  {37, 1},
  {1, 15},
  {16, 1},
  {1, 5},
  {1, 2},
  {1, 14},
  {1, 31},
  {2, 16},
  {2, 12},
  {1, 15},
  {1, 12},
  {2, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 6},
  {2, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {2, 20},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 24},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 16},
  {1, 18},
  {2, 13},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 8},
  {1, 16},
  {6, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {3, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {6, 10},
  {4, 7},
  {1, 1},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {4, 6},
  {1, 2},
  {3, 11},
  {1, 13},
  {1, 11},
  {2, 13},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 26},
  {1, 32},
  {1, 23},
  {1, 15},
  {1, 8},
  {1, 21},
  {2, 19},
  {1, 17},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 5},
  {1, 3},
  {2, 15},
  {1, 12},
  {2, 8},
  {1, 5},
  {1, 11},
  {3, 21},
  {2, 16},
  {1, 30},
  {1, 28},
  {1, 11},
  {8, 1},
  {1, 15},
  {38, 1},
  {1, 5},
  {1, 31},
  {1, 20},
  {6, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {4, 1},
  {1, 5},
  {1, 1},
  {1, 15},
  {1, 31},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {4, 20},
  {2, 17},
  {1, 20},
  {1, 17},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 18},
  {13, 1},
  {1, 3},
  {1, 31},
  {3, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 30},
  {1, 16},
  {1, 5},
  {20, 1},
  {1, 4},
  {1, 28},
  {3, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {9, 17},
  {1, 21},
  {1, 7},
  {1, 5},
  {55, 1},
  {1, 7},
  {1, 15},
  {1, 29},
  {1, 16},
  {1, 13},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 25},
  {1, 17},
  {1, 19},
  {1, 27},
  {1, 5},
  {1, 11},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 16},
  {4, 14},
  {5, 13},
  {1, 2},
  {1, 11},
  {5, 6},
  {1, 11},
  {2, 6},
  {2, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {8, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {2, 10},
  {6, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {2, 10},
  {1, 3},
  {3, 10},
  {8, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {2, 18},
  {2, 21},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 6},
  {1, 18},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 21},
  {2, 8},
  {1, 12},
  {1, 4},
  {2, 16},
  {1, 12},
  {3, 16},
  {1, 30},
  {1, 28},
  {1, 15},
  {46, 1},
  {1, 7},
  {1, 5},
  {7, 20},
  {3, 17},
  {1, 19},
  {4, 20},
  {1, 17},
  {2, 20},
  {1, 28},
  {5, 1},
  {1, 12},
  {1, 5},
  {1, 28},
  {2, 17},
  {1, 20},
  {2, 17},
  {1, 19},
  {4, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {3, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 30},
  {1, 18},
  {11, 1},
  {1, 5},
  {1, 18},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {3, 17},
  {1, 30},
  {1, 5},
  {20, 1},
  {1, 7},
  {1, 5},
  {1, 13},
  {1, 30},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {2, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {4, 17},
  {1, 29},
  {1, 30},
  {58, 1},
  {1, 5},
  {1, 12},
  {1, 31},
  {1, 14},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 21},
  {1, 13},
  {1, 12},
  {1, 8},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 4},
  {1, 3},
  {1, 2},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 25},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 13},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 24},
  {1, 17},
  {1, 19},
  {1, 30},
  {5, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 11},
  {1, 6},
  {2, 11},
  {10, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {3, 8},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {1, 7},
  {3, 10},
  {3, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {4, 10},
  {13, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 21},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 18},
  {1, 11},
  {1, 13},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 26},
  {1, 23},
  {2, 16},
  {4, 12},
  {2, 15},
  {3, 12},
  {1, 15},
  {2, 12},
  {3, 16},
  {2, 32},
  {1, 15},
  {13, 1},
  {1, 15},
  {33, 1},
  {1, 2},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {5, 17},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 20},
  {1, 1},
  {1, 5},
  {4, 1},
  {2, 5},
  {1, 1},
  {1, 31},
  {1, 20},
  {5, 17},
  {1, 20},
  {1, 19},
  {4, 17},
  {3, 20},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 21},
  {1, 5},
  {11, 1},
  {1, 18},
  {1, 20},
  {2, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 30},
  {1, 9},
  {23, 1},
  {1, 28},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {3, 24},
  {2, 17},
  {2, 24},
  {2, 17},
  {1, 20},
  {1, 30},
  {1, 15},
  {1, 5},
  {13, 1},
  {1, 15},
  {43, 1},
  {1, 3},
  {1, 11},
  {1, 29},
  {1, 16},
  {2, 21},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {2, 16},
  {2, 14},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 23},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 11},
  {2, 6},
  {1, 2},
  {11, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {7, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {4, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {7, 7},
  {1, 9},
  {5, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 7},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 21},
  {1, 2},
  {1, 3},
  {1, 11},
  {1, 19},
  {2, 20},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {2, 12},
  {2, 16},
  {1, 12},
  {1, 16},
  {2, 14},
  {1, 30},
  {1, 28},
  {1, 7},
  {46, 1},
  {1, 15},
  {1, 21},
  {1, 20},
  {2, 17},
  {1, 20},
  {2, 17},
  {4, 20},
  {4, 17},
  {1, 19},
  {2, 17},
  {1, 20},
  {1, 15},
  {6, 1},
  {2, 5},
  {1, 16},
  {5, 20},
  {4, 17},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 15},
  {9, 1},
  {2, 5},
  {1, 16},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 28},
  {22, 1},
  {1, 4},
  {1, 7},
  {1, 21},
  {1, 29},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {4, 24},
  {1, 29},
  {1, 23},
  {58, 1},
  {2, 5},
  {1, 12},
  {1, 31},
  {1, 14},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 11},
  {1, 8},
  {1, 2},
  {1, 12},
  {1, 8},
  {1, 11},
  {2, 3},
  {1, 4},
  {1, 21},
  {1, 28},
  {1, 16},
  {2, 23},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {4, 16},
  {1, 26},
  {1, 32},
  {1, 29},
  {2, 19},
  {1, 30},
  {5, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {7, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 8},
  {2, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 9},
  {5, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 21},
  {2, 19},
  {1, 17},
  {3, 26},
  {1, 18},
  {1, 11},
  {1, 6},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 6},
  {2, 12},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {2, 16},
  {1, 27},
  {1, 28},
  {1, 11},
  {25, 1},
  {1, 15},
  {21, 1},
  {1, 21},
  {1, 20},
  {3, 17},
  {3, 20},
  {1, 19},
  {1, 17},
  {4, 20},
  {4, 17},
  {1, 31},
  {9, 1},
  {1, 4},
  {1, 32},
  {1, 17},
  {2, 20},
  {1, 19},
  {5, 17},
  {2, 20},
  {3, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 32},
  {1, 15},
  {10, 1},
  {1, 21},
  {4, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 28},
  {23, 1},
  {1, 13},
  {1, 31},
  {4, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {5, 24},
  {1, 17},
  {1, 26},
  {1, 15},
  {1, 5},
  {28, 1},
  {1, 15},
  {28, 1},
  {1, 4},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 5},
  {1, 2},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 2},
  {2, 21},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {2, 16},
  {1, 14},
  {1, 16},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 23},
  {2, 14},
  {1, 16},
  {2, 14},
  {3, 13},
  {1, 11},
  {6, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {6, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {13, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 7},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 15},
  {1, 1},
  {1, 28},
  {3, 20},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 21},
  {4, 12},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 30},
  {1, 28},
  {1, 15},
  {46, 1},
  {1, 5},
  {1, 28},
  {1, 20},
  {1, 17},
  {2, 20},
  {4, 17},
  {3, 20},
  {6, 17},
  {1, 31},
  {8, 1},
  {2, 5},
  {1, 18},
  {1, 31},
  {1, 20},
  {1, 17},
  {7, 20},
  {8, 17},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 21},
  {8, 1},
  {2, 5},
  {1, 21},
  {1, 17},
  {2, 20},
  {14, 17},
  {1, 20},
  {1, 21},
  {21, 1},
  {1, 5},
  {1, 16},
  {1, 30},
  {1, 29},
  {1, 24},
  {1, 17},
  {17, 24},
  {1, 29},
  {1, 17},
  {1, 29},
  {1, 23},
  {56, 1},
  {2, 5},
  {1, 7},
  {1, 21},
  {1, 31},
  {1, 18},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 8},
  {1, 16},
  {2, 14},
  {1, 26},
  {1, 29},
  {2, 17},
  {1, 30},
  {3, 16},
  {1, 14},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 13},
  {2, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {9, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {4, 2},
  {2, 8},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {2, 19},
  {1, 17},
  {2, 26},
  {1, 32},
  {1, 14},
  {2, 11},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 13},
  {1, 11},
  {3, 12},
  {2, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 32},
  {1, 27},
  {1, 5},
  {47, 1},
  {1, 30},
  {4, 17},
  {1, 20},
  {12, 17},
  {1, 31},
  {1, 15},
  {10, 1},
  {1, 28},
  {1, 31},
  {7, 17},
  {2, 20},
  {7, 17},
  {2, 20},
  {1, 17},
  {1, 30},
  {1, 15},
  {8, 1},
  {1, 5},
  {1, 30},
  {13, 17},
  {3, 20},
  {1, 17},
  {1, 20},
  {1, 12},
  {21, 1},
  {1, 3},
  {1, 32},
  {1, 29},
  {20, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 27},
  {2, 15},
  {56, 1},
  {1, 7},
  {1, 21},
  {1, 31},
  {1, 12},
  {1, 5},
  {4, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 3},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {2, 16},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 24},
  {2, 19},
  {1, 30},
  {1, 23},
  {4, 14},
  {5, 13},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {3, 10},
  {1, 9},
  {7, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {4, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {7, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 2},
  {3, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 15},
  {1, 1},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 32},
  {1, 30},
  {1, 15},
  {45, 1},
  {2, 5},
  {1, 28},
  {8, 17},
  {1, 24},
  {8, 17},
  {1, 30},
  {9, 1},
  {1, 5},
  {1, 7},
  {1, 18},
  {1, 30},
  {1, 31},
  {3, 17},
  {1, 24},
  {9, 17},
  {2, 20},
  {4, 17},
  {1, 28},
  {7, 1},
  {2, 5},
  {1, 30},
  {5, 17},
  {1, 20},
  {1, 17},
  {1, 20},
  {2, 17},
  {4, 20},
  {3, 17},
  {1, 31},
  {1, 15},
  {20, 1},
  {1, 9},
  {1, 28},
  {1, 31},
  {3, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {10, 24},
  {1, 25},
  {5, 24},
  {1, 29},
  {1, 17},
  {1, 29},
  {1, 28},
  {56, 1},
  {2, 5},
  {1, 21},
  {1, 30},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 8},
  {2, 12},
  {2, 11},
  {3, 8},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 5},
  {2, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {3, 16},
  {2, 23},
  {1, 26},
  {1, 24},
  {2, 19},
  {1, 30},
  {5, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {3, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {5, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 21},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 18},
  {1, 11},
  {1, 9},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 29},
  {1, 27},
  {1, 14},
  {1, 16},
  {1, 21},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 15},
  {3, 12},
  {1, 15},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 12},
  {18, 1},
  {1, 15},
  {28, 1},
  {1, 30},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 30},
  {1, 13},
  {11, 1},
  {1, 21},
  {1, 29},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {6, 17},
  {1, 20},
  {1, 30},
  {1, 18},
  {7, 1},
  {1, 13},
  {1, 31},
  {1, 24},
  {16, 17},
  {1, 29},
  {1, 13},
  {20, 1},
  {1, 21},
  {1, 31},
  {1, 29},
  {4, 24},
  {1, 25},
  {16, 24},
  {1, 29},
  {3, 24},
  {1, 29},
  {1, 11},
  {56, 1},
  {1, 7},
  {1, 21},
  {1, 30},
  {1, 18},
  {1, 6},
  {2, 21},
  {1, 11},
  {3, 12},
  {1, 8},
  {2, 15},
  {1, 4},
  {1, 12},
  {2, 4},
  {1, 2},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 32},
  {3, 16},
  {1, 23},
  {2, 26},
  {1, 24},
  {2, 19},
  {1, 32},
  {1, 21},
  {4, 14},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {3, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {3, 9},
  {2, 2},
  {3, 9},
  {1, 10},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {9, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 11},
  {1, 2},
  {2, 11},
  {2, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {2, 18},
  {1, 16},
  {1, 1},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {3, 15},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 28},
  {1, 15},
  {3, 12},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {2, 12},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 7},
  {1, 15},
  {44, 1},
  {1, 9},
  {1, 15},
  {1, 30},
  {1, 17},
  {5, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 32},
  {12, 1},
  {1, 15},
  {1, 21},
  {2, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {5, 24},
  {1, 28},
  {5, 1},
  {1, 4},
  {2, 5},
  {1, 29},
  {2, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {6, 17},
  {1, 30},
  {1, 11},
  {19, 1},
  {1, 14},
  {1, 27},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {3, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 30},
  {1, 15},
  {35, 1},
  {1, 15},
  {18, 1},
  {1, 7},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 5},
  {1, 12},
  {1, 18},
  {1, 13},
  {1, 8},
  {2, 12},
  {1, 5},
  {1, 28},
  {1, 21},
  {1, 3},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {3, 16},
  {2, 23},
  {1, 26},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 23},
  {4, 14},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 2},
  {8, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 8},
  {3, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {3, 7},
  {8, 9},
  {1, 7},
  {11, 9},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {3, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 21},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 22},
  {2, 23},
  {1, 11},
  {1, 8},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 12},
  {1, 11},
  {2, 21},
  {2, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 15},
  {2, 12},
  {1, 23},
  {1, 30},
  {1, 15},
  {46, 1},
  {1, 13},
  {1, 29},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 31},
  {1, 28},
  {1, 15},
  {1, 5},
  {11, 1},
  {1, 5},
  {1, 30},
  {1, 17},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {2, 24},
  {2, 17},
  {5, 24},
  {1, 17},
  {1, 29},
  {1, 13},
  {5, 1},
  {1, 5},
  {1, 18},
  {1, 31},
  {2, 24},
  {3, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {2, 24},
  {1, 30},
  {1, 18},
  {18, 1},
  {1, 15},
  {1, 30},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {3, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {6, 24},
  {1, 25},
  {1, 29},
  {1, 11},
  {14, 1},
  {1, 15},
  {40, 1},
  {1, 2},
  {2, 30},
  {1, 16},
  {3, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {3, 12},
  {1, 15},
  {1, 3},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {3, 16},
  {2, 23},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 32},
  {2, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 1},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {5, 7},
  {6, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {8, 9},
  {1, 7},
  {1, 2},
  {1, 9},
  {7, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 12},
  {7, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {5, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 5},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 5},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {1, 16},
  {1, 23},
  {1, 16},
  {2, 12},
  {1, 11},
  {1, 14},
  {1, 28},
  {2, 15},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 16},
  {1, 15},
  {1, 3},
  {1, 7},
  {1, 28},
  {1, 30},
  {1, 15},
  {44, 1},
  {2, 5},
  {1, 15},
  {1, 29},
  {16, 24},
  {1, 17},
  {1, 21},
  {13, 1},
  {1, 5},
  {1, 16},
  {1, 29},
  {1, 17},
  {11, 24},
  {2, 17},
  {3, 24},
  {1, 29},
  {1, 17},
  {1, 30},
  {1, 9},
  {5, 1},
  {1, 21},
  {1, 29},
  {2, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {3, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {2, 17},
  {1, 24},
  {1, 30},
  {1, 18},
  {16, 1},
  {1, 5},
  {1, 9},
  {1, 32},
  {1, 29},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {7, 25},
  {1, 24},
  {1, 29},
  {1, 30},
  {1, 15},
  {52, 1},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 21},
  {1, 15},
  {1, 16},
  {1, 11},
  {3, 12},
  {3, 6},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 17},
  {1, 20},
  {1, 21},
  {3, 16},
  {2, 23},
  {1, 32},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 23},
  {3, 14},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 16},
  {2, 13},
  {1, 2},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {2, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 8},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {4, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {3, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {3, 13},
  {1, 14},
  {1, 16},
  {3, 18},
  {2, 14},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 14},
  {1, 18},
  {1, 8},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {2, 23},
  {1, 30},
  {1, 23},
  {1, 11},
  {1, 14},
  {1, 15},
  {2, 16},
  {2, 15},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 30},
  {1, 21},
  {45, 1},
  {1, 5},
  {1, 15},
  {1, 29},
  {16, 24},
  {1, 29},
  {2, 4},
  {13, 1},
  {1, 7},
  {1, 30},
  {1, 29},
  {2, 24},
  {1, 25},
  {14, 24},
  {1, 17},
  {1, 29},
  {1, 23},
  {1, 14},
  {1, 5},
  {3, 1},
  {1, 21},
  {1, 29},
  {1, 17},
  {2, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 28},
  {1, 16},
  {17, 1},
  {1, 32},
  {2, 29},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {17, 25},
  {2, 24},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {2, 29},
  {1, 32},
  {1, 5},
  {52, 1},
  {1, 4},
  {1, 6},
  {1, 30},
  {1, 28},
  {1, 16},
  {1, 11},
  {1, 21},
  {3, 12},
  {1, 5},
  {1, 12},
  {2, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 21},
  {1, 9},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {2, 16},
  {1, 11},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 8},
  {1, 9},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {10, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {8, 6},
  {1, 2},
  {3, 11},
  {2, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 21},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 11},
  {2, 1},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 23},
  {1, 16},
  {1, 30},
  {1, 23},
  {1, 14},
  {3, 21},
  {2, 12},
  {2, 5},
  {2, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 28},
  {1, 30},
  {1, 21},
  {1, 15},
  {7, 1},
  {1, 15},
  {17, 1},
  {1, 15},
  {17, 1},
  {2, 5},
  {1, 28},
  {1, 29},
  {16, 24},
  {1, 29},
  {1, 11},
  {13, 1},
  {1, 5},
  {1, 4},
  {1, 13},
  {1, 29},
  {1, 17},
  {1, 24},
  {1, 25},
  {14, 24},
  {1, 29},
  {1, 24},
  {1, 29},
  {1, 14},
  {2, 1},
  {1, 5},
  {2, 15},
  {3, 24},
  {1, 29},
  {1, 17},
  {12, 24},
  {1, 29},
  {1, 23},
  {1, 11},
  {15, 1},
  {1, 5},
  {1, 21},
  {1, 27},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {2, 25},
  {1, 24},
  {5, 25},
  {1, 24},
  {12, 25},
  {1, 24},
  {2, 25},
  {1, 29},
  {1, 27},
  {1, 21},
  {51, 1},
  {1, 4},
  {1, 3},
  {1, 14},
  {1, 30},
  {1, 28},
  {3, 12},
  {1, 18},
  {2, 11},
  {1, 8},
  {2, 15},
  {2, 11},
  {1, 12},
  {3, 15},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 18},
  {3, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 23},
  {5, 14},
  {2, 16},
  {3, 13},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {2, 10},
  {4, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 2},
  {3, 9},
  {1, 7},
  {11, 9},
  {3, 2},
  {1, 9},
  {5, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 6},
  {1, 12},
  {1, 16},
  {1, 8},
  {5, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 11},
  {5, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 14},
  {1, 13},
  {2, 15},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 23},
  {2, 16},
  {3, 12},
  {1, 16},
  {2, 12},
  {1, 4},
  {1, 12},
  {1, 15},
  {3, 12},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 30},
  {1, 21},
  {1, 5},
  {44, 1},
  {1, 5},
  {1, 28},
  {2, 29},
  {14, 24},
  {1, 29},
  {1, 31},
  {1, 13},
  {15, 1},
  {1, 5},
  {1, 32},
  {2, 29},
  {17, 24},
  {1, 29},
  {1, 28},
  {1, 15},
  {3, 5},
  {1, 28},
  {1, 29},
  {3, 24},
  {1, 17},
  {1, 29},
  {8, 24},
  {1, 29},
  {1, 17},
  {2, 29},
  {1, 32},
  {1, 8},
  {15, 1},
  {1, 18},
  {1, 27},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {8, 25},
  {1, 24},
  {6, 25},
  {1, 24},
  {11, 25},
  {1, 24},
  {2, 25},
  {1, 28},
  {1, 15},
  {51, 1},
  {1, 4},
  {1, 16},
  {1, 31},
  {1, 21},
  {1, 16},
  {3, 12},
  {1, 11},
  {3, 15},
  {1, 12},
  {3, 11},
  {1, 12},
  {1, 18},
  {1, 21},
  {1, 6},
  {1, 14},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 31},
  {1, 14},
  {1, 12},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {4, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {3, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 15},
  {5, 9},
  {1, 8},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 21},
  {1, 18},
  {1, 1},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 16},
  {3, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 21},
  {1, 15},
  {1, 3},
  {1, 5},
  {1, 30},
  {1, 28},
  {1, 15},
  {30, 1},
  {1, 15},
  {11, 1},
  {3, 5},
  {1, 30},
  {1, 29},
  {4, 24},
  {1, 29},
  {3, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 29},
  {1, 30},
  {14, 1},
  {3, 5},
  {1, 18},
  {1, 27},
  {1, 29},
  {2, 24},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {3, 24},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 25},
  {3, 24},
  {1, 31},
  {1, 13},
  {1, 1},
  {1, 4},
  {1, 11},
  {1, 32},
  {1, 29},
  {1, 24},
  {1, 29},
  {12, 24},
  {1, 17},
  {1, 24},
  {1, 29},
  {1, 14},
  {1, 9},
  {14, 1},
  {1, 12},
  {1, 30},
  {2, 29},
  {5, 25},
  {1, 24},
  {8, 25},
  {1, 24},
  {19, 25},
  {1, 29},
  {1, 21},
  {14, 1},
  {1, 15},
  {19, 1},
  {1, 15},
  {15, 1},
  {3, 5},
  {1, 29},
  {1, 21},
  {4, 12},
  {1, 16},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 21},
  {2, 16},
  {1, 14},
  {1, 32},
  {1, 27},
  {2, 17},
  {1, 31},
  {1, 14},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {2, 19},
  {1, 20},
  {1, 23},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {2, 13},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 7},
  {1, 10},
  {5, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {8, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {4, 9},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 12},
  {6, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {6, 11},
  {3, 13},
  {1, 16},
  {3, 18},
  {1, 14},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 22},
  {1, 26},
  {2, 14},
  {2, 2},
  {1, 30},
  {2, 19},
  {1, 27},
  {1, 32},
  {1, 23},
  {2, 16},
  {3, 12},
  {1, 15},
  {1, 12},
  {3, 15},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 16},
  {1, 28},
  {1, 21},
  {1, 9},
  {43, 1},
  {2, 5},
  {1, 32},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 27},
  {1, 5},
  {15, 1},
  {1, 5},
  {1, 15},
  {1, 23},
  {2, 29},
  {2, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 24},
  {1, 29},
  {1, 32},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 30},
  {2, 25},
  {4, 24},
  {1, 25},
  {8, 24},
  {1, 29},
  {1, 24},
  {1, 29},
  {1, 16},
  {1, 5},
  {13, 1},
  {1, 7},
  {1, 32},
  {1, 27},
  {1, 29},
  {17, 25},
  {1, 24},
  {17, 25},
  {1, 27},
  {1, 30},
  {1, 10},
  {49, 1},
  {1, 5},
  {1, 4},
  {1, 13},
  {1, 31},
  {1, 16},
  {2, 12},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 13},
  {1, 12},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 14},
  {1, 26},
  {1, 27},
  {2, 17},
  {1, 31},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {2, 19},
  {1, 20},
  {1, 11},
  {4, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 16},
  {1, 2},
  {1, 11},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {8, 9},
  {1, 2},
  {2, 9},
  {1, 2},
  {1, 9},
  {7, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 16},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {5, 13},
  {4, 14},
  {1, 16},
  {1, 30},
  {2, 19},
  {1, 29},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 2},
  {1, 5},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 5},
  {1, 12},
  {2, 15},
  {1, 4},
  {1, 16},
  {1, 11},
  {1, 21},
  {1, 30},
  {1, 15},
  {42, 1},
  {2, 5},
  {1, 15},
  {1, 30},
  {1, 29},
  {2, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 30},
  {15, 1},
  {2, 5},
  {2, 12},
  {1, 27},
  {1, 29},
  {1, 24},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 29},
  {1, 24},
  {1, 25},
  {1, 24},
  {3, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 14},
  {1, 5},
  {1, 15},
  {1, 27},
  {2, 24},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {2, 24},
  {1, 29},
  {1, 30},
  {1, 2},
  {13, 1},
  {1, 5},
  {1, 21},
  {2, 29},
  {1, 22},
  {3, 25},
  {1, 27},
  {2, 25},
  {1, 27},
  {9, 25},
  {1, 27},
  {1, 29},
  {1, 27},
  {1, 25},
  {2, 22},
  {2, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 29},
  {1, 28},
  {19, 1},
  {1, 15},
  {28, 1},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 14},
  {1, 31},
  {1, 18},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {2, 8},
  {2, 12},
  {1, 11},
  {1, 15},
  {2, 11},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 13},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 23},
  {4, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {11, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {5, 10},
  {1, 7},
  {2, 10},
  {3, 7},
  {2, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {7, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {6, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 28},
  {2, 19},
  {1, 24},
  {1, 32},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 6},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 14},
  {1, 15},
  {1, 16},
  {2, 15},
  {1, 12},
  {2, 5},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 5},
  {15, 1},
  {1, 15},
  {28, 1},
  {1, 3},
  {1, 30},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 29},
  {1, 32},
  {1, 4},
  {15, 1},
  {3, 5},
  {1, 14},
  {1, 29},
  {1, 25},
  {1, 24},
  {9, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {2, 29},
  {1, 30},
  {1, 12},
  {1, 5},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 30},
  {1, 16},
  {13, 1},
  {1, 18},
  {1, 27},
  {1, 29},
  {2, 25},
  {1, 22},
  {4, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 27},
  {1, 25},
  {1, 27},
  {1, 32},
  {1, 29},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {6, 25},
  {1, 22},
  {2, 25},
  {2, 27},
  {1, 5},
  {48, 1},
  {1, 4},
  {1, 12},
  {1, 28},
  {1, 31},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 2},
  {1, 12},
  {1, 5},
  {2, 11},
  {1, 16},
  {1, 21},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 32},
  {1, 1},
  {1, 11},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 15},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {2, 10},
  {5, 9},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {7, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 11},
  {2, 15},
  {1, 20},
  {1, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 15},
  {1, 21},
  {1, 11},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 8},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 21},
  {1, 30},
  {1, 9},
  {1, 15},
  {41, 1},
  {1, 5},
  {1, 2},
  {1, 16},
  {3, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 21},
  {15, 1},
  {5, 5},
  {1, 28},
  {1, 27},
  {1, 24},
  {4, 25},
  {2, 24},
  {7, 25},
  {1, 29},
  {1, 24},
  {3, 29},
  {1, 23},
  {1, 15},
  {1, 27},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {2, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 32},
  {12, 1},
  {1, 4},
  {1, 21},
  {1, 32},
  {1, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {10, 25},
  {1, 29},
  {1, 30},
  {1, 13},
  {1, 5},
  {2, 27},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 29},
  {1, 28},
  {47, 1},
  {3, 5},
  {2, 30},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 3},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 3},
  {2, 12},
  {3, 11},
  {1, 21},
  {1, 12},
  {1, 13},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 28},
  {1, 6},
  {1, 13},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 31},
  {2, 19},
  {1, 31},
  {6, 14},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {6, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 16},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 13},
  {1, 6},
  {3, 13},
  {5, 14},
  {1, 21},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 32},
  {1, 14},
  {1, 21},
  {1, 18},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 14},
  {1, 12},
  {1, 13},
  {1, 30},
  {1, 21},
  {1, 5},
  {8, 1},
  {1, 15},
  {33, 1},
  {1, 5},
  {1, 11},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {3, 25},
  {1, 24},
  {1, 29},
  {1, 21},
  {1, 15},
  {1, 5},
  {15, 1},
  {2, 5},
  {1, 4},
  {1, 11},
  {1, 27},
  {6, 25},
  {1, 29},
  {2, 25},
  {1, 24},
  {6, 25},
  {1, 24},
  {2, 29},
  {1, 27},
  {1, 32},
  {1, 29},
  {1, 25},
  {2, 29},
  {1, 24},
  {4, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {1, 29},
  {1, 28},
  {1, 15},
  {10, 1},
  {1, 15},
  {1, 7},
  {1, 32},
  {4, 25},
  {1, 27},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 29},
  {1, 14},
  {1, 15},
  {1, 5},
  {1, 21},
  {2, 29},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {4, 25},
  {1, 30},
  {1, 27},
  {2, 15},
  {46, 1},
  {1, 5},
  {1, 8},
  {1, 30},
  {1, 27},
  {1, 4},
  {1, 12},
  {1, 8},
  {1, 11},
  {2, 3},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 5},
  {3, 12},
  {1, 21},
  {1, 16},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 24},
  {2, 20},
  {1, 28},
  {1, 8},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 28},
  {1, 21},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {3, 4},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 10},
  {2, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {5, 9},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 12},
  {3, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {3, 14},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 2},
  {1, 5},
  {1, 1},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {2, 14},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 8},
  {3, 12},
  {1, 15},
  {1, 5},
  {2, 15},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 13},
  {1, 14},
  {1, 30},
  {1, 21},
  {42, 1},
  {2, 5},
  {1, 15},
  {1, 29},
  {9, 25},
  {1, 24},
  {3, 25},
  {1, 29},
  {2, 25},
  {1, 29},
  {1, 18},
  {15, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 15},
  {1, 5},
  {1, 14},
  {2, 29},
  {1, 24},
  {8, 25},
  {1, 24},
  {5, 25},
  {2, 29},
  {1, 25},
  {1, 27},
  {3, 25},
  {1, 29},
  {1, 25},
  {1, 24},
  {10, 25},
  {1, 24},
  {1, 29},
  {1, 28},
  {10, 1},
  {1, 5},
  {1, 11},
  {1, 23},
  {1, 29},
  {1, 27},
  {2, 22},
  {3, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {4, 25},
  {1, 22},
  {1, 25},
  {1, 27},
  {1, 29},
  {1, 32},
  {1, 3},
  {2, 5},
  {1, 12},
  {1, 30},
  {1, 29},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 15},
  {45, 1},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 31},
  {1, 28},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 12},
  {2, 11},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 15},
  {2, 12},
  {1, 21},
  {1, 6},
  {1, 18},
  {1, 23},
  {1, 27},
  {1, 17},
  {2, 20},
  {1, 21},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 31},
  {2, 19},
  {1, 28},
  {5, 14},
  {1, 13},
  {1, 14},
  {4, 13},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 16},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {160, 0},
  {160, 0},
  {4, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 16},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 14},
  {1, 18},
  {1, 6},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 8},
  {1, 21},
  {1, 11},
  {1, 16},
  {1, 14},
  {1, 30},
  {1, 28},
  {1, 11},
  {42, 1},
  {1, 5},
  {1, 21},
  {1, 29},
  {14, 25},
  {1, 24},
  {1, 25},
  {1, 27},
  {1, 15},
  {1, 5},
  {16, 1},
  {5, 5},
  {1, 30},
  {1, 27},
  {16, 25},
  {2, 29},
  {4, 25},
  {1, 24},
  {8, 25},
  {1, 24},
  {4, 25},
  {1, 29},
  {1, 23},
  {1, 5},
  {10, 1},
  {1, 23},
  {1, 27},
  {1, 25},
  {1, 29},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {3, 22},
  {3, 25},
  {1, 27},
  {1, 26},
  {1, 15},
  {1, 3},
  {2, 5},
  {1, 4},
  {1, 23},
  {1, 25},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 15},
  {46, 1},
  {1, 4},
  {1, 15},
  {1, 31},
  {1, 23},
  {1, 13},
  {3, 12},
  {1, 6},
  {1, 15},
  {2, 8},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 3},
  {1, 11},
  {1, 21},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 31},
  {1, 16},
  {1, 2},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 23},
  {3, 14},
  {2, 16},
  {1, 14},
  {3, 13},
  {1, 11},
  {1, 13},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 12},
  {3, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {2, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {4, 4},
  {1, 1},
  {1, 7},
  {2, 3},
  {1, 10},
  {2, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {4, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {5, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {3, 6},
  {1, 12},
  {5, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {4, 13},
  {4, 14},
  {1, 16},
  {1, 5},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 32},
  {1, 23},
  {1, 18},
  {1, 7},
  {1, 1},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 26},
  {1, 14},
  {1, 21},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 12},
  {2, 11},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 15},
  {40, 1},
  {3, 5},
  {1, 28},
  {1, 27},
  {6, 25},
  {1, 27},
  {9, 25},
  {1, 27},
  {1, 7},
  {17, 1},
  {4, 5},
  {1, 12},
  {1, 21},
  {2, 27},
  {11, 25},
  {1, 29},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 29},
  {8, 25},
  {1, 29},
  {8, 25},
  {2, 29},
  {1, 18},
  {9, 1},
  {1, 3},
  {1, 21},
  {1, 32},
  {1, 22},
  {3, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {2, 22},
  {2, 25},
  {1, 27},
  {1, 14},
  {1, 5},
  {1, 4},
  {4, 5},
  {2, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {4, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {4, 22},
  {1, 29},
  {1, 27},
  {1, 32},
  {33, 1},
  {1, 15},
  {11, 1},
  {1, 5},
  {1, 12},
  {1, 21},
  {1, 31},
  {1, 23},
  {1, 13},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 6},
  {1, 8},
  {1, 15},
  {1, 5},
  {3, 15},
  {1, 3},
  {1, 12},
  {2, 11},
  {1, 16},
  {1, 18},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 31},
  {1, 13},
  {2, 6},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 20},
  {1, 23},
  {4, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {5, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {2, 9},
  {1, 10},
  {3, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 10},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {4, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 12},
  {3, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 13},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 22},
  {2, 23},
  {1, 13},
  {1, 11},
  {1, 9},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {2, 14},
  {1, 11},
  {1, 8},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 16},
  {1, 8},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 12},
  {41, 1},
  {2, 5},
  {1, 28},
  {1, 27},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {2, 25},
  {1, 29},
  {1, 27},
  {1, 5},
  {19, 1},
  {3, 4},
  {1, 15},
  {1, 32},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {4, 25},
  {1, 27},
  {2, 25},
  {1, 27},
  {1, 25},
  {1, 27},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 29},
  {2, 25},
  {1, 27},
  {2, 15},
  {8, 1},
  {1, 13},
  {1, 32},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {7, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 27},
  {1, 30},
  {1, 14},
  {3, 5},
  {1, 4},
  {2, 5},
  {1, 8},
  {1, 14},
  {2, 27},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 27},
  {1, 25},
  {5, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 27},
  {1, 25},
  {2, 22},
  {1, 28},
  {1, 5},
  {44, 1},
  {1, 3},
  {1, 28},
  {1, 31},
  {1, 23},
  {1, 30},
  {2, 21},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 8},
  {1, 15},
  {2, 5},
  {2, 15},
  {2, 12},
  {1, 16},
  {1, 18},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 21},
  {6, 14},
  {4, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {10, 6},
  {1, 12},
  {3, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {3, 10},
  {7, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {4, 9},
  {5, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {10, 2},
  {1, 11},
  {1, 12},
  {1, 16},
  {6, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {3, 18},
  {1, 15},
  {1, 30},
  {2, 19},
  {1, 17},
  {2, 26},
  {1, 23},
  {1, 18},
  {2, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 11},
  {2, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 2},
  {1, 4},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 15},
  {40, 1},
  {2, 5},
  {1, 15},
  {1, 32},
  {1, 27},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {3, 25},
  {1, 27},
  {2, 25},
  {1, 27},
  {13, 1},
  {1, 5},
  {1, 15},
  {4, 1},
  {1, 4},
  {5, 5},
  {1, 27},
  {1, 22},
  {9, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {7, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {2, 25},
  {1, 29},
  {1, 27},
  {1, 11},
  {8, 1},
  {1, 6},
  {1, 32},
  {1, 27},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {5, 22},
  {1, 25},
  {2, 27},
  {1, 32},
  {1, 9},
  {1, 4},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 15},
  {1, 32},
  {1, 27},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {4, 22},
  {2, 27},
  {1, 25},
  {1, 22},
  {1, 27},
  {1, 15},
  {42, 1},
  {1, 5},
  {1, 3},
  {1, 13},
  {1, 28},
  {1, 30},
  {1, 11},
  {1, 8},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 15},
  {2, 4},
  {1, 3},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 18},
  {1, 21},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {5, 14},
  {1, 16},
  {4, 13},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {7, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {7, 9},
  {1, 10},
  {1, 9},
  {9, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {8, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {12, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {3, 11},
  {3, 13},
  {1, 16},
  {1, 18},
  {1, 14},
  {3, 18},
  {1, 30},
  {2, 19},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 13},
  {1, 7},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {2, 16},
  {1, 3},
  {1, 8},
  {1, 21},
  {4, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 21},
  {1, 11},
  {1, 8},
  {1, 12},
  {1, 16},
  {1, 30},
  {1, 21},
  {1, 15},
  {14, 1},
  {1, 15},
  {25, 1},
  {2, 5},
  {1, 28},
  {2, 25},
  {1, 22},
  {5, 25},
  {1, 22},
  {2, 25},
  {2, 22},
  {3, 25},
  {1, 27},
  {1, 32},
  {1, 5},
  {12, 1},
  {3, 5},
  {4, 1},
  {5, 5},
  {1, 28},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {2, 27},
  {1, 15},
  {8, 1},
  {1, 23},
  {1, 27},
  {7, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 27},
  {1, 30},
  {1, 12},
  {2, 5},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 15},
  {2, 27},
  {2, 22},
  {1, 25},
  {7, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {4, 22},
  {1, 27},
  {1, 21},
  {1, 15},
  {12, 1},
  {1, 15},
  {29, 1},
  {1, 4},
  {1, 12},
  {1, 30},
  {1, 28},
  {1, 12},
  {1, 16},
  {1, 21},
  {2, 12},
  {1, 5},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 21},
  {1, 28},
  {2, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 28},
  {1, 11},
  {1, 13},
  {1, 18},
  {2, 23},
  {1, 26},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 11},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {7, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 10},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 7},
  {4, 10},
  {3, 3},
  {1, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {3, 10},
  {4, 9},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {11, 2},
  {9, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {4, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 15},
  {2, 19},
  {1, 17},
  {1, 27},
  {2, 26},
  {1, 14},
  {1, 15},
  {1, 1},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 8},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 16},
  {2, 15},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 8},
  {1, 2},
  {2, 16},
  {1, 30},
  {1, 28},
  {27, 1},
  {1, 15},
  {11, 1},
  {2, 5},
  {1, 15},
  {1, 5},
  {2, 27},
  {1, 25},
  {5, 22},
  {1, 25},
  {2, 22},
  {3, 25},
  {1, 22},
  {3, 25},
  {1, 23},
  {14, 1},
  {1, 5},
  {5, 1},
  {1, 4},
  {1, 1},
  {4, 5},
  {1, 30},
  {1, 27},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {3, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {2, 27},
  {7, 1},
  {1, 15},
  {1, 14},
  {2, 27},
  {3, 22},
  {1, 25},
  {5, 22},
  {1, 25},
  {5, 22},
  {1, 25},
  {1, 22},
  {2, 27},
  {1, 18},
  {1, 5},
  {4, 1},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 15},
  {1, 32},
  {1, 27},
  {16, 22},
  {1, 25},
  {2, 27},
  {1, 15},
  {4, 1},
  {1, 15},
  {36, 1},
  {1, 5},
  {1, 15},
  {1, 11},
  {1, 31},
  {1, 21},
  {1, 12},
  {1, 16},
  {1, 11},
  {2, 12},
  {1, 2},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 2},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 18},
  {1, 21},
  {1, 27},
  {1, 29},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 30},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {4, 13},
  {2, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 16},
  {1, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {7, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {2, 10},
  {3, 3},
  {1, 10},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 15},
  {1, 8},
  {2, 2},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 2},
  {1, 11},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 23},
  {2, 14},
  {1, 15},
  {1, 28},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 4},
  {1, 9},
  {1, 6},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 5},
  {32, 1},
  {1, 15},
  {6, 1},
  {2, 5},
  {1, 3},
  {1, 27},
  {2, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {2, 25},
  {2, 27},
  {1, 23},
  {1, 15},
  {1, 5},
  {21, 1},
  {3, 5},
  {1, 14},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 32},
  {1, 15},
  {6, 1},
  {1, 14},
  {1, 27},
  {1, 22},
  {1, 25},
  {12, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 27},
  {1, 23},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 15},
  {3, 5},
  {1, 15},
  {2, 27},
  {3, 22},
  {1, 25},
  {8, 22},
  {1, 25},
  {3, 22},
  {2, 27},
  {1, 23},
  {41, 1},
  {1, 5},
  {1, 3},
  {1, 28},
  {1, 31},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {2, 5},
  {4, 12},
  {1, 18},
  {1, 23},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {2, 12},
  {1, 16},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 21},
  {2, 14},
  {2, 16},
  {1, 14},
  {3, 13},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {8, 6},
  {1, 8},
  {4, 6},
  {1, 12},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {5, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 9},
  {4, 2},
  {2, 6},
  {1, 12},
  {1, 16},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {3, 11},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 21},
  {1, 1},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 27},
  {1, 22},
  {2, 23},
  {1, 18},
  {1, 9},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 15},
  {2, 5},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 11},
  {1, 15},
  {30, 1},
  {1, 5},
  {6, 1},
  {2, 5},
  {1, 15},
  {1, 5},
  {2, 27},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {2, 25},
  {1, 27},
  {1, 18},
  {21, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 32},
  {1, 27},
  {5, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 27},
  {1, 23},
  {6, 1},
  {1, 6},
  {1, 26},
  {1, 27},
  {8, 22},
  {1, 25},
  {4, 22},
  {1, 25},
  {3, 22},
  {1, 27},
  {1, 22},
  {1, 23},
  {1, 6},
  {1, 5},
  {4, 1},
  {7, 5},
  {1, 15},
  {1, 21},
  {2, 27},
  {3, 22},
  {1, 25},
  {1, 22},
  {1, 27},
  {1, 22},
  {1, 25},
  {9, 22},
  {1, 27},
  {1, 15},
  {18, 1},
  {1, 15},
  {20, 1},
  {2, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 11},
  {1, 5},
  {2, 12},
  {1, 6},
  {2, 21},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 13},
  {1, 6},
  {2, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {4, 14},
  {1, 16},
  {1, 18},
  {4, 13},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 16},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 11},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {7, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {8, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {8, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {7, 2},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 12},
  {3, 6},
  {2, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 6},
  {4, 11},
  {2, 13},
  {2, 14},
  {1, 18},
  {1, 16},
  {1, 14},
  {2, 18},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 24},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 6},
  {1, 2},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 26},
  {2, 23},
  {3, 16},
  {2, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 14},
  {1, 30},
  {1, 21},
  {1, 8},
  {38, 1},
  {2, 5},
  {1, 15},
  {2, 27},
  {1, 22},
  {1, 25},
  {6, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 5},
  {19, 1},
  {1, 15},
  {3, 5},
  {2, 4},
  {1, 5},
  {1, 11},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {8, 22},
  {1, 25},
  {1, 22},
  {1, 27},
  {1, 23},
  {1, 11},
  {4, 1},
  {1, 2},
  {1, 32},
  {1, 27},
  {4, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {7, 22},
  {1, 25},
  {1, 22},
  {2, 27},
  {1, 26},
  {1, 15},
  {2, 5},
  {5, 1},
  {7, 5},
  {1, 15},
  {1, 27},
  {19, 22},
  {1, 32},
  {40, 1},
  {1, 5},
  {1, 11},
  {1, 30},
  {1, 28},
  {2, 12},
  {1, 16},
  {2, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 13},
  {1, 14},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 21},
  {1, 14},
  {1, 16},
  {2, 14},
  {2, 16},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 12},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 10},
  {5, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {7, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {3, 9},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 8},
  {1, 11},
  {8, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 1},
  {1, 30},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 15},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {2, 23},
  {2, 16},
  {2, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 5},
  {1, 12},
  {2, 15},
  {1, 21},
  {2, 12},
  {1, 14},
  {1, 30},
  {1, 23},
  {17, 1},
  {1, 15},
  {19, 1},
  {3, 5},
  {1, 15},
  {1, 21},
  {1, 27},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 27},
  {1, 11},
  {17, 1},
  {5, 5},
  {1, 15},
  {2, 5},
  {2, 4},
  {1, 15},
  {1, 21},
  {2, 27},
  {5, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 14},
  {4, 1},
  {1, 5},
  {1, 26},
  {1, 27},
  {11, 22},
  {1, 27},
  {6, 22},
  {2, 27},
  {1, 16},
  {1, 5},
  {7, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {5, 5},
  {1, 14},
  {1, 30},
  {18, 22},
  {1, 27},
  {1, 21},
  {38, 1},
  {2, 5},
  {1, 21},
  {1, 31},
  {1, 14},
  {1, 12},
  {2, 15},
  {1, 30},
  {1, 12},
  {1, 11},
  {2, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {2, 18},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 28},
  {2, 13},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 23},
  {1, 14},
  {1, 16},
  {3, 14},
  {4, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {14, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {3, 10},
  {1, 9},
  {5, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {3, 10},
  {6, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 15},
  {1, 9},
  {5, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {3, 18},
  {1, 21},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {2, 14},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 27},
  {4, 23},
  {1, 21},
  {1, 16},
  {2, 15},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 16},
  {1, 32},
  {1, 30},
  {1, 4},
  {37, 1},
  {3, 5},
  {1, 23},
  {1, 27},
  {11, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {1, 27},
  {2, 5},
  {18, 1},
  {6, 5},
  {1, 4},
  {2, 5},
  {1, 15},
  {1, 30},
  {1, 27},
  {1, 25},
  {3, 22},
  {1, 25},
  {4, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {2, 27},
  {1, 14},
  {1, 7},
  {3, 1},
  {1, 23},
  {1, 27},
  {14, 22},
  {1, 25},
  {4, 22},
  {1, 27},
  {1, 23},
  {3, 5},
  {9, 1},
  {1, 15},
  {4, 5},
  {1, 4},
  {1, 32},
  {1, 27},
  {2, 22},
  {1, 27},
  {15, 22},
  {1, 23},
  {1, 11},
  {38, 1},
  {1, 8},
  {1, 28},
  {1, 30},
  {1, 14},
  {1, 16},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 5},
  {1, 21},
  {2, 12},
  {1, 15},
  {2, 12},
  {2, 16},
  {1, 13},
  {1, 21},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 9},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 31},
  {1, 21},
  {3, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {5, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 12},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {7, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {7, 9},
  {2, 8},
  {1, 9},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 15},
  {3, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {5, 13},
  {1, 14},
  {1, 16},
  {2, 18},
  {1, 21},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 22},
  {2, 26},
  {1, 14},
  {1, 13},
  {1, 11},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 27},
  {1, 32},
  {1, 14},
  {1, 16},
  {2, 11},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 21},
  {2, 15},
  {1, 2},
  {1, 28},
  {1, 30},
  {1, 7},
  {1, 15},
  {32, 1},
  {2, 5},
  {1, 15},
  {4, 5},
  {1, 32},
  {1, 27},
  {1, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {10, 22},
  {1, 27},
  {1, 32},
  {1, 15},
  {21, 1},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 12},
  {1, 23},
  {2, 27},
  {5, 22},
  {1, 25},
  {6, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 22},
  {2, 27},
  {1, 13},
  {2, 1},
  {1, 5},
  {1, 14},
  {1, 26},
  {20, 22},
  {1, 23},
  {1, 9},
  {5, 1},
  {2, 5},
  {1, 15},
  {1, 1},
  {9, 5},
  {1, 21},
  {1, 27},
  {2, 22},
  {1, 26},
  {15, 22},
  {1, 27},
  {1, 21},
  {37, 1},
  {1, 4},
  {1, 16},
  {2, 30},
  {1, 16},
  {1, 21},
  {1, 28},
  {1, 16},
  {1, 21},
  {2, 12},
  {1, 15},
  {3, 12},
  {1, 3},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 6},
  {1, 23},
  {1, 18},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 31},
  {1, 18},
  {1, 6},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 24},
  {2, 19},
  {1, 28},
  {4, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {5, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {5, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {4, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 8},
  {4, 2},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 14},
  {1, 6},
  {1, 12},
  {1, 28},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 27},
  {1, 30},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 18},
  {1, 12},
  {1, 8},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 16},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 5},
  {33, 1},
  {6, 5},
  {1, 28},
  {1, 27},
  {1, 25},
  {6, 22},
  {1, 25},
  {7, 22},
  {1, 25},
  {1, 32},
  {2, 5},
  {13, 1},
  {1, 15},
  {1, 5},
  {8, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 16},
  {1, 32},
  {1, 27},
  {1, 25},
  {8, 22},
  {1, 25},
  {11, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {1, 26},
  {1, 16},
  {1, 5},
  {1, 1},
  {1, 6},
  {1, 26},
  {18, 22},
  {2, 27},
  {1, 26},
  {1, 15},
  {1, 8},
  {1, 5},
  {5, 1},
  {7, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 32},
  {1, 27},
  {18, 22},
  {1, 26},
  {1, 13},
  {27, 1},
  {1, 15},
  {9, 1},
  {1, 13},
  {1, 30},
  {1, 21},
  {1, 16},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 16},
  {2, 18},
  {2, 14},
  {1, 28},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 2},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {2, 21},
  {4, 14},
  {4, 13},
  {2, 6},
  {3, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 16},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {4, 8},
  {3, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {7, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {9, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 1},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 6},
  {2, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 26},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 15},
  {1, 11},
  {1, 5},
  {1, 21},
  {1, 18},
  {1, 14},
  {1, 30},
  {1, 21},
  {1, 15},
  {4, 1},
  {1, 15},
  {29, 1},
  {1, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 12},
  {1, 26},
  {1, 27},
  {4, 22},
  {1, 27},
  {4, 22},
  {1, 25},
  {5, 22},
  {1, 27},
  {1, 23},
  {1, 15},
  {12, 1},
  {3, 5},
  {6, 1},
  {2, 5},
  {1, 15},
  {1, 5},
  {2, 4},
  {2, 5},
  {1, 16},
  {1, 14},
  {3, 27},
  {15, 22},
  {1, 25},
  {9, 22},
  {1, 27},
  {1, 26},
  {1, 12},
  {1, 4},
  {1, 12},
  {1, 23},
  {1, 26},
  {18, 22},
  {2, 27},
  {1, 13},
  {8, 1},
  {1, 5},
  {4, 1},
  {2, 5},
  {1, 15},
  {3, 5},
  {2, 12},
  {1, 16},
  {1, 27},
  {1, 26},
  {18, 22},
  {1, 32},
  {6, 1},
  {1, 15},
  {28, 1},
  {1, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 14},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 2},
  {1, 12},
  {1, 11},
  {1, 16},
  {1, 18},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 13},
  {1, 8},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 21},
  {4, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 6},
  {1, 8},
  {1, 16},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {4, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {6, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {2, 8},
  {4, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 13},
  {1, 6},
  {3, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 21},
  {1, 30},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 2},
  {1, 15},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {4, 16},
  {1, 12},
  {1, 11},
  {1, 21},
  {2, 8},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 15},
  {1, 8},
  {1, 13},
  {2, 28},
  {1, 11},
  {36, 1},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 32},
  {16, 22},
  {1, 27},
  {1, 23},
  {1, 12},
  {1, 5},
  {21, 1},
  {4, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 15},
  {1, 16},
  {1, 23},
  {1, 27},
  {1, 25},
  {4, 22},
  {1, 25},
  {5, 22},
  {1, 25},
  {2, 22},
  {1, 25},
  {11, 22},
  {1, 27},
  {1, 26},
  {1, 5},
  {1, 1},
  {1, 23},
  {1, 26},
  {18, 22},
  {1, 26},
  {1, 27},
  {1, 14},
  {1, 5},
  {1, 4},
  {12, 1},
  {8, 5},
  {1, 12},
  {1, 23},
  {1, 22},
  {1, 26},
  {16, 22},
  {2, 26},
  {1, 18},
  {21, 1},
  {1, 15},
  {13, 1},
  {1, 3},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 12},
  {2, 4},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 29},
  {3, 20},
  {1, 28},
  {1, 12},
  {2, 13},
  {1, 14},
  {1, 32},
  {1, 26},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 21},
  {1, 18},
  {3, 14},
  {1, 16},
  {5, 13},
  {1, 6},
  {3, 11},
  {8, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {5, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 8},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 14},
  {1, 18},
  {1, 1},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 8},
  {1, 30},
  {1, 28},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 3},
  {1, 8},
  {1, 21},
  {1, 4},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 15},
  {33, 1},
  {4, 5},
  {1, 8},
  {1, 12},
  {1, 30},
  {16, 22},
  {1, 27},
  {1, 14},
  {23, 1},
  {2, 5},
  {1, 1},
  {5, 5},
  {1, 15},
  {1, 14},
  {1, 32},
  {6, 22},
  {1, 26},
  {1, 22},
  {1, 27},
  {1, 22},
  {1, 26},
  {2, 22},
  {1, 26},
  {1, 22},
  {1, 26},
  {3, 22},
  {1, 27},
  {2, 22},
  {1, 25},
  {3, 22},
  {1, 27},
  {1, 23},
  {1, 8},
  {1, 14},
  {1, 26},
  {19, 22},
  {1, 27},
  {1, 23},
  {1, 15},
  {11, 1},
  {2, 5},
  {1, 15},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 15},
  {2, 26},
  {18, 22},
  {1, 32},
  {1, 15},
  {32, 1},
  {1, 4},
  {1, 3},
  {1, 15},
  {1, 30},
  {1, 28},
  {1, 16},
  {4, 11},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 18},
  {1, 6},
  {1, 13},
  {2, 14},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 31},
  {5, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {1, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {2, 6},
  {1, 16},
  {1, 6},
  {1, 12},
  {7, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {5, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {3, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {4, 10},
  {6, 7},
  {4, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 8},
  {3, 2},
  {3, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {10, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 16},
  {3, 14},
  {2, 18},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 9},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 24},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 21},
  {2, 5},
  {1, 16},
  {3, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 11},
  {2, 12},
  {1, 16},
  {1, 30},
  {1, 21},
  {35, 1},
  {2, 5},
  {1, 4},
  {1, 13},
  {1, 26},
  {11, 22},
  {1, 26},
  {4, 22},
  {1, 27},
  {1, 14},
  {1, 9},
  {5, 1},
  {1, 15},
  {21, 1},
  {3, 5},
  {1, 4},
  {1, 16},
  {1, 23},
  {1, 27},
  {25, 22},
  {1, 27},
  {1, 32},
  {1, 14},
  {2, 26},
  {18, 22},
  {2, 26},
  {1, 8},
  {2, 5},
  {11, 1},
  {4, 5},
  {3, 1},
  {2, 4},
  {3, 5},
  {1, 23},
  {1, 26},
  {18, 22},
  {1, 26},
  {1, 14},
  {14, 1},
  {1, 15},
  {18, 1},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 21},
  {2, 12},
  {4, 8},
  {3, 12},
  {2, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 13},
  {4, 14},
  {1, 16},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 12},
  {5, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {3, 6},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {1, 8},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 10},
  {3, 3},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {9, 9},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 15},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 16},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 5},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 9},
  {1, 5},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 26},
  {1, 23},
  {2, 16},
  {2, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 30},
  {1, 28},
  {1, 15},
  {34, 1},
  {2, 5},
  {1, 15},
  {1, 16},
  {1, 27},
  {1, 26},
  {15, 22},
  {1, 27},
  {1, 15},
  {27, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 12},
  {1, 4},
  {1, 32},
  {1, 27},
  {19, 22},
  {1, 27},
  {5, 22},
  {2, 26},
  {1, 22},
  {1, 26},
  {18, 22},
  {1, 32},
  {1, 11},
  {14, 1},
  {1, 5},
  {1, 1},
  {2, 5},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 12},
  {3, 26},
  {5, 22},
  {1, 26},
  {11, 22},
  {1, 26},
  {1, 15},
  {31, 1},
  {2, 5},
  {1, 28},
  {1, 30},
  {1, 6},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 14},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 2},
  {2, 12},
  {1, 16},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 28},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {3, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 2},
  {1, 13},
  {8, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 8},
  {2, 9},
  {1, 7},
  {3, 9},
  {3, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {8, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {1, 2},
  {3, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {3, 18},
  {1, 30},
  {2, 19},
  {1, 24},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {2, 16},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 16},
  {1, 18},
  {1, 12},
  {1, 5},
  {1, 2},
  {1, 11},
  {1, 15},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 12},
  {1, 3},
  {26, 1},
  {1, 15},
  {1, 5},
  {6, 1},
  {2, 5},
  {1, 14},
  {1, 26},
  {16, 22},
  {1, 27},
  {2, 5},
  {28, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 11},
  {1, 27},
  {25, 22},
  {1, 26},
  {13, 22},
  {1, 26},
  {6, 22},
  {1, 26},
  {1, 16},
  {1, 12},
  {1, 4},
  {16, 1},
  {4, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 16},
  {1, 22},
  {1, 26},
  {16, 22},
  {1, 26},
  {1, 22},
  {1, 14},
  {32, 1},
  {1, 13},
  {2, 30},
  {2, 12},
  {1, 9},
  {1, 11},
  {1, 12},
  {2, 21},
  {2, 12},
  {1, 8},
  {1, 3},
  {1, 15},
  {3, 12},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 20},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 1},
  {4, 14},
  {4, 13},
  {2, 11},
  {1, 2},
  {2, 11},
  {3, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {6, 9},
  {1, 7},
  {4, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {6, 13},
  {2, 14},
  {2, 16},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 22},
  {1, 23},
  {1, 16},
  {2, 18},
  {1, 12},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 11},
  {3, 12},
  {1, 21},
  {1, 16},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 8},
  {1, 5},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 23},
  {1, 30},
  {1, 21},
  {1, 15},
  {24, 1},
  {2, 5},
  {7, 1},
  {2, 5},
  {1, 11},
  {1, 23},
  {1, 27},
  {1, 26},
  {15, 22},
  {1, 27},
  {1, 15},
  {29, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 23},
  {1, 27},
  {26, 22},
  {1, 26},
  {11, 22},
  {1, 26},
  {5, 22},
  {1, 27},
  {1, 23},
  {1, 4},
  {17, 1},
  {3, 5},
  {1, 15},
  {1, 5},
  {3, 4},
  {4, 5},
  {2, 26},
  {17, 22},
  {1, 27},
  {1, 32},
  {1, 15},
  {30, 1},
  {1, 9},
  {1, 16},
  {1, 31},
  {1, 21},
  {2, 12},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 28},
  {1, 12},
  {1, 3},
  {2, 12},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 24},
  {1, 19},
  {1, 20},
  {1, 13},
  {1, 2},
  {1, 13},
  {2, 14},
  {2, 26},
  {1, 17},
  {2, 19},
  {1, 30},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 13},
  {1, 11},
  {4, 6},
  {1, 2},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {9, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {5, 7},
  {8, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 16},
  {5, 14},
  {1, 23},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 6},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 12},
  {1, 4},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 3},
  {1, 15},
  {1, 5},
  {1, 12},
  {2, 21},
  {1, 30},
  {1, 32},
  {1, 13},
  {6, 1},
  {1, 15},
  {5, 1},
  {1, 15},
  {5, 1},
  {1, 15},
  {16, 1},
  {1, 4},
  {1, 23},
  {16, 22},
  {1, 27},
  {1, 32},
  {1, 2},
  {1, 5},
  {22, 1},
  {1, 15},
  {2, 5},
  {5, 1},
  {1, 4},
  {3, 5},
  {1, 16},
  {1, 26},
  {1, 27},
  {43, 22},
  {1, 16},
  {1, 12},
  {1, 5},
  {5, 1},
  {1, 15},
  {1, 5},
  {12, 1},
  {4, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {3, 5},
  {1, 16},
  {2, 26},
  {17, 22},
  {1, 26},
  {1, 23},
  {1, 15},
  {29, 1},
  {1, 2},
  {2, 30},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 3},
  {1, 15},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 21},
  {3, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 5},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 21},
  {4, 14},
  {4, 13},
  {1, 2},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {5, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {5, 10},
  {8, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 13},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 3},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 5},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 27},
  {2, 23},
  {1, 16},
  {2, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {2, 15},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 12},
  {2, 16},
  {1, 21},
  {1, 30},
  {1, 18},
  {1, 15},
  {32, 1},
  {1, 4},
  {1, 5},
  {1, 8},
  {1, 28},
  {16, 22},
  {1, 27},
  {1, 32},
  {1, 5},
  {14, 1},
  {1, 5},
  {1, 15},
  {5, 1},
  {3, 5},
  {6, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 11},
  {1, 16},
  {1, 27},
  {41, 22},
  {1, 27},
  {1, 32},
  {1, 2},
  {5, 1},
  {3, 5},
  {13, 1},
  {2, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 3},
  {2, 12},
  {1, 23},
  {2, 26},
  {16, 22},
  {1, 27},
  {1, 32},
  {1, 15},
  {27, 1},
  {2, 5},
  {1, 16},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 12},
  {1, 11},
  {1, 3},
  {1, 12},
  {1, 15},
  {4, 12},
  {1, 15},
  {3, 12},
  {2, 21},
  {2, 14},
  {1, 23},
  {1, 30},
  {1, 24},
  {2, 20},
  {1, 28},
  {1, 11},
  {1, 6},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 21},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 16},
  {1, 12},
  {5, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {6, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {2, 9},
  {1, 7},
  {3, 8},
  {1, 9},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {4, 11},
  {3, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {2, 16},
  {1, 14},
  {1, 30},
  {2, 19},
  {1, 17},
  {1, 26},
  {1, 22},
  {2, 23},
  {2, 16},
  {1, 13},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 23},
  {3, 16},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 21},
  {1, 8},
  {3, 11},
  {2, 12},
  {1, 16},
  {2, 28},
  {1, 12},
  {34, 1},
  {1, 3},
  {1, 32},
  {16, 22},
  {1, 27},
  {1, 26},
  {2, 5},
  {13, 1},
  {3, 5},
  {4, 1},
  {1, 5},
  {11, 1},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 28},
  {1, 27},
  {40, 22},
  {1, 26},
  {1, 14},
  {1, 7},
  {1, 5},
  {5, 1},
  {1, 5},
  {21, 1},
  {3, 5},
  {2, 12},
  {1, 26},
  {18, 22},
  {1, 26},
  {1, 32},
  {1, 5},
  {27, 1},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 14},
  {1, 21},
  {1, 12},
  {2, 8},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 16},
  {2, 21},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 18},
  {1, 15},
  {1, 11},
  {1, 16},
  {1, 23},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 11},
  {4, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {2, 11},
  {6, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 12},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 7},
  {3, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {8, 7},
  {4, 9},
  {1, 8},
  {1, 10},
  {4, 9},
  {1, 2},
  {3, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 15},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 13},
  {1, 18},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 22},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 12},
  {1, 5},
  {1, 28},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 8},
  {1, 5},
  {2, 15},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 30},
  {1, 9},
  {1, 15},
  {32, 1},
  {1, 9},
  {1, 11},
  {1, 26},
  {17, 22},
  {1, 23},
  {33, 1},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 12},
  {1, 11},
  {39, 22},
  {2, 27},
  {1, 21},
  {12, 1},
  {1, 5},
  {1, 15},
  {15, 1},
  {1, 4},
  {3, 5},
  {2, 12},
  {1, 16},
  {19, 22},
  {1, 27},
  {1, 15},
  {26, 1},
  {1, 8},
  {1, 12},
  {2, 30},
  {1, 16},
  {1, 12},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 4},
  {1, 12},
  {2, 15},
  {1, 21},
  {1, 8},
  {1, 4},
  {1, 5},
  {1, 12},
  {2, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 16},
  {1, 23},
  {2, 32},
  {1, 17},
  {2, 19},
  {1, 30},
  {1, 16},
  {1, 23},
  {1, 16},
  {2, 14},
  {5, 13},
  {3, 11},
  {1, 6},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {9, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {7, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {2, 9},
  {4, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 13},
  {1, 21},
  {1, 20},
  {2, 19},
  {1, 29},
  {2, 26},
  {1, 23},
  {3, 16},
  {1, 18},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 16},
  {2, 21},
  {2, 11},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 30},
  {1, 21},
  {1, 5},
  {33, 1},
  {1, 11},
  {1, 27},
  {15, 22},
  {1, 25},
  {1, 27},
  {1, 23},
  {1, 15},
  {1, 5},
  {33, 1},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 26},
  {1, 25},
  {37, 22},
  {1, 25},
  {1, 23},
  {1, 15},
  {1, 5},
  {11, 1},
  {3, 5},
  {15, 1},
  {1, 4},
  {3, 5},
  {2, 12},
  {1, 26},
  {18, 22},
  {1, 27},
  {1, 32},
  {1, 15},
  {26, 1},
  {1, 11},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 12},
  {2, 11},
  {1, 6},
  {1, 12},
  {2, 15},
  {2, 5},
  {1, 11},
  {3, 15},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 28},
  {1, 18},
  {1, 15},
  {1, 11},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 28},
  {3, 16},
  {2, 14},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {3, 10},
  {1, 9},
  {7, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 9},
  {4, 7},
  {6, 9},
  {1, 10},
  {1, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {5, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 15},
  {1, 1},
  {1, 31},
  {2, 19},
  {1, 29},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 11},
  {2, 5},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 14},
  {1, 16},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 11},
  {1, 5},
  {1, 16},
  {1, 15},
  {1, 14},
  {2, 21},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 23},
  {1, 28},
  {1, 15},
  {31, 1},
  {1, 5},
  {1, 12},
  {1, 16},
  {1, 25},
  {11, 22},
  {1, 25},
  {3, 22},
  {1, 25},
  {1, 27},
  {1, 21},
  {35, 1},
  {4, 5},
  {1, 16},
  {1, 27},
  {2, 25},
  {33, 22},
  {1, 25},
  {2, 27},
  {1, 11},
  {13, 1},
  {1, 5},
  {16, 1},
  {1, 5},
  {2, 4},
  {2, 5},
  {2, 12},
  {1, 23},
  {1, 27},
  {18, 22},
  {1, 27},
  {1, 28},
  {24, 1},
  {1, 5},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 18},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 15},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 3},
  {2, 15},
  {1, 11},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 26},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 21},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 14},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 18},
  {3, 14},
  {1, 16},
  {1, 14},
  {3, 13},
  {5, 11},
  {1, 8},
  {3, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 8},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {5, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {2, 7},
  {2, 10},
  {8, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 22},
  {2, 26},
  {2, 16},
  {1, 11},
  {1, 8},
  {1, 21},
  {2, 19},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 16},
  {2, 12},
  {1, 15},
  {3, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {2, 21},
  {1, 16},
  {2, 12},
  {1, 14},
  {1, 30},
  {1, 14},
  {32, 1},
  {1, 5},
  {1, 14},
  {1, 27},
  {2, 25},
  {1, 22},
  {13, 25},
  {1, 27},
  {1, 14},
  {1, 3},
  {30, 1},
  {1, 15},
  {2, 5},
  {3, 1},
  {2, 5},
  {1, 15},
  {1, 23},
  {1, 29},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {6, 25},
  {1, 24},
  {2, 25},
  {2, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 24},
  {1, 25},
  {1, 29},
  {1, 16},
  {1, 12},
  {1, 4},
  {31, 1},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 3},
  {1, 18},
  {1, 31},
  {1, 29},
  {4, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {2, 25},
  {1, 22},
  {7, 25},
  {1, 27},
  {1, 15},
  {24, 1},
  {1, 11},
  {2, 30},
  {1, 6},
  {1, 13},
  {1, 12},
  {1, 16},
  {1, 11},
  {2, 12},
  {2, 16},
  {1, 12},
  {1, 8},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 5},
  {1, 6},
  {1, 11},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 24},
  {2, 19},
  {1, 30},
  {1, 15},
  {1, 14},
  {3, 18},
  {4, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {4, 9},
  {2, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {4, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {3, 1},
  {1, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {1, 9},
  {5, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {4, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 6},
  {6, 13},
  {2, 14},
  {1, 16},
  {2, 15},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 24},
  {1, 22},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 16},
  {3, 12},
  {1, 11},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 16},
  {2, 28},
  {1, 15},
  {30, 1},
  {1, 4},
  {1, 11},
  {1, 14},
  {1, 29},
  {1, 25},
  {2, 29},
  {1, 25},
  {1, 29},
  {1, 25},
  {2, 29},
  {1, 25},
  {2, 29},
  {1, 27},
  {5, 29},
  {1, 13},
  {29, 1},
  {3, 5},
  {4, 1},
  {3, 5},
  {1, 15},
  {1, 12},
  {1, 30},
  {1, 17},
  {2, 29},
  {1, 17},
  {1, 29},
  {1, 24},
  {2, 29},
  {1, 24},
  {2, 29},
  {1, 24},
  {1, 29},
  {1, 24},
  {1, 29},
  {1, 24},
  {2, 29},
  {1, 24},
  {4, 29},
  {1, 24},
  {3, 29},
  {1, 24},
  {2, 29},
  {1, 24},
  {4, 29},
  {1, 32},
  {1, 11},
  {32, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 12},
  {1, 3},
  {1, 28},
  {2, 31},
  {1, 29},
  {1, 27},
  {2, 29},
  {1, 27},
  {2, 29},
  {1, 27},
  {2, 29},
  {1, 27},
  {2, 29},
  {1, 30},
  {2, 29},
  {1, 27},
  {1, 31},
  {1, 21},
  {23, 1},
  {1, 5},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 12},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 14},
  {1, 12},
  {1, 3},
  {1, 16},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 4},
  {2, 12},
  {1, 15},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 28},
  {1, 11},
  {1, 16},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 14},
  {4, 13},
  {1, 11},
  {2, 6},
  {2, 11},
  {1, 2},
  {2, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {11, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {1, 8},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {9, 7},
  {6, 9},
  {1, 7},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {6, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 24},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {3, 16},
  {1, 18},
  {2, 12},
  {1, 11},
  {1, 12},
  {2, 15},
  {3, 11},
  {2, 12},
  {1, 15},
  {2, 21},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 21},
  {31, 1},
  {2, 4},
  {1, 12},
  {1, 5},
  {2, 12},
  {7, 5},
  {1, 12},
  {1, 14},
  {1, 15},
  {1, 11},
  {1, 21},
  {1, 11},
  {1, 12},
  {2, 5},
  {24, 1},
  {1, 15},
  {1, 5},
  {2, 1},
  {1, 5},
  {7, 1},
  {5, 5},
  {2, 15},
  {1, 11},
  {2, 5},
  {2, 15},
  {1, 21},
  {2, 15},
  {1, 21},
  {5, 15},
  {1, 21},
  {2, 15},
  {3, 21},
  {2, 15},
  {2, 21},
  {7, 15},
  {1, 21},
  {1, 15},
  {3, 5},
  {18, 1},
  {1, 15},
  {1, 5},
  {13, 1},
  {1, 4},
  {4, 5},
  {1, 7},
  {1, 18},
  {1, 21},
  {1, 18},
  {1, 21},
  {2, 16},
  {1, 15},
  {1, 16},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 8},
  {1, 5},
  {2, 15},
  {1, 5},
  {23, 1},
  {1, 9},
  {2, 30},
  {1, 5},
  {1, 12},
  {1, 28},
  {1, 16},
  {1, 12},
  {1, 15},
  {3, 12},
  {2, 16},
  {2, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 11},
  {1, 6},
  {1, 18},
  {2, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 1},
  {3, 14},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 6},
  {4, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 8},
  {7, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {2, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {2, 3},
  {2, 10},
  {4, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {3, 10},
  {9, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 4},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 3},
  {1, 5},
  {1, 28},
  {2, 20},
  {1, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 21},
  {5, 12},
  {2, 21},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 16},
  {3, 21},
  {1, 30},
  {1, 28},
  {1, 1},
  {1, 15},
  {27, 1},
  {1, 4},
  {13, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {24, 1},
  {3, 5},
  {11, 1},
  {2, 5},
  {1, 4},
  {2, 5},
  {1, 3},
  {10, 5},
  {1, 15},
  {1, 1},
  {1, 15},
  {2, 5},
  {1, 15},
  {3, 5},
  {2, 4},
  {3, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 5},
  {1, 15},
  {5, 5},
  {17, 1},
  {3, 5},
  {13, 1},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {3, 1},
  {5, 5},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 4},
  {7, 5},
  {24, 1},
  {1, 15},
  {1, 31},
  {1, 28},
  {2, 12},
  {1, 21},
  {1, 14},
  {1, 12},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 11},
  {3, 16},
  {1, 15},
  {2, 12},
  {1, 3},
  {2, 16},
  {2, 23},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 17},
  {2, 19},
  {1, 30},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 12},
  {1, 16},
  {2, 12},
  {1, 6},
  {2, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 9},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {7, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {5, 3},
  {2, 4},
  {2, 1},
  {3, 7},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 18},
  {1, 13},
  {5, 14},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 13},
  {1, 12},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {3, 14},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {2, 11},
  {2, 12},
  {1, 8},
  {1, 21},
  {1, 16},
  {1, 6},
  {1, 18},
  {1, 30},
  {1, 18},
  {1, 5},
  {28, 1},
  {12, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {18, 1},
  {1, 15},
  {1, 5},
  {19, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {2, 1},
  {10, 5},
  {2, 4},
  {2, 5},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {5, 5},
  {1, 15},
  {2, 5},
  {41, 1},
  {1, 4},
  {5, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {3, 5},
  {3, 4},
  {1, 5},
  {1, 15},
  {2, 5},
  {23, 1},
  {1, 9},
  {2, 30},
  {1, 16},
  {1, 3},
  {1, 12},
  {2, 11},
  {2, 12},
  {1, 15},
  {2, 12},
  {3, 11},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {2, 20},
  {1, 18},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 15},
  {2, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {7, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {10, 7},
  {1, 10},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {4, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 14},
  {1, 16},
  {1, 13},
  {2, 14},
  {2, 16},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 25},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 18},
  {1, 11},
  {2, 15},
  {1, 30},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {1, 23},
  {2, 14},
  {2, 12},
  {1, 4},
  {1, 16},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 8},
  {1, 3},
  {1, 21},
  {1, 15},
  {2, 16},
  {1, 30},
  {1, 28},
  {1, 15},
  {15, 1},
  {1, 15},
  {11, 1},
  {1, 4},
  {2, 5},
  {1, 15},
  {3, 5},
  {1, 15},
  {3, 5},
  {1, 15},
  {1, 5},
  {1, 4},
  {2, 5},
  {2, 4},
  {1, 5},
  {10, 1},
  {1, 15},
  {8, 1},
  {3, 5},
  {19, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 15},
  {1, 5},
  {7, 1},
  {1, 5},
  {3, 1},
  {2, 5},
  {13, 1},
  {5, 5},
  {42, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {5, 5},
  {13, 1},
  {1, 15},
  {10, 1},
  {1, 5},
  {1, 3},
  {1, 31},
  {1, 32},
  {1, 12},
  {1, 8},
  {1, 4},
  {1, 12},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 16},
  {3, 12},
  {1, 13},
  {1, 11},
  {1, 16},
  {1, 14},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 21},
  {1, 32},
  {1, 26},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {5, 14},
  {2, 16},
  {3, 13},
  {1, 6},
  {2, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 8},
  {1, 12},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {6, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {4, 3},
  {2, 4},
  {1, 3},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {3, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {4, 14},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 28},
  {2, 20},
  {1, 17},
  {2, 26},
  {2, 14},
  {1, 16},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 5},
  {1, 3},
  {2, 15},
  {1, 7},
  {2, 12},
  {1, 23},
  {1, 30},
  {1, 13},
  {28, 1},
  {13, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 15},
  {2, 5},
  {42, 1},
  {1, 5},
  {1, 4},
  {4, 5},
  {1, 15},
  {2, 5},
  {24, 1},
  {2, 5},
  {4, 1},
  {1, 15},
  {1, 5},
  {23, 1},
  {1, 15},
  {1, 5},
  {14, 1},
  {1, 4},
  {1, 5},
  {1, 15},
  {3, 5},
  {1, 15},
  {3, 5},
  {1, 15},
  {4, 5},
  {25, 1},
  {1, 7},
  {1, 28},
  {1, 30},
  {1, 18},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 8},
  {1, 11},
  {1, 4},
  {3, 8},
  {1, 15},
  {3, 12},
  {1, 11},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 24},
  {1, 17},
  {1, 20},
  {1, 30},
  {1, 5},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 15},
  {3, 14},
  {2, 16},
  {1, 14},
  {1, 6},
  {2, 13},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {6, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {8, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 8},
  {2, 10},
  {3, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {7, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {4, 13},
  {3, 14},
  {1, 18},
  {1, 21},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 2},
  {1, 12},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 11},
  {3, 12},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 6},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 32},
  {1, 28},
  {1, 1},
  {1, 15},
  {23, 1},
  {2, 5},
  {1, 15},
  {7, 5},
  {1, 15},
  {6, 5},
  {1, 15},
  {4, 5},
  {45, 1},
  {6, 5},
  {30, 1},
  {3, 5},
  {17, 1},
  {1, 5},
  {1, 15},
  {3, 1},
  {3, 5},
  {14, 1},
  {12, 5},
  {28, 1},
  {1, 4},
  {1, 18},
  {1, 30},
  {1, 28},
  {1, 12},
  {1, 18},
  {1, 15},
  {1, 5},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 11},
  {1, 3},
  {1, 8},
  {2, 12},
  {1, 16},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 18},
  {1, 23},
  {1, 27},
  {1, 24},
  {2, 20},
  {1, 21},
  {2, 2},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 28},
  {5, 14},
  {4, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {3, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {3, 1},
  {3, 7},
  {1, 10},
  {1, 3},
  {9, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 28},
  {2, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 26},
  {1, 30},
  {1, 23},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 28},
  {1, 30},
  {1, 16},
  {1, 5},
  {24, 1},
  {4, 5},
  {1, 15},
  {7, 5},
  {1, 15},
  {7, 5},
  {49, 1},
  {2, 5},
  {38, 1},
  {1, 15},
  {1, 5},
  {11, 1},
  {3, 5},
  {20, 1},
  {11, 5},
  {28, 1},
  {1, 7},
  {1, 28},
  {1, 30},
  {1, 21},
  {2, 12},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 6},
  {6, 12},
  {1, 16},
  {1, 21},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 25},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 5},
  {1, 7},
  {1, 6},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 12},
  {4, 14},
  {1, 16},
  {1, 14},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {2, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {3, 18},
  {1, 12},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {2, 23},
  {1, 18},
  {1, 11},
  {1, 2},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 14},
  {1, 18},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 2},
  {2, 8},
  {1, 13},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 21},
  {1, 15},
  {23, 1},
  {18, 5},
  {36, 1},
  {1, 5},
  {1, 15},
  {40, 1},
  {1, 5},
  {1, 15},
  {10, 1},
  {2, 5},
  {2, 1},
  {1, 5},
  {1, 15},
  {32, 1},
  {2, 5},
  {1, 15},
  {2, 5},
  {1, 15},
  {2, 5},
  {1, 15},
  {30, 1},
  {1, 15},
  {1, 30},
  {1, 28},
  {1, 18},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 21},
  {2, 11},
  {1, 18},
  {1, 21},
  {1, 11},
  {3, 21},
  {1, 11},
  {1, 16},
  {1, 14},
  {3, 23},
  {1, 27},
  {2, 17},
  {1, 20},
  {1, 21},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 30},
  {5, 14},
  {1, 18},
  {4, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {4, 8},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 7},
  {2, 1},
  {2, 7},
  {1, 3},
  {8, 10},
  {1, 3},
  {1, 7},
  {3, 10},
  {2, 7},
  {2, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {2, 18},
  {1, 30},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 30},
  {2, 20},
  {1, 24},
  {1, 26},
  {2, 23},
  {1, 16},
  {3, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 12},
  {2, 14},
  {1, 21},
  {1, 30},
  {1, 13},
  {1, 7},
  {24, 1},
  {4, 5},
  {1, 15},
  {7, 5},
  {1, 15},
  {2, 5},
  {37, 1},
  {3, 5},
  {32, 1},
  {1, 15},
  {1, 5},
  {5, 1},
  {3, 5},
  {14, 1},
  {2, 5},
  {32, 1},
  {10, 5},
  {27, 1},
  {1, 15},
  {1, 28},
  {1, 31},
  {1, 15},
  {1, 7},
  {1, 15},
  {1, 8},
  {1, 5},
  {1, 8},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 21},
  {5, 15},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {2, 20},
  {1, 31},
  {1, 16},
  {1, 12},
  {1, 2},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {3, 14},
  {2, 18},
  {4, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {6, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {5, 8},
  {1, 2},
  {4, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {5, 10},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {3, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {4, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {4, 14},
  {1, 18},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 14},
  {1, 18},
  {2, 16},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 16},
  {3, 12},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 3},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 28},
  {2, 16},
  {1, 30},
  {1, 28},
  {1, 1},
  {1, 15},
  {13, 1},
  {1, 5},
  {1, 15},
  {5, 1},
  {2, 5},
  {1, 15},
  {1, 1},
  {7, 5},
  {1, 15},
  {4, 5},
  {39, 1},
  {1, 5},
  {32, 1},
  {3, 5},
  {6, 1},
  {1, 5},
  {49, 1},
  {8, 5},
  {29, 1},
  {2, 5},
  {1, 31},
  {1, 30},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 3},
  {2, 5},
  {1, 15},
  {1, 3},
  {2, 5},
  {1, 15},
  {4, 12},
  {1, 11},
  {1, 16},
  {1, 23},
  {1, 28},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 28},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 18},
  {1, 23},
  {2, 32},
  {1, 17},
  {2, 19},
  {1, 31},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {6, 6},
  {1, 11},
  {9, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {2, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {4, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {7, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {2, 13},
  {1, 30},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {2, 23},
  {2, 12},
  {1, 3},
  {1, 2},
  {1, 12},
  {1, 5},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 3},
  {3, 12},
  {1, 11},
  {2, 21},
  {1, 11},
  {1, 6},
  {1, 23},
  {1, 30},
  {1, 15},
  {15, 1},
  {2, 5},
  {5, 1},
  {7, 5},
  {1, 15},
  {7, 5},
  {19, 1},
  {1, 15},
  {27, 1},
  {1, 15},
  {2, 5},
  {23, 1},
  {1, 5},
  {57, 1},
  {1, 15},
  {2, 5},
  {14, 1},
  {1, 15},
  {19, 1},
  {1, 9},
  {2, 30},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 5},
  {3, 12},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 2},
  {1, 6},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 9},
  {2, 14},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {3, 13},
  {2, 6},
  {1, 11},
  {2, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {7, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {4, 3},
  {1, 8},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 16},
  {1, 18},
  {1, 11},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 32},
  {1, 14},
  {1, 18},
  {1, 11},
  {1, 3},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 15},
  {3, 3},
  {2, 15},
  {1, 8},
  {1, 12},
  {2, 6},
  {1, 11},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 18},
  {1, 21},
  {2, 28},
  {1, 15},
  {21, 1},
  {3, 5},
  {1, 15},
  {8, 5},
  {7, 1},
  {1, 5},
  {1, 15},
  {13, 1},
  {1, 5},
  {25, 1},
  {3, 5},
  {80, 1},
  {4, 5},
  {6, 1},
  {2, 5},
  {1, 15},
  {26, 1},
  {1, 7},
  {1, 15},
  {1, 31},
  {1, 21},
  {1, 6},
  {1, 9},
  {1, 15},
  {3, 12},
  {1, 15},
  {2, 5},
  {1, 12},
  {1, 15},
  {3, 12},
  {1, 11},
  {1, 12},
  {1, 13},
  {2, 14},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 30},
  {1, 11},
  {1, 9},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 32},
  {1, 29},
  {2, 19},
  {1, 31},
  {1, 21},
  {4, 14},
  {2, 16},
  {5, 13},
  {2, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {3, 6},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {4, 3},
  {5, 10},
  {1, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {4, 7},
  {1, 3},
  {2, 9},
  {1, 7},
  {14, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 8},
  {6, 2},
  {1, 8},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {5, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 24},
  {1, 22},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 21},
  {1, 9},
  {1, 18},
  {1, 30},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {1, 23},
  {1, 16},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 12},
  {3, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 21},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 21},
  {22, 1},
  {8, 5},
  {1, 15},
  {2, 5},
  {7, 1},
  {3, 5},
  {20, 1},
  {1, 15},
  {1, 5},
  {16, 1},
  {1, 5},
  {6, 1},
  {1, 15},
  {1, 5},
  {76, 1},
  {1, 5},
  {8, 1},
  {3, 5},
  {19, 1},
  {1, 15},
  {5, 1},
  {1, 11},
  {2, 30},
  {1, 18},
  {2, 8},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 18},
  {1, 21},
  {1, 32},
  {1, 23},
  {1, 32},
  {1, 29},
  {3, 20},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {8, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {8, 10},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {5, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {4, 3},
  {1, 7},
  {2, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {5, 7},
  {8, 9},
  {1, 7},
  {8, 9},
  {1, 7},
  {2, 2},
  {1, 8},
  {8, 2},
  {1, 9},
  {3, 2},
  {2, 6},
  {4, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {2, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 5},
  {1, 30},
  {2, 19},
  {1, 24},
  {1, 22},
  {2, 26},
  {1, 21},
  {1, 18},
  {2, 15},
  {1, 28},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 15},
  {3, 12},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 8},
  {1, 4},
  {1, 21},
  {1, 8},
  {1, 6},
  {1, 28},
  {1, 30},
  {2, 15},
  {21, 1},
  {3, 5},
  {1, 1},
  {4, 5},
  {30, 1},
  {2, 5},
  {23, 1},
  {3, 5},
  {113, 1},
  {1, 12},
  {1, 28},
  {1, 31},
  {1, 21},
  {1, 18},
  {3, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 13},
  {1, 14},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 30},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 14},
  {1, 16},
  {3, 14},
  {3, 13},
  {3, 11},
  {7, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {6, 3},
  {1, 7},
  {6, 10},
  {2, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 6},
  {2, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 15},
  {1, 31},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 5},
  {1, 12},
  {1, 16},
  {1, 30},
  {1, 28},
  {1, 5},
  {23, 1},
  {1, 15},
  {4, 5},
  {5, 1},
  {1, 15},
  {2, 5},
  {61, 1},
  {1, 15},
  {1, 5},
  {100, 1},
  {1, 7},
  {1, 18},
  {1, 30},
  {1, 28},
  {1, 6},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 11},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 15},
  {2, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 14},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 1},
  {1, 18},
  {2, 14},
  {2, 13},
  {1, 14},
  {2, 13},
  {3, 11},
  {1, 6},
  {1, 13},
  {6, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 12},
  {6, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 15},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {2, 2},
  {1, 8},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {9, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {6, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {6, 3},
  {1, 7},
  {3, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {6, 7},
  {2, 9},
  {1, 7},
  {15, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 11},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 18},
  {1, 6},
  {1, 13},
  {1, 28},
  {2, 20},
  {1, 24},
  {1, 27},
  {1, 23},
  {2, 14},
  {1, 21},
  {1, 6},
  {3, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 4},
  {1, 5},
  {2, 8},
  {1, 21},
  {1, 18},
  {1, 5},
  {2, 12},
  {1, 32},
  {1, 30},
  {2, 15},
  {20, 1},
  {3, 5},
  {7, 1},
  {3, 5},
  {29, 1},
  {1, 5},
  {1, 15},
  {5, 1},
  {1, 5},
  {1, 15},
  {23, 1},
  {3, 5},
  {2, 1},
  {1, 5},
  {1, 15},
  {96, 1},
  {1, 4},
  {1, 3},
  {2, 30},
  {1, 18},
  {2, 12},
  {1, 11},
  {1, 15},
  {2, 8},
  {1, 11},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 12},
  {2, 15},
  {2, 16},
  {1, 23},
  {1, 32},
  {2, 17},
  {1, 19},
  {1, 30},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 14},
  {2, 23},
  {1, 32},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 18},
  {1, 13},
  {3, 14},
  {4, 13},
  {3, 11},
  {2, 6},
  {1, 12},
  {5, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 16},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {7, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {3, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {2, 10},
  {1, 3},
  {4, 10},
  {2, 3},
  {1, 7},
  {7, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {8, 3},
  {4, 10},
  {1, 3},
  {3, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {1, 9},
  {5, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 15},
  {1, 7},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {6, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 13},
  {2, 6},
  {1, 30},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 26},
  {2, 23},
  {1, 14},
  {1, 16},
  {2, 12},
  {1, 8},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 4},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 14},
  {2, 30},
  {1, 3},
  {20, 1},
  {2, 5},
  {8, 1},
  {1, 5},
  {32, 1},
  {2, 5},
  {4, 1},
  {3, 5},
  {27, 1},
  {3, 5},
  {53, 1},
  {1, 15},
  {1, 5},
  {27, 1},
  {1, 15},
  {12, 1},
  {1, 7},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 8},
  {1, 12},
  {2, 15},
  {2, 12},
  {1, 11},
  {2, 15},
  {1, 5},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 28},
  {3, 13},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 5},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 16},
  {5, 13},
  {1, 2},
  {1, 11},
  {6, 6},
  {1, 2},
  {14, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 8},
  {5, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {2, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {2, 3},
  {1, 10},
  {6, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {10, 3},
  {4, 10},
  {1, 3},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {7, 9},
  {2, 7},
  {3, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 16},
  {1, 6},
  {2, 18},
  {1, 20},
  {2, 17},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 11},
  {3, 12},
  {2, 11},
  {2, 12},
  {2, 15},
  {1, 8},
  {1, 12},
  {3, 8},
  {1, 12},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 15},
  {10, 1},
  {1, 5},
  {1, 15},
  {101, 1},
  {1, 5},
  {1, 15},
  {30, 1},
  {1, 5},
  {1, 15},
  {5, 1},
  {3, 5},
  {41, 1},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 6},
  {1, 8},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 21},
  {1, 15},
  {3, 12},
  {2, 15},
  {2, 12},
  {1, 5},
  {1, 3},
  {1, 8},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 13},
  {1, 6},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 21},
  {2, 18},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 11},
  {1, 13},
  {3, 11},
  {6, 6},
  {1, 2},
  {6, 6},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 16},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {4, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {6, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {8, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {2, 7},
  {3, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {2, 2},
  {1, 9},
  {7, 2},
  {1, 8},
  {5, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {4, 6},
  {2, 2},
  {8, 11},
  {3, 13},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 18},
  {1, 13},
  {1, 2},
  {1, 13},
  {1, 30},
  {2, 20},
  {1, 17},
  {1, 32},
  {1, 23},
  {3, 16},
  {2, 12},
  {1, 15},
  {3, 12},
  {2, 15},
  {2, 3},
  {1, 15},
  {2, 12},
  {1, 11},
  {2, 21},
  {1, 16},
  {1, 28},
  {1, 31},
  {1, 11},
  {11, 1},
  {2, 5},
  {27, 1},
  {1, 15},
  {33, 1},
  {1, 15},
  {1, 5},
  {11, 1},
  {1, 15},
  {1, 5},
  {18, 1},
  {1, 15},
  {1, 5},
  {5, 1},
  {2, 5},
  {12, 1},
  {1, 15},
  {11, 1},
  {1, 15},
  {1, 5},
  {4, 1},
  {2, 5},
  {13, 1},
  {1, 15},
  {1, 5},
  {32, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 21},
  {2, 7},
  {1, 1},
  {1, 9},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 16},
  {1, 12},
  {2, 11},
  {1, 12},
  {1, 8},
  {2, 16},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 16},
  {1, 8},
  {2, 13},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 5},
  {3, 14},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {7, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {8, 3},
  {1, 4},
  {1, 10},
  {1, 3},
  {6, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {4, 7},
  {7, 9},
  {1, 3},
  {1, 15},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {5, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {5, 13},
  {1, 16},
  {1, 14},
  {3, 18},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {2, 13},
  {1, 18},
  {1, 28},
  {3, 20},
  {1, 27},
  {1, 26},
  {2, 14},
  {1, 16},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 16},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 12},
  {1, 7},
  {1, 15},
  {1, 11},
  {1, 16},
  {1, 21},
  {2, 30},
  {2, 15},
  {70, 1},
  {3, 5},
  {10, 1},
  {2, 5},
  {18, 1},
  {2, 5},
  {25, 1},
  {1, 15},
  {5, 1},
  {2, 5},
  {19, 1},
  {3, 5},
  {33, 1},
  {1, 15},
  {1, 31},
  {1, 28},
  {1, 12},
  {1, 8},
  {1, 4},
  {3, 5},
  {3, 12},
  {1, 15},
  {1, 16},
  {3, 12},
  {2, 21},
  {1, 11},
  {1, 21},
  {1, 6},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {2, 20},
  {1, 30},
  {1, 13},
  {1, 2},
  {2, 18},
  {1, 23},
  {2, 32},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {5, 13},
  {1, 6},
  {1, 11},
  {9, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 11},
  {2, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 2},
  {3, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 12},
  {1, 8},
  {1, 2},
  {4, 8},
  {4, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 12},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {7, 3},
  {1, 4},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {2, 7},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {5, 9},
  {2, 2},
  {1, 6},
  {1, 8},
  {6, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {1, 32},
  {1, 23},
  {2, 18},
  {1, 8},
  {1, 16},
  {1, 30},
  {2, 19},
  {1, 17},
  {2, 26},
  {2, 16},
  {1, 18},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 8},
  {3, 5},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 4},
  {1, 21},
  {1, 3},
  {1, 6},
  {1, 18},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 5},
  {21, 1},
  {1, 15},
  {2, 5},
  {134, 1},
  {1, 5},
  {33, 1},
  {1, 15},
  {2, 30},
  {1, 5},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 15},
  {3, 12},
  {2, 21},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 15},
  {1, 7},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 5},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {1, 16},
  {1, 2},
  {2, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {3, 6},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {4, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 3},
  {2, 10},
  {4, 3},
  {1, 8},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {2, 10},
  {4, 7},
  {5, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {8, 9},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 2},
  {1, 6},
  {1, 2},
  {2, 11},
  {1, 6},
  {6, 13},
  {1, 14},
  {1, 18},
  {2, 14},
  {1, 6},
  {1, 2},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 15},
  {1, 16},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 32},
  {2, 23},
  {1, 16},
  {3, 12},
  {1, 15},
  {1, 3},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 2},
  {1, 15},
  {1, 6},
  {1, 18},
  {1, 21},
  {1, 16},
  {1, 32},
  {1, 30},
  {2, 15},
  {12, 1},
  {1, 5},
  {1, 15},
  {4, 1},
  {3, 5},
  {141, 1},
  {1, 5},
  {1, 15},
  {26, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 18},
  {1, 2},
  {3, 3},
  {1, 12},
  {1, 5},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 21},
  {4, 12},
  {3, 14},
  {1, 32},
  {1, 27},
  {1, 17},
  {2, 20},
  {1, 28},
  {1, 2},
  {1, 9},
  {1, 13},
  {1, 18},
  {1, 23},
  {2, 32},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {2, 14},
  {1, 18},
  {1, 14},
  {2, 16},
  {1, 13},
  {2, 16},
  {3, 13},
  {11, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {5, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {2, 10},
  {8, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {3, 10},
  {2, 7},
  {1, 10},
  {3, 7},
  {4, 9},
  {1, 15},
  {2, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {11, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {2, 13},
  {1, 14},
  {1, 13},
  {3, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {1, 32},
  {1, 23},
  {1, 18},
  {1, 11},
  {1, 6},
  {1, 16},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 15},
  {1, 12},
  {1, 8},
  {2, 21},
  {1, 12},
  {1, 8},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 21},
  {2, 12},
  {1, 14},
  {1, 32},
  {1, 30},
  {1, 2},
  {12, 1},
  {3, 5},
  {4, 1},
  {1, 5},
  {7, 1},
  {1, 15},
  {1, 5},
  {13, 1},
  {1, 15},
  {72, 1},
  {1, 15},
  {47, 1},
  {2, 5},
  {24, 1},
  {1, 9},
  {1, 28},
  {1, 31},
  {1, 21},
  {1, 6},
  {1, 3},
  {2, 4},
  {9, 12},
  {2, 21},
  {3, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 2},
  {1, 7},
  {1, 11},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 11},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 16},
  {1, 8},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {3, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 6},
  {6, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {1, 4},
  {2, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 15},
  {3, 9},
  {2, 2},
  {2, 6},
  {3, 2},
  {1, 8},
  {13, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {5, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {5, 13},
  {2, 18},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 21},
  {1, 15},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 21},
  {2, 13},
  {1, 3},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 8},
  {3, 5},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 28},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 11},
  {1, 13},
  {1, 23},
  {1, 30},
  {1, 28},
  {1, 7},
  {1, 15},
  {10, 1},
  {1, 5},
  {12, 1},
  {2, 5},
  {18, 1},
  {1, 15},
  {49, 1},
  {1, 5},
  {1, 15},
  {70, 1},
  {1, 15},
  {20, 1},
  {1, 7},
  {1, 13},
  {1, 31},
  {1, 28},
  {1, 16},
  {1, 12},
  {1, 3},
  {2, 5},
  {1, 12},
  {2, 15},
  {4, 12},
  {1, 5},
  {1, 12},
  {1, 16},
  {2, 21},
  {3, 16},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 28},
  {1, 2},
  {1, 7},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 28},
  {2, 14},
  {1, 16},
  {1, 18},
  {2, 14},
  {2, 13},
  {1, 16},
  {2, 13},
  {3, 6},
  {1, 11},
  {1, 2},
  {6, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {9, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {1, 9},
  {1, 10},
  {4, 7},
  {1, 9},
  {2, 7},
  {7, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {4, 9},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 11},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {1, 13},
  {1, 11},
  {2, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {3, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {2, 6},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 32},
  {1, 26},
  {1, 14},
  {1, 16},
  {1, 8},
  {2, 4},
  {1, 5},
  {1, 11},
  {1, 3},
  {2, 11},
  {1, 18},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 12},
  {94, 1},
  {2, 5},
  {90, 1},
  {1, 11},
  {1, 30},
  {1, 28},
  {1, 16},
  {2, 15},
  {1, 4},
  {2, 3},
  {1, 12},
  {1, 21},
  {1, 28},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 12},
  {2, 21},
  {1, 14},
  {2, 21},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 5},
  {1, 12},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 15},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {3, 3},
  {1, 8},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {3, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {6, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 9},
  {2, 7},
  {1, 15},
  {1, 7},
  {5, 9},
  {1, 2},
  {3, 9},
  {1, 2},
  {1, 6},
  {1, 8},
  {7, 2},
  {1, 9},
  {1, 15},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 13},
  {1, 6},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 15},
  {1, 1},
  {1, 31},
  {2, 19},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {2, 15},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 4},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 8},
  {3, 12},
  {1, 15},
  {1, 14},
  {3, 12},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 23},
  {1, 28},
  {1, 30},
  {1, 18},
  {1, 15},
  {69, 1},
  {1, 5},
  {1, 15},
  {113, 1},
  {1, 12},
  {1, 28},
  {1, 30},
  {1, 11},
  {1, 8},
  {1, 5},
  {2, 15},
  {1, 11},
  {1, 15},
  {1, 3},
  {1, 4},
  {1, 12},
  {2, 15},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 12},
  {1, 21},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 17},
  {2, 20},
  {1, 21},
  {2, 6},
  {1, 13},
  {1, 18},
  {2, 23},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {4, 13},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {5, 8},
  {1, 2},
  {2, 8},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {8, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {5, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {5, 9},
  {2, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {3, 7},
  {4, 9},
  {1, 15},
  {1, 7},
  {3, 9},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {3, 2},
  {1, 11},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 2},
  {4, 11},
  {1, 6},
  {3, 13},
  {1, 16},
  {3, 18},
  {1, 14},
  {2, 16},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 24},
  {1, 22},
  {2, 26},
  {2, 16},
  {1, 18},
  {1, 11},
  {1, 21},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 29},
  {1, 32},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 12},
  {2, 11},
  {1, 12},
  {2, 8},
  {1, 9},
  {2, 15},
  {1, 3},
  {1, 14},
  {2, 30},
  {1, 5},
  {1, 4},
  {69, 1},
  {2, 5},
  {73, 1},
  {1, 15},
  {1, 5},
  {36, 1},
  {1, 2},
  {1, 28},
  {1, 30},
  {1, 18},
  {1, 12},
  {3, 5},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 21},
  {1, 16},
  {1, 21},
  {2, 16},
  {1, 14},
  {1, 32},
  {1, 27},
  {1, 17},
  {2, 20},
  {1, 28},
  {1, 12},
  {1, 8},
  {1, 13},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 30},
  {1, 15},
  {1, 21},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {4, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {9, 3},
  {1, 8},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 9},
  {4, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 15},
  {1, 9},
  {2, 7},
  {1, 3},
  {1, 15},
  {6, 9},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 11},
  {1, 2},
  {1, 18},
  {2, 13},
  {1, 16},
  {1, 13},
  {3, 14},
  {1, 11},
  {1, 1},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 8},
  {1, 1},
  {1, 28},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 32},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 8},
  {1, 3},
  {2, 5},
  {1, 15},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 30},
  {1, 28},
  {1, 11},
  {1, 15},
  {43, 1},
  {1, 15},
  {10, 1},
  {1, 15},
  {86, 1},
  {2, 5},
  {25, 1},
  {1, 15},
  {11, 1},
  {1, 6},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 11},
  {1, 9},
  {1, 15},
  {1, 4},
  {1, 5},
  {2, 12},
  {2, 15},
  {2, 5},
  {1, 8},
  {1, 12},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 14},
  {1, 16},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 18},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 21},
  {5, 14},
  {2, 16},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {1, 12},
  {1, 6},
  {3, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {2, 9},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {8, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {4, 3},
  {1, 10},
  {1, 3},
  {2, 7},
  {3, 3},
  {3, 10},
  {11, 7},
  {8, 9},
  {3, 7},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {3, 2},
  {1, 8},
  {11, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 24},
  {3, 26},
  {2, 14},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 31},
  {2, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 28},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 4},
  {2, 15},
  {1, 4},
  {3, 8},
  {1, 11},
  {1, 30},
  {1, 28},
  {1, 5},
  {14, 1},
  {1, 15},
  {1, 5},
  {119, 1},
  {1, 15},
  {14, 1},
  {1, 15},
  {1, 5},
  {27, 1},
  {1, 15},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 2},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 16},
  {2, 15},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 23},
  {2, 26},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 16},
  {1, 8},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 28},
  {1, 16},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 13},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 9},
  {1, 10},
  {1, 7},
  {2, 10},
  {2, 9},
  {1, 7},
  {4, 10},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 4},
  {4, 3},
  {1, 8},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {2, 3},
  {2, 7},
  {1, 3},
  {2, 10},
  {8, 7},
  {1, 9},
  {5, 7},
  {2, 9},
  {1, 7},
  {18, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 9},
  {1, 15},
  {4, 2},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 11},
  {4, 6},
  {4, 11},
  {7, 13},
  {2, 18},
  {1, 9},
  {1, 5},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {2, 13},
  {1, 16},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 31},
  {1, 21},
  {1, 6},
  {2, 12},
  {1, 11},
  {1, 8},
  {1, 5},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 4},
  {1, 12},
  {2, 15},
  {1, 2},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 18},
  {1, 21},
  {1, 30},
  {1, 21},
  {1, 1},
  {1, 15},
  {10, 1},
  {2, 5},
  {86, 1},
  {1, 15},
  {47, 1},
  {2, 5},
  {29, 1},
  {1, 18},
  {2, 30},
  {1, 13},
  {1, 8},
  {1, 12},
  {1, 3},
  {2, 5},
  {1, 15},
  {1, 8},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {3, 16},
  {1, 12},
  {2, 21},
  {2, 16},
  {2, 23},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 18},
  {2, 6},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 18},
  {5, 14},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 13},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {3, 6},
  {2, 12},
  {2, 6},
  {2, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 8},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {4, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {4, 7},
  {1, 9},
  {3, 7},
  {3, 9},
  {1, 7},
  {11, 9},
  {1, 15},
  {1, 7},
  {6, 9},
  {4, 2},
  {1, 8},
  {4, 2},
  {2, 9},
  {5, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {6, 6},
  {1, 11},
  {1, 2},
  {3, 11},
  {2, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {2, 14},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 18},
  {1, 9},
  {1, 12},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {1, 14},
  {2, 16},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 6},
  {2, 8},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 3},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 21},
  {1, 15},
  {2, 18},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 7},
  {45, 1},
  {1, 15},
  {29, 1},
  {1, 15},
  {100, 1},
  {1, 15},
  {2, 30},
  {1, 18},
  {1, 11},
  {1, 2},
  {1, 8},
  {1, 12},
  {1, 8},
  {2, 5},
  {1, 15},
  {1, 21},
  {3, 5},
  {1, 12},
  {1, 21},
  {1, 16},
  {3, 12},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 8},
  {1, 9},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 11},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {2, 13},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 6},
  {1, 16},
  {1, 8},
  {1, 16},
  {1, 8},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {3, 8},
  {1, 2},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {6, 10},
  {1, 9},
  {6, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {9, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {9, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {5, 10},
  {10, 7},
  {1, 10},
  {4, 9},
  {1, 7},
  {6, 9},
  {4, 7},
  {1, 15},
  {5, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {5, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {8, 13},
  {2, 14},
  {1, 6},
  {1, 11},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 14},
  {1, 13},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 29},
  {1, 19},
  {2, 17},
  {1, 27},
  {1, 23},
  {1, 14},
  {2, 16},
  {3, 12},
  {1, 3},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 12},
  {3, 15},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 18},
  {1, 28},
  {1, 30},
  {2, 15},
  {3, 1},
  {1, 5},
  {1, 15},
  {13, 1},
  {1, 15},
  {36, 1},
  {1, 15},
  {65, 1},
  {1, 15},
  {51, 1},
  {1, 7},
  {1, 12},
  {2, 30},
  {1, 23},
  {1, 6},
  {1, 8},
  {2, 3},
  {3, 12},
  {1, 5},
  {1, 8},
  {1, 21},
  {1, 12},
  {3, 5},
  {1, 21},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {2, 19},
  {1, 28},
  {1, 11},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 23},
  {2, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 18},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 18},
  {6, 13},
  {1, 11},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 8},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {5, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {3, 3},
  {1, 4},
  {1, 12},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {7, 3},
  {1, 7},
  {7, 10},
  {8, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {6, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {3, 7},
  {1, 9},
  {1, 15},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {12, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 11},
  {5, 6},
  {5, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 30},
  {2, 19},
  {1, 17},
  {1, 29},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 15},
  {1, 7},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 26},
  {2, 23},
  {2, 16},
  {1, 12},
  {1, 6},
  {3, 15},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 15},
  {1, 8},
  {1, 4},
  {1, 15},
  {2, 12},
  {1, 8},
  {2, 3},
  {1, 9},
  {1, 13},
  {1, 28},
  {1, 30},
  {2, 7},
  {3, 1},
  {2, 5},
  {83, 1},
  {1, 15},
  {82, 1},
  {1, 15},
  {1, 7},
  {1, 28},
  {1, 30},
  {1, 23},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 9},
  {1, 8},
  {2, 12},
  {1, 3},
  {1, 12},
  {2, 15},
  {1, 12},
  {3, 5},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 16},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 5},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 15},
  {1, 18},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {4, 13},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {8, 10},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 8},
  {1, 3},
  {1, 8},
  {4, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {8, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {4, 10},
  {10, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {2, 7},
  {1, 15},
  {1, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {3, 9},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {6, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {6, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {3, 11},
  {5, 13},
  {2, 16},
  {2, 18},
  {1, 11},
  {1, 12},
  {1, 20},
  {2, 19},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 21},
  {1, 18},
  {1, 11},
  {2, 15},
  {1, 30},
  {2, 20},
  {1, 24},
  {1, 25},
  {1, 32},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 21},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 11},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 9},
  {3, 3},
  {1, 5},
  {2, 12},
  {2, 30},
  {1, 13},
  {1, 15},
  {169, 1},
  {1, 5},
  {1, 13},
  {1, 28},
  {1, 31},
  {1, 23},
  {1, 11},
  {3, 12},
  {1, 8},
  {1, 5},
  {1, 12},
  {1, 8},
  {4, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {3, 15},
  {1, 21},
  {1, 14},
  {2, 23},
  {1, 32},
  {2, 17},
  {1, 20},
  {1, 31},
  {1, 21},
  {2, 11},
  {2, 18},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 28},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 6},
  {2, 13},
  {6, 6},
  {1, 12},
  {5, 6},
  {2, 12},
  {1, 6},
  {2, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {5, 10},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 3},
  {3, 10},
  {2, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {6, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {4, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {4, 3},
  {10, 7},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 9},
  {3, 7},
  {2, 9},
  {1, 7},
  {9, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {3, 18},
  {1, 14},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 21},
  {1, 18},
  {1, 11},
  {1, 7},
  {1, 15},
  {1, 31},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 27},
  {3, 23},
  {1, 8},
  {4, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 3},
  {1, 8},
  {3, 3},
  {1, 8},
  {1, 4},
  {1, 15},
  {1, 16},
  {1, 32},
  {1, 28},
  {1, 13},
  {1, 4},
  {62, 1},
  {1, 15},
  {105, 1},
  {1, 9},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 16},
  {1, 13},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 15},
  {2, 12},
  {2, 8},
  {2, 12},
  {1, 5},
  {2, 15},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {3, 20},
  {1, 27},
  {1, 1},
  {2, 15},
  {1, 18},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 16},
  {4, 14},
  {1, 16},
  {1, 14},
  {5, 13},
  {6, 6},
  {1, 2},
  {5, 6},
  {2, 12},
  {1, 11},
  {1, 16},
  {5, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 10},
  {1, 8},
  {3, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {10, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {8, 7},
  {1, 9},
  {4, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {5, 9},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {17, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {5, 2},
  {1, 11},
  {1, 6},
  {6, 13},
  {1, 16},
  {3, 14},
  {1, 18},
  {1, 11},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 25},
  {1, 26},
  {2, 23},
  {1, 18},
  {1, 11},
  {1, 1},
  {1, 4},
  {1, 28},
  {1, 31},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 23},
  {2, 16},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 28},
  {1, 21},
  {1, 2},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 2},
  {4, 15},
  {1, 23},
  {1, 30},
  {1, 28},
  {1, 6},
  {1, 15},
  {75, 1},
  {1, 15},
  {90, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 21},
  {3, 12},
  {1, 15},
  {2, 21},
  {1, 12},
  {2, 21},
  {1, 8},
  {1, 12},
  {1, 5},
  {4, 12},
  {4, 21},
  {2, 23},
  {1, 16},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {1, 19},
  {1, 30},
  {1, 13},
  {2, 11},
  {1, 21},
  {1, 14},
  {1, 23},
  {1, 26},
  {2, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {4, 14},
  {1, 16},
  {5, 13},
  {1, 6},
  {2, 13},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 16},
  {1, 12},
  {3, 6},
  {2, 12},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {7, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {9, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 7},
  {2, 3},
  {1, 8},
  {5, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {9, 7},
  {1, 9},
  {3, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 15},
  {1, 7},
  {1, 9},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 11},
  {1, 9},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {4, 18},
  {1, 21},
  {1, 20},
  {2, 19},
  {1, 24},
  {1, 27},
  {2, 26},
  {2, 18},
  {1, 11},
  {1, 2},
  {1, 18},
  {1, 30},
  {1, 20},
  {1, 17},
  {1, 24},
  {1, 29},
  {1, 32},
  {1, 23},
  {2, 14},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 21},
  {1, 15},
  {1, 12},
  {3, 15},
  {5, 3},
  {1, 15},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 21},
  {2, 30},
  {1, 12},
  {1, 8},
  {17, 1},
  {1, 15},
  {134, 1},
  {1, 15},
  {11, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 18},
  {1, 6},
  {7, 12},
  {1, 21},
  {1, 12},
  {1, 5},
  {3, 12},
  {1, 5},
  {1, 12},
  {1, 21},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 23},
  {1, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 23},
  {1, 15},
  {1, 13},
  {2, 18},
  {1, 23},
  {2, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 21},
  {1, 14},
  {1, 16},
  {4, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 2},
  {1, 11},
  {6, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {3, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {8, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {8, 7},
  {1, 9},
  {3, 7},
  {3, 9},
  {1, 7},
  {10, 9},
  {2, 7},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {11, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 3},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {1, 23},
  {2, 18},
  {1, 2},
  {1, 12},
  {1, 1},
  {1, 30},
  {1, 20},
  {2, 17},
  {1, 29},
  {1, 32},
  {1, 23},
  {2, 16},
  {1, 11},
  {1, 15},
  {1, 8},
  {1, 5},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 8},
  {2, 3},
  {1, 4},
  {2, 15},
  {1, 5},
  {2, 12},
  {1, 8},
  {2, 11},
  {1, 23},
  {1, 30},
  {1, 28},
  {1, 11},
  {1, 15},
  {97, 1},
  {1, 15},
  {4, 1},
  {1, 15},
  {42, 1},
  {1, 15},
  {17, 1},
  {1, 28},
  {1, 30},
  {1, 28},
  {2, 12},
  {1, 8},
  {1, 15},
  {1, 8},
  {6, 12},
  {1, 15},
  {1, 3},
  {3, 12},
  {1, 5},
  {1, 15},
  {1, 21},
  {2, 12},
  {2, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 29},
  {1, 21},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 23},
  {6, 14},
  {4, 13},
  {1, 6},
  {2, 11},
  {7, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {3, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {6, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {6, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {12, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {3, 2},
  {2, 8},
  {3, 2},
  {2, 9},
  {1, 11},
  {1, 9},
  {1, 11},
  {1, 9},
  {9, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {6, 13},
  {1, 16},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 2},
  {1, 11},
  {1, 15},
  {1, 31},
  {2, 20},
  {1, 17},
  {1, 27},
  {1, 32},
  {2, 14},
  {1, 21},
  {1, 16},
  {2, 8},
  {1, 15},
  {2, 5},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 2},
  {3, 15},
  {1, 18},
  {1, 23},
  {1, 30},
  {1, 28},
  {1, 6},
  {1, 7},
  {129, 1},
  {1, 15},
  {25, 1},
  {1, 15},
  {4, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 21},
  {2, 12},
  {1, 5},
  {3, 15},
  {2, 5},
  {1, 12},
  {1, 8},
  {7, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 28},
  {1, 15},
  {1, 7},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 11},
  {3, 14},
  {1, 16},
  {2, 14},
  {5, 13},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 12},
  {1, 11},
  {2, 12},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {7, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {8, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {13, 7},
  {1, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {10, 9},
  {3, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {3, 2},
  {3, 9},
  {2, 2},
  {1, 9},
  {1, 15},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {3, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 18},
  {1, 11},
  {2, 15},
  {1, 20},
  {2, 19},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 15},
  {1, 5},
  {1, 28},
  {1, 31},
  {2, 20},
  {1, 17},
  {1, 27},
  {1, 26},
  {1, 32},
  {1, 21},
  {1, 16},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 3},
  {2, 5},
  {2, 15},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 28},
  {1, 21},
  {1, 15},
  {1, 4},
  {1, 16},
  {2, 14},
  {1, 30},
  {1, 28},
  {1, 15},
  {1, 1},
  {1, 15},
  {47, 1},
  {1, 15},
  {86, 1},
  {1, 15},
  {21, 1},
  {1, 7},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 21},
  {1, 8},
  {1, 3},
  {1, 5},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 3},
  {1, 5},
  {1, 3},
  {2, 12},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 16},
  {1, 14},
  {2, 32},
  {1, 17},
  {2, 20},
  {1, 30},
  {1, 13},
  {1, 7},
  {1, 15},
  {1, 13},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 28},
  {1, 23},
  {4, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {160, 0},
  {160, 0},
  {7, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {5, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {12, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 15},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 9},
  {7, 2},
  {1, 9},
  {7, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 6},
  {1, 2},
  {2, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {2, 13},
  {3, 14},
  {1, 13},
  {1, 18},
  {1, 28},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 14},
  {1, 13},
  {2, 11},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 29},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 11},
  {1, 12},
  {2, 4},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 8},
  {2, 15},
  {1, 2},
  {2, 3},
  {3, 15},
  {1, 21},
  {1, 4},
  {1, 12},
  {1, 18},
  {1, 11},
  {1, 16},
  {2, 28},
  {1, 21},
  {1, 5},
  {156, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 14},
  {2, 12},
  {2, 15},
  {2, 12},
  {2, 15},
  {1, 11},
  {1, 21},
  {2, 12},
  {1, 5},
  {3, 12},
  {1, 21},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 16},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 20},
  {1, 31},
  {1, 5},
  {1, 7},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 29},
  {3, 19},
  {1, 30},
  {2, 18},
  {4, 14},
  {1, 13},
  {1, 14},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {3, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {4, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {7, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {8, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {160, 0},
  {160, 0},
  {7, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {11, 7},
  {2, 9},
  {1, 7},
  {11, 9},
  {2, 7},
  {3, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {7, 2},
  {1, 9},
  {1, 11},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {4, 2},
  {3, 11},
  {4, 13},
  {1, 18},
  {2, 13},
  {2, 14},
  {1, 13},
  {1, 8},
  {1, 5},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 25},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 13},
  {2, 15},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 13},
  {1, 8},
  {1, 12},
  {1, 4},
  {2, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 5},
  {3, 15},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 30},
  {1, 21},
  {1, 15},
  {1, 13},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 1},
  {1, 15},
  {152, 1},
  {1, 5},
  {1, 15},
  {2, 30},
  {1, 23},
  {1, 14},
  {1, 12},
  {3, 5},
  {2, 15},
  {1, 12},
  {1, 16},
  {2, 12},
  {3, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {2, 21},
  {3, 12},
  {1, 23},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 28},
  {5, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {3, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {5, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {6, 3},
  {1, 8},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {5, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {16, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {11, 9},
  {10, 2},
  {1, 15},
  {1, 7},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 16},
  {2, 14},
  {2, 18},
  {1, 15},
  {1, 31},
  {2, 19},
  {1, 17},
  {2, 27},
  {2, 26},
  {2, 14},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 9},
  {1, 15},
  {3, 12},
  {1, 11},
  {2, 15},
  {1, 5},
  {1, 8},
  {2, 15},
  {1, 12},
  {1, 21},
  {1, 30},
  {1, 5},
  {1, 11},
  {1, 14},
  {1, 28},
  {1, 30},
  {1, 21},
  {1, 7},
  {83, 1},
  {1, 15},
  {25, 1},
  {1, 15},
  {42, 1},
  {1, 15},
  {2, 30},
  {1, 21},
  {1, 13},
  {1, 18},
  {1, 21},
  {2, 4},
  {1, 5},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {2, 5},
  {2, 12},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 28},
  {1, 15},
  {2, 16},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 18},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 18},
  {1, 21},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 21},
  {2, 16},
  {3, 14},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {4, 6},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {4, 8},
  {1, 6},
  {2, 8},
  {1, 9},
  {2, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {8, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {2, 7},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {5, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {5, 7},
  {1, 1},
  {3, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {13, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 7},
  {1, 15},
  {3, 2},
  {2, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {3, 2},
  {2, 11},
  {3, 13},
  {1, 6},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {2, 18},
  {2, 15},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 12},
  {1, 3},
  {1, 14},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 3},
  {1, 12},
  {2, 15},
  {1, 4},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 3},
  {3, 5},
  {2, 15},
  {2, 11},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 15},
  {1, 1},
  {1, 15},
  {97, 1},
  {1, 15},
  {49, 1},
  {1, 15},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 14},
  {1, 6},
  {1, 8},
  {1, 3},
  {2, 15},
  {2, 5},
  {1, 3},
  {1, 12},
  {1, 21},
  {1, 11},
  {2, 5},
  {3, 12},
  {1, 21},
  {3, 12},
  {2, 11},
  {1, 14},
  {1, 23},
  {2, 32},
  {1, 29},
  {1, 17},
  {2, 20},
  {1, 28},
  {1, 13},
  {3, 11},
  {2, 23},
  {2, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 30},
  {4, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {2, 13},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {4, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 10},
  {7, 7},
  {5, 10},
  {1, 3},
  {1, 7},
  {4, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {2, 3},
  {1, 7},
  {7, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {5, 7},
  {1, 4},
  {3, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {4, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {6, 2},
  {1, 11},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {5, 18},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {2, 13},
  {1, 11},
  {1, 21},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 24},
  {2, 27},
  {2, 14},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 21},
  {4, 12},
  {1, 8},
  {1, 15},
  {1, 4},
  {1, 5},
  {2, 15},
  {2, 11},
  {1, 12},
  {1, 18},
  {1, 28},
  {2, 30},
  {1, 8},
  {11, 1},
  {1, 15},
  {102, 1},
  {1, 15},
  {32, 1},
  {1, 15},
  {1, 21},
  {2, 30},
  {1, 15},
  {1, 11},
  {3, 12},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 5},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 12},
  {2, 5},
  {3, 12},
  {1, 21},
  {3, 12},
  {1, 16},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 30},
  {2, 12},
  {1, 2},
  {2, 18},
  {1, 23},
  {2, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 11},
  {2, 14},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 18},
  {4, 13},
  {1, 16},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 2},
  {9, 7},
  {1, 10},
  {1, 7},
  {5, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {7, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 1},
  {1, 7},
  {5, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {11, 7},
  {4, 9},
  {1, 7},
  {9, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {2, 2},
  {1, 9},
  {8, 2},
  {1, 9},
  {3, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {6, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 16},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 22},
  {1, 26},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 11},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 20},
  {1, 19},
  {2, 17},
  {1, 27},
  {1, 32},
  {2, 23},
  {1, 13},
  {2, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 15},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 2},
  {1, 15},
  {1, 4},
  {1, 5},
  {1, 11},
  {2, 15},
  {1, 3},
  {1, 12},
  {2, 16},
  {1, 21},
  {2, 30},
  {1, 18},
  {1, 1},
  {1, 15},
  {63, 1},
  {1, 15},
  {79, 1},
  {1, 7},
  {1, 28},
  {1, 30},
  {1, 28},
  {2, 8},
  {1, 3},
  {1, 2},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 12},
  {2, 15},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 12},
  {2, 15},
  {2, 16},
  {1, 14},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {2, 20},
  {1, 30},
  {2, 16},
  {1, 2},
  {1, 11},
  {2, 14},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 32},
  {2, 14},
  {1, 18},
  {2, 14},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 16},
  {2, 13},
  {2, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {3, 6},
  {2, 11},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 16},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 10},
  {6, 7},
  {1, 10},
  {1, 7},
  {8, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 3},
  {1, 10},
  {7, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {5, 1},
  {1, 7},
  {1, 1},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {6, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {5, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {3, 2},
  {1, 9},
  {12, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {5, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 26},
  {2, 23},
  {1, 18},
  {1, 11},
  {1, 2},
  {1, 16},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 29},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 6},
  {1, 9},
  {1, 15},
  {1, 8},
  {2, 15},
  {1, 5},
  {2, 12},
  {1, 2},
  {2, 15},
  {1, 11},
  {1, 4},
  {1, 3},
  {3, 8},
  {1, 4},
  {1, 15},
  {1, 8},
  {1, 12},
  {1, 16},
  {1, 18},
  {2, 30},
  {1, 21},
  {1, 10},
  {13, 1},
  {1, 15},
  {5, 1},
  {1, 15},
  {50, 1},
  {1, 15},
  {70, 1},
  {2, 15},
  {1, 28},
  {1, 30},
  {1, 23},
  {1, 18},
  {3, 3},
  {1, 9},
  {1, 11},
  {1, 8},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 21},
  {3, 12},
  {1, 5},
  {1, 12},
  {1, 21},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 27},
  {1, 29},
  {3, 20},
  {1, 31},
  {1, 23},
  {1, 18},
  {2, 13},
  {1, 18},
  {1, 21},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {2, 19},
  {1, 20},
  {1, 21},
  {1, 12},
  {2, 14},
  {1, 18},
  {2, 14},
  {2, 13},
  {1, 18},
  {3, 13},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {8, 8},
  {9, 7},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 7},
  {4, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {5, 3},
  {1, 10},
  {2, 3},
  {1, 4},
  {4, 3},
  {7, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {4, 1},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {4, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 15},
  {5, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {6, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 15},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {4, 2},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {2, 13},
  {4, 14},
  {1, 18},
  {2, 21},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 18},
  {1, 16},
  {1, 12},
  {1, 13},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 6},
  {2, 11},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 8},
  {2, 3},
  {1, 4},
  {1, 15},
  {1, 21},
  {1, 15},
  {3, 12},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 15},
  {1, 1},
  {1, 15},
  {21, 1},
  {1, 15},
  {26, 1},
  {1, 15},
  {89, 1},
  {1, 18},
  {2, 30},
  {1, 21},
  {2, 13},
  {2, 12},
  {1, 4},
  {1, 15},
  {1, 21},
  {1, 2},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 15},
  {1, 8},
  {1, 3},
  {2, 5},
  {1, 15},
  {1, 21},
  {4, 12},
  {1, 14},
  {2, 23},
  {1, 32},
  {1, 29},
  {2, 17},
  {1, 19},
  {1, 31},
  {1, 21},
  {3, 13},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 24},
  {1, 20},
  {2, 19},
  {1, 30},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 16},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 10},
  {6, 7},
  {3, 10},
  {1, 3},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {10, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {3, 3},
  {3, 4},
  {4, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {4, 7},
  {1, 1},
  {3, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {3, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {2, 9},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 13},
  {1, 18},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 24},
  {1, 22},
  {2, 26},
  {2, 23},
  {2, 16},
  {1, 6},
  {1, 15},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 27},
  {1, 23},
  {2, 14},
  {1, 11},
  {1, 13},
  {1, 6},
  {3, 12},
  {1, 15},
  {2, 3},
  {2, 12},
  {1, 15},
  {1, 6},
  {1, 9},
  {1, 15},
  {1, 3},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 16},
  {1, 23},
  {1, 30},
  {1, 28},
  {1, 18},
  {44, 1},
  {1, 15},
  {92, 1},
  {1, 15},
  {1, 28},
  {2, 30},
  {2, 16},
  {1, 12},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 12},
  {1, 13},
  {1, 28},
  {4, 3},
  {1, 8},
  {2, 15},
  {1, 4},
  {1, 12},
  {2, 5},
  {1, 12},
  {1, 15},
  {2, 12},
  {2, 16},
  {1, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 17},
  {1, 31},
  {1, 28},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 18},
  {2, 23},
  {1, 32},
  {1, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 30},
  {2, 15},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {7, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {3, 8},
  {8, 7},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {7, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {9, 4},
  {1, 3},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {14, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 7},
  {6, 9},
  {1, 10},
  {1, 2},
  {1, 9},
  {1, 2},
  {3, 9},
  {8, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {5, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 16},
  {3, 14},
  {2, 18},
  {1, 15},
  {1, 21},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 13},
  {3, 15},
  {1, 30},
  {3, 20},
  {1, 29},
  {1, 27},
  {2, 23},
  {1, 14},
  {1, 16},
  {3, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {2, 15},
  {1, 9},
  {1, 4},
  {2, 8},
  {2, 12},
  {1, 3},
  {1, 2},
  {1, 11},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 14},
  {2, 30},
  {1, 21},
  {2, 15},
  {22, 1},
  {1, 15},
  {110, 1},
  {1, 16},
  {2, 30},
  {1, 21},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 18},
  {1, 8},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 8},
  {2, 5},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {2, 15},
  {1, 12},
  {1, 18},
  {1, 23},
  {1, 32},
  {1, 27},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 18},
  {1, 21},
  {1, 23},
  {1, 32},
  {1, 26},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {6, 14},
  {5, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {3, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 10},
  {4, 9},
  {1, 10},
  {7, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {4, 10},
  {15, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {5, 4},
  {1, 5},
  {2, 1},
  {160, 0},
  {160, 0},
  {11, 4},
  {1, 1},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {5, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {12, 7},
  {1, 9},
  {5, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 6},
  {7, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {3, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {3, 18},
  {1, 13},
  {2, 21},
  {1, 30},
  {3, 19},
  {1, 25},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 16},
  {1, 13},
  {2, 15},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 23},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 28},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 4},
  {1, 8},
  {5, 15},
  {2, 21},
  {1, 15},
  {2, 12},
  {1, 2},
  {1, 11},
  {1, 28},
  {1, 31},
  {1, 28},
  {1, 15},
  {1, 7},
  {129, 1},
  {1, 15},
  {1, 1},
  {1, 21},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 6},
  {2, 21},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 12},
  {2, 3},
  {2, 5},
  {1, 12},
  {1, 15},
  {5, 12},
  {1, 21},
  {1, 14},
  {1, 21},
  {1, 32},
  {1, 27},
  {2, 17},
  {1, 20},
  {1, 31},
  {1, 23},
  {1, 3},
  {3, 13},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 15},
  {1, 28},
  {1, 16},
  {3, 14},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 18},
  {5, 11},
  {4, 6},
  {1, 11},
  {5, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 9},
  {1, 7},
  {4, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {1, 10},
  {8, 7},
  {5, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {3, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {16, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {19, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 8},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {3, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {6, 13},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 6},
  {1, 4},
  {1, 5},
  {1, 16},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 12},
  {2, 8},
  {1, 9},
  {1, 3},
  {3, 15},
  {1, 3},
  {2, 5},
  {1, 15},
  {1, 21},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 9},
  {2, 6},
  {1, 21},
  {2, 30},
  {1, 21},
  {2, 15},
  {74, 1},
  {1, 15},
  {51, 1},
  {1, 5},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 28},
  {3, 13},
  {3, 12},
  {2, 21},
  {3, 12},
  {1, 15},
  {2, 12},
  {1, 8},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 15},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 28},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 14},
  {1, 23},
  {2, 32},
  {2, 29},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 18},
  {5, 14},
  {1, 18},
  {2, 13},
  {4, 11},
  {8, 6},
  {1, 11},
  {1, 2},
  {8, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 9},
  {1, 7},
  {4, 9},
  {3, 8},
  {1, 2},
  {4, 8},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {7, 7},
  {3, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {3, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 1},
  {160, 0},
  {160, 0},
  {5, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 1},
  {7, 7},
  {1, 9},
  {4, 7},
  {1, 9},
  {3, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {4, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {5, 14},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 24},
  {3, 26},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 29},
  {3, 23},
  {1, 21},
  {1, 8},
  {1, 5},
  {3, 12},
  {2, 8},
  {1, 21},
  {2, 15},
  {2, 5},
  {2, 4},
  {3, 5},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 13},
  {1, 14},
  {2, 30},
  {1, 28},
  {1, 21},
  {29, 1},
  {1, 15},
  {93, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 21},
  {2, 30},
  {1, 15},
  {1, 4},
  {2, 12},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 11},
  {2, 12},
  {2, 11},
  {1, 12},
  {1, 3},
  {1, 8},
  {3, 5},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 28},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 23},
  {1, 28},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 32},
  {2, 12},
  {1, 11},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {3, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {8, 7},
  {7, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {8, 4},
  {1, 5},
  {2, 4},
  {160, 0},
  {160, 0},
  {3, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {3, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 1},
  {9, 7},
  {1, 10},
  {8, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {19, 9},
  {2, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {1, 11},
  {1, 9},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {6, 13},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 12},
  {1, 28},
  {1, 31},
  {2, 19},
  {1, 17},
  {1, 25},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 14},
  {1, 13},
  {2, 15},
  {1, 18},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 23},
  {2, 16},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 5},
  {3, 3},
  {2, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 13},
  {1, 14},
  {1, 28},
  {2, 30},
  {1, 28},
  {1, 15},
  {1, 1},
  {1, 15},
  {18, 1},
  {1, 15},
  {23, 1},
  {1, 15},
  {63, 1},
  {1, 15},
  {14, 1},
  {2, 30},
  {1, 28},
  {1, 18},
  {1, 21},
  {1, 15},
  {2, 12},
  {3, 11},
  {3, 12},
  {1, 21},
  {1, 15},
  {2, 12},
  {2, 15},
  {1, 12},
  {2, 8},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 8},
  {1, 16},
  {1, 28},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 31},
  {3, 20},
  {1, 31},
  {1, 21},
  {1, 16},
  {1, 6},
  {2, 11},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 30},
  {1, 21},
  {5, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {2, 11},
  {8, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 2},
  {1, 8},
  {1, 6},
  {4, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {6, 7},
  {1, 10},
  {1, 3},
  {7, 10},
  {3, 3},
  {1, 7},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 5},
  {2, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {6, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 1},
  {4, 7},
  {1, 9},
  {2, 7},
  {1, 9},
  {9, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {11, 9},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 2},
  {4, 11},
  {3, 13},
  {1, 18},
  {1, 13},
  {2, 18},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 28},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 27},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 14},
  {1, 18},
  {1, 2},
  {1, 6},
  {1, 16},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 17},
  {2, 29},
  {1, 32},
  {1, 23},
  {2, 14},
  {1, 13},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 15},
  {2, 5},
  {3, 3},
  {1, 4},
  {3, 15},
  {1, 8},
  {2, 12},
  {1, 11},
  {2, 12},
  {2, 9},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 32},
  {2, 30},
  {1, 21},
  {1, 15},
  {62, 1},
  {1, 15},
  {12, 1},
  {1, 15},
  {6, 1},
  {1, 15},
  {17, 1},
  {1, 15},
  {12, 1},
  {1, 15},
  {2, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 28},
  {2, 30},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {3, 12},
  {1, 4},
  {2, 21},
  {2, 12},
  {1, 21},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 16},
  {1, 23},
  {2, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 12},
  {1, 6},
  {1, 13},
  {1, 18},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 30},
  {1, 15},
  {1, 21},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 14},
  {4, 13},
  {1, 11},
  {2, 2},
  {7, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 12},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {3, 10},
  {8, 7},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {4, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {4, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 15},
  {3, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {8, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {4, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {4, 13},
  {1, 18},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 1},
  {1, 15},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 29},
  {2, 26},
  {2, 23},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 21},
  {1, 30},
  {1, 20},
  {2, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {2, 23},
  {2, 16},
  {2, 15},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {3, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 28},
  {1, 18},
  {1, 12},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 21},
  {1, 8},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 15},
  {1, 1},
  {1, 15},
  {84, 1},
  {1, 15},
  {28, 1},
  {1, 7},
  {1, 21},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 15},
  {1, 7},
  {1, 6},
  {3, 12},
  {1, 15},
  {1, 12},
  {2, 21},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {4, 12},
  {1, 11},
  {3, 16},
  {1, 23},
  {1, 32},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 6},
  {1, 8},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 30},
  {1, 24},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 21},
  {4, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 14},
  {2, 13},
  {1, 11},
  {1, 13},
  {1, 11},
  {4, 6},
  {1, 12},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 8},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {8, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {4, 10},
  {7, 7},
  {1, 3},
  {1, 8},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {3, 10},
  {3, 9},
  {1, 7},
  {5, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {5, 9},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {4, 11},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {2, 26},
  {2, 23},
  {2, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {1, 30},
  {3, 17},
  {1, 24},
  {1, 27},
  {1, 26},
  {1, 23},
  {1, 21},
  {1, 14},
  {1, 21},
  {2, 12},
  {1, 5},
  {4, 15},
  {1, 11},
  {2, 15},
  {1, 9},
  {1, 4},
  {1, 3},
  {2, 11},
  {1, 12},
  {2, 4},
  {1, 8},
  {1, 12},
  {1, 21},
  {1, 28},
  {1, 5},
  {1, 9},
  {1, 6},
  {1, 18},
  {1, 28},
  {2, 30},
  {2, 15},
  {112, 1},
  {1, 21},
  {1, 28},
  {2, 30},
  {3, 15},
  {1, 7},
  {2, 8},
  {2, 12},
  {1, 11},
  {2, 15},
  {2, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 11},
  {2, 21},
  {1, 12},
  {1, 16},
  {1, 18},
  {3, 12},
  {1, 16},
  {1, 21},
  {2, 23},
  {1, 32},
  {1, 29},
  {2, 20},
  {1, 17},
  {1, 31},
  {1, 23},
  {1, 18},
  {1, 6},
  {1, 2},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 32},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 15},
  {1, 18},
  {1, 14},
  {1, 16},
  {2, 14},
  {2, 16},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {6, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {7, 9},
  {1, 7},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {7, 7},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {7, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {8, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {11, 7},
  {1, 9},
  {3, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {6, 2},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 11},
  {5, 13},
  {1, 16},
  {5, 14},
  {1, 12},
  {1, 1},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 14},
  {2, 13},
  {1, 11},
  {1, 15},
  {1, 30},
  {1, 20},
  {2, 17},
  {1, 24},
  {1, 27},
  {1, 26},
  {2, 23},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 5},
  {3, 15},
  {1, 5},
  {1, 2},
  {3, 12},
  {1, 16},
  {1, 12},
  {1, 28},
  {2, 30},
  {1, 21},
  {2, 15},
  {49, 1},
  {1, 15},
  {57, 1},
  {1, 18},
  {1, 21},
  {2, 30},
  {1, 28},
  {2, 15},
  {1, 7},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 12},
  {3, 15},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 16},
  {1, 12},
  {1, 15},
  {3, 21},
  {2, 11},
  {1, 15},
  {2, 16},
  {1, 14},
  {1, 32},
  {2, 27},
  {1, 24},
  {1, 17},
  {1, 19},
  {1, 31},
  {1, 21},
  {1, 6},
  {1, 2},
  {1, 15},
  {1, 13},
  {1, 14},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 31},
  {1, 21},
  {7, 14},
  {1, 16},
  {1, 18},
  {5, 13},
  {1, 2},
  {12, 6},
  {1, 12},
  {4, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {2, 9},
  {1, 2},
  {2, 9},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 6},
  {2, 8},
  {1, 9},
  {7, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {1, 3},
  {2, 10},
  {2, 7},
  {1, 3},
  {1, 7},
  {8, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {2, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {4, 4},
  {160, 0},
  {160, 0},
  {3, 4},
  {1, 5},
  {7, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {4, 7},
  {1, 4},
  {5, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 7},
  {4, 9},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {16, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {6, 14},
  {1, 21},
  {1, 28},
  {3, 19},
  {1, 17},
  {2, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {2, 13},
  {1, 6},
  {1, 16},
  {1, 32},
  {1, 20},
  {2, 17},
  {2, 29},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {2, 11},
  {2, 12},
  {1, 2},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 15},
  {2, 3},
  {2, 8},
  {1, 15},
  {1, 28},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 5},
  {2, 8},
  {1, 12},
  {2, 16},
  {2, 12},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 1},
  {1, 15},
  {84, 1},
  {1, 15},
  {16, 1},
  {1, 15},
  {1, 1},
  {1, 11},
  {1, 21},
  {2, 30},
  {1, 28},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 5},
  {1, 3},
  {1, 7},
  {1, 21},
  {2, 15},
  {1, 3},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {3, 15},
  {1, 12},
  {1, 15},
  {3, 12},
  {2, 21},
  {1, 14},
  {1, 11},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 17},
  {1, 20},
  {1, 31},
  {1, 13},
  {1, 3},
  {1, 6},
  {1, 2},
  {1, 13},
  {1, 14},
  {2, 23},
  {2, 26},
  {1, 29},
  {3, 19},
  {1, 31},
  {1, 15},
  {1, 21},
  {1, 18},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {5, 13},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {6, 8},
  {1, 9},
  {1, 10},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {4, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {9, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {7, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 1},
  {3, 7},
  {1, 4},
  {3, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 7},
  {3, 9},
  {5, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 11},
  {13, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {5, 13},
  {1, 16},
  {1, 18},
  {3, 14},
  {2, 18},
  {1, 7},
  {1, 5},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {3, 26},
  {1, 23},
  {1, 14},
  {2, 16},
  {2, 12},
  {1, 21},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 25},
  {2, 26},
  {1, 23},
  {1, 16},
  {3, 12},
  {2, 15},
  {2, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {3, 5},
  {1, 4},
  {1, 8},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 9},
  {1, 15},
  {1, 1},
  {2, 28},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 15},
  {1, 1},
  {1, 15},
  {36, 1},
  {1, 15},
  {61, 1},
  {1, 15},
  {1, 21},
  {1, 28},
  {1, 30},
  {2, 28},
  {1, 18},
  {1, 12},
  {1, 5},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 5},
  {3, 15},
  {1, 3},
  {3, 12},
  {1, 15},
  {5, 5},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 16},
  {1, 11},
  {1, 16},
  {1, 6},
  {2, 16},
  {1, 23},
  {1, 14},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 14},
  {1, 12},
  {1, 6},
  {2, 13},
  {1, 16},
  {2, 23},
  {2, 26},
  {1, 20},
  {1, 17},
  {2, 19},
  {1, 31},
  {1, 28},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 18},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 2},
  {8, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 8},
  {1, 2},
  {1, 11},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {8, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {2, 7},
  {4, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {6, 3},
  {11, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {5, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 7},
  {1, 1},
  {5, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {6, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {11, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 2},
  {3, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {2, 13},
  {7, 14},
  {1, 18},
  {1, 28},
  {3, 19},
  {1, 20},
  {1, 25},
  {1, 22},
  {2, 26},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 31},
  {2, 17},
  {1, 24},
  {1, 29},
  {1, 26},
  {3, 23},
  {1, 16},
  {2, 12},
  {2, 15},
  {1, 11},
  {1, 3},
  {1, 12},
  {1, 8},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 12},
  {1, 1},
  {1, 15},
  {1, 5},
  {1, 4},
  {1, 13},
  {1, 16},
  {1, 12},
  {1, 14},
  {1, 28},
  {2, 30},
  {1, 21},
  {1, 15},
  {1, 1},
  {1, 15},
  {53, 1},
  {1, 15},
  {37, 1},
  {1, 15},
  {2, 1},
  {1, 15},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 1},
  {1, 10},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 2},
  {2, 21},
  {1, 15},
  {2, 5},
  {1, 12},
  {3, 5},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 21},
  {2, 15},
  {1, 12},
  {1, 15},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 15},
  {1, 2},
  {1, 16},
  {1, 6},
  {1, 13},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 13},
  {2, 14},
  {2, 18},
  {1, 16},
  {1, 13},
  {1, 16},
  {4, 13},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {6, 8},
  {1, 9},
  {7, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {2, 10},
  {1, 7},
  {5, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {12, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 1},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {4, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 10},
  {4, 7},
  {1, 1},
  {3, 7},
  {1, 1},
  {2, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 10},
  {6, 9},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {9, 2},
  {1, 9},
  {1, 15},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 2},
  {2, 11},
  {7, 13},
  {1, 16},
  {3, 14},
  {1, 16},
  {1, 18},
  {1, 15},
  {1, 1},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 27},
  {1, 22},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 2},
  {1, 15},
  {2, 21},
  {1, 31},
  {2, 17},
  {1, 24},
  {1, 25},
  {2, 26},
  {1, 23},
  {2, 16},
  {1, 11},
  {2, 21},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 12},
  {2, 8},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 8},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 5},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 12},
  {2, 16},
  {1, 21},
  {1, 28},
  {2, 30},
  {1, 23},
  {1, 18},
  {1, 1},
  {1, 15},
  {91, 1},
  {2, 28},
  {1, 30},
  {1, 28},
  {1, 21},
  {2, 15},
  {1, 7},
  {2, 3},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 21},
  {3, 15},
  {1, 9},
  {1, 8},
  {1, 5},
  {2, 15},
  {1, 21},
  {1, 12},
  {1, 16},
  {1, 11},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 17},
  {3, 20},
  {1, 28},
  {1, 18},
  {2, 11},
  {1, 13},
  {2, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 18},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {8, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {6, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 6},
  {6, 8},
  {1, 6},
  {2, 8},
  {1, 9},
  {7, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 10},
  {2, 7},
  {7, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {5, 3},
  {2, 4},
  {1, 5},
  {9, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 1},
  {4, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {6, 3},
  {1, 7},
  {1, 3},
  {4, 10},
  {9, 7},
  {1, 1},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 15},
  {1, 9},
  {2, 2},
  {2, 9},
  {7, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {2, 11},
  {1, 2},
  {2, 11},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 16},
  {4, 14},
  {1, 18},
  {1, 15},
  {1, 28},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 23},
  {2, 14},
  {1, 11},
  {1, 7},
  {1, 11},
  {1, 13},
  {1, 30},
  {2, 17},
  {1, 24},
  {1, 29},
  {3, 26},
  {1, 16},
  {1, 14},
  {1, 28},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 18},
  {1, 21},
  {1, 15},
  {5, 8},
  {1, 6},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 2},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 2},
  {2, 18},
  {1, 6},
  {2, 21},
  {1, 28},
  {1, 32},
  {2, 28},
  {1, 6},
  {1, 15},
  {1, 1},
  {1, 15},
  {9, 1},
  {1, 15},
  {71, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 7},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 30},
  {2, 21},
  {1, 12},
  {1, 3},
  {3, 15},
  {2, 5},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 15},
  {5, 12},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 5},
  {2, 12},
  {1, 16},
  {1, 14},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 23},
  {1, 18},
  {1, 11},
  {2, 13},
  {1, 18},
  {2, 23},
  {2, 26},
  {1, 27},
  {1, 17},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 11},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {6, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 12},
  {3, 6},
  {1, 12},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {8, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {2, 3},
  {1, 7},
  {6, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {5, 3},
  {11, 4},
  {160, 0},
  {160, 0},
  {1, 5},
  {8, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {7, 3},
  {1, 7},
  {2, 3},
  {3, 10},
  {6, 7},
  {1, 1},
  {5, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {5, 2},
  {1, 9},
  {1, 15},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 13},
  {1, 14},
  {1, 13},
  {2, 14},
  {1, 18},
  {2, 14},
  {1, 21},
  {2, 15},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 23},
  {2, 14},
  {1, 13},
  {1, 15},
  {2, 5},
  {1, 21},
  {2, 17},
  {1, 24},
  {1, 25},
  {1, 27},
  {1, 32},
  {1, 26},
  {2, 23},
  {2, 16},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 13},
  {4, 12},
  {1, 15},
  {1, 8},
  {2, 4},
  {1, 8},
  {1, 9},
  {3, 4},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 18},
  {1, 21},
  {1, 32},
  {2, 28},
  {1, 18},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {13, 1},
  {1, 15},
  {4, 1},
  {1, 15},
  {32, 1},
  {1, 15},
  {25, 1},
  {1, 5},
  {1, 15},
  {1, 21},
  {3, 30},
  {1, 21},
  {1, 1},
  {1, 3},
  {1, 14},
  {2, 28},
  {1, 18},
  {1, 13},
  {2, 15},
  {1, 8},
  {1, 5},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 8},
  {2, 5},
  {1, 15},
  {1, 21},
  {2, 4},
  {1, 12},
  {1, 15},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 29},
  {3, 17},
  {1, 31},
  {1, 21},
  {1, 13},
  {1, 6},
  {2, 16},
  {2, 14},
  {2, 23},
  {1, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 28},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 16},
  {2, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 6},
  {2, 12},
  {2, 6},
  {1, 12},
  {4, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {3, 8},
  {7, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {4, 10},
  {1, 7},
  {1, 3},
  {1, 10},
  {6, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 3},
  {2, 4},
  {160, 0},
  {160, 0},
  {2, 4},
  {1, 1},
  {8, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {2, 7},
  {3, 3},
  {1, 10},
  {13, 7},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {10, 2},
  {1, 11},
  {1, 9},
  {1, 2},
  {2, 9},
  {5, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 11},
  {5, 13},
  {1, 18},
  {1, 14},
  {1, 13},
  {4, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {3, 19},
  {1, 20},
  {1, 29},
  {1, 22},
  {2, 26},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 15},
  {1, 9},
  {1, 21},
  {1, 31},
  {3, 17},
  {1, 29},
  {1, 32},
  {1, 26},
  {2, 23},
  {1, 16},
  {1, 18},
  {1, 30},
  {2, 15},
  {3, 11},
  {1, 15},
  {1, 16},
  {3, 8},
  {1, 3},
  {1, 15},
  {2, 5},
  {1, 3},
  {1, 9},
  {1, 15},
  {2, 3},
  {1, 2},
  {1, 15},
  {2, 8},
  {1, 5},
  {1, 1},
  {1, 15},
  {1, 21},
  {1, 7},
  {2, 12},
  {1, 14},
  {1, 23},
  {1, 28},
  {1, 32},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 15},
  {2, 1},
  {1, 15},
  {7, 1},
  {1, 15},
  {27, 1},
  {1, 15},
  {35, 1},
  {1, 15},
  {1, 1},
  {2, 15},
  {1, 28},
  {3, 30},
  {1, 21},
  {1, 2},
  {1, 8},
  {1, 3},
  {2, 8},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 6},
  {2, 15},
  {3, 12},
  {2, 11},
  {2, 12},
  {1, 15},
  {1, 21},
  {6, 12},
  {2, 8},
  {1, 3},
  {3, 15},
  {1, 8},
  {1, 14},
  {2, 23},
  {1, 27},
  {1, 29},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 12},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 16},
  {2, 14},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 11},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 13},
  {1, 14},
  {4, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {3, 2},
  {1, 11},
  {13, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {9, 7},
  {5, 10},
  {2, 7},
  {5, 10},
  {11, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {11, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 1},
  {4, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {3, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {12, 7},
  {1, 9},
  {1, 7},
  {1, 8},
  {2, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {11, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {17, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {3, 13},
  {1, 18},
  {3, 13},
  {6, 14},
  {1, 18},
  {1, 14},
  {1, 1},
  {1, 21},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 22},
  {2, 26},
  {1, 23},
  {2, 14},
  {1, 16},
  {1, 7},
  {1, 21},
  {1, 18},
  {1, 28},
  {1, 31},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {2, 23},
  {2, 28},
  {1, 11},
  {3, 6},
  {1, 13},
  {2, 15},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 8},
  {2, 3},
  {1, 4},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 3},
  {1, 8},
  {1, 15},
  {1, 3},
  {3, 4},
  {2, 5},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 13},
  {1, 6},
  {1, 18},
  {2, 14},
  {1, 23},
  {3, 30},
  {2, 28},
  {2, 15},
  {2, 1},
  {1, 15},
  {52, 1},
  {1, 15},
  {11, 1},
  {1, 15},
  {1, 1},
  {2, 15},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 30},
  {1, 28},
  {4, 21},
  {1, 15},
  {1, 11},
  {1, 2},
  {2, 12},
  {1, 6},
  {4, 12},
  {1, 11},
  {1, 15},
  {3, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {2, 28},
  {3, 15},
  {2, 28},
  {1, 21},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 18},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 29},
  {2, 17},
  {2, 20},
  {1, 30},
  {1, 18},
  {3, 11},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 17},
  {3, 19},
  {1, 31},
  {1, 21},
  {7, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {4, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {8, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 6},
  {8, 2},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 2},
  {7, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 7},
  {2, 9},
  {2, 7},
  {3, 10},
  {1, 3},
  {6, 10},
  {1, 3},
  {2, 10},
  {1, 8},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {4, 3},
  {10, 4},
  {160, 0},
  {160, 0},
  {8, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {4, 4},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {19, 7},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 7},
  {11, 9},
  {1, 2},
  {1, 9},
  {11, 2},
  {1, 11},
  {1, 9},
  {9, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 14},
  {1, 16},
  {7, 14},
  {2, 21},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 29},
  {1, 27},
  {2, 26},
  {2, 23},
  {1, 16},
  {1, 18},
  {1, 2},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 26},
  {2, 23},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 21},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 2},
  {4, 3},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 15},
  {1, 8},
  {2, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {2, 11},
  {1, 15},
  {1, 21},
  {1, 28},
  {1, 30},
  {3, 28},
  {1, 21},
  {1, 11},
  {57, 1},
  {1, 15},
  {2, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 18},
  {1, 21},
  {3, 30},
  {2, 28},
  {2, 15},
  {2, 3},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 8},
  {4, 12},
  {1, 16},
  {1, 21},
  {3, 12},
  {1, 28},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 15},
  {2, 21},
  {2, 23},
  {1, 32},
  {1, 27},
  {1, 24},
  {3, 20},
  {1, 31},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 13},
  {1, 11},
  {2, 18},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {3, 19},
  {1, 30},
  {1, 15},
  {1, 18},
  {7, 14},
  {1, 13},
  {1, 14},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {6, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 8},
  {9, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {2, 2},
  {6, 9},
  {1, 7},
  {1, 9},
  {3, 8},
  {1, 2},
  {3, 8},
  {2, 9},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {4, 7},
  {1, 9},
  {3, 7},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {7, 10},
  {1, 7},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {10, 4},
  {160, 0},
  {160, 0},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {3, 1},
  {3, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {3, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {12, 7},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 10},
  {5, 9},
  {1, 7},
  {3, 9},
  {1, 3},
  {1, 15},
  {6, 9},
  {3, 2},
  {1, 9},
  {5, 2},
  {1, 9},
  {1, 11},
  {2, 9},
  {11, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {2, 11},
  {5, 13},
  {1, 14},
  {1, 13},
  {1, 16},
  {6, 14},
  {1, 18},
  {2, 21},
  {1, 31},
  {3, 19},
  {1, 24},
  {1, 27},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 18},
  {2, 13},
  {1, 18},
  {2, 16},
  {1, 28},
  {3, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 14},
  {2, 16},
  {1, 21},
  {1, 15},
  {1, 3},
  {1, 5},
  {1, 11},
  {1, 8},
  {3, 12},
  {1, 2},
  {1, 11},
  {1, 3},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 12},
  {5, 3},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 2},
  {4, 6},
  {1, 7},
  {1, 15},
  {1, 1},
  {1, 8},
  {1, 18},
  {1, 21},
  {2, 28},
  {3, 30},
  {1, 28},
  {1, 21},
  {2, 15},
  {2, 1},
  {1, 15},
  {14, 1},
  {1, 15},
  {30, 1},
  {1, 15},
  {2, 1},
  {1, 5},
  {1, 15},
  {1, 1},
  {1, 7},
  {1, 21},
  {1, 28},
  {4, 30},
  {1, 28},
  {1, 15},
  {2, 1},
  {2, 12},
  {1, 18},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {4, 12},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 15},
  {1, 8},
  {2, 5},
  {2, 15},
  {4, 12},
  {1, 13},
  {1, 14},
  {1, 21},
  {1, 32},
  {1, 27},
  {1, 29},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 30},
  {1, 14},
  {1, 12},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 21},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 21},
  {7, 14},
  {1, 16},
  {1, 14},
  {5, 13},
  {1, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {8, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 8},
  {1, 15},
  {4, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {8, 9},
  {1, 2},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {7, 7},
  {8, 10},
  {1, 3},
  {6, 10},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 5},
  {8, 4},
  {1, 3},
  {1, 4},
  {4, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {18, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 7},
  {1, 8},
  {1, 7},
  {2, 9},
  {1, 8},
  {3, 9},
  {1, 3},
  {6, 9},
  {1, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {2, 2},
  {1, 15},
  {2, 9},
  {1, 2},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 11},
  {1, 9},
  {6, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {2, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {5, 13},
  {1, 18},
  {1, 16},
  {5, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {1, 21},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 24},
  {1, 27},
  {1, 22},
  {1, 23},
  {1, 26},
  {1, 23},
  {1, 14},
  {3, 16},
  {1, 13},
  {1, 18},
  {1, 21},
  {1, 31},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 20},
  {1, 29},
  {2, 32},
  {2, 23},
  {1, 28},
  {2, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 8},
  {1, 21},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 12},
  {1, 5},
  {6, 12},
  {2, 18},
  {1, 2},
  {1, 9},
  {2, 15},
  {1, 21},
  {1, 6},
  {1, 16},
  {2, 14},
  {1, 23},
  {2, 28},
  {2, 30},
  {3, 28},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {2, 1},
  {1, 15},
  {31, 1},
  {1, 15},
  {3, 1},
  {1, 15},
  {2, 1},
  {1, 7},
  {2, 15},
  {1, 21},
  {1, 28},
  {2, 30},
  {1, 28},
  {1, 30},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 9},
  {1, 8},
  {2, 12},
  {1, 4},
  {1, 3},
  {1, 9},
  {1, 8},
  {3, 3},
  {1, 8},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 16},
  {1, 15},
  {3, 12},
  {1, 15},
  {1, 12},
  {1, 4},
  {1, 8},
  {2, 15},
  {2, 16},
  {1, 13},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {3, 17},
  {1, 20},
  {1, 32},
  {1, 21},
  {1, 16},
  {2, 6},
  {1, 13},
  {1, 18},
  {3, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {2, 19},
  {1, 20},
  {1, 30},
  {1, 16},
  {3, 14},
  {1, 23},
  {4, 14},
  {3, 13},
  {1, 14},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {1, 16},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 9},
  {1, 2},
  {4, 9},
  {1, 7},
  {3, 9},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {3, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {7, 7},
  {7, 10},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {1, 3},
  {15, 4},
  {160, 0},
  {160, 0},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 1},
  {1, 7},
  {3, 1},
  {1, 7},
  {1, 1},
  {2, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {6, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {11, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {9, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {3, 2},
  {1, 9},
  {2, 2},
  {2, 9},
  {1, 11},
  {6, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {3, 2},
  {2, 11},
  {4, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {5, 14},
  {1, 18},
  {1, 13},
  {2, 15},
  {1, 30},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 25},
  {1, 27},
  {2, 26},
  {2, 23},
  {2, 14},
  {1, 13},
  {1, 16},
  {2, 14},
  {1, 31},
  {3, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 32},
  {1, 23},
  {1, 14},
  {1, 16},
  {1, 21},
  {1, 12},
  {1, 8},
  {2, 12},
  {2, 15},
  {2, 12},
  {1, 11},
  {1, 6},
  {1, 3},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 12},
  {2, 5},
  {1, 12},
  {1, 3},
  {4, 12},
  {1, 16},
  {1, 18},
  {1, 28},
  {1, 21},
  {2, 2},
  {2, 11},
  {1, 15},
  {1, 11},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 13},
  {2, 12},
  {1, 11},
  {1, 21},
  {2, 28},
  {4, 30},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 11},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {3, 1},
  {1, 15},
  {8, 1},
  {1, 15},
  {6, 1},
  {1, 15},
  {3, 1},
  {2, 7},
  {3, 15},
  {3, 28},
  {3, 30},
  {1, 28},
  {2, 21},
  {1, 15},
  {1, 1},
  {1, 18},
  {1, 21},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 11},
  {1, 8},
  {1, 10},
  {1, 8},
  {1, 3},
  {2, 12},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {3, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 16},
  {2, 15},
  {3, 12},
  {1, 15},
  {3, 12},
  {1, 21},
  {1, 23},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {2, 17},
  {1, 30},
  {1, 14},
  {2, 16},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 14},
  {2, 23},
  {2, 32},
  {1, 27},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 28},
  {3, 14},
  {2, 18},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 14},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 8},
  {2, 6},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {8, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {3, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {7, 7},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 10},
  {1, 3},
  {6, 10},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {20, 4},
  {160, 0},
  {160, 0},
  {10, 4},
  {1, 3},
  {4, 4},
  {2, 1},
  {1, 7},
  {4, 1},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {3, 7},
  {2, 4},
  {1, 7},
  {1, 1},
  {17, 7},
  {2, 10},
  {2, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 15},
  {1, 10},
  {3, 2},
  {1, 9},
  {11, 2},
  {2, 9},
  {1, 11},
  {1, 9},
  {2, 2},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {3, 2},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 11},
  {4, 13},
  {1, 16},
  {2, 14},
  {1, 16},
  {6, 14},
  {2, 18},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {3, 26},
  {1, 14},
  {1, 23},
  {1, 16},
  {1, 14},
  {3, 16},
  {1, 32},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {2, 23},
  {1, 16},
  {1, 14},
  {1, 11},
  {1, 6},
  {1, 21},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {2, 8},
  {1, 4},
  {1, 12},
  {1, 8},
  {2, 11},
  {1, 6},
  {1, 11},
  {2, 13},
  {3, 11},
  {1, 15},
  {1, 6},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 31},
  {1, 21},
  {1, 18},
  {2, 12},
  {1, 16},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 13},
  {2, 21},
  {1, 28},
  {5, 30},
  {4, 28},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 11},
  {2, 15},
  {3, 7},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 7},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {4, 15},
  {1, 18},
  {1, 21},
  {2, 28},
  {3, 30},
  {2, 31},
  {2, 30},
  {1, 28},
  {1, 15},
  {3, 12},
  {1, 8},
  {2, 3},
  {1, 6},
  {1, 28},
  {1, 21},
  {1, 9},
  {1, 11},
  {1, 7},
  {1, 9},
  {1, 3},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 7},
  {1, 9},
  {1, 11},
  {1, 13},
  {2, 11},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 8},
  {5, 12},
  {1, 21},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 21},
  {3, 12},
  {1, 15},
  {2, 16},
  {1, 14},
  {2, 32},
  {2, 27},
  {1, 29},
  {2, 17},
  {2, 20},
  {1, 21},
  {2, 16},
  {1, 6},
  {2, 13},
  {1, 18},
  {1, 14},
  {2, 23},
  {2, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 31},
  {1, 15},
  {1, 18},
  {8, 14},
  {1, 13},
  {1, 14},
  {1, 6},
  {1, 16},
  {3, 13},
  {2, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {6, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {8, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {9, 9},
  {5, 8},
  {1, 6},
  {1, 8},
  {1, 9},
  {1, 10},
  {2, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {7, 7},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {1, 8},
  {1, 3},
  {3, 10},
  {2, 3},
  {1, 10},
  {5, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {3, 3},
  {2, 4},
  {1, 3},
  {16, 4},
  {160, 0},
  {160, 0},
  {3, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {6, 4},
  {1, 1},
  {1, 7},
  {4, 1},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 4},
  {6, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {11, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {3, 7},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {1, 15},
  {1, 2},
  {1, 9},
  {1, 11},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 9},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {6, 13},
  {1, 16},
  {3, 14},
  {1, 16},
  {3, 14},
  {2, 18},
  {2, 15},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 25},
  {1, 27},
  {3, 26},
  {1, 23},
  {3, 14},
  {1, 6},
  {2, 12},
  {1, 18},
  {1, 31},
  {3, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 32},
  {1, 26},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {3, 8},
  {1, 12},
  {1, 4},
  {1, 3},
  {1, 12},
  {2, 8},
  {5, 12},
  {1, 5},
  {2, 12},
  {2, 2},
  {2, 8},
  {1, 15},
  {2, 21},
  {2, 18},
  {1, 16},
  {1, 28},
  {1, 21},
  {1, 11},
  {2, 2},
  {3, 21},
  {1, 18},
  {3, 12},
  {1, 3},
  {1, 2},
  {1, 15},
  {1, 11},
  {3, 28},
  {3, 30},
  {1, 31},
  {12, 30},
  {1, 28},
  {7, 30},
  {3, 31},
  {1, 30},
  {1, 31},
  {1, 30},
  {2, 28},
  {1, 18},
  {2, 21},
  {1, 16},
  {2, 12},
  {1, 3},
  {1, 12},
  {2, 3},
  {1, 5},
  {1, 12},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 8},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 4},
  {1, 21},
  {1, 28},
  {1, 6},
  {2, 12},
  {2, 6},
  {2, 8},
  {3, 3},
  {2, 8},
  {1, 3},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {2, 12},
  {2, 21},
  {1, 11},
  {2, 16},
  {1, 28},
  {1, 21},
  {2, 32},
  {2, 29},
  {1, 24},
  {3, 17},
  {1, 31},
  {1, 21},
  {1, 13},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 13},
  {2, 14},
  {2, 23},
  {2, 32},
  {1, 29},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 30},
  {1, 28},
  {2, 18},
  {4, 14},
  {2, 16},
  {1, 14},
  {2, 16},
  {1, 13},
  {1, 16},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {8, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {3, 2},
  {1, 11},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 6},
  {1, 8},
  {1, 6},
  {4, 8},
  {5, 9},
  {2, 10},
  {7, 7},
  {2, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {5, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {11, 4},
  {1, 3},
  {3, 4},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {6, 4},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 3},
  {7, 1},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {7, 7},
  {1, 3},
  {5, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {3, 7},
  {1, 10},
  {5, 7},
  {6, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {8, 9},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 10},
  {2, 2},
  {2, 9},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 11},
  {1, 9},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 11},
  {2, 2},
  {2, 11},
  {8, 13},
  {2, 14},
  {1, 16},
  {3, 14},
  {2, 18},
  {1, 15},
  {1, 21},
  {1, 31},
  {3, 19},
  {1, 17},
  {1, 25},
  {4, 26},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 13},
  {2, 6},
  {1, 11},
  {1, 28},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {2, 26},
  {1, 21},
  {1, 23},
  {1, 14},
  {1, 11},
  {2, 21},
  {1, 8},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {1, 3},
  {1, 12},
  {1, 5},
  {3, 8},
  {1, 12},
  {2, 8},
  {2, 4},
  {1, 3},
  {1, 9},
  {1, 11},
  {3, 21},
  {1, 15},
  {3, 12},
  {1, 6},
  {1, 15},
  {1, 2},
  {1, 8},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 6},
  {2, 11},
  {2, 9},
  {1, 6},
  {1, 13},
  {1, 16},
  {1, 14},
  {1, 18},
  {2, 21},
  {3, 28},
  {1, 15},
  {1, 28},
  {2, 15},
  {7, 28},
  {1, 15},
  {1, 28},
  {1, 15},
  {1, 28},
  {3, 15},
  {1, 21},
  {1, 18},
  {1, 5},
  {1, 1},
  {1, 21},
  {2, 2},
  {1, 12},
  {1, 21},
  {1, 28},
  {2, 12},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 4},
  {1, 5},
  {1, 9},
  {1, 3},
  {2, 21},
  {1, 11},
  {1, 21},
  {2, 15},
  {1, 6},
  {1, 11},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 11},
  {1, 15},
  {1, 2},
  {1, 15},
  {1, 8},
  {1, 15},
  {1, 8},
  {1, 15},
  {2, 4},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 16},
  {1, 28},
  {1, 21},
  {2, 14},
  {1, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 24},
  {3, 20},
  {1, 31},
  {1, 21},
  {2, 12},
  {1, 16},
  {1, 6},
  {2, 13},
  {1, 18},
  {1, 21},
  {1, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 28},
  {2, 15},
  {1, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {3, 13},
  {1, 16},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {3, 6},
  {1, 12},
  {1, 6},
  {1, 16},
  {5, 6},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 8},
  {3, 6},
  {1, 8},
  {2, 2},
  {1, 8},
  {4, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 9},
  {7, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 10},
  {5, 7},
  {1, 9},
  {3, 10},
  {1, 7},
  {8, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 5},
  {1, 4},
  {2, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {6, 4},
  {2, 1},
  {7, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 7},
  {1, 5},
  {1, 15},
  {1, 1},
  {1, 7},
  {4, 1},
  {1, 4},
  {4, 7},
  {1, 1},
  {6, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 7},
  {2, 10},
  {1, 7},
  {2, 10},
  {7, 7},
  {1, 3},
  {3, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {7, 9},
  {7, 2},
  {2, 9},
  {2, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {4, 13},
  {1, 14},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 18},
  {1, 15},
  {2, 21},
  {1, 30},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 17},
  {1, 24},
  {1, 27},
  {3, 26},
  {1, 23},
  {2, 14},
  {1, 13},
  {1, 2},
  {2, 12},
  {1, 21},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 27},
  {2, 32},
  {1, 23},
  {1, 14},
  {1, 28},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 13},
  {1, 12},
  {1, 8},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 15},
  {1, 2},
  {1, 15},
  {2, 8},
  {1, 12},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 11},
  {4, 12},
  {1, 21},
  {1, 8},
  {1, 5},
  {1, 12},
  {1, 15},
  {2, 3},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 15},
  {2, 21},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 13},
  {2, 11},
  {1, 15},
  {1, 1},
  {1, 5},
  {4, 1},
  {1, 15},
  {7, 5},
  {1, 1},
  {1, 15},
  {2, 1},
  {3, 15},
  {1, 11},
  {1, 10},
  {1, 11},
  {1, 15},
  {2, 7},
  {1, 18},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 8},
  {3, 3},
  {1, 4},
  {1, 8},
  {1, 21},
  {1, 11},
  {1, 3},
  {2, 4},
  {1, 15},
  {1, 21},
  {1, 16},
  {6, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {1, 3},
  {2, 5},
  {1, 12},
  {2, 4},
  {1, 3},
  {2, 15},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 16},
  {1, 23},
  {1, 28},
  {2, 32},
  {1, 27},
  {2, 29},
  {1, 17},
  {1, 19},
  {2, 20},
  {1, 31},
  {1, 21},
  {1, 13},
  {1, 6},
  {1, 12},
  {1, 16},
  {1, 13},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 28},
  {1, 32},
  {1, 29},
  {1, 24},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 21},
  {1, 18},
  {1, 14},
  {1, 18},
  {4, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 16},
  {2, 13},
  {1, 6},
  {4, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {5, 6},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 12},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {2, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {3, 2},
  {4, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 10},
  {6, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {8, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {12, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {4, 1},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 5},
  {1, 3},
  {8, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 1},
  {1, 5},
  {4, 1},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 1},
  {10, 7},
  {1, 3},
  {2, 7},
  {1, 9},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {3, 9},
  {1, 7},
  {1, 8},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {4, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {5, 9},
  {3, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {1, 2},
  {1, 11},
  {1, 9},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {4, 14},
  {1, 21},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 17},
  {2, 27},
  {2, 26},
  {2, 23},
  {2, 16},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 16},
  {1, 14},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {2, 29},
  {1, 27},
  {2, 32},
  {1, 23},
  {2, 16},
  {1, 14},
  {1, 11},
  {2, 12},
  {1, 2},
  {1, 8},
  {1, 3},
  {1, 9},
  {2, 15},
  {3, 12},
  {1, 3},
  {2, 12},
  {2, 8},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 8},
  {3, 12},
  {1, 15},
  {2, 6},
  {1, 12},
  {1, 3},
  {2, 15},
  {1, 5},
  {1, 11},
  {2, 12},
  {1, 5},
  {1, 11},
  {1, 6},
  {1, 28},
  {1, 15},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 11},
  {2, 12},
  {2, 8},
  {4, 9},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 1},
  {1, 7},
  {1, 9},
  {1, 15},
  {1, 6},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 15},
  {1, 5},
  {1, 4},
  {1, 11},
  {2, 15},
  {1, 8},
  {1, 10},
  {1, 11},
  {2, 9},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 4},
  {1, 8},
  {1, 4},
  {1, 8},
  {1, 4},
  {1, 12},
  {2, 15},
  {1, 12},
  {1, 5},
  {1, 8},
  {4, 15},
  {1, 11},
  {1, 21},
  {6, 12},
  {1, 15},
  {1, 3},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {3, 15},
  {1, 12},
  {1, 11},
  {1, 12},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {2, 27},
  {1, 29},
  {2, 20},
  {1, 19},
  {2, 20},
  {1, 23},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 6},
  {2, 13},
  {1, 18},
  {3, 23},
  {1, 32},
  {1, 27},
  {1, 31},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 14},
  {1, 21},
  {1, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {6, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {4, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 9},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {4, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {6, 7},
  {2, 9},
  {1, 7},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {5, 1},
  {2, 5},
  {2, 4},
  {1, 5},
  {11, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 1},
  {1, 7},
  {3, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {3, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {7, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {5, 9},
  {2, 7},
  {1, 15},
  {4, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {4, 2},
  {2, 9},
  {3, 2},
  {1, 9},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {6, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {3, 16},
  {1, 12},
  {1, 28},
  {1, 31},
  {2, 19},
  {2, 20},
  {1, 29},
  {1, 27},
  {3, 26},
  {1, 23},
  {2, 14},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 6},
  {1, 18},
  {1, 28},
  {1, 17},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 24},
  {2, 29},
  {1, 27},
  {1, 32},
  {2, 23},
  {1, 14},
  {2, 16},
  {1, 11},
  {2, 8},
  {1, 15},
  {1, 21},
  {1, 9},
  {1, 12},
  {1, 5},
  {3, 12},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 15},
  {2, 11},
  {2, 15},
  {2, 21},
  {1, 15},
  {2, 21},
  {1, 15},
  {1, 21},
  {1, 15},
  {2, 11},
  {1, 15},
  {2, 12},
  {1, 5},
  {1, 15},
  {2, 21},
  {1, 2},
  {1, 8},
  {2, 3},
  {2, 12},
  {2, 8},
  {1, 9},
  {1, 10},
  {5, 7},
  {1, 9},
  {1, 4},
  {1, 15},
  {1, 21},
  {1, 28},
  {1, 21},
  {6, 15},
  {3, 21},
  {2, 15},
  {1, 21},
  {1, 18},
  {1, 7},
  {1, 3},
  {1, 11},
  {1, 9},
  {1, 8},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 9},
  {3, 3},
  {1, 15},
  {1, 21},
  {1, 16},
  {2, 12},
  {3, 15},
  {1, 3},
  {1, 12},
  {1, 16},
  {1, 15},
  {2, 11},
  {2, 12},
  {2, 8},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 6},
  {2, 12},
  {1, 15},
  {1, 12},
  {2, 4},
  {2, 15},
  {2, 12},
  {1, 16},
  {2, 14},
  {2, 23},
  {2, 27},
  {1, 29},
  {1, 24},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 30},
  {1, 18},
  {1, 16},
  {1, 12},
  {2, 11},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 24},
  {3, 19},
  {1, 20},
  {1, 30},
  {1, 23},
  {5, 14},
  {1, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 13},
  {1, 14},
  {1, 16},
  {2, 13},
  {1, 16},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 16},
  {3, 6},
  {1, 16},
  {2, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {5, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {5, 8},
  {6, 7},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {11, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {2, 1},
  {1, 7},
  {5, 1},
  {3, 7},
  {1, 1},
  {4, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 3},
  {4, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {6, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 8},
  {3, 9},
  {1, 7},
  {9, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {3, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {5, 13},
  {1, 16},
  {5, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 31},
  {3, 19},
  {1, 24},
  {1, 29},
  {2, 27},
  {2, 26},
  {1, 23},
  {2, 14},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 12},
  {1, 30},
  {1, 17},
  {1, 19},
  {3, 17},
  {1, 29},
  {2, 27},
  {1, 32},
  {2, 23},
  {2, 14},
  {1, 16},
  {1, 15},
  {1, 28},
  {2, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 28},
  {1, 11},
  {1, 16},
  {1, 6},
  {1, 12},
  {1, 16},
  {2, 6},
  {4, 12},
  {1, 8},
  {2, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {3, 21},
  {1, 16},
  {1, 12},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 21},
  {3, 8},
  {1, 12},
  {1, 2},
  {1, 21},
  {1, 3},
  {1, 8},
  {1, 10},
  {1, 3},
  {2, 7},
  {1, 3},
  {2, 7},
  {1, 10},
  {1, 3},
  {1, 5},
  {1, 15},
  {1, 5},
  {1, 15},
  {1, 7},
  {6, 15},
  {1, 21},
  {1, 15},
  {1, 13},
  {1, 15},
  {1, 21},
  {2, 15},
  {1, 5},
  {1, 9},
  {1, 7},
  {1, 9},
  {2, 8},
  {2, 3},
  {2, 9},
  {1, 15},
  {1, 11},
  {1, 8},
  {1, 3},
  {1, 4},
  {2, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {5, 12},
  {1, 16},
  {1, 15},
  {1, 11},
  {2, 16},
  {3, 21},
  {1, 11},
  {1, 16},
  {1, 11},
  {3, 12},
  {1, 21},
  {1, 15},
  {1, 16},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 16},
  {1, 12},
  {1, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 13},
  {1, 18},
  {2, 23},
  {1, 32},
  {1, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 15},
  {3, 14},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 13},
  {2, 6},
  {1, 13},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 8},
  {1, 6},
  {2, 12},
  {1, 8},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {2, 2},
  {3, 8},
  {1, 6},
  {5, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 5},
  {160, 0},
  {160, 0},
  {6, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {9, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {4, 1},
  {1, 15},
  {3, 1},
  {1, 4},
  {2, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {5, 7},
  {1, 3},
  {2, 7},
  {4, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {7, 7},
  {1, 3},
  {1, 9},
  {3, 7},
  {6, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 11},
  {1, 16},
  {5, 13},
  {1, 14},
  {1, 16},
  {5, 14},
  {1, 18},
  {1, 13},
  {1, 16},
  {1, 11},
  {1, 28},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 20},
  {1, 29},
  {1, 22},
  {2, 26},
  {1, 32},
  {1, 23},
  {1, 14},
  {1, 18},
  {1, 13},
  {1, 16},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 29},
  {1, 27},
  {3, 32},
  {1, 14},
  {1, 16},
  {1, 30},
  {1, 21},
  {1, 12},
  {2, 11},
  {1, 16},
  {1, 15},
  {1, 21},
  {1, 2},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 11},
  {3, 8},
  {1, 5},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 15},
  {3, 12},
  {1, 16},
  {1, 15},
  {1, 16},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 21},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 10},
  {1, 7},
  {3, 9},
  {1, 8},
  {2, 10},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 1},
  {2, 3},
  {3, 5},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 12},
  {1, 6},
  {1, 16},
  {2, 6},
  {1, 15},
  {1, 21},
  {1, 2},
  {1, 3},
  {1, 2},
  {1, 3},
  {1, 9},
  {1, 8},
  {1, 12},
  {3, 15},
  {2, 8},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 8},
  {4, 12},
  {2, 21},
  {1, 11},
  {1, 15},
  {4, 16},
  {1, 14},
  {2, 16},
  {1, 21},
  {1, 16},
  {2, 12},
  {1, 21},
  {2, 23},
  {1, 14},
  {1, 32},
  {1, 27},
  {2, 29},
  {2, 17},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {2, 16},
  {1, 6},
  {1, 13},
  {1, 11},
  {2, 18},
  {1, 14},
  {1, 32},
  {1, 23},
  {1, 26},
  {2, 27},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 16},
  {3, 14},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 13},
  {1, 14},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 12},
  {1, 11},
  {7, 6},
  {1, 12},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {7, 8},
  {1, 10},
  {3, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 10},
  {1, 9},
  {11, 10},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 4},
  {1, 5},
  {10, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 1},
  {1, 15},
  {1, 5},
  {1, 1},
  {1, 5},
  {2, 1},
  {7, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 3},
  {3, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {8, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {9, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 9},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {2, 2},
  {1, 13},
  {1, 6},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 11},
  {1, 13},
  {5, 14},
  {1, 18},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {3, 26},
  {2, 23},
  {1, 14},
  {2, 13},
  {3, 11},
  {2, 21},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {2, 17},
  {1, 29},
  {2, 27},
  {1, 28},
  {1, 32},
  {1, 21},
  {4, 14},
  {1, 11},
  {1, 21},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 15},
  {1, 12},
  {2, 8},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 12},
  {2, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 15},
  {2, 12},
  {1, 11},
  {1, 18},
  {1, 12},
  {1, 6},
  {1, 11},
  {2, 21},
  {1, 7},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 10},
  {3, 8},
  {1, 9},
  {1, 2},
  {1, 15},
  {1, 30},
  {1, 15},
  {2, 7},
  {1, 8},
  {1, 7},
  {3, 15},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 12},
  {1, 2},
  {1, 6},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 2},
  {4, 8},
  {1, 18},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 8},
  {2, 15},
  {2, 5},
  {1, 15},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 16},
  {1, 21},
  {2, 28},
  {2, 16},
  {1, 3},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 16},
  {1, 12},
  {1, 16},
  {1, 21},
  {1, 16},
  {1, 14},
  {3, 23},
  {1, 32},
  {1, 27},
  {1, 29},
  {4, 20},
  {1, 31},
  {1, 32},
  {1, 14},
  {2, 12},
  {1, 6},
  {1, 13},
  {3, 14},
  {2, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 28},
  {1, 12},
  {2, 16},
  {4, 14},
  {2, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {3, 13},
  {1, 16},
  {1, 13},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 12},
  {2, 6},
  {3, 12},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {2, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {5, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {9, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {4, 7},
  {2, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {11, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 5},
  {4, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {5, 4},
  {2, 1},
  {1, 5},
  {1, 1},
  {1, 7},
  {2, 1},
  {1, 7},
  {2, 1},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {5, 7},
  {1, 4},
  {5, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 10},
  {7, 7},
  {1, 3},
  {1, 7},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 7},
  {4, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {8, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 16},
  {2, 13},
  {1, 18},
  {2, 16},
  {5, 14},
  {2, 16},
  {1, 7},
  {1, 15},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 25},
  {1, 27},
  {3, 26},
  {1, 23},
  {1, 21},
  {2, 18},
  {1, 11},
  {1, 9},
  {1, 15},
  {1, 7},
  {1, 13},
  {1, 28},
  {1, 31},
  {2, 20},
  {3, 17},
  {1, 29},
  {2, 27},
  {1, 32},
  {3, 23},
  {1, 16},
  {1, 21},
  {1, 11},
  {1, 12},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 16},
  {1, 21},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 12},
  {2, 3},
  {1, 8},
  {2, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {2, 5},
  {1, 15},
  {1, 8},
  {1, 3},
  {2, 5},
  {1, 4},
  {1, 2},
  {2, 12},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 12},
  {2, 11},
  {1, 8},
  {5, 10},
  {2, 2},
  {1, 8},
  {2, 15},
  {1, 21},
  {1, 15},
  {1, 21},
  {1, 15},
  {3, 21},
  {1, 28},
  {1, 15},
  {1, 2},
  {1, 7},
  {1, 3},
  {1, 8},
  {2, 15},
  {1, 11},
  {1, 12},
  {1, 5},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 21},
  {1, 11},
  {1, 8},
  {2, 3},
  {1, 12},
  {1, 11},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 12},
  {2, 5},
  {1, 15},
  {1, 16},
  {1, 15},
  {2, 16},
  {1, 12},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 21},
  {1, 6},
  {1, 16},
  {2, 21},
  {1, 18},
  {1, 14},
  {3, 23},
  {1, 32},
  {2, 27},
  {1, 29},
  {2, 17},
  {1, 20},
  {1, 17},
  {1, 31},
  {1, 28},
  {1, 13},
  {1, 6},
  {1, 16},
  {1, 13},
  {1, 11},
  {1, 15},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 32},
  {2, 26},
  {1, 29},
  {1, 17},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 21},
  {8, 14},
  {1, 16},
  {1, 14},
  {3, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {2, 13},
  {1, 6},
  {1, 13},
  {2, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 2},
  {7, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {4, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {2, 9},
  {2, 8},
  {1, 9},
  {1, 10},
  {1, 8},
  {6, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 8},
  {4, 3},
  {1, 10},
  {2, 3},
  {1, 7},
  {1, 4},
  {3, 3},
  {1, 4},
  {5, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {3, 1},
  {160, 0},
  {160, 0},
  {8, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {6, 4},
  {2, 3},
  {4, 4},
  {2, 1},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 1},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {7, 7},
  {1, 9},
  {1, 7},
  {9, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {10, 9},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 18},
  {2, 14},
  {1, 18},
  {1, 15},
  {1, 28},
  {1, 31},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 25},
  {1, 22},
  {2, 26},
  {2, 23},
  {1, 14},
  {2, 18},
  {2, 13},
  {1, 2},
  {1, 9},
  {1, 15},
  {1, 28},
  {1, 31},
  {3, 20},
  {2, 17},
  {1, 29},
  {2, 27},
  {2, 32},
  {2, 23},
  {2, 16},
  {1, 14},
  {1, 28},
  {1, 15},
  {1, 11},
  {1, 21},
  {4, 16},
  {1, 15},
  {1, 16},
  {1, 4},
  {1, 15},
  {1, 5},
  {1, 3},
  {1, 12},
  {1, 15},
  {1, 21},
  {1, 5},
  {1, 4},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 15},
  {3, 8},
  {2, 6},
  {2, 12},
  {2, 8},
  {1, 10},
  {1, 3},
  {2, 10},
  {1, 9},
  {2, 6},
  {2, 13},
  {1, 11},
  {1, 15},
  {1, 4},
  {1, 9},
  {1, 15},
  {1, 21},
  {3, 15},
  {2, 8},
  {1, 2},
  {2, 9},
  {1, 11},
  {2, 21},
  {4, 5},
  {1, 11},
  {2, 21},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 2},
  {1, 15},
  {1, 11},
  {2, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 8},
  {1, 15},
  {3, 12},
  {1, 11},
  {3, 14},
  {2, 23},
  {1, 28},
  {2, 32},
  {1, 27},
  {2, 29},
  {1, 20},
  {1, 17},
  {2, 20},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 12},
  {1, 16},
  {1, 6},
  {2, 13},
  {2, 18},
  {1, 21},
  {1, 23},
  {1, 32},
  {2, 26},
  {1, 27},
  {1, 24},
  {1, 17},
  {3, 19},
  {1, 20},
  {2, 15},
  {1, 11},
  {5, 14},
  {2, 18},
  {2, 13},
  {1, 18},
  {4, 13},
  {1, 6},
  {1, 13},
  {1, 16},
  {4, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {5, 6},
  {1, 12},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {9, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {5, 8},
  {1, 2},
  {8, 8},
  {1, 9},
  {1, 8},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {4, 9},
  {4, 10},
  {1, 9},
  {4, 10},
  {1, 3},
  {1, 10},
  {2, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {160, 0},
  {160, 0},
  {8, 1},
  {2, 4},
  {1, 5},
  {9, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {4, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {6, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {9, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {4, 13},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 18},
  {2, 15},
  {1, 21},
  {1, 30},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {2, 27},
  {2, 26},
  {2, 23},
  {1, 14},
  {2, 18},
  {1, 11},
  {1, 15},
  {1, 1},
  {1, 15},
  {1, 18},
  {1, 23},
  {2, 31},
  {4, 20},
  {2, 29},
  {2, 27},
  {1, 26},
  {4, 23},
  {1, 14},
  {1, 21},
  {1, 15},
  {1, 11},
  {1, 15},
  {1, 11},
  {1, 6},
  {1, 15},
  {1, 21},
  {2, 15},
  {4, 12},
  {1, 16},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 15},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 11},
  {1, 6},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 10},
  {1, 8},
  {3, 3},
  {1, 10},
  {3, 8},
  {1, 16},
  {1, 12},
  {1, 6},
  {1, 8},
  {1, 15},
  {1, 21},
  {1, 28},
  {1, 5},
  {1, 12},
  {1, 3},
  {1, 2},
  {1, 9},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 12},
  {1, 8},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {7, 12},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 4},
  {1, 12},
  {1, 5},
  {2, 15},
  {1, 5},
  {1, 4},
  {1, 15},
  {2, 4},
  {2, 12},
  {1, 14},
  {1, 16},
  {2, 14},
  {2, 23},
  {1, 26},
  {2, 32},
  {2, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 19},
  {1, 17},
  {1, 31},
  {1, 28},
  {1, 14},
  {1, 13},
  {1, 16},
  {2, 6},
  {2, 13},
  {1, 14},
  {2, 23},
  {2, 26},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 31},
  {1, 21},
  {1, 18},
  {4, 14},
  {2, 18},
  {1, 14},
  {1, 13},
  {1, 14},
  {7, 13},
  {1, 6},
  {1, 13},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {4, 6},
  {1, 12},
  {2, 6},
  {1, 2},
  {1, 16},
  {1, 12},
  {1, 8},
  {3, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {12, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {2, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 8},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 8},
  {4, 10},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {5, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {6, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {9, 1},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {5, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 1},
  {2, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {3, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 3},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {7, 7},
  {8, 9},
  {1, 7},
  {6, 9},
  {1, 7},
  {7, 9},
  {1, 7},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 16},
  {3, 13},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 18},
  {5, 14},
  {2, 18},
  {1, 28},
  {1, 31},
  {2, 19},
  {2, 20},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 26},
  {1, 22},
  {1, 26},
  {2, 23},
  {1, 21},
  {1, 18},
  {1, 9},
  {1, 15},
  {2, 7},
  {1, 11},
  {1, 16},
  {1, 23},
  {1, 31},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {2, 29},
  {3, 27},
  {2, 26},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 18},
  {1, 11},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 3},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 21},
  {2, 12},
  {1, 16},
  {1, 11},
  {1, 12},
  {1, 8},
  {3, 12},
  {1, 15},
  {1, 28},
  {1, 21},
  {1, 12},
  {2, 4},
  {1, 3},
  {1, 15},
  {1, 3},
  {1, 12},
  {1, 8},
  {2, 2},
  {1, 15},
  {2, 28},
  {1, 15},
  {1, 16},
  {1, 6},
  {1, 11},
  {3, 15},
  {2, 5},
  {1, 3},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 4},
  {1, 15},
  {2, 5},
  {1, 8},
  {2, 15},
  {3, 12},
  {1, 11},
  {1, 16},
  {2, 12},
  {1, 15},
  {1, 21},
  {2, 12},
  {2, 15},
  {2, 5},
  {1, 3},
  {1, 15},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 3},
  {1, 8},
  {1, 11},
  {1, 12},
  {2, 16},
  {3, 23},
  {2, 26},
  {2, 27},
  {1, 29},
  {2, 17},
  {1, 20},
  {2, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 18},
  {1, 16},
  {1, 12},
  {2, 6},
  {2, 13},
  {2, 14},
  {2, 23},
  {1, 26},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {3, 19},
  {1, 31},
  {1, 28},
  {1, 5},
  {1, 16},
  {2, 14},
  {2, 16},
  {2, 14},
  {1, 18},
  {1, 16},
  {3, 13},
  {1, 14},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {6, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {8, 6},
  {1, 12},
  {1, 6},
  {1, 8},
  {2, 6},
  {1, 11},
  {1, 8},
  {1, 2},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 6},
  {3, 2},
  {1, 15},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {3, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {6, 8},
  {1, 6},
  {1, 3},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {6, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {1, 10},
  {1, 3},
  {1, 10},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 5},
  {4, 4},
  {1, 3},
  {1, 5},
  {10, 4},
  {1, 1},
  {2, 4},
  {3, 1},
  {2, 4},
  {1, 7},
  {5, 4},
  {1, 7},
  {1, 4},
  {1, 1},
  {1, 7},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 4},
  {2, 7},
  {1, 4},
  {8, 7},
  {1, 9},
  {4, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {9, 9},
  {1, 7},
  {4, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {2, 2},
  {3, 11},
  {1, 2},
  {1, 11},
  {1, 6},
  {1, 16},
  {5, 13},
  {1, 18},
  {1, 16},
  {3, 13},
  {2, 14},
  {1, 16},
  {3, 14},
  {1, 18},
  {2, 16},
  {1, 30},
  {1, 31},
  {3, 19},
  {1, 20},
  {1, 24},
  {1, 25},
  {1, 22},
  {2, 26},
  {1, 32},
  {2, 23},
  {1, 14},
  {1, 13},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 8},
  {1, 5},
  {1, 12},
  {1, 21},
  {1, 30},
  {1, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 20},
  {1, 29},
  {1, 25},
  {2, 27},
  {1, 26},
  {3, 23},
  {2, 14},
  {1, 16},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 15},
  {2, 8},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 16},
  {1, 21},
  {1, 13},
  {1, 15},
  {1, 8},
  {1, 16},
  {3, 12},
  {1, 15},
  {1, 21},
  {1, 12},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 15},
  {1, 10},
  {2, 8},
  {1, 15},
  {1, 4},
  {2, 5},
  {1, 28},
  {1, 11},
  {1, 6},
  {3, 11},
  {1, 12},
  {1, 3},
  {1, 11},
  {1, 15},
  {5, 7},
  {1, 15},
  {1, 9},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 15},
  {1, 11},
  {1, 15},
  {3, 11},
  {1, 16},
  {1, 21},
  {1, 11},
  {2, 12},
  {2, 11},
  {1, 12},
  {1, 4},
  {1, 8},
  {2, 15},
  {1, 3},
  {1, 12},
  {1, 15},
  {2, 12},
  {1, 11},
  {2, 16},
  {1, 14},
  {2, 23},
  {2, 26},
  {1, 27},
  {2, 29},
  {2, 17},
  {3, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 15},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 13},
  {2, 14},
  {2, 23},
  {2, 32},
  {2, 27},
  {1, 17},
  {1, 20},
  {4, 19},
  {1, 30},
  {1, 21},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 13},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {2, 11},
  {4, 6},
  {1, 2},
  {4, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {9, 6},
  {1, 12},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {8, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {10, 8},
  {1, 2},
  {3, 8},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {3, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 5},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {5, 4},
  {1, 5},
  {1, 3},
  {7, 4},
  {1, 3},
  {3, 4},
  {1, 1},
  {3, 4},
  {1, 1},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {9, 7},
  {2, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {6, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {1, 2},
  {5, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 18},
  {1, 14},
  {2, 16},
  {1, 23},
  {1, 31},
  {1, 20},
  {3, 19},
  {2, 17},
  {2, 27},
  {3, 26},
  {2, 23},
  {1, 14},
  {1, 18},
  {1, 11},
  {1, 15},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 13},
  {1, 21},
  {1, 28},
  {1, 31},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 24},
  {1, 25},
  {1, 29},
  {2, 27},
  {1, 32},
  {3, 23},
  {1, 14},
  {4, 16},
  {1, 11},
  {1, 12},
  {1, 15},
  {1, 12},
  {1, 16},
  {1, 15},
  {1, 14},
  {1, 28},
  {1, 21},
  {1, 12},
  {1, 8},
  {1, 12},
  {1, 11},
  {3, 12},
  {1, 15},
  {1, 21},
  {3, 3},
  {1, 11},
  {3, 8},
  {1, 4},
  {1, 3},
  {2, 12},
  {1, 15},
  {5, 12},
  {1, 3},
  {1, 8},
  {1, 3},
  {2, 21},
  {1, 15},
  {1, 4},
  {1, 9},
  {1, 15},
  {1, 28},
  {1, 15},
  {1, 4},
  {1, 12},
  {1, 5},
  {1, 12},
  {1, 8},
  {2, 11},
  {1, 16},
  {2, 11},
  {1, 14},
  {2, 12},
  {2, 15},
  {3, 12},
  {1, 15},
  {2, 12},
  {4, 16},
  {1, 18},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 32},
  {2, 27},
  {2, 29},
  {1, 17},
  {2, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 30},
  {1, 18},
  {1, 15},
  {1, 1},
  {2, 15},
  {1, 2},
  {1, 13},
  {2, 18},
  {1, 14},
  {2, 23},
  {3, 32},
  {1, 27},
  {1, 29},
  {1, 20},
  {4, 19},
  {1, 31},
  {1, 1},
  {1, 7},
  {8, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 13},
  {4, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 12},
  {1, 16},
  {1, 8},
  {1, 11},
  {1, 12},
  {2, 6},
  {1, 11},
  {1, 8},
  {2, 6},
  {1, 2},
  {1, 6},
  {6, 2},
  {1, 9},
  {9, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 10},
  {1, 9},
  {2, 10},
  {1, 9},
  {1, 8},
  {2, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 8},
  {4, 10},
  {1, 3},
  {1, 7},
  {2, 3},
  {2, 7},
  {1, 3},
  {4, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {3, 3},
  {1, 5},
  {3, 3},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 5},
  {3, 4},
  {1, 3},
  {1, 5},
  {6, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 15},
  {1, 4},
  {1, 1},
  {3, 4},
  {1, 1},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 1},
  {1, 7},
  {2, 4},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 3},
  {3, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {5, 9},
  {1, 10},
  {9, 9},
  {1, 7},
  {5, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 13},
  {1, 6},
  {3, 13},
  {1, 14},
  {2, 13},
  {1, 14},
  {1, 18},
  {6, 14},
  {2, 16},
  {1, 15},
  {1, 21},
  {1, 31},
  {1, 20},
  {3, 19},
  {1, 17},
  {1, 29},
  {1, 27},
  {1, 22},
  {3, 26},
  {2, 23},
  {2, 14},
  {2, 13},
  {1, 6},
  {2, 16},
  {1, 12},
  {1, 16},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 17},
  {1, 19},
  {4, 17},
  {2, 29},
  {2, 27},
  {1, 26},
  {2, 32},
  {2, 23},
  {2, 14},
  {5, 16},
  {1, 21},
  {1, 23},
  {1, 16},
  {1, 11},
  {1, 8},
  {1, 16},
  {1, 12},
  {1, 11},
  {2, 12},
  {1, 4},
  {1, 15},
  {1, 21},
  {1, 15},
  {1, 2},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 15},
  {1, 8},
  {1, 3},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 3},
  {1, 12},
  {2, 8},
  {1, 3},
  {2, 15},
  {1, 28},
  {3, 21},
  {1, 15},
  {1, 28},
  {1, 11},
  {2, 8},
  {1, 3},
  {1, 8},
  {2, 12},
  {1, 8},
  {2, 12},
  {1, 15},
  {2, 12},
  {1, 21},
  {1, 11},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 12},
  {2, 16},
  {1, 21},
  {2, 14},
  {1, 21},
  {1, 23},
  {2, 32},
  {2, 27},
  {2, 29},
  {3, 17},
  {1, 19},
  {2, 20},
  {1, 31},
  {1, 28},
  {1, 14},
  {2, 13},
  {1, 6},
  {2, 11},
  {2, 18},
  {2, 14},
  {3, 23},
  {2, 26},
  {2, 29},
  {1, 17},
  {4, 19},
  {1, 31},
  {1, 28},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 23},
  {1, 16},
  {1, 23},
  {4, 14},
  {2, 16},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {1, 6},
  {1, 11},
  {2, 2},
  {8, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {2, 6},
  {1, 11},
  {4, 6},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {8, 2},
  {1, 8},
  {1, 15},
  {4, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {4, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {5, 10},
  {1, 9},
  {6, 10},
  {1, 3},
  {2, 10},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {8, 1},
  {2, 4},
  {1, 5},
  {11, 4},
  {3, 5},
  {1, 1},
  {2, 4},
  {1, 1},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {10, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {4, 9},
  {1, 7},
  {10, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {4, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {3, 2},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {2, 11},
  {4, 13},
  {1, 6},
  {1, 13},
  {1, 14},
  {1, 11},
  {2, 18},
  {2, 14},
  {1, 16},
  {1, 14},
  {5, 18},
  {1, 15},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 17},
  {1, 24},
  {2, 25},
  {4, 26},
  {2, 23},
  {3, 14},
  {3, 13},
  {1, 6},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 28},
  {1, 31},
  {2, 20},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 24},
  {2, 29},
  {3, 27},
  {2, 26},
  {3, 23},
  {4, 14},
  {1, 32},
  {1, 11},
  {2, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 15},
  {1, 12},
  {1, 5},
  {2, 12},
  {2, 21},
  {1, 2},
  {1, 8},
  {1, 11},
  {1, 28},
  {1, 30},
  {1, 15},
  {1, 21},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 8},
  {2, 15},
  {2, 11},
  {1, 8},
  {1, 12},
  {1, 16},
  {2, 28},
  {1, 21},
  {1, 8},
  {1, 16},
  {1, 21},
  {2, 11},
  {1, 8},
  {1, 9},
  {3, 15},
  {1, 8},
  {1, 15},
  {3, 12},
  {1, 21},
  {1, 16},
  {2, 12},
  {1, 16},
  {1, 21},
  {2, 16},
  {1, 14},
  {1, 23},
  {1, 32},
  {1, 28},
  {2, 32},
  {2, 27},
  {1, 29},
  {2, 17},
  {5, 20},
  {1, 29},
  {1, 28},
  {1, 7},
  {1, 3},
  {3, 16},
  {2, 13},
  {1, 16},
  {3, 14},
  {2, 23},
  {2, 32},
  {2, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 28},
  {1, 15},
  {1, 21},
  {2, 14},
  {1, 23},
  {3, 16},
  {1, 14},
  {3, 16},
  {1, 14},
  {2, 16},
  {2, 13},
  {1, 16},
  {2, 13},
  {2, 6},
  {1, 11},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {6, 6},
  {1, 11},
  {2, 6},
  {3, 12},
  {1, 6},
  {1, 16},
  {1, 12},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {6, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {4, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 10},
  {1, 9},
  {4, 10},
  {1, 9},
  {3, 10},
  {1, 8},
  {3, 10},
  {1, 9},
  {8, 10},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {1, 3},
  {6, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 5},
  {2, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {10, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {3, 7},
  {1, 4},
  {7, 7},
  {3, 9},
  {1, 10},
  {6, 9},
  {1, 10},
  {3, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {1, 2},
  {3, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {21, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 13},
  {1, 2},
  {1, 6},
  {1, 2},
  {4, 6},
  {2, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 13},
  {1, 18},
  {3, 13},
  {1, 16},
  {4, 14},
  {1, 18},
  {2, 14},
  {1, 18},
  {2, 15},
  {1, 21},
  {1, 28},
  {1, 31},
  {3, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 25},
  {1, 22},
  {3, 26},
  {3, 23},
  {3, 14},
  {1, 13},
  {1, 11},
  {1, 2},
  {2, 12},
  {1, 16},
  {1, 21},
  {1, 30},
  {1, 31},
  {1, 19},
  {1, 20},
  {2, 19},
  {1, 17},
  {1, 20},
  {1, 17},
  {2, 29},
  {1, 25},
  {2, 27},
  {4, 26},
  {4, 23},
  {2, 14},
  {2, 16},
  {1, 12},
  {2, 11},
  {1, 9},
  {1, 11},
  {1, 12},
  {1, 16},
  {1, 28},
  {2, 12},
  {1, 5},
  {1, 8},
  {1, 15},
  {1, 12},
  {1, 15},
  {2, 21},
  {1, 8},
  {1, 12},
  {1, 3},
  {1, 28},
  {1, 21},
  {1, 11},
  {1, 16},
  {1, 21},
  {3, 28},
  {2, 15},
  {1, 6},
  {1, 11},
  {1, 14},
  {1, 11},
  {1, 13},
  {1, 11},
  {1, 15},
  {2, 11},
  {1, 16},
  {1, 14},
  {1, 21},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 23},
  {1, 21},
  {1, 23},
  {1, 32},
  {3, 27},
  {3, 29},
  {2, 17},
  {1, 20},
  {2, 19},
  {2, 20},
  {1, 31},
  {1, 28},
  {1, 15},
  {2, 11},
  {1, 6},
  {1, 12},
  {3, 16},
  {3, 14},
  {3, 23},
  {2, 26},
  {2, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 28},
  {1, 15},
  {1, 21},
  {3, 14},
  {2, 16},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 13},
  {1, 16},
  {1, 6},
  {1, 13},
  {3, 6},
  {1, 13},
  {2, 6},
  {1, 11},
  {9, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {6, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {4, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 10},
  {1, 8},
  {1, 10},
  {3, 7},
  {3, 9},
  {1, 7},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {8, 10},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {4, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {3, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {3, 1},
  {160, 0},
  {160, 0},
  {7, 1},
  {1, 4},
  {4, 1},
  {1, 5},
  {1, 1},
  {4, 4},
  {1, 5},
  {9, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {3, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {9, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {3, 9},
  {2, 10},
  {5, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 6},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 9},
  {13, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 11},
  {1, 6},
  {5, 11},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 13},
  {1, 16},
  {4, 14},
  {1, 16},
  {3, 14},
  {1, 21},
  {1, 18},
  {2, 21},
  {1, 28},
  {1, 31},
  {3, 19},
  {2, 17},
  {1, 29},
  {1, 25},
  {5, 26},
  {1, 23},
  {3, 14},
  {2, 18},
  {4, 11},
  {1, 2},
  {2, 15},
  {1, 28},
  {1, 30},
  {1, 31},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 20},
  {1, 24},
  {2, 29},
  {1, 25},
  {4, 27},
  {1, 32},
  {1, 26},
  {1, 32},
  {2, 23},
  {1, 21},
  {1, 14},
  {1, 21},
  {1, 14},
  {1, 18},
  {3, 14},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {4, 16},
  {1, 21},
  {1, 15},
  {1, 12},
  {1, 11},
  {1, 21},
  {1, 11},
  {1, 16},
  {1, 11},
  {1, 16},
  {1, 21},
  {2, 16},
  {1, 18},
  {2, 21},
  {1, 14},
  {1, 18},
  {1, 21},
  {1, 14},
  {2, 18},
  {1, 16},
  {1, 18},
  {1, 21},
  {1, 23},
  {1, 21},
  {4, 23},
  {2, 32},
  {2, 30},
  {1, 27},
  {2, 29},
  {1, 31},
  {4, 20},
  {2, 19},
  {1, 17},
  {1, 20},
  {1, 31},
  {1, 30},
  {1, 23},
  {1, 16},
  {1, 14},
  {1, 11},
  {1, 2},
  {1, 6},
  {3, 11},
  {2, 18},
  {3, 23},
  {1, 26},
  {1, 23},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 28},
  {1, 9},
  {1, 15},
  {1, 21},
  {1, 18},
  {1, 14},
  {1, 16},
  {1, 23},
  {2, 16},
  {1, 23},
  {3, 16},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {5, 9},
  {1, 7},
  {1, 10},
  {2, 7},
  {3, 9},
  {3, 7},
  {2, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 3},
  {3, 10},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {6, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {12, 1},
  {1, 4},
  {2, 5},
  {11, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {5, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {7, 7},
  {3, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {3, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 9},
  {14, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {5, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {4, 13},
  {1, 16},
  {1, 18},
  {5, 13},
  {4, 14},
  {2, 18},
  {1, 14},
  {1, 18},
  {3, 21},
  {1, 28},
  {1, 31},
  {1, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 25},
  {1, 27},
  {4, 26},
  {2, 23},
  {2, 14},
  {2, 18},
  {3, 11},
  {1, 2},
  {1, 9},
  {1, 15},
  {1, 21},
  {1, 18},
  {1, 28},
  {1, 30},
  {1, 31},
  {2, 20},
  {2, 19},
  {5, 17},
  {2, 29},
  {1, 25},
  {4, 27},
  {3, 32},
  {1, 26},
  {12, 23},
  {1, 16},
  {1, 23},
  {1, 16},
  {1, 23},
  {1, 14},
  {2, 16},
  {1, 14},
  {2, 16},
  {1, 23},
  {2, 14},
  {3, 23},
  {1, 14},
  {4, 23},
  {1, 28},
  {3, 23},
  {5, 32},
  {2, 27},
  {1, 29},
  {1, 31},
  {1, 29},
  {4, 20},
  {1, 17},
  {2, 19},
  {2, 20},
  {1, 31},
  {1, 28},
  {4, 16},
  {1, 8},
  {2, 6},
  {2, 11},
  {2, 18},
  {3, 21},
  {2, 23},
  {2, 26},
  {1, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 28},
  {1, 21},
  {2, 14},
  {1, 16},
  {1, 14},
  {3, 16},
  {1, 23},
  {3, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {2, 13},
  {1, 16},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 13},
  {3, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {2, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {5, 8},
  {1, 9},
  {1, 7},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {3, 7},
  {1, 9},
  {6, 7},
  {2, 10},
  {1, 7},
  {8, 10},
  {1, 7},
  {1, 4},
  {1, 7},
  {5, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {5, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 5},
  {1, 12},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {7, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {14, 1},
  {11, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {4, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 1},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {4, 7},
  {1, 4},
  {7, 7},
  {7, 9},
  {1, 10},
  {5, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 8},
  {1, 2},
  {3, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 9},
  {1, 8},
  {14, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {2, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 2},
  {2, 11},
  {6, 13},
  {1, 18},
  {1, 16},
  {1, 13},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 18},
  {3, 14},
  {1, 16},
  {3, 14},
  {1, 21},
  {1, 28},
  {1, 31},
  {4, 19},
  {1, 17},
  {1, 24},
  {1, 29},
  {2, 27},
  {4, 26},
  {2, 23},
  {1, 14},
  {2, 18},
  {2, 11},
  {1, 2},
  {2, 9},
  {1, 2},
  {1, 16},
  {1, 13},
  {2, 21},
  {1, 28},
  {1, 30},
  {1, 31},
  {2, 20},
  {1, 19},
  {2, 20},
  {1, 19},
  {3, 17},
  {2, 24},
  {3, 29},
  {4, 27},
  {13, 26},
  {1, 23},
  {1, 26},
  {1, 23},
  {1, 26},
  {1, 23},
  {1, 26},
  {1, 23},
  {1, 26},
  {1, 23},
  {2, 26},
  {1, 23},
  {2, 26},
  {2, 32},
  {2, 27},
  {1, 32},
  {5, 27},
  {3, 29},
  {4, 20},
  {2, 19},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 31},
  {2, 28},
  {2, 5},
  {2, 12},
  {1, 16},
  {2, 12},
  {2, 6},
  {2, 13},
  {2, 14},
  {1, 21},
  {1, 23},
  {1, 26},
  {1, 32},
  {1, 26},
  {2, 27},
  {1, 29},
  {1, 17},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 28},
  {1, 15},
  {1, 11},
  {4, 14},
  {1, 16},
  {1, 14},
  {4, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 13},
  {1, 16},
  {1, 13},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {5, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {5, 7},
  {2, 10},
  {2, 7},
  {4, 10},
  {1, 3},
  {5, 10},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {4, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {3, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 1},
  {160, 0},
  {160, 0},
  {13, 1},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {8, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 1},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 4},
  {8, 7},
  {3, 9},
  {1, 10},
  {3, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {6, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {10, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {1, 13},
  {2, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 6},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {8, 13},
  {1, 18},
  {1, 13},
  {1, 18},
  {2, 14},
  {1, 16},
  {5, 14},
  {1, 18},
  {3, 21},
  {1, 28},
  {1, 31},
  {1, 20},
  {3, 19},
  {2, 17},
  {1, 29},
  {1, 25},
  {2, 22},
  {3, 26},
  {3, 23},
  {1, 21},
  {2, 18},
  {1, 11},
  {4, 2},
  {1, 7},
  {1, 1},
  {1, 21},
  {1, 18},
  {1, 21},
  {1, 18},
  {1, 32},
  {2, 31},
  {2, 20},
  {7, 19},
  {1, 20},
  {4, 17},
  {1, 29},
  {1, 24},
  {2, 29},
  {1, 25},
  {2, 29},
  {1, 25},
  {1, 29},
  {2, 27},
  {1, 22},
  {1, 27},
  {2, 22},
  {1, 27},
  {1, 26},
  {1, 27},
  {1, 22},
  {5, 27},
  {4, 29},
  {1, 31},
  {2, 29},
  {1, 17},
  {1, 31},
  {1, 17},
  {1, 20},
  {1, 17},
  {2, 20},
  {6, 19},
  {2, 20},
  {1, 31},
  {1, 30},
  {1, 28},
  {2, 18},
  {2, 11},
  {1, 2},
  {1, 16},
  {2, 12},
  {2, 13},
  {3, 18},
  {1, 14},
  {2, 23},
  {1, 26},
  {1, 23},
  {2, 26},
  {1, 22},
  {1, 29},
  {1, 24},
  {1, 17},
  {5, 19},
  {1, 31},
  {1, 28},
  {1, 15},
  {4, 14},
  {1, 16},
  {1, 14},
  {2, 16},
  {1, 23},
  {3, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 13},
  {1, 16},
  {2, 13},
  {1, 6},
  {1, 11},
  {1, 13},
  {7, 6},
  {1, 2},
  {4, 6},
  {1, 2},
  {1, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {1, 2},
  {3, 6},
  {3, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 2},
  {2, 8},
  {1, 6},
  {6, 8},
  {1, 2},
  {1, 7},
  {3, 9},
  {2, 10},
  {1, 9},
  {9, 7},
  {2, 10},
  {1, 7},
  {2, 3},
  {1, 10},
  {1, 3},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {2, 7},
  {4, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {6, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 12},
  {1, 5},
  {2, 3},
  {1, 5},
  {9, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {1, 1},
  {1, 5},
  {13, 1},
  {2, 4},
  {1, 5},
  {6, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {5, 4},
  {1, 7},
  {2, 4},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {11, 7},
  {1, 9},
  {1, 10},
  {8, 9},
  {1, 10},
  {4, 9},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 9},
  {3, 2},
  {1, 9},
  {1, 11},
  {1, 9},
  {1, 15},
  {1, 9},
  {6, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {3, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {2, 11},
  {1, 6},
  {2, 11},
  {1, 2},
  {12, 13},
  {5, 14},
  {2, 18},
  {1, 14},
  {3, 18},
  {1, 21},
  {1, 28},
  {1, 31},
  {1, 20},
  {2, 19},
  {1, 20},
  {2, 17},
  {1, 24},
  {4, 27},
  {2, 26},
  {3, 23},
  {1, 14},
  {1, 21},
  {1, 14},
  {1, 18},
  {3, 13},
  {1, 11},
  {1, 2},
  {2, 13},
  {1, 18},
  {1, 7},
  {1, 11},
  {1, 18},
  {1, 15},
  {1, 21},
  {2, 28},
  {2, 31},
  {2, 20},
  {6, 19},
  {4, 20},
  {1, 17},
  {1, 20},
  {1, 17},
  {1, 20},
  {3, 17},
  {1, 24},
  {1, 17},
  {4, 24},
  {1, 17},
  {1, 24},
  {1, 17},
  {1, 24},
  {1, 20},
  {1, 17},
  {3, 20},
  {12, 19},
  {3, 20},
  {1, 31},
  {2, 28},
  {1, 21},
  {1, 18},
  {1, 7},
  {1, 15},
  {1, 8},
  {1, 6},
  {1, 13},
  {1, 11},
  {3, 13},
  {1, 18},
  {1, 16},
  {2, 14},
  {1, 18},
  {4, 23},
  {3, 26},
  {1, 27},
  {1, 25},
  {2, 24},
  {1, 20},
  {3, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 15},
  {1, 21},
  {1, 13},
  {1, 23},
  {1, 16},
  {5, 14},
  {5, 16},
  {1, 14},
  {1, 16},
  {5, 13},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {8, 6},
  {1, 2},
  {1, 11},
  {5, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {2, 8},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {3, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {2, 10},
  {7, 7},
  {1, 10},
  {2, 7},
  {3, 10},
  {1, 3},
  {2, 10},
  {1, 3},
  {1, 8},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 7},
  {5, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 5},
  {2, 3},
  {1, 4},
  {1, 3},
  {8, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {14, 1},
  {1, 5},
  {3, 4},
  {1, 5},
  {8, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {2, 4},
  {1, 7},
  {2, 4},
  {1, 1},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {8, 7},
  {4, 9},
  {1, 10},
  {1, 8},
  {2, 9},
  {1, 10},
  {4, 9},
  {1, 10},
  {3, 9},
  {1, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 9},
  {1, 2},
  {2, 9},
  {1, 2},
  {2, 9},
  {7, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 6},
  {1, 11},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {3, 2},
  {2, 11},
  {1, 6},
  {1, 13},
  {3, 11},
  {3, 13},
  {1, 14},
  {3, 13},
  {3, 18},
  {3, 14},
  {1, 16},
  {1, 14},
  {2, 18},
  {1, 9},
  {1, 15},
  {1, 1},
  {2, 28},
  {1, 20},
  {4, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 25},
  {2, 27},
  {1, 32},
  {2, 26},
  {1, 32},
  {3, 23},
  {5, 14},
  {1, 16},
  {2, 13},
  {1, 2},
  {2, 15},
  {1, 1},
  {2, 15},
  {2, 5},
  {1, 1},
  {1, 15},
  {1, 21},
  {2, 28},
  {3, 31},
  {1, 20},
  {1, 19},
  {1, 20},
  {6, 19},
  {1, 20},
  {1, 19},
  {2, 20},
  {1, 17},
  {1, 19},
  {3, 20},
  {1, 17},
  {2, 20},
  {9, 19},
  {1, 20},
  {1, 19},
  {1, 20},
  {1, 31},
  {1, 20},
  {2, 31},
  {1, 30},
  {2, 28},
  {1, 15},
  {1, 5},
  {2, 15},
  {1, 11},
  {1, 15},
  {1, 2},
  {2, 6},
  {1, 13},
  {1, 11},
  {1, 13},
  {2, 18},
  {4, 14},
  {4, 23},
  {2, 26},
  {2, 27},
  {2, 29},
  {1, 17},
  {5, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 15},
  {1, 21},
  {1, 18},
  {1, 14},
  {2, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {3, 13},
  {1, 16},
  {3, 13},
  {1, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {6, 6},
  {1, 11},
  {3, 6},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 13},
  {1, 6},
  {1, 2},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 8},
  {1, 11},
  {1, 2},
  {1, 12},
  {1, 11},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {5, 8},
  {1, 2},
  {2, 8},
  {2, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {9, 7},
  {3, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {5, 10},
  {2, 3},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {6, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {4, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {5, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 1},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {2, 1},
  {160, 0},
  {160, 0},
  {1, 5},
  {1, 1},
  {1, 5},
  {13, 1},
  {14, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {2, 4},
  {1, 1},
  {2, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {2, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {2, 7},
  {1, 4},
  {7, 7},
  {1, 10},
  {3, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {1, 8},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {2, 9},
  {1, 6},
  {4, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {6, 2},
  {1, 9},
  {5, 2},
  {1, 11},
  {1, 9},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {5, 13},
  {1, 18},
  {3, 13},
  {1, 16},
  {1, 14},
  {1, 16},
  {3, 14},
  {1, 16},
  {2, 18},
  {1, 14},
  {2, 18},
  {1, 21},
  {1, 18},
  {1, 28},
  {1, 31},
  {5, 19},
  {1, 20},
  {1, 17},
  {2, 29},
  {2, 27},
  {4, 26},
  {5, 23},
  {3, 14},
  {1, 18},
  {1, 13},
  {2, 11},
  {1, 2},
  {1, 7},
  {1, 6},
  {2, 2},
  {4, 15},
  {1, 1},
  {1, 15},
  {2, 21},
  {1, 18},
  {3, 28},
  {1, 30},
  {5, 31},
  {1, 20},
  {3, 31},
  {6, 20},
  {7, 31},
  {1, 28},
  {1, 30},
  {1, 28},
  {3, 21},
  {1, 15},
  {1, 5},
  {5, 1},
  {1, 15},
  {1, 9},
  {1, 6},
  {1, 2},
  {2, 11},
  {1, 13},
  {4, 18},
  {1, 21},
  {3, 23},
  {4, 32},
  {1, 26},
  {2, 27},
  {2, 29},
  {2, 20},
  {4, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {2, 4},
  {1, 6},
  {1, 18},
  {1, 14},
  {1, 18},
  {6, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {1, 13},
  {1, 16},
  {1, 18},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {3, 6},
  {1, 11},
  {1, 6},
  {1, 13},
  {8, 6},
  {1, 2},
  {6, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 6},
  {2, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {2, 8},
  {1, 2},
  {1, 9},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 9},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 7},
  {1, 10},
  {1, 9},
  {5, 7},
  {1, 10},
  {1, 7},
  {3, 10},
  {1, 8},
  {5, 3},
  {1, 10},
  {3, 3},
  {5, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {2, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {1, 5},
  {1, 3},
  {2, 4},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {160, 0},
  {160, 0},
  {1, 5},
  {13, 1},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {5, 4},
  {1, 5},
  {2, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {3, 4},
  {1, 1},
  {1, 7},
  {2, 4},
  {3, 1},
  {1, 4},
  {1, 3},
  {5, 4},
  {7, 3},
  {1, 4},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {9, 7},
  {2, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9},
  {2, 7},
  {13, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 2},
  {2, 9},
  {1, 2},
  {3, 9},
  {2, 2},
  {1, 8},
  {5, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 9},
  {4, 2},
  {1, 9},
  {6, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 13},
  {2, 11},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {4, 13},
  {1, 18},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {7, 14},
  {3, 18},
  {1, 6},
  {1, 7},
  {2, 28},
  {1, 20},
  {5, 19},
  {1, 20},
  {1, 17},
  {1, 29},
  {1, 25},
  {2, 27},
  {4, 26},
  {1, 23},
  {1, 26},
  {3, 23},
  {2, 14},
  {3, 18},
  {3, 13},
  {1, 2},
  {2, 7},
  {1, 9},
  {1, 2},
  {1, 11},
  {1, 9},
  {1, 11},
  {1, 13},
  {3, 15},
  {3, 5},
  {1, 1},
  {1, 21},
  {3, 15},
  {1, 28},
  {1, 21},
  {1, 16},
  {1, 12},
  {3, 5},
  {1, 12},
  {1, 15},
  {1, 21},
  {2, 15},
  {3, 5},
  {3, 1},
  {1, 7},
  {1, 2},
  {2, 9},
  {1, 2},
  {1, 15},
  {1, 7},
  {2, 15},
  {2, 2},
  {1, 6},
  {1, 11},
  {1, 13},
  {1, 18},
  {1, 13},
  {1, 14},
  {2, 18},
  {1, 23},
  {1, 14},
  {1, 28},
  {2, 23},
  {3, 32},
  {2, 27},
  {3, 29},
  {2, 20},
  {5, 19},
  {1, 20},
  {1, 31},
  {1, 28},
  {1, 18},
  {10, 14},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 14},
  {4, 13},
  {1, 6},
  {6, 13},
  {2, 6},
  {1, 11},
  {1, 13},
  {1, 6},
  {1, 11},
  {18, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {2, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 8},
  {1, 11},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {3, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 9},
  {1, 8},
  {1, 2},
  {2, 8},
  {1, 6},
  {1, 2},
  {4, 8},
  {3, 9},
  {2, 7},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 9},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 10},
  {1, 7},
  {8, 10},
  {1, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {7, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 7},
  {2, 4},
  {1, 7},
  {1, 4},
  {1, 3},
  {1, 4},
  {3, 3},
  {1, 4},
  {1, 3},
  {1, 4},
  {1, 3},
  {1, 5},
  {2, 3},
  {9, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {3, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {2, 1},
  {1, 5},
  {3, 1},
  {1, 5},
  {8, 1},
  {16, 4},
  {1, 3},
  {2, 4},
  {2, 3},
  {3, 4},
  {2, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 1},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {5, 3},
  {1, 10},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {7, 7},
  {5, 9},
  {1, 7},
  {1, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {2, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {1, 9},
  {1, 10},
  {5, 9},
  {1, 7},
  {10, 9},
  {1, 2},
  {1, 9},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {12, 2},
  {1, 8},
  {5, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {2, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {1, 2},
  {1, 11},
  {2, 2},
  {1, 11},
  {4, 2},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {4, 13},
  {1, 16},
  {1, 18},
  {1, 16},
  {1, 14},
  {1, 16},
  {1, 18},
  {5, 14},
  {1, 18},
  {4, 14},
  {1, 18},
  {1, 21},
  {1, 1},
  {1, 28},
  {1, 30},
  {1, 20},
  {5, 19},
  {2, 17},
  {1, 29},
  {1, 24},
  {3, 27},
  {4, 26},
  {1, 23},
  {1, 26},
  {3, 23},
  {5, 14},
  {1, 13},
  {1, 18},
  {1, 11},
  {1, 18},
  {1, 11},
  {1, 18},
  {2, 11},
  {1, 13},
  {3, 11},
  {1, 13},
  {1, 11},
  {3, 15},
  {1, 2},
  {1, 11},
  {2, 6},
  {1, 13},
  {1, 6},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 9},
  {1, 11},
  {1, 9},
  {1, 2},
  {7, 11},
  {6, 13},
  {1, 11},
  {1, 13},
  {2, 18},
  {3, 14},
  {1, 23},
  {1, 21},
  {3, 23},
  {1, 32},
  {2, 26},
  {1, 32},
  {2, 27},
  {2, 29},
  {2, 20},
  {6, 19},
  {2, 31},
  {1, 18},
  {2, 5},
  {1, 16},
  {4, 14},
  {1, 23},
  {1, 16},
  {3, 14},
  {1, 16},
  {2, 14},
  {1, 16},
  {1, 14},
  {2, 13},
  {1, 14},
  {1, 11},
  {2, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 6},
  {1, 13},
  {1, 11},
  {4, 6},
  {1, 13},
  {1, 6},
  {1, 11},
  {9, 6},
  {1, 12},
  {1, 6},
  {1, 12},
  {4, 6},
  {3, 2},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 11},
  {1, 12},
  {1, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 6},
  {4, 2},
  {1, 8},
  {3, 2},
  {2, 8},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {2, 2},
  {1, 6},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {1, 8},
  {1, 2},
  {4, 8},
  {1, 2},
  {2, 8},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 9},
  {1, 8},
  {1, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {2, 7},
  {1, 9},
  {2, 7},
  {1, 10},
  {1, 7},
  {1, 10},
  {1, 7},
  {7, 10},
  {1, 3},
  {1, 8},
  {2, 10},
  {1, 3},
  {1, 10},
  {2, 3},
  {1, 8},
  {4, 3},
  {1, 4},
  {3, 3},
  {4, 4},
  {1, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {2, 3},
  {1, 4},
  {1, 3},
  {2, 4},
  {1, 3},
  {12, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {1, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {1, 4},
  {1, 1},
  {160, 0},
  {160, 0},
  {3, 1},
  {1, 5},
  {10, 1},
  {1, 5},
  {4, 4},
  {1, 5},
  {1, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {2, 4},
  {1, 5},
  {3, 4},
  {2, 3},
  {3, 4},
  {1, 7},
  {1, 1},
  {1, 7},
  {6, 1},
  {6, 4},
  {2, 3},
  {1, 10},
  {1, 3},
  {1, 10},
  {3, 3},
  {1, 4},
  {2, 7},
  {1, 3},
  {1, 7},
  {1, 4},
  {1, 7},
  {1, 3},
  {8, 7},
  {1, 9},
  {1, 7},
  {1, 9},
  {1, 7},
  {3, 9},
  {2, 10},
  {2, 9},
  {1, 10},
  {7, 9},
  {1, 7},
  {3, 9},
  {1, 7},
  {2, 9},
  {1, 7},
  {1, 9}