/****************************************************************************
 * arch/arm/src/stm32/hardware/stm32f20xxx_pinmap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_STM32_HARDWARE_STM32F20XXX_PINMAP_H
#define __ARCH_ARM_SRC_STM32_HARDWARE_STM32F20XXX_PINMAP_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include "stm32_gpio.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Alternate Pin Functions.  All members of the STM32F20xxx family share the
 * same pin multiplexing (although they may differ in the pins physically
 * available).
 *
 * Alternative pin selections are provided with a numeric suffix like _1, _2,
 * etc. Drivers, however, will use the pin selection without the numeric
 * suffix. Additional definitions are required in the board.h file.  For
 * example, if CAN1_RX connects via PA11 on some board, then the following
 * definitions should appear in the board.h header file for that board:
 *
 * #define GPIO_CAN1_RX GPIO_CAN1_RX_1
 *
 * The driver will then automatically configure PA11 as the CAN1 RX pin.
 */

/* WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
 * Additional effort is required to select specific GPIO options such as
 * frequency, open-drain/push-pull, and pull-up/down!  Just the basics are
 * defined for most pins in this file.
 */

/* ADC */

#define GPIO_ADC1_IN0_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ADC1_IN1_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ADC1_IN2_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ADC1_IN3_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ADC1_IN4_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN4)
#define GPIO_ADC1_IN5_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN5)
#define GPIO_ADC1_IN6_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN6)
#define GPIO_ADC1_IN7_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ADC1_IN8_0       (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN0)
#define GPIO_ADC1_IN9_0       (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN1)
#define GPIO_ADC1_IN10_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN0)
#define GPIO_ADC1_IN11_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ADC1_IN12_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ADC1_IN13_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ADC1_IN14_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ADC1_IN15_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN5)

#define GPIO_ADC2_IN0_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ADC2_IN1_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ADC2_IN2_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ADC2_IN3_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ADC2_IN4_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN4)
#define GPIO_ADC2_IN5_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN5)
#define GPIO_ADC2_IN6_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN6)
#define GPIO_ADC2_IN7_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ADC2_IN8_0       (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN0)
#define GPIO_ADC2_IN9_0       (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN1)
#define GPIO_ADC2_IN10_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN0)
#define GPIO_ADC2_IN11_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ADC2_IN12_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ADC2_IN13_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ADC2_IN14_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ADC2_IN15_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN5)

#define GPIO_ADC3_IN0_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ADC3_IN1_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ADC3_IN2_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ADC3_IN3_0       (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ADC3_IN4_0       (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN6)
#define GPIO_ADC3_IN5_0       (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN7)
#define GPIO_ADC3_IN6_0       (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN8)
#define GPIO_ADC3_IN7_0       (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN9)
#define GPIO_ADC3_IN8_0       (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN10)
#define GPIO_ADC3_IN9_0       (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN3)
#define GPIO_ADC3_IN10_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN0)
#define GPIO_ADC3_IN11_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ADC3_IN12_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ADC3_IN13_0      (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ADC3_IN14_0      (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN4)
#define GPIO_ADC3_IN15_0      (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN5)

/* CAN */

#define GPIO_CAN1_RX_1        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)
#define GPIO_CAN1_RX_2        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_CAN1_RX_3        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN0)
#define GPIO_CAN1_RX_4        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN9)
#define GPIO_CAN1_TX_1        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN12)
#define GPIO_CAN1_TX_2        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_CAN1_TX_3        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN1)
#define GPIO_CAN1_TX_4        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN13)

#define GPIO_CAN2_RX_1        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_CAN2_RX_2        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_CAN2_TX_1        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#define GPIO_CAN2_TX_2        (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)

/* DAC -" Once the DAC channelx is enabled, the corresponding GPIO pin
 * (PA4 or PA5) is automatically connected to the analog converter output
 * (DAC_OUTx). In order to avoid parasitic consumption, the PA4 or PA5 pin
 * should first be configured to analog (AIN)".
 */

#define GPIO_DAC1_OUT1_0      (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN4)
#define GPIO_DAC1_OUT2_0      (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN5)

/* Digital Camera Interface (DCMI) */

#define GPIO_DCMI_D0_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN9)
#define GPIO_DCMI_D0_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN6)
#define GPIO_DCMI_D0_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN9)
#define GPIO_DCMI_D1_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN10)
#define GPIO_DCMI_D1_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN7)
#define GPIO_DCMI_D1_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN10)
#define GPIO_DCMI_D2_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN8)
#define GPIO_DCMI_D2_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN0)
#define GPIO_DCMI_D2_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN11)
#define GPIO_DCMI_D3_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN9)
#define GPIO_DCMI_D3_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN1)
#define GPIO_DCMI_D3_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN12)
#define GPIO_DCMI_D4_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN11)
#define GPIO_DCMI_D4_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN4)
#define GPIO_DCMI_D4_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN14)
#define GPIO_DCMI_D5_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN6)
#define GPIO_DCMI_D5_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN4)
#define GPIO_DCMI_D6_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN8)
#define GPIO_DCMI_D6_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN5)
#define GPIO_DCMI_D6_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN6)
#define GPIO_DCMI_D7_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN9)
#define GPIO_DCMI_D7_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN6)
#define GPIO_DCMI_D7_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN7)
#define GPIO_DCMI_D8_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN10)
#define GPIO_DCMI_D8_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN1)
#define GPIO_DCMI_D9_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN12)
#define GPIO_DCMI_D9_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN2)
#define GPIO_DCMI_D10_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN5)
#define GPIO_DCMI_D10_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN3)
#define GPIO_DCMI_D11_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTD|GPIO_PIN2)
#define GPIO_DCMI_D11_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN15)
#define GPIO_DCMI_D12_0       (GPIO_ALT|GPIO_AF13|GPIO_PORTF|GPIO_PIN11)
#define GPIO_DCMI_D13_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN15)
#define GPIO_DCMI_D13_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN0)
#define GPIO_DCMI_HSYNC_1     (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN4)
#define GPIO_DCMI_HSYNC_2     (GPIO_ALT|GPIO_AF13|GPIO_PORTH|GPIO_PIN8)
#define GPIO_DCMI_PIXCK_0     (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN6)
#define GPIO_DCMI_VSYNC_1     (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN7)
#define GPIO_DCMI_VSYNC_2     (GPIO_ALT|GPIO_AF13|GPIO_PORTI|GPIO_PIN5)

/* Clocks outputs */

#define GPIO_MCO1_0           (GPIO_ALT|GPIO_AF0|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_MCO2_0           (GPIO_ALT|GPIO_AF0|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)

/* Ethernet MAC */

#define GPIO_ETH_MDC_0          (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ETH_MDIO_0         (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ETH_MII_COL_1      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ETH_MII_COL_2      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN3)
#define GPIO_ETH_MII_CRS_1      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ETH_MII_CRS_2      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN2)
#define GPIO_ETH_MII_RXD0_0     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ETH_MII_RXD1_0     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#define GPIO_ETH_MII_RXD2_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#define GPIO_ETH_MII_RXD2_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)
#define GPIO_ETH_MII_RXD3_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)
#define GPIO_ETH_MII_RXD3_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN7)
#define GPIO_ETH_MII_RX_CLK_0   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ETH_MII_RX_DV_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ETH_MII_RX_ER_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_ETH_MII_RX_ER_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN10)
#define GPIO_ETH_MII_TXD0_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_ETH_MII_TXD0_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN13)
#define GPIO_ETH_MII_TXD1_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#define GPIO_ETH_MII_TXD1_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)
#define GPIO_ETH_MII_TXD2_0     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ETH_MII_TXD3_1     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_ETH_MII_TXD3_2     (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN2)
#define GPIO_ETH_MII_TX_CLK_0   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ETH_MII_TX_EN_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_ETH_MII_TX_EN_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)
#define GPIO_ETH_PPS_OUT_1      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_ETH_PPS_OUT_2      (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN8)
#define GPIO_ETH_RMII_CRS_DV_0  (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ETH_RMII_REF_CLK_0 (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ETH_RMII_RXD0_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ETH_RMII_RXD1_0    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#define GPIO_ETH_RMII_TXD0_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_ETH_RMII_TXD0_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN13)
#define GPIO_ETH_RMII_TXD1_1    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#define GPIO_ETH_RMII_TXD1_2    (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)
#define GPIO_ETH_RMII_TX_EN_1   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_ETH_RMII_TX_EN_2   (GPIO_ALT|GPIO_AF11|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)

/* Flexible Static Memory Controller (FSMC) */

#define GPIO_FSMC_A0_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN0)
#define GPIO_FSMC_A1_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN1)
#define GPIO_FSMC_A2_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN2)
#define GPIO_FSMC_A3_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN3)
#define GPIO_FSMC_A4_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN4)
#define GPIO_FSMC_A5_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN5)
#define GPIO_FSMC_A6_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN12)
#define GPIO_FSMC_A7_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN13)
#define GPIO_FSMC_A8_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN14)
#define GPIO_FSMC_A9_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN15)
#define GPIO_FSMC_A10_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN0)
#define GPIO_FSMC_A11_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN1)
#define GPIO_FSMC_A12_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN2)
#define GPIO_FSMC_A13_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN3)
#define GPIO_FSMC_A14_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN4)
#define GPIO_FSMC_A15_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN5)
#define GPIO_FSMC_A16_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN11)
#define GPIO_FSMC_A17_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN12)
#define GPIO_FSMC_A18_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN13)
#define GPIO_FSMC_A19_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN3)
#define GPIO_FSMC_A20_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN4)
#define GPIO_FSMC_A21_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN5)
#define GPIO_FSMC_A22_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN6)
#define GPIO_FSMC_A23_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN2)
#define GPIO_FSMC_A24_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN13)
#define GPIO_FSMC_A25_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN14)
#define GPIO_FSMC_NBL1_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN1)
#define GPIO_FSMC_CD_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN9)
#define GPIO_FSMC_CLK_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN3)
#define GPIO_FSMC_D0_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN14)
#define GPIO_FSMC_D1_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN15)
#define GPIO_FSMC_D2_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN0)
#define GPIO_FSMC_D3_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN1)
#define GPIO_FSMC_D4_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN7)
#define GPIO_FSMC_D5_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN8)
#define GPIO_FSMC_D6_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN9)
#define GPIO_FSMC_D7_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN10)
#define GPIO_FSMC_D8_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN11)
#define GPIO_FSMC_D9_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN12)
#define GPIO_FSMC_D10_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN13)
#define GPIO_FSMC_D11_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN14)
#define GPIO_FSMC_D12_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN15)
#define GPIO_FSMC_D13_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN8)
#define GPIO_FSMC_D14_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN9)
#define GPIO_FSMC_D15_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN10)
#define GPIO_FSMC_INT2_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN6)
#define GPIO_FSMC_INT3_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN7)
#define GPIO_FSMC_INTR_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN10)
#define GPIO_FSMC_NBL0_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTE|GPIO_PIN0)
#define GPIO_FSMC_NCE2_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN7)
#define GPIO_FSMC_NCE3_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN9)
#define GPIO_FSMC_NCE4_1      (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN10)
#define GPIO_FSMC_NCE4_2      (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN11)
#define GPIO_FSMC_NE1_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN7)
#define GPIO_FSMC_NE2_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN9)
#define GPIO_FSMC_NE3_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN10)
#define GPIO_FSMC_NE4_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTG|GPIO_PIN12)
#define GPIO_FSMC_NIORD_0     (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN6)
#define GPIO_FSMC_NIOWR_0     (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN8)
#define GPIO_FSMC_NL_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTB|GPIO_PIN7)
#define GPIO_FSMC_NOE_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN4)
#define GPIO_FSMC_NREG_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTF|GPIO_PIN7)
#define GPIO_FSMC_NWAIT_0     (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN6)
#define GPIO_FSMC_NWE_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTD|GPIO_PIN5)

/* I2C */

#define GPIO_I2C1_SCL_1       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN6)
#define GPIO_I2C1_SCL_2       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN8)
#define GPIO_I2C1_SDA_1       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN7)
#define GPIO_I2C1_SDA_2       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN9)
#define GPIO_I2C1_SMBA_0      (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)

#define GPIO_I2C2_SCL_1       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN10)
#define GPIO_I2C2_SCL_2       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN1)
#define GPIO_I2C2_SCL_3       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN4)
#define GPIO_I2C2_SDA_1       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN11)
#define GPIO_I2C2_SDA_2       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN0)
#define GPIO_I2C2_SDA_3       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN5)
#define GPIO_I2C2_SMBA_1      (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_I2C2_SMBA_2      (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN2)
#define GPIO_I2C2_SMBA_3      (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)

#define GPIO_I2C3_SCL_1       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN8)
#define GPIO_I2C3_SCL_2       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN7)
#define GPIO_I2C3_SDA_1       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN9)
#define GPIO_I2C3_SDA_2       (GPIO_ALT|GPIO_AF4|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN8)
#define GPIO_I2C3_SMBA_1      (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_I2C3_SMBA_2      (GPIO_ALT|GPIO_AF4|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN9)

/* I2S */

#define GPIO_I2S2_CK_1        (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN10)
#define GPIO_I2S2_CK_2        (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN13)
#define GPIO_I2S2_CK_3        (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN1)
#define GPIO_I2S2_MCK_0       (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN6)
#define GPIO_I2S2_SD_1        (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN15)
#define GPIO_I2S2_SD_2        (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN3)
#define GPIO_I2S2_SD_3        (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN3)
#define GPIO_I2S2_WS_1        (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN12)
#define GPIO_I2S2_WS_2        (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN6)
#define GPIO_I2S2_WS_3        (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN9)
#define GPIO_I2S2_WS_4        (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN0)

#define GPIO_I2S2EXT_SD_1     (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN14)
#define GPIO_I2S2EXT_SD_2     (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN2)
#define GPIO_I2S2EXT_SD_3     (GPIO_ALT|GPIO_AF6|GPIO_PORTI|GPIO_PIN2)

#define GPIO_I2S3_CK_1        (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN3)
#define GPIO_I2S3_CK_2        (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN10)
#define GPIO_I2S3_MCK_0       (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN7)
#define GPIO_I2S3_SD_1        (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN5)
#define GPIO_I2S3_SD_2        (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN12)
#define GPIO_I2S3_WS_1        (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN4)
#define GPIO_I2S3_WS_2        (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN15)

#define GPIO_I2S3EXT_SD_1     (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN11)
#define GPIO_I2S3EXT_SD_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN4)

#define GPIO_I2S_CKIN_0       (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN9)

/* JTAG */

#define GPIO_JTCK_SWCLK_0     (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN14)
#define GPIO_JTDI_0           (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN15)
#define GPIO_JTDO_0           (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN3)
#define GPIO_JTMS_SWDIO_0     (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN13)
#define GPIO_JTRST_0          (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN4)

/* OTG FS/HS (VBUS PA9 is not an alternate configuration) */

#define GPIO_OTGFS_DM_0       (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)
#define GPIO_OTGFS_DP_0       (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN12)
#define GPIO_OTGFS_ID_0       (GPIO_ALT|GPIO_PULLUP|GPIO_AF10|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN10)
#define GPIO_OTGFS_SCL_0      (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN8)
#define GPIO_OTGFS_SDA_0      (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN9)
#define GPIO_OTGFS_SOF_0      (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)

#define GPIO_OTGHS_DM_0       (GPIO_ALT|GPIO_FLOAT|GPIO_AF12|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN14)
#define GPIO_OTGHS_DP_0       (GPIO_ALT|GPIO_FLOAT|GPIO_AF12|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN15)
#define GPIO_OTGHS_ID_0       (GPIO_ALT|GPIO_AF12|GPIO_PORTB|GPIO_PIN12)
#define GPIO_OTGHS_INTN_1     (GPIO_ALT|GPIO_AF12|GPIO_PORTB|GPIO_PIN1)
#define GPIO_OTGFS_INTN_2     (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN6)
#define GPIO_OTGHS_SCL_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTB|GPIO_PIN10)
#define GPIO_OTGHS_SDA_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTB|GPIO_PIN11)
#define GPIO_OTGHS_SOF_0      (GPIO_ALT|GPIO_AF12|GPIO_PORTA|GPIO_PIN4)
#define GPIO_OTGHS_ULPI_CK_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTA|GPIO_PIN5)
#define GPIO_OTGHS_ULPI_D0_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTA|GPIO_PIN3)
#define GPIO_OTGHS_ULPI_D1_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN0)
#define GPIO_OTGHS_ULPI_D2_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN1)
#define GPIO_OTGHS_ULPI_D3_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN10)
#define GPIO_OTGHS_ULPI_D4_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN11)
#define GPIO_OTGHS_ULPI_D5_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN12)
#define GPIO_OTGHS_ULPI_D6_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN13)
#define GPIO_OTGHS_ULPI_D7_0  (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN5)
#define GPIO_OTGHS_ULPI_DIR_1 (GPIO_ALT|GPIO_AF10|GPIO_PORTC|GPIO_PIN2)
#define GPIO_OTGHS_ULPI_DIR_2 (GPIO_ALT|GPIO_AF10|GPIO_PORTI|GPIO_PIN11)
#define GPIO_OTGHS_ULPI_NXT_1 (GPIO_ALT|GPIO_AF10|GPIO_PORTC|GPIO_PIN3)
#define GPIO_OTGHS_ULPI_NXT_2 (GPIO_ALT|GPIO_AF10|GPIO_PORTH|GPIO_PIN4)
#define GPIO_OTGHS_ULPI_STP_0 (GPIO_ALT|GPIO_AF10|GPIO_PORTC|GPIO_PIN0)

/* RTC */

#define GPIO_RTC_50HZ_0       (GPIO_ALT|GPIO_AF0|GPIO_PORTC|GPIO_PIN15)

/* SDIO
 *
 * Note that the below configures GPIO_SPEED_50MHz I/O, that means for using
 * the SDIO that you must enable I/O Compensation via the configuration
 * option CONFIG_STM32_SYSCFG_IOCOMPENSATION=y.
 */

#define GPIO_SDIO_CK_0        (GPIO_ALT|GPIO_AF12|GPIO_PORTC|GPIO_PIN12)
#define GPIO_SDIO_CMD_0       (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN2)
#define GPIO_SDIO_D0_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_SDIO_D1_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_SDIO_D2_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_SDIO_D3_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_SDIO_D4_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_SDIO_D5_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_SDIO_D6_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_SDIO_D7_0        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)

/* SPI */

#define GPIO_SPI1_MISO_1      (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SPI1_MISO_2      (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI1_MOSI_1      (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN7)
#define GPIO_SPI1_MOSI_2      (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI1_NSS_1       (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI1_NSS_2       (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI1_SCK_1       (GPIO_ALT|GPIO_AF5|GPIO_PORTA|GPIO_PIN5)
#define GPIO_SPI1_SCK_2       (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN3)

#define GPIO_SPI2_MISO_1      (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN14)
#define GPIO_SPI2_MISO_2      (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN2)
#define GPIO_SPI2_MISO_3      (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN2)
#define GPIO_SPI2_MOSI_1      (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN15)
#define GPIO_SPI2_MOSI_2      (GPIO_ALT|GPIO_AF5|GPIO_PORTC|GPIO_PIN3)
#define GPIO_SPI2_MOSI_3      (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN3)
#define GPIO_SPI2_NSS_1       (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN12)
#define GPIO_SPI2_NSS_2       (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN9)
#define GPIO_SPI2_NSS_3       (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN0)
#define GPIO_SPI2_SCK_1       (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN10)
#define GPIO_SPI2_SCK_2       (GPIO_ALT|GPIO_AF5|GPIO_PORTB|GPIO_PIN13)
#define GPIO_SPI2_SCK_3       (GPIO_ALT|GPIO_AF5|GPIO_PORTI|GPIO_PIN1)

#define GPIO_SPI3_MISO_1      (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI3_MISO_2      (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN11)
#define GPIO_SPI3_MOSI_1      (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI3_MOSI_2      (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN12)
#define GPIO_SPI3_NSS_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI3_NSS_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI3_SCK_1       (GPIO_ALT|GPIO_AF6|GPIO_PORTB|GPIO_PIN3)
#define GPIO_SPI3_SCK_2       (GPIO_ALT|GPIO_AF6|GPIO_PORTC|GPIO_PIN10)

/* Timers */

#define GPIO_TIM1_BKIN_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM1_BKIN_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN12)
#define GPIO_TIM1_BKIN_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN15)
#define GPIO_TIM1_CH1N_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM1_CH1N_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN13)
#define GPIO_TIM1_CH1N_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN8)
#define GPIO_TIM1_CH1IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN8)
#define GPIO_TIM1_CH1IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN9)
#define GPIO_TIM1_CH1OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_TIM1_CH1OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN9)
#define GPIO_TIM1_CH2N_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM1_CH2N_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM1_CH2N_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN10)
#define GPIO_TIM1_CH2IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN9)
#define GPIO_TIM1_CH2IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN11)
#define GPIO_TIM1_CH2OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_TIM1_CH2OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN11)
#define GPIO_TIM1_CH3N_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM1_CH3N_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTC|GPIO_PIN15)
#define GPIO_TIM1_CH3N_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN12)
#define GPIO_TIM1_CH3IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN10)
#define GPIO_TIM1_CH3IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN13)
#define GPIO_TIM1_CH3OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN10)
#define GPIO_TIM1_CH3OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN13)
#define GPIO_TIM1_CH4IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN11)
#define GPIO_TIM1_CH4IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN14)
#define GPIO_TIM1_CH4OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)
#define GPIO_TIM1_CH4OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN14)
#define GPIO_TIM1_ETR_1       (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN12)
#define GPIO_TIM1_ETR_2       (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN7)

#define GPIO_TIM2_CH1IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM2_CH1IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN15)
#define GPIO_TIM2_CH1IN_3     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM2_CH1OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM2_CH1OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN15)
#define GPIO_TIM2_CH1OUT_3    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM2_CH2IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM2_CH2IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN3)
#define GPIO_TIM2_CH2OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM2_CH2OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN3)
#define GPIO_TIM2_CH3IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM2_CH3IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN10)
#define GPIO_TIM2_CH3OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM2_CH3OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_TIM2_CH4IN_1     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM2_CH4IN_2     (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN11)
#define GPIO_TIM2_CH4OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM2_CH4OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_TIM2_ETR_1       (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM2_ETR_2       (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN15)
#define GPIO_TIM2_ETR_3       (GPIO_ALT|GPIO_AF1|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN5)

#define GPIO_TIM3_CH1IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM3_CH1IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN4)
#define GPIO_TIM3_CH1IN_3     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM3_CH1OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM3_CH1OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN4)
#define GPIO_TIM3_CH1OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM3_CH2IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM3_CH2IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN5)
#define GPIO_TIM3_CH2IN_3     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM3_CH2OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM3_CH2OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_TIM3_CH2OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM3_CH3IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM3_CH3IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM3_CH3OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM3_CH3OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM3_CH4IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM3_CH4IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM3_CH4OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM3_CH4OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM3_ETR_0       (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN2)

#define GPIO_TIM4_CH1IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN6)
#define GPIO_TIM4_CH1IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN12)
#define GPIO_TIM4_CH1OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)
#define GPIO_TIM4_CH1OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN12)
#define GPIO_TIM4_CH2IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN7)
#define GPIO_TIM4_CH2IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN13)
#define GPIO_TIM4_CH2OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN7)
#define GPIO_TIM4_CH2OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN13)
#define GPIO_TIM4_CH3IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM4_CH3IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN14)
#define GPIO_TIM4_CH3OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM4_CH3OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN14)
#define GPIO_TIM4_CH4IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM4_CH4IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN15)
#define GPIO_TIM4_CH4OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM4_CH4OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN15)
#define GPIO_TIM4_ETR_0       (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN0)

#define GPIO_TIM5_CH1IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM5_CH1IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN10)
#define GPIO_TIM5_CH1OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM5_CH1OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN10)
#define GPIO_TIM5_CH2IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM5_CH2IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN11)
#define GPIO_TIM5_CH2OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM5_CH2OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN11)
#define GPIO_TIM5_CH3IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM5_CH3IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN12)
#define GPIO_TIM5_CH3OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM5_CH3OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN12)
#define GPIO_TIM5_CH4IN_1     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM5_CH4IN_2     (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTI|GPIO_PIN0)
#define GPIO_TIM5_CH4OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM5_CH4OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN0)
#define GPIO_TIM5_ETR_0       (GPIO_ALT|GPIO_AF2|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN10)

#define GPIO_TIM8_BKIN_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM8_BKIN_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTI|GPIO_PIN4)
#define GPIO_TIM8_CH1N_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM8_CH1N_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM8_CH1N_3      (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN13)
#define GPIO_TIM8_CH1IN_1     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM8_CH1IN_2     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTI|GPIO_PIN5)
#define GPIO_TIM8_CH1OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM8_CH1OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN5)
#define GPIO_TIM8_CH2IN_1     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM8_CH2IN_2     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTI|GPIO_PIN6)
#define GPIO_TIM8_CH2OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM8_CH2OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN6)
#define GPIO_TIM8_CH2N_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM8_CH2N_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM8_CH2N_3      (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN14)
#define GPIO_TIM8_CH3N_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM8_CH3N_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTC|GPIO_PIN15)
#define GPIO_TIM8_CH3N_3      (GPIO_ALT|GPIO_AF3|GPIO_PORTH|GPIO_PIN15)
#define GPIO_TIM8_CH3IN_1     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM8_CH3IN_2     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTI|GPIO_PIN7)
#define GPIO_TIM8_CH3OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM8_CH3OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN7)
#define GPIO_TIM8_CH4IN_1     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM8_CH4IN_2     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTI|GPIO_PIN2)
#define GPIO_TIM8_CH4OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM8_CH4OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN2)
#define GPIO_TIM8_ETR_1       (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM8_ETR_2       (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTI|GPIO_PIN3)

#define GPIO_TIM9_CH1IN_1     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM9_CH1IN_2     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM9_CH1OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM9_CH1OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM9_CH2IN_1     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM9_CH2IN_2     (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN6)
#define GPIO_TIM9_CH2OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM9_CH2OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN6)

#define GPIO_TIM10_CH1IN_1    (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM10_CH1IN_2    (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN6)
#define GPIO_TIM10_CH1OUT_1   (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM10_CH1OUT_2   (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN6)

#define GPIO_TIM11_CH1IN_1    (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM11_CH1IN_2    (GPIO_ALT|GPIO_AF3|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN7)
#define GPIO_TIM11_CH1OUT_1   (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM11_CH1OUT_2   (GPIO_ALT|GPIO_AF3|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN7)

#define GPIO_TIM12_CH1IN_1    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN6)
#define GPIO_TIM12_CH1IN_2    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM12_CH1OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)
#define GPIO_TIM12_CH1OUT_2   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM12_CH2IN_1    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN15)
#define GPIO_TIM12_CH2IN_2    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN9)
#define GPIO_TIM12_CH2OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN15)
#define GPIO_TIM12_CH2OUT_2   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN9)

#define GPIO_TIM13_CH1IN_1    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM13_CH1IN_2    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN8)
#define GPIO_TIM13_CH1OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM13_CH1OUT_2   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN8)

#define GPIO_TIM14_CH1IN_1    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM14_CH1IN_2    (GPIO_ALT|GPIO_AF9|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN9)
#define GPIO_TIM14_CH1OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM14_CH1OUT_2   (GPIO_ALT|GPIO_AF9|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN9)

/* Trace */

#define GPIO_TRACECLK_0       (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN2)
#define GPIO_TRACED0_0        (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TRACED1_0        (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN4)
#define GPIO_TRACED2_0        (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TRACED3_0        (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN6)
#define GPIO_TRACESWO_0       (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN3)

/* UARTs/USARTs */

#define GPIO_USART1_CK_0      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN8)
#define GPIO_USART1_CTS_0     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN11)
#define GPIO_USART1_RTS_0     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN12)
#define GPIO_USART1_RX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN10)
#define GPIO_USART1_RX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN7)
#define GPIO_USART1_TX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_USART1_TX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)

#define GPIO_USART2_CK_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN4)
#define GPIO_USART2_CK_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN7)
#define GPIO_USART2_CTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN0)
#define GPIO_USART2_CTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN3)
#define GPIO_USART2_RTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN1)
#define GPIO_USART2_RTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN4)
#define GPIO_USART2_RX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_USART2_RX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN6)
#define GPIO_USART2_TX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_USART2_TX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN5)

#define GPIO_USART3_CK_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN12)
#define GPIO_USART3_CK_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN12)
#define GPIO_USART3_CK_3      (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN10)
#define GPIO_USART3_CTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN13)
#define GPIO_USART3_CTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN11)
#define GPIO_USART3_RTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN14)
#define GPIO_USART3_RTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN12)
#define GPIO_USART3_RX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_USART3_RX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_USART3_RX_3      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN9)
#define GPIO_USART3_TX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_USART3_TX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_USART3_TX_3      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN8)

#define GPIO_UART4_RX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_UART4_RX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_UART4_TX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_UART4_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)

#define GPIO_UART5_RX_0       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN2)
#define GPIO_UART5_TX_0       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN12)

#define GPIO_USART6_CK_1      (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN8)
#define GPIO_USART6_CK_2      (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN7)
#define GPIO_USART6_CTS_1     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN13)
#define GPIO_USART6_CTS_2     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN15)
#define GPIO_USART6_RTS_1     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN12)
#define GPIO_USART6_RTS_2     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN8)
#define GPIO_USART6_RX_1      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_USART6_RX_2      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN9)
#define GPIO_USART6_TX_1      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_USART6_TX_2      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)

#endif /* __ARCH_ARM_SRC_STM32_HARDWARE_STM32F20XXX_PINMAP_H */
