/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.plugin;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.plugin.CircularDependencyException;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.MissingDependencyException;
import org.apache.nutch.plugin.Plugin;
import org.apache.nutch.plugin.PluginClassLoader;
import org.apache.nutch.plugin.PluginDescriptor;
import org.apache.nutch.plugin.PluginManifestParser;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.plugin.URLStreamHandlerFactory;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRepository
implements java.net.URLStreamHandlerFactory {
    private static final WeakHashMap<String, PluginRepository> CACHE = new WeakHashMap();
    private boolean auto;
    private List<PluginDescriptor> fRegisteredPlugins;
    private HashMap<String, ExtensionPoint> fExtensionPoints;
    private HashMap<String, Plugin> fActivatedPlugins = new HashMap();
    private static final Map<String, Map<PluginClassLoader, Class<?>>> CLASS_CACHE = new HashMap();
    private Configuration conf;
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PluginRepository(Configuration conf) throws RuntimeException {
        this.fExtensionPoints = new HashMap();
        this.conf = new Configuration(conf);
        this.auto = conf.getBoolean("plugin.auto-activation", true);
        String[] pluginFolders = conf.getStrings("plugin.folders");
        PluginManifestParser manifestParser = new PluginManifestParser(this.conf, this);
        Map<String, PluginDescriptor> allPlugins = manifestParser.parsePluginFolder(pluginFolders);
        if (allPlugins.isEmpty()) {
            LOG.warn("No plugins found on paths of property plugin.folders=\"{}\"", (Object)conf.get("plugin.folders"));
        }
        Pattern excludes = Pattern.compile(conf.get("plugin.excludes", ""));
        Pattern includes = Pattern.compile(conf.get("plugin.includes", ""));
        Map<String, PluginDescriptor> filteredPlugins = PluginRepository.filter(excludes, includes, allPlugins);
        this.fRegisteredPlugins = this.getDependencyCheckedPlugins(filteredPlugins, this.auto ? allPlugins : filteredPlugins);
        this.installExtensionPoints(this.fRegisteredPlugins);
        try {
            this.installExtensions(this.fRegisteredPlugins);
        }
        catch (PluginRuntimeException e) {
            LOG.error("Could not install extensions.", (Object)e.toString());
            throw new RuntimeException(e.getMessage());
        }
        this.registerURLStreamHandlerFactory();
        this.displayStatus();
    }

    public static synchronized PluginRepository get(Configuration conf) {
        PluginRepository result;
        Object uuid = NutchConfiguration.getUUID(conf);
        if (uuid == null) {
            uuid = "nonNutchConf@" + conf.hashCode();
        }
        if ((result = CACHE.get(uuid)) == null) {
            result = new PluginRepository(conf);
            CACHE.put((String)uuid, result);
        }
        return result;
    }

    private void installExtensionPoints(List<PluginDescriptor> plugins) {
        if (plugins == null) {
            return;
        }
        for (PluginDescriptor plugin : plugins) {
            for (ExtensionPoint point : plugin.getExtenstionPoints()) {
                String xpId = point.getId();
                LOG.debug("Adding extension point {}", (Object)xpId);
                this.fExtensionPoints.put(xpId, point);
            }
        }
    }

    private void installExtensions(List<PluginDescriptor> pRegisteredPlugins) throws PluginRuntimeException {
        for (PluginDescriptor descriptor : pRegisteredPlugins) {
            for (Extension extension : descriptor.getExtensions()) {
                String xpId = extension.getTargetPoint();
                ExtensionPoint point = this.getExtensionPoint(xpId);
                if (point == null) {
                    throw new PluginRuntimeException("Plugin (" + descriptor.getPluginId() + "), extension point: " + xpId + " does not exist.");
                }
                point.addExtension(extension);
            }
        }
    }

    private void getPluginCheckedDependencies(PluginDescriptor plugin, Map<String, PluginDescriptor> plugins, Map<String, PluginDescriptor> dependencies, Map<String, PluginDescriptor> branch) throws MissingDependencyException, CircularDependencyException {
        if (dependencies == null) {
            dependencies = new HashMap<String, PluginDescriptor>();
        }
        if (branch == null) {
            branch = new HashMap<String, PluginDescriptor>();
        }
        branch.put(plugin.getPluginId(), plugin);
        for (String id : plugin.getDependencies()) {
            PluginDescriptor dependency = plugins.get(id);
            if (dependency == null) {
                throw new MissingDependencyException("Missing dependency " + id + " for plugin " + plugin.getPluginId());
            }
            if (branch.containsKey(id)) {
                throw new CircularDependencyException("Circular dependency detected " + id + " for plugin " + plugin.getPluginId());
            }
            dependencies.put(id, dependency);
            this.getPluginCheckedDependencies(plugins.get(id), plugins, dependencies, branch);
        }
        branch.remove(plugin.getPluginId());
    }

    private Map<String, PluginDescriptor> getPluginCheckedDependencies(PluginDescriptor plugin, Map<String, PluginDescriptor> plugins) throws MissingDependencyException, CircularDependencyException {
        HashMap<String, PluginDescriptor> dependencies = new HashMap<String, PluginDescriptor>();
        HashMap<String, PluginDescriptor> branch = new HashMap<String, PluginDescriptor>();
        this.getPluginCheckedDependencies(plugin, plugins, dependencies, branch);
        return dependencies;
    }

    private List<PluginDescriptor> getDependencyCheckedPlugins(Map<String, PluginDescriptor> filtered, Map<String, PluginDescriptor> all) {
        if (filtered == null) {
            return null;
        }
        HashMap<String, PluginDescriptor> checked = new HashMap<String, PluginDescriptor>();
        for (PluginDescriptor plugin : filtered.values()) {
            try {
                checked.putAll(this.getPluginCheckedDependencies(plugin, all));
                checked.put(plugin.getPluginId(), plugin);
            }
            catch (MissingDependencyException mde) {
                LOG.warn(mde.getMessage());
            }
            catch (CircularDependencyException cde) {
                LOG.warn(cde.getMessage());
            }
        }
        return new ArrayList<PluginDescriptor>(checked.values());
    }

    public PluginDescriptor[] getPluginDescriptors() {
        return this.fRegisteredPlugins.toArray(new PluginDescriptor[this.fRegisteredPlugins.size()]);
    }

    public PluginDescriptor getPluginDescriptor(String pPluginId) {
        for (PluginDescriptor descriptor : this.fRegisteredPlugins) {
            if (!descriptor.getPluginId().equals(pPluginId)) continue;
            return descriptor;
        }
        return null;
    }

    public ExtensionPoint getExtensionPoint(String pXpId) {
        return this.fExtensionPoints.get(pXpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin getPluginInstance(PluginDescriptor pDescriptor) throws PluginRuntimeException {
        if (this.fActivatedPlugins.containsKey(pDescriptor.getPluginId())) {
            return this.fActivatedPlugins.get(pDescriptor.getPluginId());
        }
        try {
            PluginDescriptor pluginDescriptor = pDescriptor;
            synchronized (pluginDescriptor) {
                Class<?> pluginClass = this.getCachedClass(pDescriptor, pDescriptor.getPluginClass());
                Constructor<?> constructor = pluginClass.getConstructor(PluginDescriptor.class, Configuration.class);
                Plugin plugin = (Plugin)constructor.newInstance(pDescriptor, this.conf);
                plugin.startUp();
                this.fActivatedPlugins.put(pDescriptor.getPluginId(), plugin);
                return plugin;
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new PluginRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new PluginRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new PluginRuntimeException(e);
        }
    }

    @Deprecated
    public void finalize() throws Throwable {
        this.shutDownActivatedPlugins();
    }

    private void shutDownActivatedPlugins() throws PluginRuntimeException {
        for (Plugin plugin : this.fActivatedPlugins.values()) {
            plugin.shutDown();
        }
    }

    public Class<?> getCachedClass(PluginDescriptor pDescriptor, String className) throws ClassNotFoundException {
        PluginClassLoader loader;
        Class<?> clazz;
        Map<PluginClassLoader, Class<?>> descMap = CLASS_CACHE.get(className);
        if (descMap == null) {
            descMap = new HashMap();
            CLASS_CACHE.put(className, descMap);
        }
        if ((clazz = descMap.get(loader = pDescriptor.getClassLoader())) == null) {
            clazz = loader.loadClass(className);
            descMap.put(loader, clazz);
        }
        return clazz;
    }

    private void displayStatus() {
        LOG.info("Plugin Auto-activation mode: [{}]", (Object)this.auto);
        LOG.info("Registered Plugins:");
        if (this.fRegisteredPlugins == null || this.fRegisteredPlugins.size() == 0) {
            LOG.info("\tNONE");
        } else {
            for (PluginDescriptor plugin : this.fRegisteredPlugins) {
                LOG.info("\t{} ({})", (Object)plugin.getName(), (Object)plugin.getPluginId());
            }
        }
        LOG.info("Registered Extension-Points:");
        if (this.fExtensionPoints == null || this.fExtensionPoints.size() == 0) {
            LOG.info("\tNONE");
        } else {
            for (ExtensionPoint ep : this.fExtensionPoints.values()) {
                LOG.info("\t{} ({})", (Object)ep.getName(), (Object)ep.getId());
            }
        }
    }

    private static Map<String, PluginDescriptor> filter(Pattern excludes, Pattern includes, Map<String, PluginDescriptor> plugins) {
        HashMap<String, PluginDescriptor> map = new HashMap<String, PluginDescriptor>();
        if (plugins == null) {
            return map;
        }
        for (PluginDescriptor plugin : plugins.values()) {
            String id;
            if (plugin == null || (id = plugin.getPluginId()) == null) continue;
            if (!includes.matcher(id).matches()) {
                LOG.debug("not including: {}", (Object)id);
                continue;
            }
            if (excludes.matcher(id).matches()) {
                LOG.debug("excluding: {}", (Object)id);
                continue;
            }
            map.put(plugin.getPluginId(), plugin);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object[] getOrderedPlugins(Class<?> clazz, String xPointId, String orderProperty) {
        ObjectCache objectCache = ObjectCache.get(this.conf);
        Object[] filters = (Object[])objectCache.getObject(clazz.getName());
        if (filters == null) {
            String order = this.conf.get(orderProperty);
            List<Object> orderOfFilters = new ArrayList();
            boolean userDefinedOrder = false;
            if (order != null && !order.trim().isEmpty()) {
                orderOfFilters = Arrays.asList(order.trim().split("\\s+"));
                userDefinedOrder = true;
            }
            try {
                void var14_20;
                ExtensionPoint point = PluginRepository.get(this.conf).getExtensionPoint(xPointId);
                if (point == null) {
                    throw new RuntimeException(xPointId + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                HashMap<String, Object> filterMap = new HashMap<String, Object>();
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    Object object = extension.getExtensionInstance();
                    if (filterMap.containsKey(object.getClass().getName())) continue;
                    filterMap.put(object.getClass().getName(), object);
                    if (userDefinedOrder) continue;
                    orderOfFilters.add(object.getClass().getName());
                }
                ArrayList sorted = new ArrayList();
                for (String string : orderOfFilters) {
                    Object f = filterMap.get(string);
                    if (f == null) {
                        LOG.error("{} : {} declared in configuration property {} but not found in an active plugin - ignoring.", new Object[]{clazz.getSimpleName(), string, orderProperty});
                        continue;
                    }
                    sorted.add(f);
                }
                Object[] filter = (Object[])Array.newInstance(clazz, sorted.size());
                boolean bl = false;
                while (var14_20 < sorted.size()) {
                    filter[var14_20] = sorted.get((int)var14_20);
                    LOG.trace("{} : filters[{}] = {}", new Object[]{clazz.getSimpleName(), (int)var14_20, filter[var14_20].getClass()});
                    ++var14_20;
                }
                objectCache.setObject(clazz.getName(), filter);
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
            filters = (Object[])objectCache.getObject(clazz.getName());
        }
        return filters;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: PluginRepository pluginId className [arg1 arg2 ...]");
            return;
        }
        Configuration conf = NutchConfiguration.create();
        PluginRepository repo = new PluginRepository(conf);
        PluginDescriptor d = repo.getPluginDescriptor(args[0]);
        if (d == null) {
            System.err.println("Plugin '" + args[0] + "' not present or inactive.");
            return;
        }
        PluginClassLoader cl = d.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(args[1], true, cl);
        }
        catch (Exception e) {
            System.err.println("Could not load the class '" + args[1] + ": " + e.getMessage());
            return;
        }
        Method m = null;
        try {
            m = clazz.getMethod("main", args.getClass());
        }
        catch (Exception e) {
            System.err.println("Could not find the 'main(String[])' method in class " + args[1] + ": " + e.getMessage());
            return;
        }
        String[] subargs = new String[args.length - 2];
        System.arraycopy(args, 2, subargs, 0, subargs.length);
        m.invoke(null, new Object[]{subargs});
    }

    private void registerURLStreamHandlerFactory() {
        URLStreamHandlerFactory.getInstance().registerPluginRepository(this);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        LOG.debug("Creating URLStreamHandler for protocol: {}", (Object)protocol);
        if (this.fExtensionPoints != null) {
            ExtensionPoint ep = this.fExtensionPoints.get("org.apache.nutch.protocol.Protocol");
            if (ep != null) {
                Extension[] extensions;
                for (Extension extension : extensions = ep.getExtensions()) {
                    String p = extension.getAttribute("protocolName");
                    if (!p.equals(protocol)) continue;
                    LOG.debug("Suitable protocolName attribute located: {}", (Object)p);
                    Object extinst = null;
                    try {
                        extinst = extension.getExtensionInstance();
                        LOG.debug("Located extension instance class: {}", (Object)extinst.getClass().getName());
                    }
                    catch (Exception e) {
                        LOG.warn("Could not find {}", (Object)extension.getId(), (Object)e);
                    }
                    String handlerClass = extension.getAttribute("urlStreamHandler");
                    if (handlerClass != null) {
                        LOG.debug("Located URLStreamHandler: {}", (Object)handlerClass);
                        ClassLoader cl = this.getClass().getClassLoader();
                        if (extinst != null) {
                            cl = extinst.getClass().getClassLoader();
                        }
                        try {
                            Class<?> clazz = cl.loadClass(handlerClass);
                            return (URLStreamHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            LOG.error("Could not instantiate protocol {} handler class {} defined by extension {}", new Object[]{protocol, handlerClass, extension.getId(), e});
                            return null;
                        }
                    }
                    LOG.debug("Suitable protocol extension found that did not declare a handler");
                    return null;
                }
                LOG.debug("No suitable protocol extensions registered for protocol: {}", (Object)protocol);
            } else {
                LOG.debug("No protocol extensions registered?");
            }
        }
        return null;
    }
}

