/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.urlnormalizer.host;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLNormalizer;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostURLNormalizer
implements URLNormalizer {
    private Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String attributeFile = null;
    private static final HashMap<String, String> hostsMap = new HashMap();

    private synchronized void readConfiguration(Reader configReader) throws IOException {
        String line;
        if (hostsMap.size() > 0) {
            return;
        }
        BufferedReader reader = new BufferedReader(configReader);
        while ((line = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((CharSequence)line) || line.startsWith("#")) continue;
            line = line.trim();
            int delimiterIndex = line.indexOf(" ");
            String host = line.substring(0, delimiterIndex);
            String target = line.substring(delimiterIndex + 1);
            hostsMap.put(host, target);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String pluginName = "urlnormalizer-host";
        Extension[] extensions = PluginRepository.get((Configuration)conf).getExtensionPoint(URLNormalizer.class.getName()).getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getDescriptor().getPluginId().equals(pluginName)) continue;
            attributeFile = extension.getAttribute("file");
            break;
        }
        if (attributeFile != null && attributeFile.trim().equals("")) {
            attributeFile = null;
        }
        if (attributeFile != null) {
            LOG.info("Attribute \"file\" is defined for plugin {} as {}", (Object)pluginName, (Object)attributeFile);
        } else {
            LOG.warn("Attribute \"file\" is not defined in plugin.xml for plugin {}", (Object)pluginName);
        }
        String file = conf.get("urlnormalizer.hosts.file", attributeFile);
        String stringRules = conf.get("urlnormalizer.hosts.rules");
        Reader reader = null;
        if (stringRules != null) {
            reader = new StringReader(stringRules);
        } else {
            LOG.info("Reading {} rules file {}", (Object)pluginName, (Object)file);
            reader = conf.getConfResourceAsReader(file);
        }
        try {
            if (reader == null) {
                reader = new FileReader(file);
            }
            this.readConfiguration(reader);
        }
        catch (IOException e) {
            LOG.error("Error reading {} rule file {}", new Object[]{pluginName, file, e});
        }
    }

    public String normalize(String urlString, String scope) throws MalformedURLException {
        String host = new URL(urlString).getHost();
        if (hostsMap.containsKey(host)) {
            return this.replaceHost(urlString, host, hostsMap.get(host));
        }
        String[] hostParts = host.split("\\.");
        StringBuilder hostBuffer = new StringBuilder();
        Object wildCardHost = new String();
        hostBuffer.append(hostParts[hostParts.length - 1]);
        for (int i = hostParts.length - 2; i > 0; --i) {
            hostBuffer.insert(0, hostParts[i] + ".");
            wildCardHost = "*." + hostBuffer.toString();
            if (!hostsMap.containsKey(wildCardHost)) continue;
            return this.replaceHost(urlString, host, hostsMap.get(wildCardHost));
        }
        return urlString;
    }

    protected String replaceHost(String urlString, String host, String target) {
        int hostIndex = urlString.indexOf(host);
        StringBuilder buffer = new StringBuilder();
        buffer.append(urlString.substring(0, hostIndex));
        buffer.append(target);
        buffer.append(urlString.substring(hostIndex + host.length()));
        return buffer.toString();
    }
}

