/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NoLockFactory;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.index.Index;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;

final class LocalShardSnapshot
implements Closeable {
    private final IndexShard shard;
    private final Store store;
    private final Engine.IndexCommitRef indexCommit;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    LocalShardSnapshot(IndexShard shard) {
        this.shard = shard;
        this.store = shard.store();
        this.store.incRef();
        boolean success = false;
        try {
            this.indexCommit = shard.acquireLastIndexCommit(true);
            success = true;
        }
        finally {
            if (!success) {
                this.store.decRef();
            }
        }
    }

    Index getIndex() {
        return this.shard.indexSettings().getIndex();
    }

    long maxSeqNo() {
        return this.shard.getEngine().getSeqNoStats(-1L).getMaxSeqNo();
    }

    long maxUnsafeAutoIdTimestamp() {
        return Long.parseLong(this.shard.getEngine().commitStats().getUserData().get("max_unsafe_auto_id_timestamp"));
    }

    Directory getSnapshotDirectory() {
        return new FilterDirectory(this.store.directory()){

            public String[] listAll() throws IOException {
                Collection fileNames = LocalShardSnapshot.this.indexCommit.getIndexCommit().getFileNames();
                String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
                return fileNameArray;
            }

            public void deleteFile(String name) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            public void sync(Collection<String> names) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            public void rename(String source, String dest) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            public Lock obtainLock(String name) throws IOException {
                return NoLockFactory.INSTANCE.obtainLock(this.in, name);
            }

            public void close() throws IOException {
                throw new UnsupportedOperationException("nobody should close this directory wrapper");
            }

            public Set<String> getPendingDeletions() throws IOException {
                return this.in.getPendingDeletions();
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.indexCommit.close();
            }
            finally {
                this.store.decRef();
            }
        }
    }

    IndexMetadata getIndexMetadata() {
        return this.shard.indexSettings.getIndexMetadata();
    }

    public String toString() {
        return "local_shard_snapshot:[" + this.shard.shardId() + " indexCommit: " + this.indexCommit + "]";
    }
}

