/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.regex;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.urlfilter.api.RegexRule;
import org.apache.nutch.urlfilter.api.RegexURLFilterBase;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexURLFilter
extends RegexURLFilterBase {
    public static final String URLFILTER_REGEX_FILE = "urlfilter.regex.file";
    public static final String URLFILTER_REGEX_RULES = "urlfilter.regex.rules";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public RegexURLFilter() {
    }

    public RegexURLFilter(String filename) throws IOException, PatternSyntaxException {
        super(filename);
    }

    RegexURLFilter(Reader reader) throws IOException, IllegalArgumentException {
        super(reader);
    }

    protected Reader getRulesReader(Configuration conf) throws IOException {
        String stringRules = conf.get(URLFILTER_REGEX_RULES);
        if (stringRules != null) {
            LOG.info("Reading urlfilter-regex string rules from property: {}", (Object)URLFILTER_REGEX_RULES);
            return new StringReader(stringRules);
        }
        String fileRules = conf.get(URLFILTER_REGEX_FILE);
        LOG.info("Reading urlfilter-regex rules file: {}", (Object)fileRules);
        return conf.getConfResourceAsReader(fileRules);
    }

    protected RegexRule createRule(boolean sign, String regex) {
        return new Rule(sign, regex);
    }

    protected RegexRule createRule(boolean sign, String regex, String hostOrDomain) {
        return new Rule(sign, regex, hostOrDomain);
    }

    public static void main(String[] args) throws IOException {
        RegexURLFilter filter = new RegexURLFilter();
        filter.setConf(NutchConfiguration.create());
        RegexURLFilter.main((RegexURLFilterBase)filter, (String[])args);
    }

    private class Rule
    extends RegexRule {
        private Pattern pattern;

        Rule(boolean sign, String regex) {
            this(sign, regex, null);
        }

        Rule(boolean sign, String regex, String hostOrDomain) {
            super(sign, regex, hostOrDomain);
            this.pattern = Pattern.compile(regex);
        }

        protected boolean match(String url) {
            return this.pattern.matcher(url).find();
        }
    }
}

