/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Utils {
    public static final Predicate<String> IS_BASE64_VALUE = Pattern.compile("[a-zA-Z0-9+/\\-_]+=?=?").asPredicate();

    static List<String> splitOnAsciiWhitespace(String input) {
        ArrayList<String> out = new ArrayList<String>();
        for (String value : input.split("[\t\n\f\r ]")) {
            if (value.isEmpty()) continue;
            out.add(value);
        }
        return out;
    }

    static List<String> strictlySplit(@Nonnull String s, char delim) {
        int next;
        int off = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((next = s.indexOf(delim, off)) != -1) {
            list.add(s.substring(off, next));
            off = next + 1;
        }
        list.add(s.substring(off));
        return list;
    }

    static String decodeString(@Nonnull String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    private Utils() {
    }
}

