/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.archive.util.iterator.CloseableIteratorUtil;
import org.archive.util.iterator.PeekableIterator;

public abstract class AbstractPeekableIterator<E>
implements PeekableIterator<E> {
    private E cachedNext = null;
    private boolean done = false;

    public abstract E getNextInner();

    @Override
    public abstract void close() throws IOException;

    @Override
    public boolean hasNext() {
        if (this.cachedNext != null) {
            return true;
        }
        if (this.done) {
            return false;
        }
        this.cachedNext = this.getNextInner();
        if (this.cachedNext == null) {
            this.done = true;
        }
        return this.cachedNext != null;
    }

    @Override
    public E next() {
        if (this.cachedNext == null && !this.hasNext()) {
            throw new NoSuchElementException("Call hasNext!");
        }
        E tmp = this.cachedNext;
        this.cachedNext = null;
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("No remove");
    }

    @Override
    public E peek() {
        if (this.cachedNext == null && !this.hasNext()) {
            throw new NoSuchElementException("Call hasNext!");
        }
        return this.cachedNext;
    }

    public static <T> PeekableIterator<T> wrap(Iterator<T> itr) {
        return new IteratorWrappedPeekableIterator<T>(itr);
    }

    public static PeekableIterator<String> wrapReader(BufferedReader reader) {
        return new BufferedReaderPeekableIterator(reader);
    }

    public static <K> Comparator<PeekableIterator<K>> getComparator(Comparator<K> comparator) {
        return new PeekableIteratorComparator<K>(comparator);
    }

    private static class IteratorWrappedPeekableIterator<C>
    extends AbstractPeekableIterator<C> {
        private Iterator<C> wrapped = null;

        public IteratorWrappedPeekableIterator(Iterator<C> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public C getNextInner() {
            C next = null;
            if (this.wrapped != null && this.wrapped.hasNext()) {
                next = this.wrapped.next();
            }
            return next;
        }

        @Override
        public void close() throws IOException {
            CloseableIteratorUtil.attemptClose(this.wrapped);
        }
    }

    private static class BufferedReaderPeekableIterator
    extends AbstractPeekableIterator<String> {
        private BufferedReader reader = null;

        public BufferedReaderPeekableIterator(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public String getNextInner() {
            String next = null;
            if (this.reader != null) {
                try {
                    next = this.reader.readLine();
                    if (next == null) {
                        this.reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            return next;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class PeekableIteratorComparator<J>
    implements Comparator<PeekableIterator<J>> {
        private Comparator<J> comparator = null;

        public PeekableIteratorComparator(Comparator<J> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(PeekableIterator<J> o1, PeekableIterator<J> o2) {
            return this.comparator.compare(o1.peek(), o2.peek());
        }
    }
}

